;*******************************************************************************
;  CHIP: SN8P2741A
;  Revision History
;  
;  V01   04/15/2014  1. First issue and only for SN8ICE 2K. 
;*******************************************************************************
.Assembly	INC_VER		1
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	256

.Assembly	INSTRUMENT	SN8P2741A
.Assembly	BIT_FILE	SN8P2741A

.Assembly	OTP_BODY_SIZE	0x1010 
.Assembly	USER_ROM_SIZE	0x1000

;.Assembly	OTP_TEST_SIZE	0x00E0
;.Assembly	MASK_TEST_FILE
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	
.Assembly	PGM_TYPE	13
.Assembly	CHIP_ID		0x6310		
.Assembly	COMMAND		Enable_ORG4_7, NEW_CODEOPTION, RBANK_LIMIT
.Assembly	Port_Pins	6,0,0,0,8,0
;*******************************************************************************
; Code Option 0x100F
.Assembly	OPTION		0		Fix_High
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/4 Fosc/8 x Fosc/16
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		4 : 7		Fix_High
.Assembly	OPTION		8		Watch_Dog 	Always_On x x x x Enable x x x x Disable x x x x x
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin 	P47	Reset
;.Assembly	OPTION   	13		Rst_Len		No	128_ILRC
.Assembly	OPTION   	13		Fix_High
.Assembly	OPTION   	14 : 15		Fix_High

; Code Option 0x100E
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x100D
.Assembly	OPTION		32 : 40		Fix_High
.Assembly	OPTION		41 : 47		Fix_High

; Code Option 0x100C
.Assembly	OPTION		48 : 63		Fix_High

; Code Option 0x1000~0x100B
.Assembly	OPTION		64 : 255	Fix_High

.Assembly	OPTION		2ffh

	L		EQU		0x80
	H		EQU		0x81
	R		EQU		0x82
	Z		EQU		0x83
	Y		EQU		0x84
	PFLAG		EQU		0x86
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FNPD		EQU		PFLAG.6
		FNT0		EQU		PFLAG.7

	RBANK		EQU		087H
			FRBNKS0	EQU		RBANK.0

	CMDB0		EQU		099H
		FCM0DY3		EQU		CMDB0.7
		FCM0DY2		EQU		CMDB0.6
		FCM0DY1		EQU		CMDB0.5
		FCM0DY0		EQU		CMDB0.4
		FCM0D3		EQU		CMDB0.3
		FCM0D2		EQU		CMDB0.2
		FCM0D1		EQU		CMDB0.1
		FCM0D0		EQU		CMDB0.0

	CMDB1		EQU		09AH
		FCM1REF		EQU		CMDB1.2
		FCM1D1		EQU		CMDB1.1
		FCM1D0		EQU		CMDB1.0

	CMDB2		EQU		09BH
		FPWS1		EQU		CMDB2.5
		FPWS0		EQU		CMDB2.4
		FCM2REF		EQU		CMDB2.3
		FCM2NS		EQU		CMDB2.2
		FCM2D1		EQU		CMDB2.1
		FCM2D0		EQU		CMDB2.0

	CM0M		EQU		09CH
		FCM0EN		EQU		CM0M.7
		FCM0OEN		EQU		CM0M.6
		FCM0OUT		EQU_R	 	CM0M.5
		FCM0SF		EQU		CM0M.4
		FCM0G		EQU		CM0M.3
		FCM0CLK		EQU		CM0M.2

	CM1M		EQU		09DH
		FCM1EN		EQU		CM1M.7
		FCM1OEN		EQU		CM1M.6
		FCM1OUT		EQU_R	 	CM1M.5
		FCM1SF		EQU		CM1M.4
		FCM1G		EQU		CM1M.3
		FCM1RS2		EQU		CM1M.2
		FCM1RS1		EQU		CM1M.1
		FCM1RS0		EQU		CM1M.0

	CM2M		EQU		09EH
		FCM2EN		EQU		CM2M.7
		FCM2OEN		EQU		CM2M.6
		FCM2OUT		EQU_R	 	CM2M.5
		FCM2SF		EQU		CM2M.4
		FCM2G		EQU		CM2M.3
		FCM2RS2		EQU		CM2M.2
		FCM2RS1		EQU		CM2M.1
		FCM2RS0		EQU		CM2M.0

	OPM		EQU		09FH
		FOPPSW		EQU		OPM.1
		FOPEN		EQU		OPM.0

	T1M		EQU		0A0H
		FT1ENB	 	EQU  	 	T1M.7
		FT1RATE2 	EQU  	  	T1M.6
		FT1RATE1 	EQU  	  	T1M.5
		FT1RATE0 	EQU  	  	T1M.4
		FT1SF		EQU  	  	T1M.0

   	T1C		EQU		0A1H

   	T1R		EQU_W		0A2H

	T2M		EQU		0A3H
		FT2ENB	 	EQU  	 	T2M.7
		FT2RATE2 	EQU  	  	T2M.6
		FT2RATE1 	EQU  	  	T2M.5
		FT2RATE0 	EQU  	  	T2M.4
		FT2SF		EQU  	  	T2M.0

   	T2C		EQU		0A4H

   	T2R		EQU_W		0A5H

	P4CON		EQU_W		0AEH

	CMCON		EQU_W		0AFH

	ADM		EQU		0xB1
		FADENB		EQU		ADM.7
		FADS		EQU		ADM.6
		FEOC		EQU		ADM.5
		FGCHS		EQU		ADM.4
		FADREF		EQU		ADM.3
		FCHS2		EQU		ADM.2
		FCHS1		EQU		ADM.1
		FCHS0		EQU		ADM.0
	ADB		EQU_R  		0B2H

	ADR		EQU		0B3H
		FINTR4V		EQU		ADR.7
		FADCKS1		EQU		ADR.6
		FADLEN		EQU		ADR.5
		FADCKS0		EQU		ADR.4
		FADB3		EQU_R	 	ADR.3
		FADB2		EQU_R	 	ADR.2
		FADB1		EQU_R 		ADR.1
		FADB0		EQU_R 		ADR.0
	
	ADT		EQU		0B4H
		FADTS1		EQU		ADT.7
		FADTS0		EQU		ADT.6
		FADT4		EQU		ADT.4
		FADT3		EQU		ADT.3
		FADT2		EQU		ADT.2
		FADT1		EQU		ADT.1
		FADT0		EQU		ADT.0

	P0M		EQU		0B8H
		FP05M		EQU		P0M.5
		FP04M		EQU		P0M.4
		FP03M		EQU		P0M.3
		FP02M		EQU		P0M.2
		FP00M		EQU		P0M.0

	PEDGE		EQU		0BFH
		FP00G1		EQU		PEDGE.1
		FP00G0		EQU		PEDGE.0

	P4M		EQU		0C4H
		FP47M		EQU		P4M.7
		FP46M		EQU		P4M.6
		FP45M		EQU		P4M.5
		FP44M		EQU		P4M.4
		FP43M		EQU		P4M.3
		FP42M		EQU		P4M.2
		FP41M		EQU		P4M.1
		FP40M		EQU		P4M.0

	INTRQ0		EQU		0C8H
		FADCIRQ		EQU		INTRQ0.7
		FT1IRQ		EQU		INTRQ0.6
		FTC0IRQ		EQU		INTRQ0.5
  		FT0IRQ  	EQU	  	INTRQ0.4
		FCM2IRQ		EQU		INTRQ0.3
		FCM1IRQ		EQU		INTRQ0.2
		FCM0IRQ		EQU		INTRQ0.1
		FP00IRQ		EQU		INTRQ0.0

	INTEN0		EQU		0C9H
		FADCIEN		EQU		INTEN0.7
		FT1IEN		EQU		INTEN0.6
		FTC0IEN		EQU		INTEN0.5
		FT0IEN		EQU 		INTEN0.4
		FCM2IEN		EQU		INTEN0.3
		FCM1IEN		EQU		INTEN0.2
		FCM0IEN		EQU		INTEN0.1
		FP00IEN		EQU		INTEN0.0

	OSCM		EQU		0CAH
		FCPUM2		EQU		OSCM.7
		FCPUM1		EQU		OSCM.6
		FCPUM0		EQU		OSCM.5
		FCLKMD1		EQU		OSCM.4
		FCLKMD0		EQU		OSCM.3
		FSTPHX2		EQU		OSCM.2
		FSTPHX1		EQU		OSCM.1
		FSTPHX0		EQU		OSCM.0

	WDTR		EQU_W		0CCH

	TC0R		EQU_W	  	0CDH

	PCL		EQU		0CEH
	PCH		EQU		0CFH

	P0		EQU  		0D0H
		FP05		EQU   		P0.5
		FP04		EQU  	 	P0.4
		FP03		EQU 		P0.3
		FP02		EQU  	 	P0.2
		FP01		EQU  	 	P0.1
		FP00		EQU  	 	P0.0

	P4		EQU		0D4H
		FP47		EQU		P4.7
		FP46		EQU		P4.6
		FP45		EQU		P4.5
		FP44		EQU		P4.4
		FP43		EQU		P4.3
		FP42		EQU		P4.2
		FP41		EQU		P4.1
		FP40		EQU		P4.0

	INTRQ1		EQU		0D6H
		FT2IRQ		EQU		INTRQ1.2
		FUTXIRQ		EQU		INTRQ1.1
		FURXIRQ		EQU		INTRQ1.0

	INTEN1		EQU		0D7H
		FT2IEN		EQU		INTEN1.2
		FUTXIEN		EQU		INTEN1.1
		FURXIEN		EQU		INTEN1.0

	T0M		EQU		0D8H
		FT0ENB	 	EQU  	 	T0M.7
		FT0RATE2 	EQU  	  	T0M.6
		FT0RATE1 	EQU  	  	T0M.5
		FT0RATE0 	EQU  	  	T0M.4

   	T0C		EQU		0D9H

	TC0M  		EQU		0DAH
		FTC0ENB		EQU		TC0M.7
		FTC0RATE2	EQU		TC0M.6
		FTC0RATE1	EQU		TC0M.5
		FTC0RATE0	EQU		TC0M.4
		FTC0CKS		EQU		TC0M.3
   	 	FTC0DIR    	EQU		TC0M.2
    		FTC0PO    	EQU		TC0M.1
    		FPWM0OUT   	EQU		TC0M.0 

	TC0C		EQU		0DBH

	BZM		EQU		0DCH
		FBZEN		EQU		BZM.7
		FBZRATE2	EQU		BZM.6
		FBZRATE1	EQU		BZM.5

	STKP		EQU		0DFH
		FGIE		EQU		STKP.7
		FSTKPB2		EQU		STKP.2
		FSTKPB1		EQU		STKP.1
		FSTKPB0		EQU		STKP.0

    	P0UR		EQU_W  		0E0H
      	P4UR		EQU_W  		0E4H
 
	@HL		EQU		0E6H
	@YZ		EQU		0E7H

	TC0D		EQU		0E8H
	URTX		EQU		0E9H
		FUTXEN		EQU		URTX.7
		FUTXPEN		EQU		URTX.6
		FUTXPS		EQU		URTX.5
		FUARTM		EQU		URTX.4
		FURXBZ		EQU_R		URTX.3
   	 	FUTXBZ    	EQU_R		URTX.2
    		FUTXD8    	EQU		URTX.1
    		FURXD8   	EQU_R		URTX.0 
	URRX		EQU		0EAH
		FURXEN		EQU		URRX.7
		FURXPEN		EQU		URRX.6
		FURXPS		EQU		URRX.5
		FURXPC		EQU		URRX.4
		FUFMER		EQU		URRX.3
   	 	FURS2    	EQU		URRX.2
    		FURS1    	EQU		URRX.1
    		FURS0   	EQU		URRX.0 
	URCR		EQU		0EBH
	UTXD		EQU		0ECH
	URXD		EQU_R		0EDH

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 4

	SleepMode	macro
		MOV	A,OSCM
		AND	A,#00011111b
		OR	A,#10100000b
		MOV	OSCM,A
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 6

	GreenMode	macro	
		MOV	A,OSCM
		AND	A,#00011111b
		OR	A,#01100000b
		MOV	OSCM,A
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 8

	SlowMode	macro	
		MOV	A,OSCM
		AND	A,#11100111b
		OR	A,#00011000b
		MOV	OSCM,A

		MOV	A,OSCM
		AND	A,#11111000b
		OR	A,#00000101b
		MOV	OSCM,A
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 9

	Slow2Normal	macro	
		MOV	A,OSCM
		AND	A,#11111000b
		MOV	OSCM,A
		NOP
		NOP
		NOP
		MOV	A,OSCM
		AND	A,#11100111b
		MOV	OSCM,A
	endm
; -----------------------------------------------------
.TEXT
{
	//{{SONIX_OPTION_RULE
	ENDP
	//}}SONIX_OPTION_RULE
}
