;*******************************************************************************
; FILENAME	: 1829Ev.asm
; AUTHOR	: SONiX 
; PURPOSE	: SN8P1829 EV Kit interface subroutine.
;                 User must include this file to communication with Ev. Kit 
; REVISION	: 12/11/2003 V1.0 	First issue
;*******************************************************************************
;*  (c) Copyright 2003, SONiX TECHNOLOGY CO., LTD.
;*******************************************************************************
;
;-------------------------------------------------------------------------------
; ICE SIO function for Link emulation board
; SIO Master Rising edge TX/RX 
;     SCK: P3.6
;     SO:  P3.4
;     SI:  P3.7
;-------------------------------------------------------------------------------
include chip.h
If	ICE_Mode == 1
public R_Temp3, R_Temp2, R_Temp1, R_Temp0;
public R_Temp3_isr, R_Temp2_isr, R_Temp1_isr, R_Temp0_isr;	
XMOV_DATA_SEG segment DATA bank 0
R_Temp3		DS	1
R_Temp2		DS	1				
R_Temp1		DS	1
R_Temp0		DS	1	
R_Temp3_isr 	DS	1
R_Temp2_isr		DS	1				
R_Temp1_isr		DS	1
R_Temp0_isr		DS	1


public SIO;
public @@delayTime;
_x_c__SIO segment CODE INBANK
SIO:
	mov	a,#V_SioLoopCnt		;set sio loop count 8
	b0mov	R_Temp1,a
SIO05:

	b0bts1	R_Temp0.0
	jmp	SIO10
	b0bset	Sio_SO
	jmp	SIO20
SIO10:
	b0bclr	Sio_SO
SIO20:
	b0bset	Sio_Sck
	nop
	nop
	b0bts1	Sio_SI
	jmp	SIO30
	b0bset	FC
	jmp	SIO40
SIO30:
	b0bclr	FC
SIO40:
	rrcm	R_Temp0
	b0bclr	Sio_sck
	nop

	decms	R_Temp1
	jmp	SIO05
	b0bclr	Sio_So
	b0mov	a,R_Temp0
	ret
;-------------------------------------------------------------------------------
; delay loop for waiting emulation board process time
;-------------------------------------------------------------------------------
@@delayTime:
	jmp	$+1
	jmp	$+1
	jmp	$+1
	jmp	$+1
	jmp	$+1
	ret
ELSE
ENDIF

//------------------------------------------------------------------------------
// For XMOV_isr usage	
// 2007.01.03 sol
If	ICE_Mode == 1
public SIO_isr;
public @@delayTime_isr;
_x_c__SIO_isr segment CODE INBANK
SIO_isr:
	mov	a,#V_SioLoopCnt		;set sio loop count 8
	b0mov	R_Temp1_isr,a
SIO05_isr:

	b0bts1	R_Temp0_isr.0
	jmp	SIO10_isr
	b0bset	Sio_SO
	jmp	SIO20_isr
SIO10_isr:
	b0bclr	Sio_SO
SIO20_isr:
	b0bset	Sio_Sck
	nop
	nop
	b0bts1	Sio_SI
	jmp	SIO30_isr
	b0bset	FC
	jmp	SIO40_isr
SIO30_isr:
	b0bclr	FC
SIO40_isr:
	rrcm	R_Temp0_isr
	b0bclr	Sio_sck
	nop

	decms	R_Temp1_isr
	jmp	SIO05_isr
	b0bclr	Sio_So
	b0mov	a,R_Temp0_isr
	ret
;-------------------------------------------------------------------------------
; delay loop for waiting emulation board process time
;-------------------------------------------------------------------------------
@@delayTime_isr:
	jmp	$+1
	jmp	$+1
	jmp	$+1
	jmp	$+1
	jmp	$+1
	ret
ELSE
ENDIF