;-------------------------------------------------------------------------------
;;Define user ram 7CH - 7FH to communication emulation board register 
;-------------------------------------------------------------------------------
IF	ICE_Mode==1

extern data R_Temp3, R_Temp2, R_Temp1, R_Temp0;
extern data R_Temp3_isr, R_Temp2_isr, R_Temp1_isr, R_Temp0_isr;

EndIF
;-------------------------------------------------------------------------------
;;Define user ICE Mode SIO interface  
;-------------------------------------------------------------------------------
INIT_1989EV MACRO
IF	ICE_Mode==1

	Sio_SCK		EQU	p3.6		; To P10
	Sio_SO		EQU	p3.7		; To P11
	Sio_SI		EQU	p3.4		; To P12
	ICE_Reset	EQU	p3.5		; ICE to reset EV Board 
	Chk_Flag	EQU	P3.5
	V_SioLoopCnt	EQU	8

	mov	a,#00000000b			; Initial port4 
	mov	p3,a				;
	mov	a,#11100000b			;
	mov	p3m,a				;
	mov	a,#00000000b			;
	mov	p3ur,a				;

Loop_Reset_EV:					; Reset use p3.1 reset emulation board
	b0bset	FWDRST
	decms	R_Temp0				;
	jmp	$-2				;
	decms	R_temp1				;
	jmp	Loop_Reset_EV			;
	b0bset	ICE_Reset			; for sync EV and ICE
	mov	a,#02h				; delay loop 256*256*2
	b0mov	R_Temp2,a			;
Loop_Reset_EV_OK:				;
	b0bset	FWDRST
	decms	R_Temp0				;
	jmp	$-2				;
	decms	R_Temp1				;
	jmp	Loop_Reset_EV_OK		;
	decms	R_Temp2				;
	jmp	Loop_Reset_Ev_OK		;
ENDIF
	ENDM

;-------------------------------------------------------------------------------
; SN8P1989 special register access MACRO 
; Write register Usage : XMOV 	register,A
; Read  register Usage : XMOV 	A, register
;-------------------------------------------------------------------------------

XMOV   MACRO	REG,VAL

IF ICE_Mode==1

	IFIDNI <VAL>,<A>			; check witer mode to emulation board
			b0mov	R_Temp2,a	; save a value
			mov	a, #(REG)	; get address value
			b0mov	R_Temp0,a	; save value in R_tamp0

			B0mov	a,RBANK		; 
			B0mov	R_Temp3,a	; Save RBANK data to R_Temp3			
			mov	a,#00H		; 
			b0mov	RBANK,a		; Change to RBANK0

			b0bclr	R_Temp0.7	; use bit7 mark to write mode flag.
			call	SIO		; sned write address to emulation board
			call	@@delayTime	; waiting for emulation board procrss command & address

			b0mov	a,R_Temp2	; load data to SIO buffer
			b0mov	R_Temp0,a	;	
			call	SIO		; send data into emulation board address 

			b0mov	a,R_Temp3	; 
			b0mov	RBANK,a		; Re-Load RBANK data from R_Temp3	
						
			b0mov	a,R_Temp2	; for keep "Acc" value

	elseIFIDNI	<REG>,<A>		; check read mode from emulation board
		
    			mov	a,#(VAL)	; get register address value
			b0mov	R_Temp0,a	;
			
			B0mov	a,RBANK		; 
			B0mov	R_Temp3,a	; Save RBANK data to R_Temp3			
			mov	a,#00H		; 
			b0mov	RBANK,a		; Change to RBANK0

			b0bset	R_Temp0.7	; use bit7 mark to read mode flag.
			call	SIO		; send read address to emulation board
			call	@@delayTime	; waiting for emulation board process command & address
			call	SIO		; received emulation board data
			
			b0mov	R_Temp2,a
			b0mov	a,R_Temp3	; 
			b0mov	RBANK,a		; Re-Load RBANK data from R_Temp3
			b0mov	a,R_Temp2
	else
		Error!! Check XMOV macro parameter. This macro need "A" parameter.
	
	endif

else    ; Real chip mode

	IFIDNI  <VAL>,<A>
 		b0mov	(REG),a			;

	elseIFIDNI <REG>,<A>
		b0mov	a,(VAL)			;

	else
		Error!! Check XMOV macro parameter. This macro need "A" parameter.
	endif	
			
ENDIF
	endm
	
	
;-------------------------------------------------------------------------------
; SN8P1989 special register access MACRO 
; Write register Usage : XMOV_isr 	register,A
; Read  register Usage : XMOV_isr 	A, register
;-------------------------------------------------------------------------------

XMOV_isr   MACRO	REG,VAL

IF ICE_Mode==1

	IFIDNI <VAL>,<A>			; check witer mode to emulation board
			b0mov	R_Temp2_isr,a	; save a value
			mov	a, #(REG)	; get address value
			b0mov	R_Temp0_isr,a	; save value in R_tamp0

			B0mov	a,RBANK		; 
			B0mov	R_Temp3_isr,a	; Save RBANK data to R_Temp3			
			mov	a,#00H		; 
			b0mov	RBANK,a		; Change to RBANK0

			b0bclr	R_Temp0_isr.7	; use bit7 mark to write mode flag.
			call	SIO_isr		; sned write address to emulation board
			call	@@delayTime_isr	; waiting for emulation board procrss command & address

			b0mov	a,R_Temp2_isr	; load data to SIO buffer
			b0mov	R_Temp0_isr,a	;	
			call	SIO_isr		; send data into emulation board address 

			b0mov	a,R_Temp3_isr	; 
			b0mov	RBANK,a		; Re-Load RBANK data from R_Temp3	
						
			b0mov	a,R_Temp2_isr	; for keep "Acc" value

	elseIFIDNI	<REG>,<A>		; check read mode from emulation board
		
    			mov	a,#(VAL)	; get register address value
			b0mov	R_Temp0_isr,a	;
			
			B0mov	a,RBANK		; 
			B0mov	R_Temp3_isr,a	; Save RBANK data to R_Temp3			
			mov	a,#00H		; 
			b0mov	RBANK,a		; Change to RBANK0

			b0bset	R_Temp0_isr.7	; use bit7 mark to read mode flag.
			call	SIO_isr		; send read address to emulation board
			call	@@delayTime_isr	; waiting for emulation board process command & address
			call	SIO_isr		; received emulation board data
			
			b0mov	R_Temp2_isr,a
			b0mov	a,R_Temp3_isr	; 
			b0mov	RBANK,a		; Re-Load RBANK data from R_Temp3
			b0mov	a,R_Temp2_isr
	else
		Error!! Check XMOV macro parameter. This macro need "A" parameter.
	
	endif

else    ; Real chip mode

	IFIDNI  <VAL>,<A>
 		b0mov	(REG),a			;

	elseIFIDNI <REG>,<A>
		b0mov	a,(VAL)			;

	else
		Error!! Check XMOV macro parameter. This macro need "A" parameter.
	endif	
			
ENDIF
	endm
	

;************************************************************************************
;XB0MOV same as SMOV                                                                *
;************************************************************************************

XB0MOV   MACRO	REG,VAL

IF ICE_Mode==1

	IFIDNI <VAL>,<A>			; check witer mode to emulation board
			b0mov	R_Temp2,a	; save a value
			mov	a, #(REG)	; get address value
			b0mov	R_Temp0,a	; save value in R_tamp0

			B0mov	a,RBANK		; 
			B0mov	R_Temp3,a	; Save RBANK data to R_Temp3			
			mov	a,#00H		; 
			b0mov	RBANK,a		; Change to RBANK0

			b0bclr	R_Temp0.7	; use bit7 mark to write mode flag.
			call	SIO		; sned write address to emulation board
			call	@@delayTime	; waiting for emulation board procrss command & address

			b0mov	a,R_Temp2	; load data to SIO buffer
			b0mov	R_Temp0,a	;	
			call	SIO		; send data into emulation board address 
			
			b0mov	a,R_Temp3		; 
			b0mov	RBANK,a		; Re-Load RBANK data from R_Temp3	
			
			b0mov	a,R_Temp2	; for keep "Acc" value

	elseIFIDNI	<REG>,<A>		; check read mode from emulation board
		
    			mov	a,#(VAL)	; get register address value
			b0mov	R_Temp0,a	;

			B0mov	a,RBANK		; 
			B0mov	R_Temp3,a	; Save RBANK data to R_Temp3			
			mov	a,#00H		; 
			b0mov	RBANK,a		; Change to RBANK0

			b0bset	R_Temp0.7	; use bit7 mark to read mode flag.
			call	SIO		; send read address to emulation board
			call	@@delayTime	; waiting for emulation board process command & address
			call	SIO		; received emulation board data
			
			b0mov	R_Temp2,a
			b0mov	a,R_Temp3	; 
			b0mov	RBANK,a		; Re-Load RBANK data from R_Temp3
			b0mov	a,R_Temp2			
	else
		Error!! Check XMOV macro parameter. This macro need "A" parameter.
	
	endif

else    ; Real chip mode

	IFIDNI  <VAL>,<A>
 		b0mov	(REG),a			;

	elseIFIDNI <REG>,<A>
		b0mov	a,(VAL)			;

	else
		Error!! Check XMOV macro parameter. This macro need "A" parameter.
	endif	
			
ENDIF
	endm
	
;************************************************************************************
;XB0MOV_isr same as SMOV                                                                *
;************************************************************************************

XB0MOV_isr   MACRO	REG,VAL

IF ICE_Mode==1

	IFIDNI <VAL>,<A>			; check witer mode to emulation board
			b0mov	R_Temp2_isr,a	; save a value
			mov	a, #(REG)	; get address value
			b0mov	R_Temp0_isr,a	; save value in R_tamp0

			B0mov	a,RBANK		; 
			B0mov	R_Temp3_isr,a	; Save RBANK data to R_Temp3			
			mov	a,#00H		; 
			b0mov	RBANK,a		; Change to RBANK0

			b0bclr	R_Temp0_isr.7	; use bit7 mark to write mode flag.
			call	SIO_isr		; sned write address to emulation board
			call	@@delayTime_isr	; waiting for emulation board procrss command & address

			b0mov	a,R_Temp2_isr	; load data to SIO buffer
			b0mov	R_Temp0_isr,a	;	
			call	SIO_isr		; send data into emulation board address 
			
			b0mov	a,R_Temp3_isr		; 
			b0mov	RBANK,a		; Re-Load RBANK data from R_Temp3	
			
			b0mov	a,R_Temp2_isr	; for keep "Acc" value

	elseIFIDNI	<REG>,<A>		; check read mode from emulation board
		
    			mov	a,#(VAL)	; get register address value
			b0mov	R_Temp0_isr,a	;

			B0mov	a,RBANK		; 
			B0mov	R_Temp3_isr,a	; Save RBANK data to R_Temp3			
			mov	a,#00H		; 
			b0mov	RBANK,a		; Change to RBANK0

			b0bset	R_Temp0_isr.7	; use bit7 mark to read mode flag.
			call	SIO_isr		; send read address to emulation board
			call	@@delayTime_isr	; waiting for emulation board process command & address
			call	SIO_isr		; received emulation board data
			
			b0mov	R_Temp2_isr,a
			b0mov	a,R_Temp3_isr	; 
			b0mov	RBANK,a		; Re-Load RBANK data from R_Temp3
			b0mov	a,R_Temp2_isr			
	else
		Error!! Check XMOV macro parameter. This macro need "A" parameter.
	
	endif

else    ; Real chip mode

	IFIDNI  <VAL>,<A>
 		b0mov	(REG),a			;

	elseIFIDNI <REG>,<A>
		b0mov	a,(VAL)			;

	else
		Error!! Check XMOV macro parameter. This macro need "A" parameter.
	endif	
			
ENDIF
	endm
	

;-------------------------------------------------------------------------------
; SN8P1989 special register Bit test 0 MACRO
; this macro is only available in R/W register of bank 0
; e.g XB0BTS0  FADCENB
;     XB0BTS0  ADCM.0    <== this syntax Not available now
;-------------------------------------------------------------------------------

XB0BTS0 	MACRO 	REG
IF ICE_Mode==1
		mov	a,#@int(REG)		; get reg. address value
		b0mov	R_Temp0,a		;

		B0mov	a,RBANK			; 
		B0mov	R_Temp3,a		; Save RBANK data to R_Temp3			
		mov	a,#00H			; 
		b0mov	RBANK,a			; Change to RBANK0

     		b0bset	R_Temp0.7		; use bit7 mark to read mode flag.
		call	SIO			; send read address to emulation board
		call	@@delayTime		; waiting for emulation board process command & address

		call	SIO			; received emulation board data
		mov	R_Temp0,a		; save received data 
		
		b0mov	a,R_Temp3		; 
		b0mov	RBANK,a			; Re-Load RBANK data from R_Temp3		
		
		b0bts0	R_Temp0.@bit(REG)	; judge data bit
ELSE
	b0bts0	REG
ENDIF
	ENDM

;-------------------------------------------------------------------------------
; SN8P1989 special register Bit test 0 MACRO
; this macro is only available in R/W register of bank 0
; e.g XB0BTS0_isr  FADCENB
;     XB0BTS0_isr  ADCM.0    <== this syntax Not available now
;-------------------------------------------------------------------------------

XB0BTS0_isr 	MACRO 	REG
IF ICE_Mode==1
		mov	a,#@int(REG)		; get reg. address value
		b0mov	R_Temp0_isr,a		;

		B0mov	a,RBANK			; 
		B0mov	R_Temp3_isr,a		; Save RBANK data to R_Temp3			
		mov	a,#00H			; 
		b0mov	RBANK,a			; Change to RBANK0

     	b0bset	R_Temp0_isr.7		; use bit7 mark to read mode flag.
		call	SIO_isr			; send read address to emulation board
		call	@@delayTime_isr		; waiting for emulation board process command & address

		call	SIO_isr			; received emulation board data
		mov	R_Temp0_isr,a		; save received data 
		
		b0mov	a,R_Temp3_isr		; 
		b0mov	RBANK,a			; Re-Load RBANK data from R_Temp3		
		
		b0bts0	R_Temp0_isr.@bit(REG)	; judge data bit
ELSE
	b0bts0	REG
ENDIF
	ENDM


;-------------------------------------------------------------------------------
; SN8P1989 special register Bit test 1 MACRO
; this macro is only available in R/W register of bank 0
; e.g XB0BTS1  FADCENB
;     XB0BTS1  ADCM.0    <== this syntax Not available now
;-------------------------------------------------------------------------------
XB0BTS1 	MACRO 	REG
IF ICE_Mode==1
		mov	a,#@int(REG)		; get reg. address value
		b0mov	R_Temp0,a		;
		
		B0mov	a,RBANK			; 
		B0mov	R_Temp3,a		; Save RBANK data to R_Temp3			
		mov	a,#00H			; 
		b0mov	RBANK,a			; Change to RBANK0		

     		b0bset	R_Temp0.7		; use bit7 mark to read mode flag.
		call	SIO			; send read address to emulation board
		call	@@delayTime		; waiting for emulation board process command & address

		call	SIO			; received emulation board data
		mov	R_Temp0,a		; save reecived data
		
		b0mov	a,R_Temp3		; 
		b0mov	RBANK,a			; Re-Load RBANK data from R_Temp3			
		
		b0bts1	R_Temp0.@bit(REG)	; judge data bit
ELSE
	b0bts1	REG
ENDIF
	ENDM


;-------------------------------------------------------------------------------
; SN8P1989 special register Bit test 1 MACRO
; this macro is only available in R/W register of bank 0
; e.g XB0BTS1_isr  FADCENB
;     XB0BTS1_isr  ADCM.0    <== this syntax Not available now
;-------------------------------------------------------------------------------
XB0BTS1_isr 	MACRO 	REG
IF ICE_Mode==1
		mov	a,#@int(REG)		; get reg. address value
		b0mov	R_Temp0_isr,a		;
		
		B0mov	a,RBANK			; 
		B0mov	R_Temp3_isr,a		; Save RBANK data to R_Temp3			
		mov	a,#00H			; 
		b0mov	RBANK,a			; Change to RBANK0		

     	b0bset	R_Temp0_isr.7		; use bit7 mark to read mode flag.
		call	SIO_isr			; send read address to emulation board
		call	@@delayTime_isr		; waiting for emulation board process command & address

		call	SIO_isr			; received emulation board data
		mov	R_Temp0_isr,a		; save reecived data
		
		b0mov	a,R_Temp3_isr		; 
		b0mov	RBANK,a			; Re-Load RBANK data from R_Temp3			
		
		b0bts1	R_Temp0_isr.@bit(REG)	; judge data bit
ELSE
	b0bts1	REG
ENDIF
	ENDM
	

;-------------------------------------------------------------------------------
; SN8P1989 special register Bit set MACRO
; this macro is only available in R/W register of bank 0
; e.g XB0BSET  FADCENB
;     XB0BSET  ADCM.0    <== this syntax Not available now
;-------------------------------------------------------------------------------    

XB0BSET 	MACRO 	REG
IF ICE_Mode==1
    		mov	a,#@int(REG)		; get reg. address value
		b0mov	R_Temp0,a		;
		
		B0mov	a,RBANK			; 
		B0mov	R_Temp3,a		; Save RBANK data to R_Temp3			
		mov	a,#00H			; 
		b0mov	RBANK,a			; Change to RBANK0		

     		b0bset	R_Temp0.7		; use bit7 mark to read mode flag.
		call	SIO			; send read address to emulation board
		call	@@delayTime		; waiting for emulation board process command & address

		call	SIO			; received emulation board data
		mov	R_Temp2,a		; save data 
		b0bset	R_Temp2.@bit(REG)	; process data bit

    		mov	a,#@int(REG)	        ; get reg. address value
		b0mov	R_Temp0,a		;

     		b0bclr	R_Temp0.7		; use bit7 mark to writer mode flag.
		call	SIO			; sned write address to emulation board
		call	@@delayTime		; waiting for emulation board process command & address
		b0mov	a,R_Temp2	        ; load data to SIO buffer
		b0mov	R_Temp0,a		;
		call	SIO			; send data into emulation board address
		
		b0mov	a,R_Temp3		; 
		b0mov	RBANK,a			; Re-Load RBANK data from R_Temp3			
ELSE
	b0bset	REG
ENDIF
	endm


;-------------------------------------------------------------------------------
; SN8P1989 special register Bit set MACRO
; this macro is only available in R/W register of bank 0
; e.g XB0BSET_isr  FADCENB
;     XB0BSET_isr  ADCM.0    <== this syntax Not available now
;-------------------------------------------------------------------------------    

XB0BSET_isr 	MACRO 	REG
IF ICE_Mode==1
    		mov	a,#@int(REG)		; get reg. address value
		b0mov	R_Temp0_isr,a		;
		
		B0mov	a,RBANK			; 
		B0mov	R_Temp3_isr,a		; Save RBANK data to R_Temp3			
		mov	a,#00H			; 
		b0mov	RBANK,a			; Change to RBANK0		

     	b0bset	R_Temp0_isr.7		; use bit7 mark to read mode flag.
		call	SIO_isr			; send read address to emulation board
		call	@@delayTime_isr		; waiting for emulation board process command & address

		call	SIO_isr			; received emulation board data
		mov	R_Temp2_isr,a		; save data 
		b0bset	R_Temp2_isr.@bit(REG)	; process data bit

    	mov	a,#@int(REG)	        ; get reg. address value
		b0mov	R_Temp0_isr,a		;

     	b0bclr	R_Temp0_isr.7		; use bit7 mark to writer mode flag.
		call	SIO_isr			; sned write address to emulation board
		call	@@delayTime_isr		; waiting for emulation board process command & address
		b0mov	a,R_Temp2_isr	        ; load data to SIO buffer
		b0mov	R_Temp0_isr,a		;
		call	SIO_isr			; send data into emulation board address
		
		b0mov	a,R_Temp3_isr		; 
		b0mov	RBANK,a			; Re-Load RBANK data from R_Temp3			
ELSE
	b0bset	REG
ENDIF
	endm
	

;-------------------------------------------------------------------------------
; SN8P1989 special register Bit clear MACRO
; this macro is only available in R/W register of bank 0
; e.g XB0BCLR  FADCENB
;     XB0BCLR  ADCM.0    <== this syntax Not available now
;-------------------------------------------------------------------------------    

XB0BCLR 	MACRO 	REG
IF ICE_Mode==1
    		mov	a,#@int(REG)		; get reg. address value
		b0mov	R_Temp0,a		;

		B0mov	a,RBANK			; 
		B0mov	R_Temp3,a		; Save RBANK data to R_Temp3			
		mov	a,#00H			; 
		b0mov	RBANK,a			; Change to RBANK0

     		b0bset	R_Temp0.7		; use bit7 mark to read mode flag.
		call	SIO			; send read address to emulation board
		call	@@delayTime		; waiting for emulation board process command & address

		call	SIO			; received emulation board data
		mov	R_Temp2,a		; save data
		b0bclr	R_Temp2.@bit(REG)	; process data bit

    		mov	a,#@int(REG)		; get reg.  address value
		b0mov	R_Temp0,a		;

     		b0bclr	R_Temp0.7	 	; use bit7 mark to writer mode flag.
		call	SIO			; sned write address to emulation board
		call	@@delayTime		; waiting for emulation board process command & address
		b0mov	a,R_Temp2		; load data to SIO buffer
		b0mov	R_Temp0,a
		call	SIO			;send data into emulation board address
		
		b0mov	a,R_Temp3		; 
		b0mov	RBANK,a			; Re-Load RBANK data from R_Temp3			
ELSE
	b0bclr	reg
ENDIF
	endm


;-------------------------------------------------------------------------------
; SN8P1989 special register Bit clear MACRO
; this macro is only available in R/W register of bank 0
; e.g XB0BCLR_isr  FADCENB
;     XB0BCLR_isr  ADCM.0    <== this syntax Not available now
;-------------------------------------------------------------------------------    

XB0BCLR_isr 	MACRO 	REG
IF ICE_Mode==1
    		mov	a,#@int(REG)		; get reg. address value
		b0mov	R_Temp0_isr,a		;

		B0mov	a,RBANK			; 
		B0mov	R_Temp3_isr,a		; Save RBANK data to R_Temp3			
		mov	a,#00H			; 
		b0mov	RBANK,a			; Change to RBANK0

     		b0bset	R_Temp0_isr.7		; use bit7 mark to read mode flag.
		call	SIO_isr			; send read address to emulation board
		call	@@delayTime_isr		; waiting for emulation board process command & address

		call	SIO_isr			; received emulation board data
		mov	R_Temp2_isr,a		; save data
		b0bclr	R_Temp2_isr.@bit(REG)	; process data bit

    	mov	a,#@int(REG)		; get reg.  address value
		b0mov	R_Temp0_isr,a		;

     	b0bclr	R_Temp0_isr.7	 	; use bit7 mark to writer mode flag.
		call	SIO_isr			; sned write address to emulation board
		call	@@delayTime_isr		; waiting for emulation board process command & address
		b0mov	a,R_Temp2_isr		; load data to SIO buffer
		b0mov	R_Temp0_isr,a
		call	SIO_isr			;send data into emulation board address
		
		b0mov	a,R_Temp3_isr	; 
		b0mov	RBANK,a			; Re-Load RBANK data from R_Temp3			
ELSE
	b0bclr	reg
ENDIF
	endm
	

;******************************************************
; @SET_LCDM1 Macro to emulate 1989 LCDM in S8KD-2 ICE
	
	@SET_LCDM1	macro	val
		IF  ICE_MODE ==	1			;Set S8KD-2 ICE LCDM register
			mov	a,#(val)
			and	a,#0xfc
			b0mov	LCDM1,a
			mov	a,#(val)
;			and	a,#0x01
;			xor	a,#0x01
;			b0bts0	FZ
;			b0bset	FP2SEG
		ELSE					;;Set SN8P1989 ICE LCDM1 register
			mov	a,#(val)
			b0mov	LCDM1,a
		ENDIF
	endm
;**********************************************************	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;----------------------------------------------------
; For XMOV : Modified by sol
;			 Assume RBANK has already been setup
;	     Don't care about Y value
;----------------------------------------------------
;Source A
;Dest	Z:	
;----------------------------------------------------
XMOVA2M   MACRO	
		  b0mov	R_Temp2,a	; save a value
			mov	a, Z	; get address value
			b0mov	R_Temp0,a	; save value in R_tamp0

			B0mov	a,RBANK		; 
			B0mov	R_Temp3,a	; Save RBANK data to R_Temp3			
			mov	a,#00H		; 
			b0mov	RBANK,a		; Change to RBANK0

			b0bclr	R_Temp0.7	; use bit7 mark to write mode flag.
			call	SIO		; sned write address to emulation board
			call	@@delayTime	; waiting for emulation board procrss command & address

			b0mov	a,R_Temp2	; load data to SIO buffer
			b0mov	R_Temp0,a	;	
			call	SIO		; send data into emulation board address 
			
			b0mov	a,R_Temp3		; 
			b0mov	RBANK,a		; Re-Load RBANK data from R_Temp3	
			
			b0mov	a,R_Temp2	; for keep "Acc" value
endm
		
;----------------------------------------------------
; For XMOV : Modified by sol
;----------------------------------------------------
;Source A
;Dest	Z
XMOVA2M_isr   MACRO	
	    b0mov	R_Temp2_isr,a		; save a value
			mov	a, Z					; get address value
			b0mov	R_Temp0_isr,a		; save value in R_tamp0

			B0mov	a,RBANK					; 
			B0mov	R_Temp3,a				; Save RBANK data to R_Temp3			
			mov	a,#00H						; 
			b0mov	RBANK,a					; Change to RBANK0

			b0bclr	R_Temp0_isr.7	; use bit7 mark to write mode flag.
			call	SIO_isr					; sned write address to emulation board
			call	@@delayTime_isr	; waiting for emulation board procrss command & address

			b0mov	a,R_Temp2_isr		; load data to SIO buffer
			b0mov	R_Temp0_isr,a		;	
			call	SIO_isr					; send data into emulation board address 
			
			b0mov	a,R_Temp3_isr		; 
			b0mov	RBANK,a					; Re-Load RBANK data from R_Temp3	
			
			b0mov	a,R_Temp2_isr		; for keep "Acc" value
endm

;----------------------------------------------------
; For XMOV : Modified by Joe
; 			 Assume RBANK has already been set
;----------------------------------------------------
;Source Z
;Dest	A
XMOVM2A   MACRO	
	    mov	a,Z	; get register address value
			b0mov	R_Temp0,a	;
			
			B0mov	a,RBANK		; 
			B0mov	R_Temp3,a	; Save RBANK data to R_Temp3			
			mov	a,#00H		; 
			b0mov	RBANK,a		; Change to RBANK0

			b0bset	R_Temp0.7	; use bit7 mark to read mode flag.
			call	SIO		; send read address to emulation board
			call	@@delayTime	; waiting for emulation board process command & address
			call	SIO		; received emulation board data
			
			b0mov	R_Temp2,a
			b0mov	a,R_Temp3	; 
			b0mov	RBANK,a		; Re-Load RBANK data from R_Temp3
			b0mov	a,R_Temp2
endm

	
;----------------------------------------------------
; For XMOV : Modified by Joe
;----------------------------------------------------
;Source Z
;Dest	A
XMOVM2A_isr   MACRO	
	    mov	a,Z			; get register address value
			b0mov	R_Temp0_isr,a		;
			
			B0mov	a,RBANK					; 
			B0mov	R_Temp3_isr,a		; Save RBANK data to R_Temp3			
			mov	a,#00H						; 
			b0mov	RBANK,a					; Change to RBANK0

			b0bset	R_Temp0_isr.7	; use bit7 mark to read mode flag.
			call	SIO_isr					; send read address to emulation board
			call	@@delayTime_isr	; waiting for emulation board process command & address
			call	SIO_isr					; received emulation board data
			
			b0mov	R_Temp2_isr,a
			b0mov	a,R_Temp3_isr		; 
			b0mov	RBANK,a					; Re-Load RBANK data from R_Temp3
			b0mov	a,R_Temp2_isr
endm

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;******************************************************
; @@CLR_ADC16IRQ Macro to emulate 16 BIT ADC INTERRUPT REQUEST in S8KD-2 ICE
	
	@@CLR_ADC16IRQ	MACRO
		IF  ICE_MODE ==	1			;;In S8KD-2 ICE Simulation
		  	XB0BCLR	FDRDY			;CLEAR DRDY FOR STOP P0.2 PULL-LOW
		  	B0BCLR	FADC16IRQ		;CLEAR ADC16IRQ 
	
		ELSE					;;In REAL SN8PTA01
			B0BCLR	FADC16IRQ		;CLEAR ADC16IRQ
		ENDIF
	endm
;**********************************************************	

;******************************************************
; @@SET_BZC VAL : SET BZC VALUE IN S8KD-2 ICE
	
	@@SET_BZC	MACRO val
		IF  ICE_MODE ==	1			;Set S8KD-2 ICE LCDM register
			MOV	A,#(VAL)
			XB0MOV	BZC,A			;SET VALUE TO TC0C AND TC0R
		ELSE					;;Set REAL SN8PTA01
			MOV	A,#(VAL)
			B0MOV	BZC,A			;SET VALUE TO BZC IN REAL CHIP
		ENDIF
	endm
;**********************************************************	