INCLUDE		chip.h
DECLARE_INDIR2_ICEMode EQU 1
include 	sn8cc_macros.asm
INCLUDESTD	MACRO1.H

; 2006.12.29 sol add if condition 
IF SW_1819A==1
include 1819AEV.h

ELSEIF SW_1829==1
include 1829EV.h

ELSEIF SO_1907==1
include 1907EV.h

ELSEIF SO_1917==1
include 1917EV.h

ELSEIF SO_1927==1
include 1927EV.h

ELSEIF SO_1937==1
include 1937EV.h

ELSEIF SW_1919==1
include 1919EV.h

ELSEIF SW_1929==1
include 1929EV.h

ELSEIF SW_1989==1
include 1989EV.h

ELSE
include 1909EV.h
ENDIF
; end if 

IF ICE_Mode==1
	extern code @@delayTime_isr;
	IF SO_1937==1
		extern code Parallel_Write_isr;  //Sol add this for support  xmov 2007.01.03
		extern code Parallel_Read_isr;
	ELSE
		extern code SIO_isr;  //Sol add this for support  xmov 2007.01.03
	ENDIF
ENDIF

PUBLIC __INDIR2_ICEMode_isr
	;read 2 bytes from @YZ, save to T, A, T is low byte and A is high byte.
	;if @YZ points to SFR, high byte is always 0

_x_c__INDIR2_ICEMode_isr@RTSegment segment CODE INBANK 
__INDIR2_ICEMode_isr:
	;check bank, if is not 0, it does not point to SFR
	B0MOV A, Y
	CMPRS A, #0
	JNZ _INDIR2_ATYZ	
	
/*********************************************************/
;judge rang is between 0x90 ~ 0x9f?	
	B0MOV A, Z
	SUB A,#0x90
	B0BTS1 FC
	JMP _INDIR2_ATYZ

  B0MOV A, Z
	CMPRS A, #0xa0
	B0BTS0 FC
	JMP _INDIR2_ATYZ

/********************************************************/ 
  b0mov	a,Z		; get register address value
	b0mov	R_Temp0_isr,a	;

IF RBANK != 0	
	B0mov	a,RBANK			; 
	B0mov	R_Temp3_isr,a	; Save RBANK data to R_Temp3			
	b0mov	RBANK,#00H			; Change to RBANK0
ENDIF
	
	b0bset	R_Temp0_isr.7	; use bit7 mark to read mode flag.
	
	IF SO_1937==1
		call	Parallel_Write_isr	; send read address to emulation board
		;call	@@delayTime_isr	; waiting for emulation board process command & address
		call	Parallel_Read_isr	; received emulation board data		
	ELSE
		call	SIO_isr			; send read address to emulation board
		call	@@delayTime_isr	; waiting for emulation board process command & address
		call	SIO_isr			; received emulation board data
	ENDIF
	
	b0mov	R_Temp2_isr,a

IF RBANK != 0	
	b0mov	a,R_Temp3_isr	; 
	b0mov	RBANK,a			; Re-Load RBANK data from R_Temp3
ENDIF
	
	b0mov	a,R_Temp2_isr

/********************************************************/ 
JMP __INDIR2_SFR_RET

_INDIR2_ATYZ:	
	B0MOV A, @YZ	
	B0MOV T, A
	//2006-12-05 HY modified for run-time library optimization
;	MOV A, #1
;	B0ADD Z, A
	__SelectBANKCNST 0
	INCMS Z
	B0MOV A, @YZ
	JMP _RET
	
__INDIR2_SFR_RET:
	B0MOV T, A
	MOV A, #0
_RET:	
	RET
//$Log: INDIR2_ICEMode_isr.asm,v $
//Revision 1.6  2006/04/21 05:01:42  joe
//1. Fixed C Stdlib bug. Remov all .CODE ŧi. User-Defined segmentŧi
//2. Fixed INDIRX_ROM build script bug.
//
//Revision 1.5  2005/12/26 08:03:11  joe
//Fixed INDIR2 bug
//