#ifndef __SN8F27E94L__H
#define __SN8F27E94L__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	X	(*((__RAM unsigned int*)0x85))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FPOR	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	FWDT	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FRST	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FSTKOV	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	RBANK	(*((__RAM unsigned int*)0x87))
#define	FRBNKS2	((*((__RAM struct specialRegister *)0x87)).bit2)
#define	FRBNKS1	((*((__RAM struct specialRegister *)0x87)).bit1)
#define	FRBNKS0	((*((__RAM struct specialRegister *)0x87)).bit0)
#define	W0	(*((__RAM unsigned int*)0x88))
#define	W1	(*((__RAM unsigned int*)0x89))
#define	W2	(*((__RAM unsigned int*)0x8a))
#define	W3	(*((__RAM unsigned int*)0x8b))
#define	W4	(*((__RAM unsigned int*)0x8c))
#define	W5	(*((__RAM unsigned int*)0x8d))
#define	W6	(*((__RAM unsigned int*)0x8e))
#define	W7	(*((__RAM unsigned int*)0x8f))
#define	_HL	(*((__RAM unsigned int*)0x90))
#define	_YZ	(*((__RAM unsigned int*)0x91))
#define	PCL	(*((__RAM unsigned int*)0x93))
#define	PCH	(*((__RAM unsigned int*)0x94))
#define	OSCM	(*((__RAM unsigned int*)0x95))
#define	FCPUM1	((*((__RAM struct specialRegister *)0x95)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0x95)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0x95)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0x95)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0x96))
#define	INTRQ0	(*((__RAM unsigned int*)0x97))
#define	FADCIRQ	((*((__RAM struct specialRegister *)0x97)).bit7)
#define	FT1IRQ	((*((__RAM struct specialRegister *)0x97)).bit6)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0x97)).bit3)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0x97)).bit2)
#define	FP01IRQ	((*((__RAM struct specialRegister *)0x97)).bit1)
#define	FP00IRQ	((*((__RAM struct specialRegister *)0x97)).bit0)
#define	INTRQ1	(*((__RAM unsigned int*)0x98))
#define	FMSPIRQ	((*((__RAM struct specialRegister *)0x98)).bit4)
#define	FUTXIRQ	((*((__RAM struct specialRegister *)0x98)).bit3)
#define	FURXIRQ	((*((__RAM struct specialRegister *)0x98)).bit2)
#define	FSIOIRQ	((*((__RAM struct specialRegister *)0x98)).bit1)
#define	FWAKEIRQ	((*((__RAM struct specialRegister *)0x98)).bit0)
#define	INTEN0	(*((__RAM unsigned int*)0x9a))
#define	FADCIEN	((*((__RAM struct specialRegister *)0x9a)).bit7)
#define	FT1IEN	((*((__RAM struct specialRegister *)0x9a)).bit6)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0x9a)).bit3)
#define	FT0IEN	((*((__RAM struct specialRegister *)0x9a)).bit2)
#define	FP01IEN	((*((__RAM struct specialRegister *)0x9a)).bit1)
#define	FP00IEN	((*((__RAM struct specialRegister *)0x9a)).bit0)
#define	INTEN1	(*((__RAM unsigned int*)0x9b))
#define	FMSPIEN	((*((__RAM struct specialRegister *)0x9b)).bit4)
#define	FUTXIEN	((*((__RAM struct specialRegister *)0x9b)).bit3)
#define	FURXIEN	((*((__RAM struct specialRegister *)0x9b)).bit2)
#define	FSIOIEN	((*((__RAM struct specialRegister *)0x9b)).bit1)
#define	FWAKEIEN	((*((__RAM struct specialRegister *)0x9b)).bit0)
#define	P0OC	(*((__RAM unsigned int*)0x9c))
#define	FP04OC	((*((__RAM struct specialRegister *)0x9c)).bit2)
#define	FP03OC	((*((__RAM struct specialRegister *)0x9c)).bit1)
#define	FP02OC	((*((__RAM struct specialRegister *)0x9c)).bit0)
#define	P1W	(*((__RAM unsigned int*)0x9e))
#define	FP13W	((*((__RAM struct specialRegister *)0x9e)).bit3)
#define	FP12W	((*((__RAM struct specialRegister *)0x9e)).bit2)
#define	FP11W	((*((__RAM struct specialRegister *)0x9e)).bit1)
#define	FP10W	((*((__RAM struct specialRegister *)0x9e)).bit0)
#define	PEDGE	(*((__RAM unsigned int*)0x9f))
#define	FP01G1	((*((__RAM struct specialRegister *)0x9f)).bit3)
#define	FP01G0	((*((__RAM struct specialRegister *)0x9f)).bit2)
#define	FP00G1	((*((__RAM struct specialRegister *)0x9f)).bit1)
#define	FP00G0	((*((__RAM struct specialRegister *)0x9f)).bit0)
#define	P0M	(*((__RAM unsigned int*)0xa0))
#define	FP07M	((*((__RAM struct specialRegister *)0xa0)).bit7)
#define	FP06M	((*((__RAM struct specialRegister *)0xa0)).bit6)
#define	FP05M	((*((__RAM struct specialRegister *)0xa0)).bit5)
#define	FP04M	((*((__RAM struct specialRegister *)0xa0)).bit4)
#define	FP03M	((*((__RAM struct specialRegister *)0xa0)).bit3)
#define	FP02M	((*((__RAM struct specialRegister *)0xa0)).bit2)
#define	FP01M	((*((__RAM struct specialRegister *)0xa0)).bit1)
#define	FP00M	((*((__RAM struct specialRegister *)0xa0)).bit0)
#define	P1M	(*((__RAM unsigned int*)0xa1))
#define	FP13M	((*((__RAM struct specialRegister *)0xa1)).bit3)
#define	FP12M	((*((__RAM struct specialRegister *)0xa1)).bit2)
#define	FP11M	((*((__RAM struct specialRegister *)0xa1)).bit1)
#define	FP10M	((*((__RAM struct specialRegister *)0xa1)).bit0)
#define	P4M	(*((__RAM unsigned int*)0xa4))
#define	FP41M	((*((__RAM struct specialRegister *)0xa4)).bit1)
#define	FP40M	((*((__RAM struct specialRegister *)0xa4)).bit0)
#define	P0	(*((__RAM unsigned int*)0xa6))
#define	FP07	((*((__RAM struct specialRegister *)0xa6)).bit7)
#define	FP06	((*((__RAM struct specialRegister *)0xa6)).bit6)
#define	FP05	((*((__RAM struct specialRegister *)0xa6)).bit5)
#define	FP04	((*((__RAM struct specialRegister *)0xa6)).bit4)
#define	FP03	((*((__RAM struct specialRegister *)0xa6)).bit3)
#define	FP02	((*((__RAM struct specialRegister *)0xa6)).bit2)
#define	FP01	((*((__RAM struct specialRegister *)0xa6)).bit1)
#define	FP00	((*((__RAM struct specialRegister *)0xa6)).bit0)
#define	P1	(*((__RAM unsigned int*)0xa7))
#define	FP13	((*((__RAM struct specialRegister *)0xa7)).bit3)
#define	FP12	((*((__RAM struct specialRegister *)0xa7)).bit2)
#define	FP11	((*((__RAM struct specialRegister *)0xa7)).bit1)
#define	FP10	((*((__RAM struct specialRegister *)0xa7)).bit0)
#define	P4	(*((__RAM unsigned int*)0xaa))
#define	FP41	((*((__RAM struct specialRegister *)0xaa)).bit1)
#define	FP40	((*((__RAM struct specialRegister *)0xaa)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xac))
#define	FP07UR	((*((__RAM struct specialRegister *)0xac)).bit7)
#define	FP06UR	((*((__RAM struct specialRegister *)0xac)).bit6)
#define	FP05UR	((*((__RAM struct specialRegister *)0xac)).bit5)
#define	FP04UR	((*((__RAM struct specialRegister *)0xac)).bit4)
#define	FP03UR	((*((__RAM struct specialRegister *)0xac)).bit3)
#define	FP02UR	((*((__RAM struct specialRegister *)0xac)).bit2)
#define	FP01UR	((*((__RAM struct specialRegister *)0xac)).bit1)
#define	FP00UR	((*((__RAM struct specialRegister *)0xac)).bit0)
#define	P1UR	(*((__RAM unsigned int*)0xad))
#define	FP13UR	((*((__RAM struct specialRegister *)0xad)).bit3)
#define	FP12UR	((*((__RAM struct specialRegister *)0xad)).bit2)
#define	FP11UR	((*((__RAM struct specialRegister *)0xad)).bit1)
#define	FP10UR	((*((__RAM struct specialRegister *)0xad)).bit0)
#define	P4UR	(*((__RAM unsigned int*)0xb0))
#define	FP41UR	((*((__RAM struct specialRegister *)0xb0)).bit1)
#define	FP40UR	((*((__RAM struct specialRegister *)0xb0)).bit0)
#define	T0M	(*((__RAM unsigned int*)0xb2))
#define	FT0ENB	((*((__RAM struct specialRegister *)0xb2)).bit7)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xb2)).bit6)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xb2)).bit5)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xb2)).bit4)
#define	FT0TB	((*((__RAM struct specialRegister *)0xb2)).bit0)
#define	T0C	(*((__RAM unsigned int*)0xb3))
#define	FT0C7	((*((__RAM struct specialRegister *)0xb3)).bit7)
#define	FT0C6	((*((__RAM struct specialRegister *)0xb3)).bit6)
#define	FT0C5	((*((__RAM struct specialRegister *)0xb3)).bit5)
#define	FT0C4	((*((__RAM struct specialRegister *)0xb3)).bit4)
#define	FT0C3	((*((__RAM struct specialRegister *)0xb3)).bit3)
#define	FT0C2	((*((__RAM struct specialRegister *)0xb3)).bit2)
#define	FT0C1	((*((__RAM struct specialRegister *)0xb3)).bit1)
#define	FT0C0	((*((__RAM struct specialRegister *)0xb3)).bit0)
#define	TC0M	(*((__RAM unsigned int*)0xb4))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xb4)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xb4)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xb4)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xb4)).bit4)
#define	FTC0CKS1	((*((__RAM struct specialRegister *)0xb4)).bit3)
#define	FTC0CKS0	((*((__RAM struct specialRegister *)0xb4)).bit2)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xb4)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xb5))
#define	FTC0C7	((*((__RAM struct specialRegister *)0xb5)).bit7)
#define	FTC0C6	((*((__RAM struct specialRegister *)0xb5)).bit6)
#define	FTC0C5	((*((__RAM struct specialRegister *)0xb5)).bit5)
#define	FTC0C4	((*((__RAM struct specialRegister *)0xb5)).bit4)
#define	FTC0C3	((*((__RAM struct specialRegister *)0xb5)).bit3)
#define	FTC0C2	((*((__RAM struct specialRegister *)0xb5)).bit2)
#define	FTC0C1	((*((__RAM struct specialRegister *)0xb5)).bit1)
#define	FTC0C0	((*((__RAM struct specialRegister *)0xb5)).bit0)
#define	TC0R	(*((__RAM unsigned int*)0xb6))
#define	TC0D	(*((__RAM unsigned int*)0xb7))
#define	FTC0D7	((*((__RAM struct specialRegister *)0xb7)).bit7)
#define	FTC0D6	((*((__RAM struct specialRegister *)0xb7)).bit6)
#define	FTC0D5	((*((__RAM struct specialRegister *)0xb7)).bit5)
#define	FTC0D4	((*((__RAM struct specialRegister *)0xb7)).bit4)
#define	FTC0D3	((*((__RAM struct specialRegister *)0xb7)).bit3)
#define	FTC0D2	((*((__RAM struct specialRegister *)0xb7)).bit2)
#define	FTC0D1	((*((__RAM struct specialRegister *)0xb7)).bit1)
#define	FTC0D0	((*((__RAM struct specialRegister *)0xb7)).bit0)
#define	ADM2	(*((__RAM unsigned int*)0xb9))
#define	FGCHS2	((*((__RAM struct specialRegister *)0xb9)).bit7)
#define	AIN2M	(*((__RAM unsigned int*)0xba))
#define	FAIN2M5	((*((__RAM struct specialRegister *)0xba)).bit5)
#define	FAIN2M4	((*((__RAM struct specialRegister *)0xba)).bit4)
#define	FAIN2M3	((*((__RAM struct specialRegister *)0xba)).bit3)
#define	FAIN2M2	((*((__RAM struct specialRegister *)0xba)).bit2)
#define	FAIN2M1	((*((__RAM struct specialRegister *)0xba)).bit1)
#define	FAIN2M0	((*((__RAM struct specialRegister *)0xba)).bit0)
#define	AIN3M	(*((__RAM unsigned int*)0xbb))
#define	FAIN3M5	((*((__RAM struct specialRegister *)0xbb)).bit5)
#define	FAIN3M4	((*((__RAM struct specialRegister *)0xbb)).bit4)
#define	FAIN3M3	((*((__RAM struct specialRegister *)0xbb)).bit3)
#define	FAIN3M2	((*((__RAM struct specialRegister *)0xbb)).bit2)
#define	FAIN3M1	((*((__RAM struct specialRegister *)0xbb)).bit1)
#define	FAIN3M0	((*((__RAM struct specialRegister *)0xbb)).bit0)
#define	AIN4M	(*((__RAM unsigned int*)0xbc))
#define	FAIN4M5	((*((__RAM struct specialRegister *)0xbc)).bit5)
#define	FAIN4M4	((*((__RAM struct specialRegister *)0xbc)).bit4)
#define	FAIN4M3	((*((__RAM struct specialRegister *)0xbc)).bit3)
#define	FAIN4M2	((*((__RAM struct specialRegister *)0xbc)).bit2)
#define	FAIN4M1	((*((__RAM struct specialRegister *)0xbc)).bit1)
#define	FAIN4M0	((*((__RAM struct specialRegister *)0xbc)).bit0)
#define	AIN5M	(*((__RAM unsigned int*)0xbd))
#define	FAIN5M5	((*((__RAM struct specialRegister *)0xbd)).bit5)
#define	FAIN5M4	((*((__RAM struct specialRegister *)0xbd)).bit4)
#define	FAIN5M3	((*((__RAM struct specialRegister *)0xbd)).bit3)
#define	FAIN5M2	((*((__RAM struct specialRegister *)0xbd)).bit2)
#define	FAIN5M1	((*((__RAM struct specialRegister *)0xbd)).bit1)
#define	FAIN5M0	((*((__RAM struct specialRegister *)0xbd)).bit0)
#define	T1M	(*((__RAM unsigned int*)0xc0))
#define	FT1ENB	((*((__RAM struct specialRegister *)0xc0)).bit7)
#define	FT1RATE2	((*((__RAM struct specialRegister *)0xc0)).bit6)
#define	FT1RATE1	((*((__RAM struct specialRegister *)0xc0)).bit5)
#define	FT1RATE0	((*((__RAM struct specialRegister *)0xc0)).bit4)
#define	FT1CKS	((*((__RAM struct specialRegister *)0xc0)).bit3)
#define	T1CL	(*((__RAM unsigned int*)0xc1))
#define	FT1C7	((*((__RAM struct specialRegister *)0xc1)).bit7)
#define	FT1C6	((*((__RAM struct specialRegister *)0xc1)).bit6)
#define	FT1C5	((*((__RAM struct specialRegister *)0xc1)).bit5)
#define	FT1C4	((*((__RAM struct specialRegister *)0xc1)).bit4)
#define	FT1C3	((*((__RAM struct specialRegister *)0xc1)).bit3)
#define	FT1C2	((*((__RAM struct specialRegister *)0xc1)).bit2)
#define	FT1C1	((*((__RAM struct specialRegister *)0xc1)).bit1)
#define	FT1C0	((*((__RAM struct specialRegister *)0xc1)).bit0)
#define	T1CH	(*((__RAM unsigned int*)0xc2))
#define	FT1C15	((*((__RAM struct specialRegister *)0xc2)).bit7)
#define	FT1C14	((*((__RAM struct specialRegister *)0xc2)).bit6)
#define	FT1C13	((*((__RAM struct specialRegister *)0xc2)).bit5)
#define	FT1C12	((*((__RAM struct specialRegister *)0xc2)).bit4)
#define	FT1C11	((*((__RAM struct specialRegister *)0xc2)).bit3)
#define	FT1C10	((*((__RAM struct specialRegister *)0xc2)).bit2)
#define	FT1C9	((*((__RAM struct specialRegister *)0xc2)).bit1)
#define	FT1C8	((*((__RAM struct specialRegister *)0xc2)).bit0)
#define	P4CON	(*((__RAM unsigned int*)0xc6))
#define	FP4CON1	((*((__RAM struct specialRegister *)0xc6)).bit1)
#define	FP4CON0	((*((__RAM struct specialRegister *)0xc6)).bit0)
#define	ADM	(*((__RAM unsigned int*)0xc8))
#define	FADENB	((*((__RAM struct specialRegister *)0xc8)).bit7)
#define	FADS	((*((__RAM struct specialRegister *)0xc8)).bit6)
#define	FEOC	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FGCHS	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FCHS1	((*((__RAM struct specialRegister *)0xc8)).bit1)
#define	FCHS0	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	ADB	(*((__RAM unsigned int*)0xc9))
#define	FADB11	((*((__RAM struct specialRegister *)0xc9)).bit7)
#define	FADB10	((*((__RAM struct specialRegister *)0xc9)).bit6)
#define	FADB9	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FADB8	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FADB7	((*((__RAM struct specialRegister *)0xc9)).bit3)
#define	FADB6	((*((__RAM struct specialRegister *)0xc9)).bit2)
#define	FADB5	((*((__RAM struct specialRegister *)0xc9)).bit1)
#define	FADB4	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	ADR	(*((__RAM unsigned int*)0xca))
#define	FADCKS1	((*((__RAM struct specialRegister *)0xca)).bit6)
#define	FADCKS0	((*((__RAM struct specialRegister *)0xca)).bit5)
#define	FADLEN	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	FADB3	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FADB2	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FADB1	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	FADB0	((*((__RAM struct specialRegister *)0xca)).bit0)
#define	PECMD	(*((__RAM unsigned int*)0xcc))
#define	PEROML	(*((__RAM unsigned int*)0xcd))
#define	PEROMH	(*((__RAM unsigned int*)0xce))
#define	PERAML	(*((__RAM unsigned int*)0xcf))
#define	PERAMCNT	(*((__RAM unsigned int*)0xd0))
#define	SIOM	(*((__RAM unsigned int*)0xd1))
#define	FSENB	((*((__RAM struct specialRegister *)0xd1)).bit7)
#define	FSTART	((*((__RAM struct specialRegister *)0xd1)).bit6)
#define	FSRATE1	((*((__RAM struct specialRegister *)0xd1)).bit5)
#define	FSRATE0	((*((__RAM struct specialRegister *)0xd1)).bit4)
#define	FMLSB	((*((__RAM struct specialRegister *)0xd1)).bit3)
#define	FSCKMD	((*((__RAM struct specialRegister *)0xd1)).bit2)
#define	FCPOL	((*((__RAM struct specialRegister *)0xd1)).bit1)
#define	FCPHA	((*((__RAM struct specialRegister *)0xd1)).bit0)
#define	SIOR	(*((__RAM unsigned int*)0xd2))
#define	SIOB	(*((__RAM unsigned int*)0xd3))
#define	SIOC	(*((__RAM unsigned int*)0xd4))
#define	FSIOBZ	((*((__RAM struct specialRegister *)0xd4)).bit2)
#define	URTX	(*((__RAM unsigned int*)0xd5))
#define	FUTXEN	((*((__RAM struct specialRegister *)0xd5)).bit7)
#define	FUTXPEN	((*((__RAM struct specialRegister *)0xd5)).bit6)
#define	FUTXPS	((*((__RAM struct specialRegister *)0xd5)).bit5)
#define	FUTXBRK	((*((__RAM struct specialRegister *)0xd5)).bit4)
#define	FURXBZ	((*((__RAM struct specialRegister *)0xd5)).bit3)
#define	FUTXBZ	((*((__RAM struct specialRegister *)0xd5)).bit2)
#define	URRX	(*((__RAM unsigned int*)0xd6))
#define	FURXEN	((*((__RAM struct specialRegister *)0xd6)).bit7)
#define	FURXPEN	((*((__RAM struct specialRegister *)0xd6)).bit6)
#define	FURXPS	((*((__RAM struct specialRegister *)0xd6)).bit5)
#define	FURXPC	((*((__RAM struct specialRegister *)0xd6)).bit4)
#define	FUFMER	((*((__RAM struct specialRegister *)0xd6)).bit3)
#define	FURS2	((*((__RAM struct specialRegister *)0xd6)).bit2)
#define	FURS1	((*((__RAM struct specialRegister *)0xd6)).bit1)
#define	FURS0	((*((__RAM struct specialRegister *)0xd6)).bit0)
#define	URCR	(*((__RAM unsigned int*)0xd7))
#define	UTXD	(*((__RAM unsigned int*)0xd8))
#define	URXD	(*((__RAM unsigned int*)0xd9))
#define	MSPSTAT	(*((__RAM unsigned int*)0xda))
#define	FCKE	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FD_A	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FP	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	FS	((*((__RAM struct specialRegister *)0xda)).bit3)
#define	FRED_WRT	((*((__RAM struct specialRegister *)0xda)).bit2)
#define	FBF	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	MSPM1	(*((__RAM unsigned int*)0xdb))
#define	FWCOL	((*((__RAM struct specialRegister *)0xdb)).bit7)
#define	FMSPOV	((*((__RAM struct specialRegister *)0xdb)).bit6)
#define	FMSPENB	((*((__RAM struct specialRegister *)0xdb)).bit5)
#define	FCKP	((*((__RAM struct specialRegister *)0xdb)).bit4)
#define	FSLRXCKP	((*((__RAM struct specialRegister *)0xdb)).bit3)
#define	FMSPWK	((*((__RAM struct specialRegister *)0xdb)).bit2)
#define	FMSPC	((*((__RAM struct specialRegister *)0xdb)).bit0)
#define	MSPM2	(*((__RAM unsigned int*)0xdc))
#define	FGCEN	((*((__RAM struct specialRegister *)0xdc)).bit7)
#define	FACKSTAT	((*((__RAM struct specialRegister *)0xdc)).bit6)
#define	FACKDT	((*((__RAM struct specialRegister *)0xdc)).bit5)
#define	FACKEN	((*((__RAM struct specialRegister *)0xdc)).bit4)
#define	FRCEN	((*((__RAM struct specialRegister *)0xdc)).bit3)
#define	FPEN	((*((__RAM struct specialRegister *)0xdc)).bit2)
#define	FRSEN	((*((__RAM struct specialRegister *)0xdc)).bit1)
#define	FSEN	((*((__RAM struct specialRegister *)0xdc)).bit0)
#define	MSPBUF	(*((__RAM unsigned int*)0xdd))
#define	FMSPBUF7	((*((__RAM struct specialRegister *)0xdd)).bit7)
#define	FMSPBUF6	((*((__RAM struct specialRegister *)0xdd)).bit6)
#define	FMSPBUF5	((*((__RAM struct specialRegister *)0xdd)).bit5)
#define	FMSPBUF4	((*((__RAM struct specialRegister *)0xdd)).bit4)
#define	FMSPBUF3	((*((__RAM struct specialRegister *)0xdd)).bit3)
#define	FMSPBUF2	((*((__RAM struct specialRegister *)0xdd)).bit2)
#define	FMSPBUF1	((*((__RAM struct specialRegister *)0xdd)).bit1)
#define	FMSPBUF0	((*((__RAM struct specialRegister *)0xdd)).bit0)
#define	MSPADR	(*((__RAM unsigned int*)0xde))
#define	FMSPADR7	((*((__RAM struct specialRegister *)0xde)).bit7)
#define	FMSPADR6	((*((__RAM struct specialRegister *)0xde)).bit6)
#define	FMSPADR5	((*((__RAM struct specialRegister *)0xde)).bit5)
#define	FMSPADR4	((*((__RAM struct specialRegister *)0xde)).bit4)
#define	FMSPADR3	((*((__RAM struct specialRegister *)0xde)).bit3)
#define	FMSPADR2	((*((__RAM struct specialRegister *)0xde)).bit2)
#define	FMSPADR1	((*((__RAM struct specialRegister *)0xde)).bit1)
#define	FMSPADR0	((*((__RAM struct specialRegister *)0xde)).bit0)
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	FLVD23	((*((__RAM struct specialRegister *)0xdf)).bit6)
#define	FLVD30	((*((__RAM struct specialRegister *)0xdf)).bit5)
#define	FSTKPB3	((*((__RAM struct specialRegister *)0xdf)).bit3)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xdf)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	STKFL	(*((__RAM unsigned int*)0xe0))
#define	STKFH	(*((__RAM unsigned int*)0xe1))
#define	STKEL	(*((__RAM unsigned int*)0xe2))
#define	STKEH	(*((__RAM unsigned int*)0xe3))
#define	STKDL	(*((__RAM unsigned int*)0xe4))
#define	STKDH	(*((__RAM unsigned int*)0xe5))
#define	STKCL	(*((__RAM unsigned int*)0xe6))
#define	STKCH	(*((__RAM unsigned int*)0xe7))
#define	STKBL	(*((__RAM unsigned int*)0xe8))
#define	STKBH	(*((__RAM unsigned int*)0xe9))
#define	STKAL	(*((__RAM unsigned int*)0xea))
#define	STKAH	(*((__RAM unsigned int*)0xeb))
#define	STK9L	(*((__RAM unsigned int*)0xec))
#define	STK9H	(*((__RAM unsigned int*)0xed))
#define	STK8L	(*((__RAM unsigned int*)0xee))
#define	STK8H	(*((__RAM unsigned int*)0xef))
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SLowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
