#ifndef __SN8P1819A__H
#define __SN8P1819A__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	X	(*((__RAM unsigned int*)0x85))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	RBANK	(*((__RAM unsigned int*)0x87))
#define	OPTION	(*((__RAM unsigned int*)0x88))
#define	FRCLK	((*((__RAM struct specialRegister *)0x88)).bit0)
#if ICE_Mode == 1
#define	LCDM1	(*((__RAM unsigned int*)0XCB))
#define	FLCDBNK	((*((__RAM struct specialRegister *)0XCB)).bit5)
#define	FLCDENB	((*((__RAM struct specialRegister *)0XCB)).bit3)
#define	Dummy	(*((__RAM unsigned int*)0X8F))
#define	FP2SEG	((*((__RAM struct specialRegister *)0X8F)).bit0)
#define	FBIAS	((*((__RAM struct specialRegister *)0X8F)).bit2)
#else
#define	LCDM1	(*((__RAM unsigned int*)0x89))
#define	FLCDBNK	((*((__RAM struct specialRegister *)0x89)).bit5)
#define	FLCDENB	((*((__RAM struct specialRegister *)0x89)).bit3)
#endif
#define	PGIACKS	(*((__RAM unsigned int*)0x92))
#define	CPM	(*((__RAM unsigned int*)0x95))
#define	FVCREG1	((*((__RAM struct specialRegister *)0x95)).bit7)
#define	FVCREG0	((*((__RAM struct specialRegister *)0x95)).bit6)
#define	FAREGENB	((*((__RAM struct specialRegister *)0x95)).bit0)
#define	CPCKS	(*((__RAM unsigned int*)0x96))
#define	PGIAM	(*((__RAM unsigned int*)0x9A))
#define	FP2GS3	((*((__RAM struct specialRegister *)0x9A)).bit7)
#define	FP2GS2	((*((__RAM struct specialRegister *)0x9A)).bit6)
#define	FP2GS1	((*((__RAM struct specialRegister *)0x9A)).bit5)
#define	FP2GS0	((*((__RAM struct specialRegister *)0x9A)).bit4)
#define	FP1GS1	((*((__RAM struct specialRegister *)0x9A)).bit2)
#define	FP1GS0	((*((__RAM struct specialRegister *)0x9A)).bit1)
#define	FPGIAENB	((*((__RAM struct specialRegister *)0x9A)).bit0)
#define	OPM	(*((__RAM unsigned int*)0x9B))
#define	FOP2UGB	((*((__RAM struct specialRegister *)0x9B)).bit3)
#define	FOP1UGB	((*((__RAM struct specialRegister *)0x9B)).bit2)
#define	FOP2ENB	((*((__RAM struct specialRegister *)0x9B)).bit1)
#define	FOP1ENB	((*((__RAM struct specialRegister *)0x9B)).bit0)
#define	P4CON	(*((__RAM unsigned int*)0xae))
#define	ADM	(*((__RAM unsigned int*)0xB1))
#define	FADENB	((*((__RAM struct specialRegister *)0xB1)).bit7)
#define	FADS	((*((__RAM struct specialRegister *)0xB1)).bit6)
#define	FEOC	((*((__RAM struct specialRegister *)0xB1)).bit5)
#define	FGCHS	((*((__RAM struct specialRegister *)0xB1)).bit4)
#define	FCHS2	((*((__RAM struct specialRegister *)0xB1)).bit2)
#define	FCHS1	((*((__RAM struct specialRegister *)0xB1)).bit1)
#define	FCHS0	((*((__RAM struct specialRegister *)0xB1)).bit0)
#define	ADB	(*((__RAM unsigned int*)0xb2))
#define	ADR	(*((__RAM unsigned int*)0xb3))
#define	FADCKS1	((*((__RAM struct specialRegister *)0xb3)).bit6)
#define	FADCKS0	((*((__RAM struct specialRegister *)0xb3)).bit4)
#define	FADB3	((*((__RAM struct specialRegister *)0xb3)).bit3)
#define	FADB2	((*((__RAM struct specialRegister *)0xb3)).bit2)
#define	FADB1	((*((__RAM struct specialRegister *)0xb3)).bit1)
#define	FADB0	((*((__RAM struct specialRegister *)0xb3)).bit0)
#define	CALIHRCH	(*((__RAM unsigned int*)0xBC))
#define	FCALSTART	((*((__RAM struct specialRegister *)0xBC)).bit7)
#define	FTC1CALCKS	((*((__RAM struct specialRegister *)0xBC)).bit6)
#define	FCALIHRCH2	((*((__RAM struct specialRegister *)0xBC)).bit2)
#define	FCALIHRCH1	((*((__RAM struct specialRegister *)0xBC)).bit1)
#define	FCALIHRCH0	((*((__RAM struct specialRegister *)0xBC)).bit0)
#define	CALIHRCL	(*((__RAM unsigned int*)0xBD))
#define	FCALIHRCL5	((*((__RAM struct specialRegister *)0xBD)).bit5)
#define	FCALIHRCL4	((*((__RAM struct specialRegister *)0xBD)).bit4)
#define	FCALIHRCL3	((*((__RAM struct specialRegister *)0xBD)).bit3)
#define	FCALIHRCL2	((*((__RAM struct specialRegister *)0xBD)).bit2)
#define	FCALIHRCL1	((*((__RAM struct specialRegister *)0xBD)).bit1)
#define	FCALIHRCL0	((*((__RAM struct specialRegister *)0xBD)).bit0)
#define	PEDGE	(*((__RAM unsigned int*)0xBF))
#define	FPEDGEN	((*((__RAM struct specialRegister *)0xBF)).bit7)
#define	FP00G0	((*((__RAM struct specialRegister *)0xBF)).bit3)
#define	FP00G1	((*((__RAM struct specialRegister *)0xBF)).bit4)
#define	P1W	(*((__RAM unsigned int*)0xc0))
#define	FP15W	((*((__RAM struct specialRegister *)0xc0)).bit5)
#define	FP14W	((*((__RAM struct specialRegister *)0xc0)).bit4)
#define	FP13W	((*((__RAM struct specialRegister *)0xc0)).bit3)
#define	FP12W	((*((__RAM struct specialRegister *)0xc0)).bit2)
#define	FP11W	((*((__RAM struct specialRegister *)0xc0)).bit1)
#define	FP10W	((*((__RAM struct specialRegister *)0xc0)).bit0)
#define	P1M	(*((__RAM unsigned int*)0xC1))
#define	FP15M	((*((__RAM struct specialRegister *)0xC1)).bit5)
#define	FP14M	((*((__RAM struct specialRegister *)0xC1)).bit4)
#define	FP13M	((*((__RAM struct specialRegister *)0xC1)).bit3)
#define	FP12M	((*((__RAM struct specialRegister *)0xC1)).bit2)
#define	FP11M	((*((__RAM struct specialRegister *)0xC1)).bit1)
#define	FP10M	((*((__RAM struct specialRegister *)0xC1)).bit0)
#define	P4M	(*((__RAM unsigned int*)0xc4))
#define	FP43M	((*((__RAM struct specialRegister *)0xc4)).bit3)
#define	FP42M	((*((__RAM struct specialRegister *)0xc4)).bit2)
#define	FP41M	((*((__RAM struct specialRegister *)0xc4)).bit1)
#define	FP40M	((*((__RAM struct specialRegister *)0xc4)).bit0)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP56M	((*((__RAM struct specialRegister *)0xc5)).bit6)
#define	FP55M	((*((__RAM struct specialRegister *)0xc5)).bit5)
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	FP53M	((*((__RAM struct specialRegister *)0xc5)).bit3)
#define	FP52M	((*((__RAM struct specialRegister *)0xc5)).bit2)
#define	FP51M	((*((__RAM struct specialRegister *)0xc5)).bit1)
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FTC1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit6)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FTC1IEN	((*((__RAM struct specialRegister *)0xc9)).bit6)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	OSCM	(*((__RAM unsigned int*)0xCA))
#define	FWTCKS	((*((__RAM struct specialRegister *)0xCA)).bit7)
#define	FWDRST	((*((__RAM struct specialRegister *)0xCA)).bit6)
#define	FWDRATE	((*((__RAM struct specialRegister *)0xCA)).bit5)
#define	FCPUM1	((*((__RAM struct specialRegister *)0xCA)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xCA)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xCA)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xCA)).bit1)
#define	TC0R	(*((__RAM unsigned int*)0xCD))
#define	PCL	(*((__RAM unsigned int*)0xCE))
#define	PCH	(*((__RAM unsigned int*)0xCF))
#define	P1	(*((__RAM unsigned int*)0xD1))
#define	FP15	((*((__RAM struct specialRegister *)0xD1)).bit5)
#define	FP14	((*((__RAM struct specialRegister *)0xD1)).bit4)
#define	FP13	((*((__RAM struct specialRegister *)0xD1)).bit3)
#define	FP12	((*((__RAM struct specialRegister *)0xD1)).bit2)
#define	FP11	((*((__RAM struct specialRegister *)0xD1)).bit1)
#define	FP10	((*((__RAM struct specialRegister *)0xD1)).bit0)
#define	P4	(*((__RAM unsigned int*)0xD4))
#define	FP43	((*((__RAM struct specialRegister *)0xD4)).bit3)
#define	FP42	((*((__RAM struct specialRegister *)0xD4)).bit2)
#define	FP41	((*((__RAM struct specialRegister *)0xD4)).bit1)
#define	FP40	((*((__RAM struct specialRegister *)0xD4)).bit0)
#define	P5	(*((__RAM unsigned int*)0xD5))
#define	FP56	((*((__RAM struct specialRegister *)0xD5)).bit6)
#define	FP55	((*((__RAM struct specialRegister *)0xD5)).bit5)
#define	FP54	((*((__RAM struct specialRegister *)0xD5)).bit4)
#define	FP53	((*((__RAM struct specialRegister *)0xD5)).bit3)
#define	FP52	((*((__RAM struct specialRegister *)0xD5)).bit2)
#define	FP51	((*((__RAM struct specialRegister *)0xD5)).bit1)
#define	FP50	((*((__RAM struct specialRegister *)0xD5)).bit0)
#define	T0M	(*((__RAM unsigned int*)0xD8))
#define	FT0ENB	((*((__RAM struct specialRegister *)0xD8)).bit7)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xD8)).bit6)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xD8)).bit5)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xD8)).bit4)
#define	FTC1X8	((*((__RAM struct specialRegister *)0xD8)).bit3)
#define	FTC0X8	((*((__RAM struct specialRegister *)0xD8)).bit2)
#define	FTC0GN	((*((__RAM struct specialRegister *)0xD8)).bit1)
#define	FT0TB	((*((__RAM struct specialRegister *)0xD8)).bit0)
#define	T0C	(*((__RAM unsigned int*)0xD9))
#define	TC0M	(*((__RAM unsigned int*)0xda))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	FTC0CKS	((*((__RAM struct specialRegister *)0xda)).bit3)
#define	FALOAD0	((*((__RAM struct specialRegister *)0xda)).bit2)
#define	FTC0OUT	((*((__RAM struct specialRegister *)0xda)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xDB))
#define	TC1M	(*((__RAM unsigned int*)0xDC))
#define	FTC1ENB	((*((__RAM struct specialRegister *)0xDC)).bit7)
#define	FTC1RATE2	((*((__RAM struct specialRegister *)0xDC)).bit6)
#define	FTC1RATE1	((*((__RAM struct specialRegister *)0xDC)).bit5)
#define	FTC1RATE0	((*((__RAM struct specialRegister *)0xDC)).bit4)
#define	FTC1CKS	((*((__RAM struct specialRegister *)0xDC)).bit3)
#define	FALOAD1	((*((__RAM struct specialRegister *)0xDC)).bit2)
#define	FTC1OUT	((*((__RAM struct specialRegister *)0xDC)).bit1)
#define	FPWM1OUT	((*((__RAM struct specialRegister *)0xDC)).bit0)
#define	TC1C	(*((__RAM unsigned int*)0xDD))
#define	TC1R	(*((__RAM unsigned int*)0xDE))
#define	STKP	(*((__RAM unsigned int*)0xDF))
#define	FGIE	((*((__RAM struct specialRegister *)0xDF)).bit7)
#define	FSTKPB3	((*((__RAM struct specialRegister *)0xDF)).bit3)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xDF)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xDF)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xDF)).bit0)
#define	P1UR	(*((__RAM unsigned int*)0xE1))
#define	FP15R	((*((__RAM struct specialRegister *)0xE1)).bit5)
#define	FP14R	((*((__RAM struct specialRegister *)0xE1)).bit4)
#define	FP13R	((*((__RAM struct specialRegister *)0xE1)).bit3)
#define	FP12R	((*((__RAM struct specialRegister *)0xE1)).bit2)
#define	FP11R	((*((__RAM struct specialRegister *)0xE1)).bit1)
#define	FP10R	((*((__RAM struct specialRegister *)0xE1)).bit0)
#define	P4UR	(*((__RAM unsigned int*)0xE4))
#define	FP43R	((*((__RAM struct specialRegister *)0xE4)).bit3)
#define	FP42R	((*((__RAM struct specialRegister *)0xE4)).bit2)
#define	FP41R	((*((__RAM struct specialRegister *)0xE4)).bit1)
#define	FP40R	((*((__RAM struct specialRegister *)0xE4)).bit0)
#define	P5UR	(*((__RAM unsigned int*)0xE5))
#define	FP56R	((*((__RAM struct specialRegister *)0xE5)).bit6)
#define	FP55R	((*((__RAM struct specialRegister *)0xE5)).bit5)
#define	FP54R	((*((__RAM struct specialRegister *)0xE5)).bit4)
#define	FP53R	((*((__RAM struct specialRegister *)0xE5)).bit3)
#define	FP52R	((*((__RAM struct specialRegister *)0xE5)).bit2)
#define	FP51R	((*((__RAM struct specialRegister *)0xE5)).bit1)
#define	FP50R	((*((__RAM struct specialRegister *)0xE5)).bit0)
#define	_HL	(*((__RAM unsigned int*)0xE6))
#define	DP0X	(*((__RAM unsigned int*)0xE6))
#define	_YZ	(*((__RAM unsigned int*)0xE7))
#define	DP1X	(*((__RAM unsigned int*)0xE7))
#define	P1OC	(*((__RAM unsigned int*)0xe9))
#define	FP10OC	((*((__RAM struct specialRegister *)0xe9)).bit0)
#define	FP11OC	((*((__RAM struct specialRegister *)0xe9)).bit1)
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#if ICE_Mode == 1
#define	P3M	(*((__RAM unsigned int*)0xC3))
#define	FP37M	((*((__RAM struct specialRegister *)0xC3)).bit7)
#define	FP36M	((*((__RAM struct specialRegister *)0xC3)).bit6)
#define	FP35M	((*((__RAM struct specialRegister *)0xC3)).bit5)
#define	FP34M	((*((__RAM struct specialRegister *)0xC3)).bit4)
#define	FP33M	((*((__RAM struct specialRegister *)0xC3)).bit3)
#define	FP32M	((*((__RAM struct specialRegister *)0xC3)).bit2)
#define	FP31M	((*((__RAM struct specialRegister *)0xC3)).bit1)
#define	FP30M	((*((__RAM struct specialRegister *)0xC3)).bit0)
#define	P3	(*((__RAM unsigned int*)0xD3))
#define	FP37	((*((__RAM struct specialRegister *)0xD3)).bit7)
#define	FP36	((*((__RAM struct specialRegister *)0xD3)).bit6)
#define	FP35	((*((__RAM struct specialRegister *)0xD3)).bit5)
#define	FP34	((*((__RAM struct specialRegister *)0xD3)).bit4)
#define	FP33	((*((__RAM struct specialRegister *)0xD3)).bit3)
#define	FP32	((*((__RAM struct specialRegister *)0xD3)).bit2)
#define	FP31	((*((__RAM struct specialRegister *)0xD3)).bit1)
#define	FP30	((*((__RAM struct specialRegister *)0xD3)).bit0)
#define	P3UR	(*((__RAM unsigned int*)0xE3))
#define	FP37R	((*((__RAM struct specialRegister *)0xE3)).bit7)
#define	FP36R	((*((__RAM struct specialRegister *)0xE3)).bit6)
#define	FP35R	((*((__RAM struct specialRegister *)0xE3)).bit5)
#define	FP34R	((*((__RAM struct specialRegister *)0xE3)).bit4)
#define	FP33R	((*((__RAM struct specialRegister *)0xE3)).bit3)
#define	FP32R	((*((__RAM struct specialRegister *)0xE3)).bit2)
#define	FP31R	((*((__RAM struct specialRegister *)0xE3)).bit1)
#define	FP30R	((*((__RAM struct specialRegister *)0xE3)).bit0)
#endif
#endif
