#ifndef __SN8P1829__H
#define __SN8P1829__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	X	(*((__RAM unsigned int*)0x85))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	RBANK	(*((__RAM unsigned int*)0x87))
#define	FRBNKS0	((*((__RAM struct specialRegister *)0x87)).bit0)
#define	FRBNKS1	((*((__RAM struct specialRegister *)0x87)).bit1)
#define	FRBNKS2	((*((__RAM struct specialRegister *)0x87)).bit2)
#define	FRBNKS3	((*((__RAM struct specialRegister *)0x87)).bit3)
#define	OPTION	(*((__RAM unsigned int*)0x88))
#define	FRTCM1	((*((__RAM struct specialRegister *)0x88)).bit3)
#define	FRTCM0	((*((__RAM struct specialRegister *)0x88)).bit2)
#define	FRCLK	((*((__RAM struct specialRegister *)0x88)).bit0)
#if ICE_Mode == 1
#define	LCDM1	(*((__RAM unsigned int*)0XCB))
#define	FLCDBNK	((*((__RAM struct specialRegister *)0XCB)).bit5)
#define	FLCDENB	((*((__RAM struct specialRegister *)0XCB)).bit3)
#define	Dummy	(*((__RAM unsigned int*)0X8F))
#define	FP2SEG	((*((__RAM struct specialRegister *)0X8F)).bit0)
#define	FBIAS	((*((__RAM struct specialRegister *)0X8F)).bit2)
#else
#define	LCDM1	(*((__RAM unsigned int*)0x89))
#define	FLCDBNK	((*((__RAM struct specialRegister *)0x89)).bit5)
#define	FLCDENB	((*((__RAM struct specialRegister *)0x89)).bit3)
#define	FBIAS	((*((__RAM struct specialRegister *)0x89)).bit2)
#define	FP2SEG	((*((__RAM struct specialRegister *)0x89)).bit0)
#endif
#define	PGIACKS	(*((__RAM unsigned int*)0x92))
#define	CPM	(*((__RAM unsigned int*)0x95))
#define	FCPSTS	((*((__RAM struct specialRegister *)0x95)).bit3)
#define	FCPAUTO	((*((__RAM struct specialRegister *)0x95)).bit2)
#define	FCPON	((*((__RAM struct specialRegister *)0x95)).bit1)
#define	FCPRENB	((*((__RAM struct specialRegister *)0x95)).bit0)
#define	CPCKS	(*((__RAM unsigned int*)0x96))
#define	PGIAM	(*((__RAM unsigned int*)0x9A))
#define	FP2GS3	((*((__RAM struct specialRegister *)0x9A)).bit7)
#define	FP2GS2	((*((__RAM struct specialRegister *)0x9A)).bit6)
#define	FP2GS1	((*((__RAM struct specialRegister *)0x9A)).bit5)
#define	FP2GS0	((*((__RAM struct specialRegister *)0x9A)).bit4)
#define	FP1GS1	((*((__RAM struct specialRegister *)0x9A)).bit2)
#define	FP1GS0	((*((__RAM struct specialRegister *)0x9A)).bit1)
#define	FPGIAENB	((*((__RAM struct specialRegister *)0x9A)).bit0)
#define	OPM	(*((__RAM unsigned int*)0x9B))
#define	FOP2ENB	((*((__RAM struct specialRegister *)0x9B)).bit1)
#define	FOP1ENB	((*((__RAM struct specialRegister *)0x9B)).bit0)
#define	ADM	(*((__RAM unsigned int*)0xB1))
#define	FADENB	((*((__RAM struct specialRegister *)0xB1)).bit7)
#define	FADS	((*((__RAM struct specialRegister *)0xB1)).bit6)
#define	FEOC	((*((__RAM struct specialRegister *)0xB1)).bit5)
#define	FGCHS	((*((__RAM struct specialRegister *)0xB1)).bit4)
#define	FCHS1	((*((__RAM struct specialRegister *)0xB1)).bit1)
#define	FCHS0	((*((__RAM struct specialRegister *)0xB1)).bit0)
#define	ADB	(*((__RAM unsigned int*)0xb2))
#define	ADR	(*((__RAM unsigned int*)0xb3))
#define	FADCKS1	((*((__RAM struct specialRegister *)0xb3)).bit6)
#define	FADLEN	((*((__RAM struct specialRegister *)0xb3)).bit5)
#define	FADCKS0	((*((__RAM struct specialRegister *)0xb3)).bit4)
#define	FADB3	((*((__RAM struct specialRegister *)0xb3)).bit3)
#define	FADB2	((*((__RAM struct specialRegister *)0xb3)).bit2)
#define	FADB1	((*((__RAM struct specialRegister *)0xb3)).bit1)
#define	FADB0	((*((__RAM struct specialRegister *)0xb3)).bit0)
#define	SIOM	(*((__RAM unsigned int*)0xB4))
#define	FSENB	((*((__RAM struct specialRegister *)0xB4)).bit7)
#define	FSTART	((*((__RAM struct specialRegister *)0xB4)).bit6)
#define	FSRATE1	((*((__RAM struct specialRegister *)0xB4)).bit5)
#define	FSRATE0	((*((__RAM struct specialRegister *)0xB4)).bit4)
#define	FSIG	((*((__RAM struct specialRegister *)0xB4)).bit3)
#define	FSCKMD	((*((__RAM struct specialRegister *)0xB4)).bit2)
#define	FSEDGE	((*((__RAM struct specialRegister *)0xB4)).bit1)
#define	FTXRX	((*((__RAM struct specialRegister *)0xB4)).bit0)
#define	SIOR	(*((__RAM unsigned int*)0xB5))
#define	SIOB	(*((__RAM unsigned int*)0xB6))
#define	PEDGE	(*((__RAM unsigned int*)0xBF))
#define	FPEDGEN	((*((__RAM struct specialRegister *)0xBF)).bit7)
#define	FP00G0	((*((__RAM struct specialRegister *)0xBF)).bit3)
#define	FP00G1	((*((__RAM struct specialRegister *)0xBF)).bit4)
#define	P1W	(*((__RAM unsigned int*)0xc0))
#define	FP13W	((*((__RAM struct specialRegister *)0xc0)).bit3)
#define	FP12W	((*((__RAM struct specialRegister *)0xc0)).bit2)
#define	FP11W	((*((__RAM struct specialRegister *)0xc0)).bit1)
#define	FP10W	((*((__RAM struct specialRegister *)0xc0)).bit0)
#define	P1M	(*((__RAM unsigned int*)0xC1))
#define	FP13M	((*((__RAM struct specialRegister *)0xC1)).bit3)
#define	FP12M	((*((__RAM struct specialRegister *)0xC1)).bit2)
#define	FP11M	((*((__RAM struct specialRegister *)0xC1)).bit1)
#define	FP10M	((*((__RAM struct specialRegister *)0xC1)).bit0)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	FP53M	((*((__RAM struct specialRegister *)0xc5)).bit3)
#define	FP52M	((*((__RAM struct specialRegister *)0xc5)).bit2)
#define	FP51M	((*((__RAM struct specialRegister *)0xc5)).bit1)
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FTC1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit6)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FSIOIRQ	((*((__RAM struct specialRegister *)0xc8)).bit3)
#define	FP01IRQ	((*((__RAM struct specialRegister *)0xc8)).bit1)
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FTC1IEN	((*((__RAM struct specialRegister *)0xc9)).bit6)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FSIOIEN	((*((__RAM struct specialRegister *)0xc9)).bit3)
#define	FP01IEN	((*((__RAM struct specialRegister *)0xc9)).bit1)
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	OSCM	(*((__RAM unsigned int*)0xCA))
#define	FWTCKS	((*((__RAM struct specialRegister *)0xCA)).bit7)
#define	FWDRST	((*((__RAM struct specialRegister *)0xCA)).bit6)
#define	FWDRATE	((*((__RAM struct specialRegister *)0xCA)).bit5)
#define	FCPUM1	((*((__RAM struct specialRegister *)0xCA)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xCA)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xCA)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xCA)).bit1)
#define	TC0R	(*((__RAM unsigned int*)0xCD))
#define	PCL	(*((__RAM unsigned int*)0xCE))
#define	PCH	(*((__RAM unsigned int*)0xCF))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP01	((*((__RAM struct specialRegister *)0xd0)).bit1)
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	P1	(*((__RAM unsigned int*)0xD1))
#define	FP13	((*((__RAM struct specialRegister *)0xD1)).bit3)
#define	FP12	((*((__RAM struct specialRegister *)0xD1)).bit2)
#define	FP11	((*((__RAM struct specialRegister *)0xD1)).bit1)
#define	FP10	((*((__RAM struct specialRegister *)0xD1)).bit0)
#define	P2	(*((__RAM unsigned int*)0xD2))
#define	FP27	((*((__RAM struct specialRegister *)0xD2)).bit7)
#define	FP26	((*((__RAM struct specialRegister *)0xD2)).bit6)
#define	FP25	((*((__RAM struct specialRegister *)0xD2)).bit5)
#define	FP24	((*((__RAM struct specialRegister *)0xD2)).bit4)
#define	FP23	((*((__RAM struct specialRegister *)0xD2)).bit3)
#define	FP22	((*((__RAM struct specialRegister *)0xD2)).bit2)
#define	FP21	((*((__RAM struct specialRegister *)0xD2)).bit1)
#define	FP20	((*((__RAM struct specialRegister *)0xD2)).bit0)
#define	P5	(*((__RAM unsigned int*)0xD5))
#define	FP54	((*((__RAM struct specialRegister *)0xD5)).bit4)
#define	FP53	((*((__RAM struct specialRegister *)0xD5)).bit3)
#define	FP52	((*((__RAM struct specialRegister *)0xD5)).bit2)
#define	FP51	((*((__RAM struct specialRegister *)0xD5)).bit1)
#define	FP50	((*((__RAM struct specialRegister *)0xD5)).bit0)
#define	T0M	(*((__RAM unsigned int*)0xD8))
#define	FT0ENB	((*((__RAM struct specialRegister *)0xD8)).bit7)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xD8)).bit6)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xD8)).bit5)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xD8)).bit4)
#define	FTC1X8	((*((__RAM struct specialRegister *)0xD8)).bit3)
#define	FTC0X8	((*((__RAM struct specialRegister *)0xD8)).bit2)
#define	FTC0GN	((*((__RAM struct specialRegister *)0xD8)).bit1)
#define	FT0TB	((*((__RAM struct specialRegister *)0xD8)).bit0)
#define	T0C	(*((__RAM unsigned int*)0xD9))
#define	TC0M	(*((__RAM unsigned int*)0xda))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	FTC0CKS	((*((__RAM struct specialRegister *)0xda)).bit3)
#define	FALOAD0	((*((__RAM struct specialRegister *)0xda)).bit2)
#define	FTC0OUT	((*((__RAM struct specialRegister *)0xda)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xDB))
#define	TC1M	(*((__RAM unsigned int*)0xDC))
#define	FTC1ENB	((*((__RAM struct specialRegister *)0xDC)).bit7)
#define	FTC1RATE2	((*((__RAM struct specialRegister *)0xDC)).bit6)
#define	FTC1RATE1	((*((__RAM struct specialRegister *)0xDC)).bit5)
#define	FTC1RATE0	((*((__RAM struct specialRegister *)0xDC)).bit4)
#define	FTC1CKS	((*((__RAM struct specialRegister *)0xDC)).bit3)
#define	FALOAD1	((*((__RAM struct specialRegister *)0xDC)).bit2)
#define	FTC1OUT	((*((__RAM struct specialRegister *)0xDC)).bit1)
#define	FPWM1OUT	((*((__RAM struct specialRegister *)0xDC)).bit0)
#define	TC1C	(*((__RAM unsigned int*)0xDD))
#define	TC1R	(*((__RAM unsigned int*)0xDE))
#define	STKP	(*((__RAM unsigned int*)0xDF))
#define	FGIE	((*((__RAM struct specialRegister *)0xDF)).bit7)
#define	FSTKPB3	((*((__RAM struct specialRegister *)0xDF)).bit3)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xDF)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xDF)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xDF)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xE0))
#define	FP01R	((*((__RAM struct specialRegister *)0xE0)).bit1)
#define	FP00R	((*((__RAM struct specialRegister *)0xE0)).bit0)
#define	P1UR	(*((__RAM unsigned int*)0xE1))
#define	FP13R	((*((__RAM struct specialRegister *)0xE1)).bit3)
#define	FP12R	((*((__RAM struct specialRegister *)0xE1)).bit2)
#define	FP11R	((*((__RAM struct specialRegister *)0xE1)).bit1)
#define	FP10R	((*((__RAM struct specialRegister *)0xE1)).bit0)
#define	P2UR	(*((__RAM unsigned int*)0xE2))
#define	FP27R	((*((__RAM struct specialRegister *)0xE2)).bit7)
#define	FP26R	((*((__RAM struct specialRegister *)0xE2)).bit6)
#define	FP25R	((*((__RAM struct specialRegister *)0xE2)).bit5)
#define	FP24R	((*((__RAM struct specialRegister *)0xE2)).bit4)
#define	FP23R	((*((__RAM struct specialRegister *)0xE2)).bit3)
#define	FP22R	((*((__RAM struct specialRegister *)0xE2)).bit2)
#define	FP21R	((*((__RAM struct specialRegister *)0xE2)).bit1)
#define	FP20R	((*((__RAM struct specialRegister *)0xE2)).bit0)
#define	P5UR	(*((__RAM unsigned int*)0xE5))
#define	FP54R	((*((__RAM struct specialRegister *)0xE5)).bit4)
#define	FP53R	((*((__RAM struct specialRegister *)0xE5)).bit3)
#define	FP52R	((*((__RAM struct specialRegister *)0xE5)).bit2)
#define	FP51R	((*((__RAM struct specialRegister *)0xE5)).bit1)
#define	FP50R	((*((__RAM struct specialRegister *)0xE5)).bit0)
#define	_HL	(*((__RAM unsigned int*)0xE6))
#define	DP0X	(*((__RAM unsigned int*)0xE6))
#define	_YZ	(*((__RAM unsigned int*)0xE7))
#define	DP1X	(*((__RAM unsigned int*)0xE7))
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#if ICE_Mode == 1
#define	P3M	(*((__RAM unsigned int*)0xC3))
#define	FP37M	((*((__RAM struct specialRegister *)0xC3)).bit7)
#define	FP36M	((*((__RAM struct specialRegister *)0xC3)).bit6)
#define	FP35M	((*((__RAM struct specialRegister *)0xC3)).bit5)
#define	FP34M	((*((__RAM struct specialRegister *)0xC3)).bit4)
#define	FP33M	((*((__RAM struct specialRegister *)0xC3)).bit3)
#define	FP32M	((*((__RAM struct specialRegister *)0xC3)).bit2)
#define	FP31M	((*((__RAM struct specialRegister *)0xC3)).bit1)
#define	FP30M	((*((__RAM struct specialRegister *)0xC3)).bit0)
#define	P3	(*((__RAM unsigned int*)0xD3))
#define	FP37	((*((__RAM struct specialRegister *)0xD3)).bit7)
#define	FP36	((*((__RAM struct specialRegister *)0xD3)).bit6)
#define	FP35	((*((__RAM struct specialRegister *)0xD3)).bit5)
#define	FP34	((*((__RAM struct specialRegister *)0xD3)).bit4)
#define	FP33	((*((__RAM struct specialRegister *)0xD3)).bit3)
#define	FP32	((*((__RAM struct specialRegister *)0xD3)).bit2)
#define	FP31	((*((__RAM struct specialRegister *)0xD3)).bit1)
#define	FP30	((*((__RAM struct specialRegister *)0xD3)).bit0)
#define	P3UR	(*((__RAM unsigned int*)0xE3))
#define	FP37R	((*((__RAM struct specialRegister *)0xE3)).bit7)
#define	FP36R	((*((__RAM struct specialRegister *)0xE3)).bit6)
#define	FP35R	((*((__RAM struct specialRegister *)0xE3)).bit5)
#define	FP34R	((*((__RAM struct specialRegister *)0xE3)).bit4)
#define	FP33R	((*((__RAM struct specialRegister *)0xE3)).bit3)
#define	FP32R	((*((__RAM struct specialRegister *)0xE3)).bit2)
#define	FP31R	((*((__RAM struct specialRegister *)0xE3)).bit1)
#define	FP30R	((*((__RAM struct specialRegister *)0xE3)).bit0)
#endif
#endif
