#ifndef __SN8P1989__H
#define __SN8P1989__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	X	(*((__RAM unsigned int*)0x85))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	RBANK	(*((__RAM unsigned int*)0x87))
#define	FRBNKS0	((*((__RAM struct specialRegister *)0x87)).bit0)
#define	FRBNKS1	((*((__RAM struct specialRegister *)0x87)).bit1)
#define	FRBNKS2	((*((__RAM struct specialRegister *)0x87)).bit2)
#define	FRBNKS3	((*((__RAM struct specialRegister *)0x87)).bit3)
#define	OPTION	(*((__RAM unsigned int*)0x88))
#define	FRCLK	((*((__RAM struct specialRegister *)0x88)).bit0)
#if ICE_Mode == 1
#define	LCDM1	(*((__RAM unsigned int*)0XCB))
#define	FLCDBNK	((*((__RAM struct specialRegister *)0XCB)).bit5)
#define	FLCDENB	((*((__RAM struct specialRegister *)0XCB)).bit3)
#define	FLCDBIAS	((*((__RAM struct specialRegister *)0XCB)).bit2)
#define	Dummy	(*((__RAM unsigned int*)0X8F))
#define	FP2HSEG	((*((__RAM struct specialRegister *)0X8F)).bit1)
#define	FP2LSEG	((*((__RAM struct specialRegister *)0X8F)).bit0)
#else
#define	LCDM1	(*((__RAM unsigned int*)0x89))
#define	FLCDBNK	((*((__RAM struct specialRegister *)0x89)).bit5)
#define	FLCDENB	((*((__RAM struct specialRegister *)0x89)).bit3)
#define	FLCDBIAS	((*((__RAM struct specialRegister *)0x89)).bit2)
#define	FP2HSEG	((*((__RAM struct specialRegister *)0x89)).bit1)
#define	FP2LSEG	((*((__RAM struct specialRegister *)0x89)).bit0)
#endif
#define	AMPM	(*((__RAM unsigned int*)0x90))
#define	FBGRENB	((*((__RAM struct specialRegister *)0x90)).bit6)
#define	FFDS1	((*((__RAM struct specialRegister *)0x90)).bit5)
#define	FFDS0	((*((__RAM struct specialRegister *)0x90)).bit4)
#define	FGS2	((*((__RAM struct specialRegister *)0x90)).bit3)
#define	FGS1	((*((__RAM struct specialRegister *)0x90)).bit2)
#define	FGS0	((*((__RAM struct specialRegister *)0x90)).bit1)
#define	FAMPENB	((*((__RAM struct specialRegister *)0x90)).bit0)
#define	AMPCHS	(*((__RAM unsigned int*)0x91))
#define	FADC16CHS3	((*((__RAM struct specialRegister *)0x91)).bit3)
#define	FADC16CHS2	((*((__RAM struct specialRegister *)0x91)).bit2)
#define	FADC16CHS1	((*((__RAM struct specialRegister *)0x91)).bit1)
#define	FADC16CHS0	((*((__RAM struct specialRegister *)0x91)).bit0)
#define	AMPCKS	(*((__RAM unsigned int*)0x92))
#define	ADC16M	(*((__RAM unsigned int*)0x93))
#define	FIRVS	((*((__RAM struct specialRegister *)0x93)).bit3)
#define	FRVS1	((*((__RAM struct specialRegister *)0x93)).bit2)
#define	FRVS0	((*((__RAM struct specialRegister *)0x93)).bit1)
#define	FADC16ENB	((*((__RAM struct specialRegister *)0x93)).bit0)
#define	ADCKS	(*((__RAM unsigned int*)0X94))
#define	REGM	(*((__RAM unsigned int*)0x95))
#define	FACMENB	((*((__RAM struct specialRegister *)0x95)).bit7)
#define	FAVDDRENB	((*((__RAM struct specialRegister *)0x95)).bit6)
#define	FAVENB	((*((__RAM struct specialRegister *)0x95)).bit5)
#define	FAVESEL1	((*((__RAM struct specialRegister *)0x95)).bit4)
#define	FAVESEL0	((*((__RAM struct specialRegister *)0x95)).bit3)
#define	FREGENB	((*((__RAM struct specialRegister *)0x95)).bit0)
#define	DFM	(*((__RAM unsigned int*)0x97))
#define	FWRS0	((*((__RAM struct specialRegister *)0x97)).bit2)
#define	FDRDY	((*((__RAM struct specialRegister *)0x97)).bit0)
#define	ADCDL	(*((__RAM unsigned int*)0x98))
#define	ADCDH	(*((__RAM unsigned int*)0x99))
#define	LBTM	(*((__RAM unsigned int*)0x9A))
#define	FLBTO	((*((__RAM struct specialRegister *)0x9A)).bit2)
#define	FLBTENB	((*((__RAM struct specialRegister *)0x9A)).bit0)
#define	BZC	(*((__RAM unsigned int*)0X9B))
#define	BZM	(*((__RAM unsigned int*)0X9C))
#define	FBZOENB	((*((__RAM struct specialRegister *)0X9C)).bit7)
#define	FBZORATE2	((*((__RAM struct specialRegister *)0X9C)).bit6)
#define	FBZORATE1	((*((__RAM struct specialRegister *)0X9C)).bit5)
#define	FBZORATE0	((*((__RAM struct specialRegister *)0X9C)).bit4)
#define	FBZOX8	((*((__RAM struct specialRegister *)0X9C)).bit2)
#define	LASERM	(*((__RAM unsigned int*)0X9D))
#define	ADC12M	(*((__RAM unsigned int*)0xB1))
#define	FADC12ENB	((*((__RAM struct specialRegister *)0xB1)).bit7)
#define	FADS	((*((__RAM struct specialRegister *)0xB1)).bit6)
#define	FEOC	((*((__RAM struct specialRegister *)0xB1)).bit5)
#define	FGCHS	((*((__RAM struct specialRegister *)0xB1)).bit4)
#define	FADC12CHS1	((*((__RAM struct specialRegister *)0xB1)).bit1)
#define	FADC12CHS0	((*((__RAM struct specialRegister *)0xB1)).bit0)
#define	ADB	(*((__RAM unsigned int*)0xb2))
#define	ADR	(*((__RAM unsigned int*)0xb3))
#define	FAD12CKS1	((*((__RAM struct specialRegister *)0xb3)).bit6)
#define	FAD12CKS	((*((__RAM struct specialRegister *)0xb3)).bit6)
#define	FAD12CKS0	((*((__RAM struct specialRegister *)0xb3)).bit4)
#define	FADB3	((*((__RAM struct specialRegister *)0xb3)).bit3)
#define	FADB2	((*((__RAM struct specialRegister *)0xb3)).bit2)
#define	FADB1	((*((__RAM struct specialRegister *)0xb3)).bit1)
#define	FADB0	((*((__RAM struct specialRegister *)0xb3)).bit0)
#define	PEDGE	(*((__RAM unsigned int*)0xBF))
#define	FPEDGEN	((*((__RAM struct specialRegister *)0xBF)).bit7)
#define	FP00G0	((*((__RAM struct specialRegister *)0xBF)).bit3)
#define	FP00G1	((*((__RAM struct specialRegister *)0xBF)).bit4)
#define	P1W	(*((__RAM unsigned int*)0xc0))
#define	FP17W	((*((__RAM struct specialRegister *)0xc0)).bit7)
#define	FP16W	((*((__RAM struct specialRegister *)0xc0)).bit6)
#define	FP15W	((*((__RAM struct specialRegister *)0xc0)).bit5)
#define	FP14W	((*((__RAM struct specialRegister *)0xc0)).bit4)
#define	FP13W	((*((__RAM struct specialRegister *)0xc0)).bit3)
#define	FP12W	((*((__RAM struct specialRegister *)0xc0)).bit2)
#define	FP11W	((*((__RAM struct specialRegister *)0xc0)).bit1)
#define	FP10W	((*((__RAM struct specialRegister *)0xc0)).bit0)
#define	P1M	(*((__RAM unsigned int*)0xC1))
#define	FP17M	((*((__RAM struct specialRegister *)0xC1)).bit7)
#define	FP16M	((*((__RAM struct specialRegister *)0xC1)).bit6)
#define	FP15M	((*((__RAM struct specialRegister *)0xC1)).bit5)
#define	FP14M	((*((__RAM struct specialRegister *)0xC1)).bit4)
#define	FP13M	((*((__RAM struct specialRegister *)0xC1)).bit3)
#define	FP12M	((*((__RAM struct specialRegister *)0xC1)).bit2)
#define	FP11M	((*((__RAM struct specialRegister *)0xC1)).bit1)
#define	FP10M	((*((__RAM struct specialRegister *)0xC1)).bit0)
#define	P2M	(*((__RAM unsigned int*)0xC2))
#define	FP27M	((*((__RAM struct specialRegister *)0xC2)).bit7)
#define	FP26M	((*((__RAM struct specialRegister *)0xC2)).bit6)
#define	FP25M	((*((__RAM struct specialRegister *)0xC2)).bit5)
#define	FP24M	((*((__RAM struct specialRegister *)0xC2)).bit4)
#define	FP23M	((*((__RAM struct specialRegister *)0xC2)).bit3)
#define	FP22M	((*((__RAM struct specialRegister *)0xC2)).bit2)
#define	FP21M	((*((__RAM struct specialRegister *)0xC2)).bit1)
#define	FP20M	((*((__RAM struct specialRegister *)0xC2)).bit0)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP57M	((*((__RAM struct specialRegister *)0xc5)).bit7)
#define	FP56M	((*((__RAM struct specialRegister *)0xc5)).bit6)
#define	FP55M	((*((__RAM struct specialRegister *)0xc5)).bit5)
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	FP53M	((*((__RAM struct specialRegister *)0xc5)).bit3)
#define	FP52M	((*((__RAM struct specialRegister *)0xc5)).bit2)
#define	FP51M	((*((__RAM struct specialRegister *)0xc5)).bit1)
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FTC1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit6)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FADC16IRQ	((*((__RAM struct specialRegister *)0xc8)).bit2)
#define	FP01IRQ	((*((__RAM struct specialRegister *)0xc8)).bit1)
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FTC1IEN	((*((__RAM struct specialRegister *)0xc9)).bit6)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FADC16IEN	((*((__RAM struct specialRegister *)0xc9)).bit2)
#define	FP01IEN	((*((__RAM struct specialRegister *)0xc9)).bit1)
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	OSCM	(*((__RAM unsigned int*)0xCA))
#define	FWTCKS	((*((__RAM struct specialRegister *)0xCA)).bit7)
#define	FWDRST	((*((__RAM struct specialRegister *)0xCA)).bit6)
#define	FWDRATE	((*((__RAM struct specialRegister *)0xCA)).bit5)
#define	FCPUM1	((*((__RAM struct specialRegister *)0xCA)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xCA)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xCA)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xCA)).bit1)
#define	TC0R	(*((__RAM unsigned int*)0xCD))
#define	PCL	(*((__RAM unsigned int*)0xCE))
#define	PCH	(*((__RAM unsigned int*)0xCF))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP02	((*((__RAM struct specialRegister *)0xd0)).bit2)
#define	FP01	((*((__RAM struct specialRegister *)0xd0)).bit1)
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	P1	(*((__RAM unsigned int*)0xD1))
#define	FP17	((*((__RAM struct specialRegister *)0xD1)).bit7)
#define	FP16	((*((__RAM struct specialRegister *)0xD1)).bit6)
#define	FP15	((*((__RAM struct specialRegister *)0xD1)).bit5)
#define	FP14	((*((__RAM struct specialRegister *)0xD1)).bit4)
#define	FP13	((*((__RAM struct specialRegister *)0xD1)).bit3)
#define	FP12	((*((__RAM struct specialRegister *)0xD1)).bit2)
#define	FP11	((*((__RAM struct specialRegister *)0xD1)).bit1)
#define	FP10	((*((__RAM struct specialRegister *)0xD1)).bit0)
#define	P2	(*((__RAM unsigned int*)0xD2))
#define	FP27	((*((__RAM struct specialRegister *)0xD2)).bit7)
#define	FP26	((*((__RAM struct specialRegister *)0xD2)).bit6)
#define	FP25	((*((__RAM struct specialRegister *)0xD2)).bit5)
#define	FP24	((*((__RAM struct specialRegister *)0xD2)).bit4)
#define	FP23	((*((__RAM struct specialRegister *)0xD2)).bit3)
#define	FP22	((*((__RAM struct specialRegister *)0xD2)).bit2)
#define	FP21	((*((__RAM struct specialRegister *)0xD2)).bit1)
#define	FP20	((*((__RAM struct specialRegister *)0xD2)).bit0)
#define	P5	(*((__RAM unsigned int*)0xD5))
#define	FP57	((*((__RAM struct specialRegister *)0xD5)).bit7)
#define	FP56	((*((__RAM struct specialRegister *)0xD5)).bit6)
#define	FP55	((*((__RAM struct specialRegister *)0xD5)).bit5)
#define	FP54	((*((__RAM struct specialRegister *)0xD5)).bit4)
#define	FP53	((*((__RAM struct specialRegister *)0xD5)).bit3)
#define	FP52	((*((__RAM struct specialRegister *)0xD5)).bit2)
#define	FP51	((*((__RAM struct specialRegister *)0xD5)).bit1)
#define	FP50	((*((__RAM struct specialRegister *)0xD5)).bit0)
#define	T0M	(*((__RAM unsigned int*)0xD8))
#define	FT0ENB	((*((__RAM struct specialRegister *)0xD8)).bit7)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xD8)).bit6)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xD8)).bit5)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xD8)).bit4)
#define	FTC1X8	((*((__RAM struct specialRegister *)0xD8)).bit3)
#define	FTC0X8	((*((__RAM struct specialRegister *)0xD8)).bit2)
#define	FTC0GN	((*((__RAM struct specialRegister *)0xD8)).bit1)
#define	FT0TB	((*((__RAM struct specialRegister *)0xD8)).bit0)
#define	T0C	(*((__RAM unsigned int*)0xD9))
#define	TC0M	(*((__RAM unsigned int*)0xda))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	FALOAD0	((*((__RAM struct specialRegister *)0xda)).bit2)
#define	FTC0OUT	((*((__RAM struct specialRegister *)0xda)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xDB))
#define	TC1M	(*((__RAM unsigned int*)0xDC))
#define	FTC1ENB	((*((__RAM struct specialRegister *)0xDC)).bit7)
#define	FTC1RATE2	((*((__RAM struct specialRegister *)0xDC)).bit6)
#define	FTC1RATE1	((*((__RAM struct specialRegister *)0xDC)).bit5)
#define	FTC1RATE0	((*((__RAM struct specialRegister *)0xDC)).bit4)
#define	FALOAD1	((*((__RAM struct specialRegister *)0xDC)).bit2)
#define	FTC1OUT	((*((__RAM struct specialRegister *)0xDC)).bit1)
#define	FPWM1OUT	((*((__RAM struct specialRegister *)0xDC)).bit0)
#define	TC1C	(*((__RAM unsigned int*)0xDD))
#define	TC1R	(*((__RAM unsigned int*)0xDE))
#define	STKP	(*((__RAM unsigned int*)0xDF))
#define	FGIE	((*((__RAM struct specialRegister *)0xDF)).bit7)
#define	FSTKPB3	((*((__RAM struct specialRegister *)0xDF)).bit3)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xDF)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xDF)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xDF)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xE0))
#define	FP01R	((*((__RAM struct specialRegister *)0xE0)).bit1)
#define	FP00R	((*((__RAM struct specialRegister *)0xE0)).bit0)
#define	P1UR	(*((__RAM unsigned int*)0xE1))
#define	FP17R	((*((__RAM struct specialRegister *)0xE1)).bit7)
#define	FP16R	((*((__RAM struct specialRegister *)0xE1)).bit6)
#define	FP15R	((*((__RAM struct specialRegister *)0xE1)).bit5)
#define	FP14R	((*((__RAM struct specialRegister *)0xE1)).bit4)
#define	FP13R	((*((__RAM struct specialRegister *)0xE1)).bit3)
#define	FP12R	((*((__RAM struct specialRegister *)0xE1)).bit2)
#define	FP11R	((*((__RAM struct specialRegister *)0xE1)).bit1)
#define	FP10R	((*((__RAM struct specialRegister *)0xE1)).bit0)
#define	P2UR	(*((__RAM unsigned int*)0xE2))
#define	FP27R	((*((__RAM struct specialRegister *)0xE2)).bit7)
#define	FP26R	((*((__RAM struct specialRegister *)0xE2)).bit6)
#define	FP25R	((*((__RAM struct specialRegister *)0xE2)).bit5)
#define	FP24R	((*((__RAM struct specialRegister *)0xE2)).bit4)
#define	FP23R	((*((__RAM struct specialRegister *)0xE2)).bit3)
#define	FP22R	((*((__RAM struct specialRegister *)0xE2)).bit2)
#define	FP21R	((*((__RAM struct specialRegister *)0xE2)).bit1)
#define	FP20R	((*((__RAM struct specialRegister *)0xE2)).bit0)
#define	P5UR	(*((__RAM unsigned int*)0xE5))
#define	FP57R	((*((__RAM struct specialRegister *)0xE5)).bit7)
#define	FP56R	((*((__RAM struct specialRegister *)0xE5)).bit6)
#define	FP55R	((*((__RAM struct specialRegister *)0xE5)).bit5)
#define	FP54R	((*((__RAM struct specialRegister *)0xE5)).bit4)
#define	FP53R	((*((__RAM struct specialRegister *)0xE5)).bit3)
#define	FP52R	((*((__RAM struct specialRegister *)0xE5)).bit2)
#define	FP51R	((*((__RAM struct specialRegister *)0xE5)).bit1)
#define	FP50R	((*((__RAM struct specialRegister *)0xE5)).bit0)
#define	_HL	(*((__RAM unsigned int*)0xE6))
#define	DP0X	(*((__RAM unsigned int*)0xE6))
#define	_YZ	(*((__RAM unsigned int*)0xE7))
#define	DP1X	(*((__RAM unsigned int*)0xE7))
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#if ICE_Mode == 1
#define	P3M	(*((__RAM unsigned int*)0xc3))
#define	FP37M	((*((__RAM struct specialRegister *)0xc3)).bit7)
#define	FP36M	((*((__RAM struct specialRegister *)0xc3)).bit6)
#define	FP35M	((*((__RAM struct specialRegister *)0xc3)).bit5)
#define	FP34M	((*((__RAM struct specialRegister *)0xc3)).bit4)
#define	P3	(*((__RAM unsigned int*)0xD3))
#define	FP37	((*((__RAM struct specialRegister *)0xD3)).bit7)
#define	FP36	((*((__RAM struct specialRegister *)0xD3)).bit6)
#define	FP35	((*((__RAM struct specialRegister *)0xD3)).bit5)
#define	FP34	((*((__RAM struct specialRegister *)0xD3)).bit4)
#define	P3UR	(*((__RAM unsigned int*)0xE3))
#define	FP37R	((*((__RAM struct specialRegister *)0xE3)).bit7)
#define	FP36R	((*((__RAM struct specialRegister *)0xE3)).bit6)
#define	FP35R	((*((__RAM struct specialRegister *)0xE3)).bit5)
#define	FP34R	((*((__RAM struct specialRegister *)0xE3)).bit4)
#endif
#endif
