#ifndef __SN8FMD23L__H
#define __SN8FMD23L__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	X	(*((__RAM unsigned int*)0x85))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FSTKOV	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FRST	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FWDT	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FPOR	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	RBANK	(*((__RAM unsigned int*)0x87))
#define	FRBANKS0	((*((__RAM struct specialRegister *)0x87)).bit0)
#define	FRBANKS1	((*((__RAM struct specialRegister *)0x87)).bit1)
#define	FRBANKS2	((*((__RAM struct specialRegister *)0x87)).bit2)
#define	W0	(*((__RAM unsigned int*)0x88))
#define	W1	(*((__RAM unsigned int*)0x89))
#define	W2	(*((__RAM unsigned int*)0x8a))
#define	W3	(*((__RAM unsigned int*)0x8b))
#define	W4	(*((__RAM unsigned int*)0x8c))
#define	W5	(*((__RAM unsigned int*)0x8d))
#define	W6	(*((__RAM unsigned int*)0x8e))
#define	W7	(*((__RAM unsigned int*)0x8f))
#define	_HL	(*((__RAM unsigned int*)0x90))
#define	_YZ	(*((__RAM unsigned int*)0x91))
#define	P2OC	(*((__RAM unsigned int*)0x92))
#define	FP20OC	((*((__RAM struct specialRegister *)0x92)).bit0)
#define	FP21OC	((*((__RAM struct specialRegister *)0x92)).bit1)
#define	FP24OC	((*((__RAM struct specialRegister *)0x92)).bit4)
#define	FP25OC	((*((__RAM struct specialRegister *)0x92)).bit5)
#define	PCL	(*((__RAM unsigned int*)0x93))
#define	PCH	(*((__RAM unsigned int*)0x94))
#define	OSCM	(*((__RAM unsigned int*)0x95))
#define	FCPUM1	((*((__RAM struct specialRegister *)0x95)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0x95)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0x95)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0x95)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0x96))
#define	INTRQ0	(*((__RAM unsigned int*)0x97))
#define	FCM0IRQ	((*((__RAM struct specialRegister *)0x97)).bit7)
#define	FT1IRQ	((*((__RAM struct specialRegister *)0x97)).bit6)
#define	FTC2IRQ	((*((__RAM struct specialRegister *)0x97)).bit5)
#define	FTC1IRQ	((*((__RAM struct specialRegister *)0x97)).bit4)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0x97)).bit3)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0x97)).bit2)
#define	FP01IRQ	((*((__RAM struct specialRegister *)0x97)).bit1)
#define	FP00IRQ	((*((__RAM struct specialRegister *)0x97)).bit0)
#define	INTRQ1	(*((__RAM unsigned int*)0x98))
#define	FMSPIRQ	((*((__RAM struct specialRegister *)0x98)).bit4)
#define	FUTXIRQ	((*((__RAM struct specialRegister *)0x98)).bit3)
#define	FURXIRQ	((*((__RAM struct specialRegister *)0x98)).bit2)
#define	FSIOIRQ	((*((__RAM struct specialRegister *)0x98)).bit1)
#define	FWAKEIRQ	((*((__RAM struct specialRegister *)0x98)).bit0)
#define	INTEN0	(*((__RAM unsigned int*)0x9a))
#define	FCM0IEN	((*((__RAM struct specialRegister *)0x9a)).bit7)
#define	FT1IEN	((*((__RAM struct specialRegister *)0x9a)).bit6)
#define	FTC2IEN	((*((__RAM struct specialRegister *)0x9a)).bit5)
#define	FTC1IEN	((*((__RAM struct specialRegister *)0x9a)).bit4)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0x9a)).bit3)
#define	FT0IEN	((*((__RAM struct specialRegister *)0x9a)).bit2)
#define	FP01IEN	((*((__RAM struct specialRegister *)0x9a)).bit1)
#define	FP00IEN	((*((__RAM struct specialRegister *)0x9a)).bit0)
#define	INTEN1	(*((__RAM unsigned int*)0x9b))
#define	FMSPIEN	((*((__RAM struct specialRegister *)0x9b)).bit4)
#define	FUTXIEN	((*((__RAM struct specialRegister *)0x9b)).bit3)
#define	FURXIEN	((*((__RAM struct specialRegister *)0x9b)).bit2)
#define	FSIOIEN	((*((__RAM struct specialRegister *)0x9b)).bit1)
#define	FWAKEIEN	((*((__RAM struct specialRegister *)0x9b)).bit0)
#define	P1W	(*((__RAM unsigned int*)0x99))
#define	FP17W	((*((__RAM struct specialRegister *)0x99)).bit7)
#define	FP16W	((*((__RAM struct specialRegister *)0x99)).bit6)
#define	FP15W	((*((__RAM struct specialRegister *)0x99)).bit5)
#define	FP14W	((*((__RAM struct specialRegister *)0x99)).bit4)
#define	FP13W	((*((__RAM struct specialRegister *)0x99)).bit3)
#define	FP12W	((*((__RAM struct specialRegister *)0x99)).bit2)
#define	FP11W	((*((__RAM struct specialRegister *)0x99)).bit1)
#define	FP10W	((*((__RAM struct specialRegister *)0x99)).bit0)
#define	CM0M	(*((__RAM unsigned int*)0x9c))
#define	FCMCH0	((*((__RAM struct specialRegister *)0x9c)).bit0)
#define	FCMCH1	((*((__RAM struct specialRegister *)0x9c)).bit1)
#define	FCMCH2	((*((__RAM struct specialRegister *)0x9c)).bit2)
#define	FCMCH3	((*((__RAM struct specialRegister *)0x9c)).bit3)
#define	FCMCH4	((*((__RAM struct specialRegister *)0x9c)).bit4)
#define	FCM0S0	((*((__RAM struct specialRegister *)0x9c)).bit5)
#define	FCM0S1	((*((__RAM struct specialRegister *)0x9c)).bit6)
#define	FCM0EN	((*((__RAM struct specialRegister *)0x9c)).bit7)
#define	CM0M1	(*((__RAM unsigned int*)0x9d))
#define	FCM0G	((*((__RAM struct specialRegister *)0x9d)).bit0)
#define	FCM0OEN	((*((__RAM struct specialRegister *)0x9d)).bit1)
#define	FCMDB0	((*((__RAM struct specialRegister *)0x9d)).bit2)
#define	FCMDB1	((*((__RAM struct specialRegister *)0x9d)).bit3)
#define	FCM0OUT	((*((__RAM struct specialRegister *)0x9d)).bit6)
#define	FTCHEN	((*((__RAM struct specialRegister *)0x9d)).bit7)
#define	CM0M2	(*((__RAM unsigned int*)0x9e))
#define	FTCHCM0	((*((__RAM struct specialRegister *)0x9e)).bit0)
#define	FTCHCM1	((*((__RAM struct specialRegister *)0x9e)).bit1)
#define	FTCHCM2	((*((__RAM struct specialRegister *)0x9e)).bit2)
#define	FTRS0	((*((__RAM struct specialRegister *)0x9e)).bit4)
#define	FTRS1	((*((__RAM struct specialRegister *)0x9e)).bit5)
#define	FTRS2	((*((__RAM struct specialRegister *)0x9e)).bit6)
#define	FTRS3	((*((__RAM struct specialRegister *)0x9e)).bit7)
#define	PEDGE	(*((__RAM unsigned int*)0x9f))
#define	FP01G1	((*((__RAM struct specialRegister *)0x9f)).bit3)
#define	FP01G0	((*((__RAM struct specialRegister *)0x9f)).bit2)
#define	FP00G1	((*((__RAM struct specialRegister *)0x9f)).bit1)
#define	FP00G0	((*((__RAM struct specialRegister *)0x9f)).bit0)
#define	P0M	(*((__RAM unsigned int*)0xa0))
#define	FP07M	((*((__RAM struct specialRegister *)0xa0)).bit7)
#define	FP06M	((*((__RAM struct specialRegister *)0xa0)).bit6)
#define	FP05M	((*((__RAM struct specialRegister *)0xa0)).bit5)
#define	FP04M	((*((__RAM struct specialRegister *)0xa0)).bit4)
#define	FP03M	((*((__RAM struct specialRegister *)0xa0)).bit3)
#define	FP02M	((*((__RAM struct specialRegister *)0xa0)).bit2)
#define	FP01M	((*((__RAM struct specialRegister *)0xa0)).bit1)
#define	FP00M	((*((__RAM struct specialRegister *)0xa0)).bit0)
#define	P1M	(*((__RAM unsigned int*)0xa1))
#define	FP17M	((*((__RAM struct specialRegister *)0xa1)).bit7)
#define	FP16M	((*((__RAM struct specialRegister *)0xa1)).bit6)
#define	FP15M	((*((__RAM struct specialRegister *)0xa1)).bit5)
#define	FP14M	((*((__RAM struct specialRegister *)0xa1)).bit4)
#define	FP13M	((*((__RAM struct specialRegister *)0xa1)).bit3)
#define	FP12M	((*((__RAM struct specialRegister *)0xa1)).bit2)
#define	FP11M	((*((__RAM struct specialRegister *)0xa1)).bit1)
#define	FP10M	((*((__RAM struct specialRegister *)0xa1)).bit0)
#define	P2M	(*((__RAM unsigned int*)0xa2))
#define	FP25M	((*((__RAM struct specialRegister *)0xa2)).bit5)
#define	FP24M	((*((__RAM struct specialRegister *)0xa2)).bit4)
#define	FP23M	((*((__RAM struct specialRegister *)0xa2)).bit3)
#define	FP22M	((*((__RAM struct specialRegister *)0xa2)).bit2)
#define	FP21M	((*((__RAM struct specialRegister *)0xa2)).bit1)
#define	FP20M	((*((__RAM struct specialRegister *)0xa2)).bit0)
#define	P5M	(*((__RAM unsigned int*)0xa5))
#define	FP57M	((*((__RAM struct specialRegister *)0xa5)).bit7)
#define	FP56M	((*((__RAM struct specialRegister *)0xa5)).bit6)
#define	FP55M	((*((__RAM struct specialRegister *)0xa5)).bit5)
#define	FP54M	((*((__RAM struct specialRegister *)0xa5)).bit4)
#define	FP53M	((*((__RAM struct specialRegister *)0xa5)).bit3)
#define	FP52M	((*((__RAM struct specialRegister *)0xa5)).bit2)
#define	FP51M	((*((__RAM struct specialRegister *)0xa5)).bit1)
#define	FP50M	((*((__RAM struct specialRegister *)0xa5)).bit0)
#define	P0	(*((__RAM unsigned int*)0xa6))
#define	FP07	((*((__RAM struct specialRegister *)0xa6)).bit7)
#define	FP06	((*((__RAM struct specialRegister *)0xa6)).bit6)
#define	FP05	((*((__RAM struct specialRegister *)0xa6)).bit5)
#define	FP04	((*((__RAM struct specialRegister *)0xa6)).bit4)
#define	FP03	((*((__RAM struct specialRegister *)0xa6)).bit3)
#define	FP02	((*((__RAM struct specialRegister *)0xa6)).bit2)
#define	FP01	((*((__RAM struct specialRegister *)0xa6)).bit1)
#define	FP00	((*((__RAM struct specialRegister *)0xa6)).bit0)
#define	P1	(*((__RAM unsigned int*)0xa7))
#define	FP17	((*((__RAM struct specialRegister *)0xa7)).bit7)
#define	FP16	((*((__RAM struct specialRegister *)0xa7)).bit6)
#define	FP15	((*((__RAM struct specialRegister *)0xa7)).bit5)
#define	FP14	((*((__RAM struct specialRegister *)0xa7)).bit4)
#define	FP13	((*((__RAM struct specialRegister *)0xa7)).bit3)
#define	FP12	((*((__RAM struct specialRegister *)0xa7)).bit2)
#define	FP11	((*((__RAM struct specialRegister *)0xa7)).bit1)
#define	FP10	((*((__RAM struct specialRegister *)0xa7)).bit0)
#define	P2	(*((__RAM unsigned int*)0xa8))
#define	FP25	((*((__RAM struct specialRegister *)0xa8)).bit5)
#define	FP24	((*((__RAM struct specialRegister *)0xa8)).bit4)
#define	FP23	((*((__RAM struct specialRegister *)0xa8)).bit3)
#define	FP22	((*((__RAM struct specialRegister *)0xa8)).bit2)
#define	FP21	((*((__RAM struct specialRegister *)0xa8)).bit1)
#define	FP20	((*((__RAM struct specialRegister *)0xa8)).bit0)
#define	P5	(*((__RAM unsigned int*)0xab))
#define	FP57	((*((__RAM struct specialRegister *)0xab)).bit7)
#define	FP56	((*((__RAM struct specialRegister *)0xab)).bit6)
#define	FP55	((*((__RAM struct specialRegister *)0xab)).bit5)
#define	FP54	((*((__RAM struct specialRegister *)0xab)).bit4)
#define	FP53	((*((__RAM struct specialRegister *)0xab)).bit3)
#define	FP52	((*((__RAM struct specialRegister *)0xab)).bit2)
#define	FP51	((*((__RAM struct specialRegister *)0xab)).bit1)
#define	FP50	((*((__RAM struct specialRegister *)0xab)).bit0)
#define	P0UR	(*((__RAM unsigned int*)0xac))
#define	FP00R	((*((__RAM struct specialRegister *)0xac)).bit0)
#define	FP01R	((*((__RAM struct specialRegister *)0xac)).bit1)
#define	FP02R	((*((__RAM struct specialRegister *)0xac)).bit2)
#define	FP03R	((*((__RAM struct specialRegister *)0xac)).bit3)
#define	FP04R	((*((__RAM struct specialRegister *)0xac)).bit4)
#define	FP05R	((*((__RAM struct specialRegister *)0xac)).bit5)
#define	FP06R	((*((__RAM struct specialRegister *)0xac)).bit6)
#define	FP07R	((*((__RAM struct specialRegister *)0xac)).bit7)
#define	P1UR	(*((__RAM unsigned int*)0xad))
#define	FP10R	((*((__RAM struct specialRegister *)0xad)).bit0)
#define	FP11R	((*((__RAM struct specialRegister *)0xad)).bit1)
#define	FP12R	((*((__RAM struct specialRegister *)0xad)).bit2)
#define	FP13R	((*((__RAM struct specialRegister *)0xad)).bit3)
#define	FP14R	((*((__RAM struct specialRegister *)0xad)).bit4)
#define	FP15R	((*((__RAM struct specialRegister *)0xad)).bit5)
#define	FP16R	((*((__RAM struct specialRegister *)0xad)).bit6)
#define	FP17R	((*((__RAM struct specialRegister *)0xad)).bit7)
#define	P2UR	(*((__RAM unsigned int*)0xae))
#define	FP20R	((*((__RAM struct specialRegister *)0xae)).bit0)
#define	FP21R	((*((__RAM struct specialRegister *)0xae)).bit1)
#define	FP22R	((*((__RAM struct specialRegister *)0xae)).bit2)
#define	FP23R	((*((__RAM struct specialRegister *)0xae)).bit3)
#define	FP24R	((*((__RAM struct specialRegister *)0xae)).bit4)
#define	FP25R	((*((__RAM struct specialRegister *)0xae)).bit5)
#define	P5UR	(*((__RAM unsigned int*)0xb1))
#define	FP50R	((*((__RAM struct specialRegister *)0xb1)).bit0)
#define	FP51R	((*((__RAM struct specialRegister *)0xb1)).bit1)
#define	FP52R	((*((__RAM struct specialRegister *)0xb1)).bit2)
#define	FP53R	((*((__RAM struct specialRegister *)0xb1)).bit3)
#define	FP54R	((*((__RAM struct specialRegister *)0xb1)).bit4)
#define	FP55R	((*((__RAM struct specialRegister *)0xb1)).bit5)
#define	FP56R	((*((__RAM struct specialRegister *)0xb1)).bit6)
#define	FP57R	((*((__RAM struct specialRegister *)0xb1)).bit7)
#define	T0M	(*((__RAM unsigned int*)0xb2))
#define	FT0ENB	((*((__RAM struct specialRegister *)0xb2)).bit7)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xb2)).bit6)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xb2)).bit5)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xb2)).bit4)
#define	FT0TB	((*((__RAM struct specialRegister *)0xb2)).bit0)
#define	T0C	(*((__RAM unsigned int*)0xb3))
#define	TC0M	(*((__RAM unsigned int*)0xb4))
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xb4)).bit7)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xb4)).bit6)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xb4)).bit5)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xb4)).bit4)
#define	FTC0CKS1	((*((__RAM struct specialRegister *)0xb4)).bit3)
#define	FTC0CKS0	((*((__RAM struct specialRegister *)0xb4)).bit2)
#define	FTC0PO	((*((__RAM struct specialRegister *)0xb4)).bit1)
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xb4)).bit0)
#define	TC0C	(*((__RAM unsigned int*)0xb5))
#define	TC0R	(*((__RAM unsigned int*)0xb6))
#define	TC0D	(*((__RAM unsigned int*)0xb7))
#define	TC1M	(*((__RAM unsigned int*)0xb8))
#define	FTC1ENB	((*((__RAM struct specialRegister *)0xb8)).bit7)
#define	FTC1RATE2	((*((__RAM struct specialRegister *)0xb8)).bit6)
#define	FTC1RATE1	((*((__RAM struct specialRegister *)0xb8)).bit5)
#define	FTC1RATE0	((*((__RAM struct specialRegister *)0xb8)).bit4)
#define	FTC1CKS1	((*((__RAM struct specialRegister *)0xb8)).bit3)
#define	FTC1CKS0	((*((__RAM struct specialRegister *)0xb8)).bit2)
#define	FTC1PO	((*((__RAM struct specialRegister *)0xb8)).bit1)
#define	FPWM1OUT	((*((__RAM struct specialRegister *)0xb8)).bit0)
#define	TC1C	(*((__RAM unsigned int*)0xb9))
#define	TC1R	(*((__RAM unsigned int*)0xba))
#define	TC1D	(*((__RAM unsigned int*)0xbb))
#define	TC2M	(*((__RAM unsigned int*)0xbc))
#define	FTC2ENB	((*((__RAM struct specialRegister *)0xbc)).bit7)
#define	FTC2RATE2	((*((__RAM struct specialRegister *)0xbc)).bit6)
#define	FTC2RATE1	((*((__RAM struct specialRegister *)0xbc)).bit5)
#define	FTC2RATE0	((*((__RAM struct specialRegister *)0xbc)).bit4)
#define	FTC2CKS1	((*((__RAM struct specialRegister *)0xbc)).bit3)
#define	FTC2CKS0	((*((__RAM struct specialRegister *)0xbc)).bit2)
#define	FTC2PO	((*((__RAM struct specialRegister *)0xbc)).bit1)
#define	FPWM2OUT	((*((__RAM struct specialRegister *)0xbc)).bit0)
#define	TC2C	(*((__RAM unsigned int*)0xbd))
#define	TC2R	(*((__RAM unsigned int*)0xbe))
#define	TC2D	(*((__RAM unsigned int*)0xbf))
#define	T1M	(*((__RAM unsigned int*)0xc0))
#define	FT1VCOV	((*((__RAM struct specialRegister *)0xc0)).bit0)
#define	FT1OV	((*((__RAM struct specialRegister *)0xc0)).bit1)
#define	FCPTStart	((*((__RAM struct specialRegister *)0xc0)).bit2)
#define	FCPTCKS	((*((__RAM struct specialRegister *)0xc0)).bit3)
#define	FT1rate0	((*((__RAM struct specialRegister *)0xc0)).bit4)
#define	FT1rate1	((*((__RAM struct specialRegister *)0xc0)).bit5)
#define	FT1rate2	((*((__RAM struct specialRegister *)0xc0)).bit6)
#define	FT1ENB	((*((__RAM struct specialRegister *)0xc0)).bit7)
#define	T1CL	(*((__RAM unsigned int*)0xc1))
#define	T1CH	(*((__RAM unsigned int*)0xc2))
#define	T1VCL	(*((__RAM unsigned int*)0xc4))
#define	T1VCH	(*((__RAM unsigned int*)0xc5))
#define	PECMD	(*((__RAM unsigned int*)0xdb))
#define	PEROML	(*((__RAM unsigned int*)0xdc))
#define	PEROMH	(*((__RAM unsigned int*)0xdd))
#define	PERAML	(*((__RAM unsigned int*)0xde))
#define	PERAMCNT	(*((__RAM unsigned int*)0xdf))
#define	SIOM	(*((__RAM unsigned int*)0xe0))
#define	FSENB	((*((__RAM struct specialRegister *)0xe0)).bit7)
#define	FSTART	((*((__RAM struct specialRegister *)0xe0)).bit6)
#define	FSRATE1	((*((__RAM struct specialRegister *)0xe0)).bit5)
#define	FSRATE0	((*((__RAM struct specialRegister *)0xe0)).bit4)
#define	FMLSB	((*((__RAM struct specialRegister *)0xe0)).bit3)
#define	FSCKMD	((*((__RAM struct specialRegister *)0xe0)).bit2)
#define	FCPOL	((*((__RAM struct specialRegister *)0xe0)).bit1)
#define	FCPHA	((*((__RAM struct specialRegister *)0xe0)).bit0)
#define	SIOR	(*((__RAM unsigned int*)0xe1))
#define	SIOB	(*((__RAM unsigned int*)0xe2))
#define	URTX	(*((__RAM unsigned int*)0xe4))
#define	FUTXEN	((*((__RAM struct specialRegister *)0xe4)).bit7)
#define	FUTXPEN	((*((__RAM struct specialRegister *)0xe4)).bit6)
#define	FUTXPS	((*((__RAM struct specialRegister *)0xe4)).bit5)
#define	FUTXBRK	((*((__RAM struct specialRegister *)0xe4)).bit4)
#define	FURXBZ	((*((__RAM struct specialRegister *)0xe4)).bit3)
#define	FUTXBZ	((*((__RAM struct specialRegister *)0xe4)).bit2)
#define	URRX	(*((__RAM unsigned int*)0xe5))
#define	FURXEN	((*((__RAM struct specialRegister *)0xe5)).bit7)
#define	FURXPEN	((*((__RAM struct specialRegister *)0xe5)).bit6)
#define	FURXPS	((*((__RAM struct specialRegister *)0xe5)).bit5)
#define	FURXPC	((*((__RAM struct specialRegister *)0xe5)).bit4)
#define	FUFMER	((*((__RAM struct specialRegister *)0xe5)).bit3)
#define	FURS2	((*((__RAM struct specialRegister *)0xe5)).bit2)
#define	FURS1	((*((__RAM struct specialRegister *)0xe5)).bit1)
#define	FURS0	((*((__RAM struct specialRegister *)0xe5)).bit0)
#define	URCR	(*((__RAM unsigned int*)0xe6))
#define	UTXD	(*((__RAM unsigned int*)0xe7))
#define	URXD	(*((__RAM unsigned int*)0xe8))
#define	MSPSTAT	(*((__RAM unsigned int*)0xea))
#define	FCKE	((*((__RAM struct specialRegister *)0xea)).bit6)
#define	FD_A	((*((__RAM struct specialRegister *)0xea)).bit5)
#define	FP	((*((__RAM struct specialRegister *)0xea)).bit4)
#define	FS	((*((__RAM struct specialRegister *)0xea)).bit3)
#define	FRED_WRT	((*((__RAM struct specialRegister *)0xea)).bit2)
#define	FBF	((*((__RAM struct specialRegister *)0xea)).bit0)
#define	MSPM1	(*((__RAM unsigned int*)0xeb))
#define	FWCOL	((*((__RAM struct specialRegister *)0xeb)).bit7)
#define	FMSPOV	((*((__RAM struct specialRegister *)0xeb)).bit6)
#define	FMSPENB	((*((__RAM struct specialRegister *)0xeb)).bit5)
#define	FCKP	((*((__RAM struct specialRegister *)0xeb)).bit4)
#define	FSLRXCKP	((*((__RAM struct specialRegister *)0xeb)).bit3)
#define	FMSPWK	((*((__RAM struct specialRegister *)0xeb)).bit2)
#define	FMSPC	((*((__RAM struct specialRegister *)0xeb)).bit0)
#define	MSPM2	(*((__RAM unsigned int*)0xec))
#define	FGCEN	((*((__RAM struct specialRegister *)0xec)).bit7)
#define	FACKSTAT	((*((__RAM struct specialRegister *)0xec)).bit6)
#define	FACKDT	((*((__RAM struct specialRegister *)0xec)).bit5)
#define	FACKEN	((*((__RAM struct specialRegister *)0xec)).bit4)
#define	FRCEN	((*((__RAM struct specialRegister *)0xec)).bit3)
#define	FPEN	((*((__RAM struct specialRegister *)0xec)).bit2)
#define	FRSEN	((*((__RAM struct specialRegister *)0xec)).bit1)
#define	FSEN	((*((__RAM struct specialRegister *)0xec)).bit0)
#define	MSPBUF	(*((__RAM unsigned int*)0xed))
#define	FMSPBUF7	((*((__RAM struct specialRegister *)0xed)).bit7)
#define	FMSPBUF6	((*((__RAM struct specialRegister *)0xed)).bit6)
#define	FMSPBUF5	((*((__RAM struct specialRegister *)0xed)).bit5)
#define	FMSPBUF4	((*((__RAM struct specialRegister *)0xed)).bit4)
#define	FMSPBUF3	((*((__RAM struct specialRegister *)0xed)).bit3)
#define	FMSPBUF2	((*((__RAM struct specialRegister *)0xed)).bit2)
#define	FMSPBUF1	((*((__RAM struct specialRegister *)0xed)).bit1)
#define	FMSPBUF0	((*((__RAM struct specialRegister *)0xed)).bit0)
#define	MSPADR	(*((__RAM unsigned int*)0xee))
#define	FMSPADR7	((*((__RAM struct specialRegister *)0xee)).bit7)
#define	FMSPADR6	((*((__RAM struct specialRegister *)0xee)).bit6)
#define	FMSPADR5	((*((__RAM struct specialRegister *)0xee)).bit5)
#define	FMSPADR4	((*((__RAM struct specialRegister *)0xee)).bit4)
#define	FMSPADR3	((*((__RAM struct specialRegister *)0xee)).bit3)
#define	FMSPADR2	((*((__RAM struct specialRegister *)0xee)).bit2)
#define	FMSPADR1	((*((__RAM struct specialRegister *)0xee)).bit1)
#define	FMSPADR0	((*((__RAM struct specialRegister *)0xee)).bit0)
#define	STKP	(*((__RAM unsigned int*)0xef))
#define	FGIE	((*((__RAM struct specialRegister *)0xef)).bit7)
#define	FLVD24	((*((__RAM struct specialRegister *)0xef)).bit6)
#define	FLVD33	((*((__RAM struct specialRegister *)0xef)).bit5)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xef)).bit2)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xef)).bit1)
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xef)).bit0)
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
