#ifndef __SN8P25231__H
#define __SN8P25231__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FLVD24	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FLVD36	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	RBANK	(*((__RAM unsigned int*)0x87))
#define	FRBNKS0	((*((__RAM struct specialRegister *)0x87)).bit0)
#define	MSPSTAT	(*((__RAM unsigned int*)0x90))
#define	FCKE	((*((__RAM struct specialRegister *)0x90)).bit6)
#define	FD_A	((*((__RAM struct specialRegister *)0x90)).bit5)
#define	FP	((*((__RAM struct specialRegister *)0x90)).bit4)
#define	FS	((*((__RAM struct specialRegister *)0x90)).bit3)
#define	FRED_WRT	((*((__RAM struct specialRegister *)0x90)).bit2)
#define	FBF	((*((__RAM struct specialRegister *)0x90)).bit0)
#define	MSPM1	(*((__RAM unsigned int*)0x91))
#define	FWCOL	((*((__RAM struct specialRegister *)0x91)).bit7)
#define	FMSPOV	((*((__RAM struct specialRegister *)0x91)).bit6)
#define	FMSPENB	((*((__RAM struct specialRegister *)0x91)).bit5)
#define	FCKP	((*((__RAM struct specialRegister *)0x91)).bit4)
#define	FSLRXCKP	((*((__RAM struct specialRegister *)0x91)).bit3)
#define	FMSPWK	((*((__RAM struct specialRegister *)0x91)).bit2)
#define	FGCEN	((*((__RAM struct specialRegister *)0x91)).bit1)
#define	MSPBUF	(*((__RAM unsigned int*)0x92))
#define	FMSPBUF7	((*((__RAM struct specialRegister *)0x92)).bit7)
#define	FMSPBUF6	((*((__RAM struct specialRegister *)0x92)).bit6)
#define	FMSPBUF5	((*((__RAM struct specialRegister *)0x92)).bit5)
#define	FMSPBUF4	((*((__RAM struct specialRegister *)0x92)).bit4)
#define	FMSPBUF3	((*((__RAM struct specialRegister *)0x92)).bit3)
#define	FMSPBUF2	((*((__RAM struct specialRegister *)0x92)).bit2)
#define	FMSPBUF1	((*((__RAM struct specialRegister *)0x92)).bit1)
#define	FMSPBUF0	((*((__RAM struct specialRegister *)0x92)).bit0)
#define	MSPADR	(*((__RAM unsigned int*)0x93))
#define	FMSPADR7	((*((__RAM struct specialRegister *)0x93)).bit7)
#define	FMSPADR6	((*((__RAM struct specialRegister *)0x93)).bit6)
#define	FMSPADR5	((*((__RAM struct specialRegister *)0x93)).bit5)
#define	FMSPADR4	((*((__RAM struct specialRegister *)0x93)).bit4)
#define	FMSPADR3	((*((__RAM struct specialRegister *)0x93)).bit3)
#define	FMSPADR2	((*((__RAM struct specialRegister *)0x93)).bit2)
#define	FMSPADR1	((*((__RAM struct specialRegister *)0x93)).bit1)
#define	FMSPADR0	((*((__RAM struct specialRegister *)0x93)).bit0)
#define	CM0M	(*((__RAM unsigned int*)0x9c))
#define	FCMCH0	((*((__RAM struct specialRegister *)0x9c)).bit0)
#define	FCMCH1	((*((__RAM struct specialRegister *)0x9c)).bit1)
#define	FCMCH2	((*((__RAM struct specialRegister *)0x9c)).bit2)
#define	FCMCH3	((*((__RAM struct specialRegister *)0x9c)).bit3)
#define	FCM0S0	((*((__RAM struct specialRegister *)0x9c)).bit4)
#define	FCM0S1	((*((__RAM struct specialRegister *)0x9c)).bit5)
#define	FCM0OUT	((*((__RAM struct specialRegister *)0x9c)).bit6)
#define	FCM0EN	((*((__RAM struct specialRegister *)0x9c)).bit7)
#define	CM0M1	(*((__RAM unsigned int*)0x9d))
#define	FCM0G	((*((__RAM struct specialRegister *)0x9d)).bit0)
#define	FCM0OEN	((*((__RAM struct specialRegister *)0x9d)).bit1)
#define	FCMDB0	((*((__RAM struct specialRegister *)0x9d)).bit2)
#define	FCMDB1	((*((__RAM struct specialRegister *)0x9d)).bit3)
#define	FTCHEN	((*((__RAM struct specialRegister *)0x9d)).bit7)
#define	CM0M2	(*((__RAM unsigned int*)0x9e))
#define	FTCHCM0	((*((__RAM struct specialRegister *)0x9e)).bit0)
#define	FTCHCM1	((*((__RAM struct specialRegister *)0x9e)).bit1)
#define	FTCHCM2	((*((__RAM struct specialRegister *)0x9e)).bit2)
#define	FTRS0	((*((__RAM struct specialRegister *)0x9e)).bit4)
#define	FTRS1	((*((__RAM struct specialRegister *)0x9e)).bit5)
#define	FTRS2	((*((__RAM struct specialRegister *)0x9e)).bit6)
#define	FTRS3	((*((__RAM struct specialRegister *)0x9e)).bit7)
#define	T1M	(*((__RAM unsigned int*)0xa0))
#define	FT1VCOV	((*((__RAM struct specialRegister *)0xa0)).bit0)
#define	FT1OV	((*((__RAM struct specialRegister *)0xa0)).bit1)
#define	FCPTStart	((*((__RAM struct specialRegister *)0xa0)).bit2)
#define	FCPTCKS	((*((__RAM struct specialRegister *)0xa0)).bit3)
#define	FT1rate0	((*((__RAM struct specialRegister *)0xa0)).bit4)
#define	FT1rate1	((*((__RAM struct specialRegister *)0xa0)).bit5)
#define	FT1rate2	((*((__RAM struct specialRegister *)0xa0)).bit6)
#define	FT1ENB	((*((__RAM struct specialRegister *)0xa0)).bit7)
#define	T1CL	(*((__RAM unsigned int*)0xa1))
#define	T1CH	(*((__RAM unsigned int*)0xa2))
#define	T1VCL	(*((__RAM unsigned int*)0xa3))
#define	T1VCH	(*((__RAM unsigned int*)0xa4))
#define	TC0R0	(*((__RAM unsigned int*)0xa8))
#define	TC0R1	(*((__RAM unsigned int*)0xa9))
#define	TC0R2	(*((__RAM unsigned int*)0xaa))
#define	TC0R3	(*((__RAM unsigned int*)0xab))
#define	TC0R4	(*((__RAM unsigned int*)0xac))
#define	TC0R5	(*((__RAM unsigned int*)0xad))
#define	TC0R6	(*((__RAM unsigned int*)0xae))
#define	TC0R7	(*((__RAM unsigned int*)0xaf))
#define	SIOM	(*((__RAM unsigned int*)0xb4))
#define	FSENB	((*((__RAM struct specialRegister *)0xb4)).bit7)
#define	FSTART	((*((__RAM struct specialRegister *)0xb4)).bit6)
#define	FSRATE1	((*((__RAM struct specialRegister *)0xb4)).bit5)
#define	FSRATE0	((*((__RAM struct specialRegister *)0xb4)).bit4)
#define	FMLSB	((*((__RAM struct specialRegister *)0xb4)).bit3)
#define	FSCKMD	((*((__RAM struct specialRegister *)0xb4)).bit2)
#define	FCPOL	((*((__RAM struct specialRegister *)0xb4)).bit1)
#define	FCPHA	((*((__RAM struct specialRegister *)0xb4)).bit0)
#define	SIOR	(*((__RAM unsigned int*)0xb5))
#define	SIOB	(*((__RAM unsigned int*)0xb6))
#define	P0M	(*((__RAM unsigned int*)0xb8))
#define	FP00M	((*((__RAM struct specialRegister *)0xb8)).bit0)
#define	FP01M	((*((__RAM struct specialRegister *)0xb8)).bit1)
#define	FP02M	((*((__RAM struct specialRegister *)0xb8)).bit2)
#define	FP03M	((*((__RAM struct specialRegister *)0xb8)).bit3)
#define	FP04M	((*((__RAM struct specialRegister *)0xb8)).bit4)
#define	PEDGE	(*((__RAM unsigned int*)0xbf))
#define	FP00G1	((*((__RAM struct specialRegister *)0xbf)).bit4)
#define	FP00G0	((*((__RAM struct specialRegister *)0xbf)).bit3)
#define	P1W	(*((__RAM unsigned int*)0xc0))
#define	P1M	(*((__RAM unsigned int*)0xc1))
#define	FP10M	((*((__RAM struct specialRegister *)0xc1)).bit0)
#define	FP11M	((*((__RAM struct specialRegister *)0xc1)).bit1)
#define	FP12M	((*((__RAM struct specialRegister *)0xc1)).bit2)
#define	FP13M	((*((__RAM struct specialRegister *)0xc1)).bit3)
#define	FP14M	((*((__RAM struct specialRegister *)0xc1)).bit4)
#define	FP15M	((*((__RAM struct specialRegister *)0xc1)).bit5)
#define	FP16M	((*((__RAM struct specialRegister *)0xc1)).bit6)
#define	FP17M	((*((__RAM struct specialRegister *)0xc1)).bit7)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	FP51M	((*((__RAM struct specialRegister *)0xc5)).bit1)
#define	FP52M	((*((__RAM struct specialRegister *)0xc5)).bit2)
#define	FP53M	((*((__RAM struct specialRegister *)0xc5)).bit3)
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	FP55M	((*((__RAM struct specialRegister *)0xc5)).bit5)
#define	FP56M	((*((__RAM struct specialRegister *)0xc5)).bit6)
#define	FP57M	((*((__RAM struct specialRegister *)0xc5)).bit7)
#define	INTRQ	(*((__RAM unsigned int*)0xc8))
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	FMSPIRQ	((*((__RAM struct specialRegister *)0xc8)).bit1)
#define	FT1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit2)
#define	FSIOIRQ	((*((__RAM struct specialRegister *)0xc8)).bit3)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FTC1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit6)
#define	FCM0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit7)
#define	INTEN	(*((__RAM unsigned int*)0xc9))
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	FMSPIEN	((*((__RAM struct specialRegister *)0xc9)).bit1)
#define	FT1IEN	((*((__RAM struct specialRegister *)0xc9)).bit2)
#define	FSIOIEN	((*((__RAM struct specialRegister *)0xc9)).bit3)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FTC1IEN	((*((__RAM struct specialRegister *)0xc9)).bit6)
#define	FCM0IEN	((*((__RAM struct specialRegister *)0xc9)).bit7)
#define	OSCM	(*((__RAM unsigned int*)0xca))
#define	FCPUM1	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FSTPHX	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	WDTR	(*((__RAM unsigned int*)0xcc))
#define	LPWS	(*((__RAM unsigned int*)0xcd))
#define	FLPWS0	((*((__RAM struct specialRegister *)0xcd)).bit0)
#define	FLPWS1	((*((__RAM struct specialRegister *)0xcd)).bit1)
#define	FLPWS2	((*((__RAM struct specialRegister *)0xcd)).bit2)
#define	FLPWS3	((*((__RAM struct specialRegister *)0xcd)).bit3)
#define	FLPWS4	((*((__RAM struct specialRegister *)0xcd)).bit4)
#define	FLPWS5	((*((__RAM struct specialRegister *)0xcd)).bit5)
#define	FLPWS6	((*((__RAM struct specialRegister *)0xcd)).bit6)
#define	FLPWS7	((*((__RAM struct specialRegister *)0xcd)).bit7)
#define	PCL	(*((__RAM unsigned int*)0xce))
#define	PCH	(*((__RAM unsigned int*)0xcf))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	FP01	((*((__RAM struct specialRegister *)0xd0)).bit1)
#define	FP02	((*((__RAM struct specialRegister *)0xd0)).bit2)
#define	FP03	((*((__RAM struct specialRegister *)0xd0)).bit3)
#define	FP04	((*((__RAM struct specialRegister *)0xd0)).bit4)
#define	FP05	((*((__RAM struct specialRegister *)0xd0)).bit5)
#define	P1	(*((__RAM unsigned int*)0xd1))
#define	FP10	((*((__RAM struct specialRegister *)0xd1)).bit0)
#define	FP11	((*((__RAM struct specialRegister *)0xd1)).bit1)
#define	FP12	((*((__RAM struct specialRegister *)0xd1)).bit2)
#define	FP13	((*((__RAM struct specialRegister *)0xd1)).bit3)
#define	FP14	((*((__RAM struct specialRegister *)0xd1)).bit4)
#define	FP15	((*((__RAM struct specialRegister *)0xd1)).bit5)
#define	FP16	((*((__RAM struct specialRegister *)0xd1)).bit6)
#define	FP17	((*((__RAM struct specialRegister *)0xd1)).bit7)
#define	P5	(*((__RAM unsigned int*)0xd5))
#define	FP50	((*((__RAM struct specialRegister *)0xd5)).bit0)
#define	FP51	((*((__RAM struct specialRegister *)0xd5)).bit1)
#define	FP52	((*((__RAM struct specialRegister *)0xd5)).bit2)
#define	FP53	((*((__RAM struct specialRegister *)0xd5)).bit3)
#define	FP54	((*((__RAM struct specialRegister *)0xd5)).bit4)
#define	FP55	((*((__RAM struct specialRegister *)0xd5)).bit5)
#define	FP56	((*((__RAM struct specialRegister *)0xd5)).bit6)
#define	FP57	((*((__RAM struct specialRegister *)0xd5)).bit7)
#define	T0M	(*((__RAM unsigned int*)0xd8))
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xd8)).bit4)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xd8)).bit5)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xd8)).bit6)
#define	FT0ENB	((*((__RAM struct specialRegister *)0xd8)).bit7)
#define	T0C	(*((__RAM unsigned int*)0xd9))
#define	TC0M	(*((__RAM unsigned int*)0xda))
#define	FPWMDR	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	FTC0rate0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	FTC0rate1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FTC0rate2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	TC0C	(*((__RAM unsigned int*)0xdb))
#define	TC1M	(*((__RAM unsigned int*)0xdc))
#define	FPWM1OUT	((*((__RAM struct specialRegister *)0xdc)).bit0)
#define	FTC1CKS0	((*((__RAM struct specialRegister *)0xdc)).bit2)
#define	FTC1rate0	((*((__RAM struct specialRegister *)0xdc)).bit4)
#define	FTC1rate1	((*((__RAM struct specialRegister *)0xdc)).bit5)
#define	FTC1rate2	((*((__RAM struct specialRegister *)0xdc)).bit6)
#define	FTC1ENB	((*((__RAM struct specialRegister *)0xdc)).bit7)
#define	TC1C	(*((__RAM unsigned int*)0xdd))
#define	TC1R	(*((__RAM unsigned int*)0xde))
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xdf)).bit2)
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	P0UR	(*((__RAM unsigned int*)0xe0))
#define	FP00R	((*((__RAM struct specialRegister *)0xe0)).bit0)
#define	FP01R	((*((__RAM struct specialRegister *)0xe0)).bit1)
#define	FP02R	((*((__RAM struct specialRegister *)0xe0)).bit2)
#define	FP03R	((*((__RAM struct specialRegister *)0xe0)).bit3)
#define	FP04R	((*((__RAM struct specialRegister *)0xe0)).bit4)
#define	P1UR	(*((__RAM unsigned int*)0xe1))
#define	FP10R	((*((__RAM struct specialRegister *)0xe1)).bit0)
#define	FP11R	((*((__RAM struct specialRegister *)0xe1)).bit1)
#define	FP12R	((*((__RAM struct specialRegister *)0xe1)).bit2)
#define	FP13R	((*((__RAM struct specialRegister *)0xe1)).bit3)
#define	FP14R	((*((__RAM struct specialRegister *)0xe1)).bit4)
#define	FP15R	((*((__RAM struct specialRegister *)0xe1)).bit5)
#define	FP16R	((*((__RAM struct specialRegister *)0xe1)).bit6)
#define	FP17R	((*((__RAM struct specialRegister *)0xe1)).bit7)
#define	P5UR	(*((__RAM unsigned int*)0xe5))
#define	FP50R	((*((__RAM struct specialRegister *)0xe5)).bit0)
#define	FP51R	((*((__RAM struct specialRegister *)0xe5)).bit1)
#define	FP52R	((*((__RAM struct specialRegister *)0xe5)).bit2)
#define	FP53R	((*((__RAM struct specialRegister *)0xe5)).bit3)
#define	FP54R	((*((__RAM struct specialRegister *)0xe5)).bit4)
#define	FP55R	((*((__RAM struct specialRegister *)0xe5)).bit5)
#define	FP56R	((*((__RAM struct specialRegister *)0xe5)).bit6)
#define	FP57R	((*((__RAM struct specialRegister *)0xe5)).bit7)
#define	_HL	(*((__RAM unsigned int*)0xe6))
#define	_YZ	(*((__RAM unsigned int*)0xe7))
#define	P1OC	(*((__RAM unsigned int*)0xe9))
#define	FP50OC	((*((__RAM struct specialRegister *)0xe9)).bit2)
#define	FP51OC	((*((__RAM struct specialRegister *)0xe9)).bit3)
#define	FP52OC	((*((__RAM struct specialRegister *)0xe9)).bit4)
#define	TC1D	(*((__RAM unsigned int*)0xea))
#define	STK7L	(*((__RAM unsigned int*)0xf0))
#define	STK7H	(*((__RAM unsigned int*)0xf1))
#define	STK6L	(*((__RAM unsigned int*)0xf2))
#define	STK6H	(*((__RAM unsigned int*)0xf3))
#define	STK5L	(*((__RAM unsigned int*)0xf4))
#define	STK5H	(*((__RAM unsigned int*)0xf5))
#define	STK4L	(*((__RAM unsigned int*)0xf6))
#define	STK4H	(*((__RAM unsigned int*)0xf7))
#define	STK3L	(*((__RAM unsigned int*)0xf8))
#define	STK3H	(*((__RAM unsigned int*)0xf9))
#define	STK2L	(*((__RAM unsigned int*)0xfa))
#define	STK2H	(*((__RAM unsigned int*)0xfb))
#define	STK1L	(*((__RAM unsigned int*)0xfc))
#define	STK1H	(*((__RAM unsigned int*)0xfd))
#define	STK0L	(*((__RAM unsigned int*)0xfe))
#define	STK0H	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
