#ifndef __SN8P2839__H
#define __SN8P2839__H
struct specialRegister{
	unsigned bit0:1;
	unsigned bit1:1;
	unsigned bit2:1;
	unsigned bit3:1;
	unsigned bit4:1;
	unsigned bit5:1;
	unsigned bit6:1;
	unsigned bit7:1;
};


void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }
#define	L	(*((__RAM unsigned int*)0x80))
#define	H	(*((__RAM unsigned int*)0x81))
#define	R	(*((__RAM unsigned int*)0x82))
#define	Z	(*((__RAM unsigned int*)0x83))
#define	Y	(*((__RAM unsigned int*)0x84))
#define	X	(*((__RAM unsigned int*)0x85))
#define	PFLAG	(*((__RAM unsigned int*)0x86))
#define	FZ	((*((__RAM struct specialRegister *)0x86)).bit0)
#define	FDC	((*((__RAM struct specialRegister *)0x86)).bit1)
#define	FC	((*((__RAM struct specialRegister *)0x86)).bit2)
#define	FLVD24	((*((__RAM struct specialRegister *)0x86)).bit4)
#define	FLVD36	((*((__RAM struct specialRegister *)0x86)).bit5)
#define	FNPD	((*((__RAM struct specialRegister *)0x86)).bit6)
#define	FNT0	((*((__RAM struct specialRegister *)0x86)).bit7)
#define	RBANK	(*((__RAM unsigned int*)0x87))
#define	FRBNKS0	((*((__RAM struct specialRegister *)0x87)).bit0)
#define	FRBNKS1	((*((__RAM struct specialRegister *)0x87)).bit1)
#define	FRBNKS2	((*((__RAM struct specialRegister *)0x87)).bit2)
#define	FRBNKS3	((*((__RAM struct specialRegister *)0x87)).bit3)
#define	LCDM	(*((__RAM unsigned int*)0x89))
#define	FLCDENB	((*((__RAM struct specialRegister *)0x89)).bit0)
#define	FP2SEG	((*((__RAM struct specialRegister *)0x89)).bit2)
#define	FRCLK	((*((__RAM struct specialRegister *)0x89)).bit3)
#define	FRES0	((*((__RAM struct specialRegister *)0x89)).bit6)
#define	FRES1	((*((__RAM struct specialRegister *)0x89)).bit7)
#define	CPM	(*((__RAM unsigned int*)0x8A))
#define	FAREGEN1	((*((__RAM struct specialRegister *)0x8A)).bit0)
#define	FAREGEN2	((*((__RAM struct specialRegister *)0x8A)).bit1)
#define	CPCKS	(*((__RAM unsigned int*)0x8B))
#define	FCPCKS0	((*((__RAM struct specialRegister *)0x8B)).bit0)
#define	FCPCKS1	((*((__RAM struct specialRegister *)0x8B)).bit1)
#define	CALIHRCH	(*((__RAM unsigned int*)0x8C))
#define	FCALIHRCH0	((*((__RAM struct specialRegister *)0x8C)).bit0)
#define	FCALIHRCH1	((*((__RAM struct specialRegister *)0x8C)).bit1)
#define	FCALIHRCH2	((*((__RAM struct specialRegister *)0x8C)).bit2)
#define	FTC1CALCKS	((*((__RAM struct specialRegister *)0x8C)).bit6)
#define	FCALSTART	((*((__RAM struct specialRegister *)0x8C)).bit7)
#define	CALIHRCL	(*((__RAM unsigned int*)0x8D))
#define	FCALIHRCL0	((*((__RAM struct specialRegister *)0x8D)).bit0)
#define	FCALIHRCL1	((*((__RAM struct specialRegister *)0x8D)).bit1)
#define	FCALIHRCL2	((*((__RAM struct specialRegister *)0x8D)).bit2)
#define	FCALIHRCL3	((*((__RAM struct specialRegister *)0x8D)).bit3)
#define	FCALIHRCL4	((*((__RAM struct specialRegister *)0x8D)).bit4)
#define	FCALIHRCL5	((*((__RAM struct specialRegister *)0x8D)).bit5)
#define	TRIM2	(*((__RAM unsigned int*)0x8E))
#define	FDVDDR_0	((*((__RAM struct specialRegister *)0x8E)).bit0)
#define	FDVDDR_1	((*((__RAM struct specialRegister *)0x8E)).bit1)
#define	FDVDDR_2	((*((__RAM struct specialRegister *)0x8E)).bit2)
#define	FDVDDR_3	((*((__RAM struct specialRegister *)0x8E)).bit3)
#define	TRIM1	(*((__RAM unsigned int*)0x8F))
#define	FAVDDR2_0	((*((__RAM struct specialRegister *)0x8F)).bit0)
#define	FAVDDR2_1	((*((__RAM struct specialRegister *)0x8F)).bit1)
#define	FAVDDR2_2	((*((__RAM struct specialRegister *)0x8F)).bit2)
#define	FAVDDR2_3	((*((__RAM struct specialRegister *)0x8F)).bit3)
#define	FAVDDR1_0	((*((__RAM struct specialRegister *)0x8F)).bit4)
#define	FAVDDR1_1	((*((__RAM struct specialRegister *)0x8F)).bit5)
#define	FAVDDR1_2	((*((__RAM struct specialRegister *)0x8F)).bit6)
#define	FAVDDR1_3	((*((__RAM struct specialRegister *)0x8F)).bit7)
#define	STK15L	(*((__RAM unsigned int*)0x90))
#define	STK15H	(*((__RAM unsigned int*)0x91))
#define	STK14L	(*((__RAM unsigned int*)0x92))
#define	STK14H	(*((__RAM unsigned int*)0x93))
#define	STK13L	(*((__RAM unsigned int*)0x94))
#define	STK13H	(*((__RAM unsigned int*)0x95))
#define	STK12L	(*((__RAM unsigned int*)0x96))
#define	STK12H	(*((__RAM unsigned int*)0x97))
#define	STK11L	(*((__RAM unsigned int*)0x98))
#define	STK11H	(*((__RAM unsigned int*)0x99))
#define	STK10L	(*((__RAM unsigned int*)0x9a))
#define	STK10H	(*((__RAM unsigned int*)0x9b))
#define	STK9L	(*((__RAM unsigned int*)0x9c))
#define	STK9H	(*((__RAM unsigned int*)0x9d))
#define	STK8L	(*((__RAM unsigned int*)0x9e))
#define	STK8H	(*((__RAM unsigned int*)0x9f))
#define	STK7L	(*((__RAM unsigned int*)0xa0))
#define	STK7H	(*((__RAM unsigned int*)0xa1))
#define	STK6L	(*((__RAM unsigned int*)0xa2))
#define	STK6H	(*((__RAM unsigned int*)0xa3))
#define	STK5L	(*((__RAM unsigned int*)0xa4))
#define	STK5H	(*((__RAM unsigned int*)0xa5))
#define	STK4L	(*((__RAM unsigned int*)0xa6))
#define	STK4H	(*((__RAM unsigned int*)0xa7))
#define	STK3L	(*((__RAM unsigned int*)0xa8))
#define	STK3H	(*((__RAM unsigned int*)0xa9))
#define	STK2L	(*((__RAM unsigned int*)0xaa))
#define	STK2H	(*((__RAM unsigned int*)0xab))
#define	STK1L	(*((__RAM unsigned int*)0xac))
#define	STK1H	(*((__RAM unsigned int*)0xad))
#define	STK0L	(*((__RAM unsigned int*)0xae))
#define	STK0H	(*((__RAM unsigned int*)0xaf))
#define	ADM	(*((__RAM unsigned int*)0xb1))
#define	FCHS0	((*((__RAM struct specialRegister *)0xb1)).bit0)
#define	FCHS1	((*((__RAM struct specialRegister *)0xb1)).bit1)
#define	FCHS2	((*((__RAM struct specialRegister *)0xb1)).bit2)
#define	FGCHS	((*((__RAM struct specialRegister *)0xb1)).bit4)
#define	FEOC	((*((__RAM struct specialRegister *)0xb1)).bit5)
#define	FADS	((*((__RAM struct specialRegister *)0xb1)).bit6)
#define	FADENB	((*((__RAM struct specialRegister *)0xb1)).bit7)
#define	ADB	(*((__RAM unsigned int*)0xb2))
#define	ADR	(*((__RAM unsigned int*)0xb3))
#define	FADB0	((*((__RAM struct specialRegister *)0xb3)).bit0)
#define	FADB1	((*((__RAM struct specialRegister *)0xb3)).bit1)
#define	FADB2	((*((__RAM struct specialRegister *)0xb3)).bit2)
#define	FADB3	((*((__RAM struct specialRegister *)0xb3)).bit3)
#define	FADCKS0	((*((__RAM struct specialRegister *)0xb3)).bit4)
#define	FADCKS1	((*((__RAM struct specialRegister *)0xb3)).bit5)
#define	FADCKS2	((*((__RAM struct specialRegister *)0xb3)).bit6)
#define	SIOM	(*((__RAM unsigned int*)0xb4))
#define	FCPHA	((*((__RAM struct specialRegister *)0xb4)).bit0)
#define	FCPOL	((*((__RAM struct specialRegister *)0xb4)).bit1)
#define	FSCKMD	((*((__RAM struct specialRegister *)0xb4)).bit2)
#define	FMLSB	((*((__RAM struct specialRegister *)0xb4)).bit3)
#define	FSRATE0	((*((__RAM struct specialRegister *)0xb4)).bit4)
#define	FSRATE1	((*((__RAM struct specialRegister *)0xb4)).bit5)
#define	FSTART	((*((__RAM struct specialRegister *)0xb4)).bit6)
#define	FSENB	((*((__RAM struct specialRegister *)0xb4)).bit7)
#define	SIOR	(*((__RAM unsigned int*)0xb5))
#define	SIOB	(*((__RAM unsigned int*)0xb6))
#define	P0M	(*((__RAM unsigned int*)0xb8))
#define	FP00M	((*((__RAM struct specialRegister *)0xb8)).bit0)
#define	FP01M	((*((__RAM struct specialRegister *)0xb8)).bit1)
#define	PGIA2CKS	(*((__RAM unsigned int*)0xb9))
#define	PGIA2M	(*((__RAM unsigned int*)0xba))
#define	FPGIA2ENB	((*((__RAM struct specialRegister *)0xba)).bit0)
#define	FP3GS0	((*((__RAM struct specialRegister *)0xba)).bit1)
#define	FP3GS1	((*((__RAM struct specialRegister *)0xba)).bit2)
#define	FP4GS0	((*((__RAM struct specialRegister *)0xba)).bit4)
#define	FP4GS1	((*((__RAM struct specialRegister *)0xba)).bit5)
#define	FP4GS2	((*((__RAM struct specialRegister *)0xba)).bit6)
#define	FP4GS3	((*((__RAM struct specialRegister *)0xba)).bit7)
#define	PGIA1CKS	(*((__RAM unsigned int*)0xbb))
#define	PGIA1M	(*((__RAM unsigned int*)0xbc))
#define	FPGIA1ENB	((*((__RAM struct specialRegister *)0xbc)).bit0)
#define	FP1GS0	((*((__RAM struct specialRegister *)0xbc)).bit1)
#define	FP1GS1	((*((__RAM struct specialRegister *)0xbc)).bit2)
#define	FP2GS0	((*((__RAM struct specialRegister *)0xbc)).bit4)
#define	FP2GS1	((*((__RAM struct specialRegister *)0xbc)).bit5)
#define	FP2GS2	((*((__RAM struct specialRegister *)0xbc)).bit6)
#define	FP2GS3	((*((__RAM struct specialRegister *)0xbc)).bit7)
#define	OPM	(*((__RAM unsigned int*)0xbd))
#define	FOP1ENB	((*((__RAM struct specialRegister *)0xbd)).bit0)
#define	FOP2ENB	((*((__RAM struct specialRegister *)0xbd)).bit1)
#define	FOP1UGB	((*((__RAM struct specialRegister *)0xbd)).bit2)
#define	FOP2UGB	((*((__RAM struct specialRegister *)0xbd)).bit3)
#define	P4CON	(*((__RAM unsigned int*)0xBE))
#define	FP4CON0	((*((__RAM struct specialRegister *)0xBE)).bit0)
#define	FP4CON1	((*((__RAM struct specialRegister *)0xBE)).bit1)
#define	FP4CON2	((*((__RAM struct specialRegister *)0xBE)).bit2)
#define	FP4CON3	((*((__RAM struct specialRegister *)0xBE)).bit3)
#define	FP4CON4	((*((__RAM struct specialRegister *)0xBE)).bit4)
#define	FP4CON5	((*((__RAM struct specialRegister *)0xBE)).bit5)
#define	FP4CON6	((*((__RAM struct specialRegister *)0xBE)).bit6)
#define	PEDGE	(*((__RAM unsigned int*)0xbf))
#define	FP00G0	((*((__RAM struct specialRegister *)0xbf)).bit0)
#define	FP00G1	((*((__RAM struct specialRegister *)0xbf)).bit1)
#define	FP01G0	((*((__RAM struct specialRegister *)0xbf)).bit2)
#define	FP01G1	((*((__RAM struct specialRegister *)0xbf)).bit3)
#define	P1W	(*((__RAM unsigned int*)0xc0))
#define	FP10W	((*((__RAM struct specialRegister *)0xc0)).bit0)
#define	FP11W	((*((__RAM struct specialRegister *)0xc0)).bit1)
#define	FP12W	((*((__RAM struct specialRegister *)0xc0)).bit2)
#define	FP13W	((*((__RAM struct specialRegister *)0xc0)).bit3)
#define	FP14W	((*((__RAM struct specialRegister *)0xc0)).bit4)
#define	FP15W	((*((__RAM struct specialRegister *)0xc0)).bit5)
#define	P1M	(*((__RAM unsigned int*)0xc1))
#define	FP10M	((*((__RAM struct specialRegister *)0xc1)).bit0)
#define	FP11M	((*((__RAM struct specialRegister *)0xc1)).bit1)
#define	FP12M	((*((__RAM struct specialRegister *)0xc1)).bit2)
#define	FP13M	((*((__RAM struct specialRegister *)0xc1)).bit3)
#define	FP14M	((*((__RAM struct specialRegister *)0xc1)).bit4)
#define	FP15M	((*((__RAM struct specialRegister *)0xc1)).bit5)
#define	P2M	(*((__RAM unsigned int*)0xc2))
#define	FP20M	((*((__RAM struct specialRegister *)0xc2)).bit0)
#define	FP21M	((*((__RAM struct specialRegister *)0xc2)).bit1)
#define	FP22M	((*((__RAM struct specialRegister *)0xc2)).bit2)
#define	FP23M	((*((__RAM struct specialRegister *)0xc2)).bit3)
#define	P4M	(*((__RAM unsigned int*)0xc4))
#define	FP40M	((*((__RAM struct specialRegister *)0xc4)).bit0)
#define	FP41M	((*((__RAM struct specialRegister *)0xc4)).bit1)
#define	FP42M	((*((__RAM struct specialRegister *)0xc4)).bit2)
#define	FP43M	((*((__RAM struct specialRegister *)0xc4)).bit3)
#define	FP44M	((*((__RAM struct specialRegister *)0xc4)).bit4)
#define	FP45M	((*((__RAM struct specialRegister *)0xc4)).bit5)
#define	FP46M	((*((__RAM struct specialRegister *)0xc4)).bit6)
#define	P5M	(*((__RAM unsigned int*)0xc5))
#define	FP50M	((*((__RAM struct specialRegister *)0xc5)).bit0)
#define	FP51M	((*((__RAM struct specialRegister *)0xc5)).bit1)
#define	FP52M	((*((__RAM struct specialRegister *)0xc5)).bit2)
#define	FP53M	((*((__RAM struct specialRegister *)0xc5)).bit3)
#define	FP54M	((*((__RAM struct specialRegister *)0xc5)).bit4)
#define	FP55M	((*((__RAM struct specialRegister *)0xc5)).bit5)
#define	FP56M	((*((__RAM struct specialRegister *)0xc5)).bit6)
#define	INTRQ1	(*((__RAM unsigned int*)0xc6))
#define	FP10IRQ	((*((__RAM struct specialRegister *)0xc6)).bit0)
#define	FP11IRQ	((*((__RAM struct specialRegister *)0xc6)).bit1)
#define	FP12IRQ	((*((__RAM struct specialRegister *)0xc6)).bit2)
#define	FP13IRQ	((*((__RAM struct specialRegister *)0xc6)).bit3)
#define	FP14IRQ	((*((__RAM struct specialRegister *)0xc6)).bit4)
#define	FP15IRQ	((*((__RAM struct specialRegister *)0xc6)).bit5)
#define	FADCIRQ	((*((__RAM struct specialRegister *)0xc6)).bit6)
#define	FSIOIRQ	((*((__RAM struct specialRegister *)0xc6)).bit7)
#define	INTEN1	(*((__RAM unsigned int*)0xc7))
#define	FP10IEN	((*((__RAM struct specialRegister *)0xc7)).bit0)
#define	FP11IEN	((*((__RAM struct specialRegister *)0xc7)).bit1)
#define	FP12IEN	((*((__RAM struct specialRegister *)0xc7)).bit2)
#define	FP13IEN	((*((__RAM struct specialRegister *)0xc7)).bit3)
#define	FP14IEN	((*((__RAM struct specialRegister *)0xc7)).bit4)
#define	FP15IEN	((*((__RAM struct specialRegister *)0xc7)).bit5)
#define	FADCIEN	((*((__RAM struct specialRegister *)0xc7)).bit6)
#define	FSIOIEN	((*((__RAM struct specialRegister *)0xc7)).bit7)
#define	INTRQ0	(*((__RAM unsigned int*)0xc8))
#define	FP00IRQ	((*((__RAM struct specialRegister *)0xc8)).bit0)
#define	FP01IRQ	((*((__RAM struct specialRegister *)0xc8)).bit1)
#define	FTXIRQ	((*((__RAM struct specialRegister *)0xc8)).bit2)
#define	FRXIRQ	((*((__RAM struct specialRegister *)0xc8)).bit3)
#define	FT0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit4)
#define	FT1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit5)
#define	FTC0IRQ	((*((__RAM struct specialRegister *)0xc8)).bit6)
#define	FTC1IRQ	((*((__RAM struct specialRegister *)0xc8)).bit7)
#define	INTEN0	(*((__RAM unsigned int*)0xc9))
#define	FP00IEN	((*((__RAM struct specialRegister *)0xc9)).bit0)
#define	FP01IEN	((*((__RAM struct specialRegister *)0xc9)).bit1)
#define	FTXIEN	((*((__RAM struct specialRegister *)0xc9)).bit2)
#define	FRXIEN	((*((__RAM struct specialRegister *)0xc9)).bit3)
#define	FT0IEN	((*((__RAM struct specialRegister *)0xc9)).bit4)
#define	FT1IEN	((*((__RAM struct specialRegister *)0xc9)).bit5)
#define	FTC0IEN	((*((__RAM struct specialRegister *)0xc9)).bit6)
#define	FTC1IEN	((*((__RAM struct specialRegister *)0xc9)).bit7)
#define	OSCM	(*((__RAM unsigned int*)0xca))
#define	FSTPHX	((*((__RAM struct specialRegister *)0xca)).bit1)
#define	FCLKMD	((*((__RAM struct specialRegister *)0xca)).bit2)
#define	FCPUM0	((*((__RAM struct specialRegister *)0xca)).bit3)
#define	FCPUM1	((*((__RAM struct specialRegister *)0xca)).bit4)
#define	WDTR	(*((__RAM unsigned int*)0xcc))
#define	TC0R	(*((__RAM unsigned int*)0xcd))
#define	PCL	(*((__RAM unsigned int*)0xce))
#define	PCH	(*((__RAM unsigned int*)0xcf))
#define	P0	(*((__RAM unsigned int*)0xd0))
#define	FP00	((*((__RAM struct specialRegister *)0xd0)).bit0)
#define	FP01	((*((__RAM struct specialRegister *)0xd0)).bit1)
#define	P1	(*((__RAM unsigned int*)0xd1))
#define	FP10	((*((__RAM struct specialRegister *)0xd1)).bit0)
#define	FP11	((*((__RAM struct specialRegister *)0xd1)).bit1)
#define	FP12	((*((__RAM struct specialRegister *)0xd1)).bit2)
#define	FP13	((*((__RAM struct specialRegister *)0xd1)).bit3)
#define	FP14	((*((__RAM struct specialRegister *)0xd1)).bit4)
#define	FP15	((*((__RAM struct specialRegister *)0xd1)).bit5)
#define	P2	(*((__RAM unsigned int*)0xd2))
#define	FP20	((*((__RAM struct specialRegister *)0xd2)).bit0)
#define	FP21	((*((__RAM struct specialRegister *)0xd2)).bit1)
#define	FP22	((*((__RAM struct specialRegister *)0xd2)).bit2)
#define	FP23	((*((__RAM struct specialRegister *)0xd2)).bit3)
#define	P4	(*((__RAM unsigned int*)0xd4))
#define	FP40	((*((__RAM struct specialRegister *)0xd4)).bit0)
#define	FP41	((*((__RAM struct specialRegister *)0xd4)).bit1)
#define	FP42	((*((__RAM struct specialRegister *)0xd4)).bit2)
#define	FP43	((*((__RAM struct specialRegister *)0xd4)).bit3)
#define	FP44	((*((__RAM struct specialRegister *)0xd4)).bit4)
#define	FP45	((*((__RAM struct specialRegister *)0xd4)).bit5)
#define	FP46	((*((__RAM struct specialRegister *)0xd4)).bit6)
#define	P5	(*((__RAM unsigned int*)0xd5))
#define	FP50	((*((__RAM struct specialRegister *)0xd5)).bit0)
#define	FP51	((*((__RAM struct specialRegister *)0xd5)).bit1)
#define	FP52	((*((__RAM struct specialRegister *)0xd5)).bit2)
#define	FP53	((*((__RAM struct specialRegister *)0xd5)).bit3)
#define	FP54	((*((__RAM struct specialRegister *)0xd5)).bit4)
#define	FP55	((*((__RAM struct specialRegister *)0xd5)).bit5)
#define	FP56	((*((__RAM struct specialRegister *)0xd5)).bit6)
#define	T1M	(*((__RAM unsigned int*)0xd6))
#define	FT1CKS	((*((__RAM struct specialRegister *)0xd6)).bit3)
#define	FT1RATE0	((*((__RAM struct specialRegister *)0xd6)).bit4)
#define	FT1RATE1	((*((__RAM struct specialRegister *)0xd6)).bit5)
#define	FT1RATE2	((*((__RAM struct specialRegister *)0xd6)).bit6)
#define	FT1ENB	((*((__RAM struct specialRegister *)0xd6)).bit7)
#define	T1C	(*((__RAM unsigned int*)0xd7))
#define	T0M	(*((__RAM unsigned int*)0xd8))
#define	FT0TB	((*((__RAM struct specialRegister *)0xd8)).bit0)
#define	FTC0GN	((*((__RAM struct specialRegister *)0xd8)).bit1)
#define	FTC0X8	((*((__RAM struct specialRegister *)0xd8)).bit2)
#define	FTC1X8	((*((__RAM struct specialRegister *)0xd8)).bit3)
#define	FT0RATE0	((*((__RAM struct specialRegister *)0xd8)).bit4)
#define	FT0RATE1	((*((__RAM struct specialRegister *)0xd8)).bit5)
#define	FT0RATE2	((*((__RAM struct specialRegister *)0xd8)).bit6)
#define	FT0ENB	((*((__RAM struct specialRegister *)0xd8)).bit7)
#define	T0C	(*((__RAM unsigned int*)0xd9))
#define	TC0M	(*((__RAM unsigned int*)0xda))
#define	FPWM0OUT	((*((__RAM struct specialRegister *)0xda)).bit0)
#define	FTC0OUT	((*((__RAM struct specialRegister *)0xda)).bit1)
#define	FALOAD0	((*((__RAM struct specialRegister *)0xda)).bit2)
#define	FTC0CKS	((*((__RAM struct specialRegister *)0xda)).bit3)
#define	FTC0RATE0	((*((__RAM struct specialRegister *)0xda)).bit4)
#define	FTC0RATE1	((*((__RAM struct specialRegister *)0xda)).bit5)
#define	FTC0RATE2	((*((__RAM struct specialRegister *)0xda)).bit6)
#define	FTC0ENB	((*((__RAM struct specialRegister *)0xda)).bit7)
#define	TC0C	(*((__RAM unsigned int*)0xdb))
#define	TC1M	(*((__RAM unsigned int*)0xdc))
#define	FPWM1OUT	((*((__RAM struct specialRegister *)0xdc)).bit0)
#define	FTC1OUT	((*((__RAM struct specialRegister *)0xdc)).bit1)
#define	FALOAD1	((*((__RAM struct specialRegister *)0xdc)).bit2)
#define	FTC1CKS	((*((__RAM struct specialRegister *)0xdc)).bit3)
#define	FTC1RATE0	((*((__RAM struct specialRegister *)0xdc)).bit4)
#define	FTC1RATE1	((*((__RAM struct specialRegister *)0xdc)).bit5)
#define	FTC1RATE2	((*((__RAM struct specialRegister *)0xdc)).bit6)
#define	FTC1ENB	((*((__RAM struct specialRegister *)0xdc)).bit7)
#define	TC1C	(*((__RAM unsigned int*)0xdd))
#define	TC1R	(*((__RAM unsigned int*)0xde))
#define	STKP	(*((__RAM unsigned int*)0xdf))
#define	FSTKPB0	((*((__RAM struct specialRegister *)0xdf)).bit0)
#define	FSTKPB1	((*((__RAM struct specialRegister *)0xdf)).bit1)
#define	FSTKPB2	((*((__RAM struct specialRegister *)0xdf)).bit2)
#define	FSTKPB3	((*((__RAM struct specialRegister *)0xdf)).bit3)
#define	FSTKPB4	((*((__RAM struct specialRegister *)0xdf)).bit4)
#define	FGIE	((*((__RAM struct specialRegister *)0xdf)).bit7)
#define	P0UR	(*((__RAM unsigned int*)0xe0))
#define	FP00R	((*((__RAM struct specialRegister *)0xe0)).bit0)
#define	FP01R	((*((__RAM struct specialRegister *)0xe0)).bit1)
#define	P1UR	(*((__RAM unsigned int*)0xe1))
#define	FP10R	((*((__RAM struct specialRegister *)0xe1)).bit0)
#define	FP11R	((*((__RAM struct specialRegister *)0xe1)).bit1)
#define	FP12R	((*((__RAM struct specialRegister *)0xe1)).bit2)
#define	FP13R	((*((__RAM struct specialRegister *)0xe1)).bit3)
#define	P2UR	(*((__RAM unsigned int*)0xe2))
#define	FP20R	((*((__RAM struct specialRegister *)0xe2)).bit0)
#define	FP21R	((*((__RAM struct specialRegister *)0xe2)).bit1)
#define	FP22R	((*((__RAM struct specialRegister *)0xe2)).bit2)
#define	FP23R	((*((__RAM struct specialRegister *)0xe2)).bit3)
#define	P4UR	(*((__RAM unsigned int*)0xe4))
#define	FP40R	((*((__RAM struct specialRegister *)0xe4)).bit0)
#define	FP41R	((*((__RAM struct specialRegister *)0xe4)).bit1)
#define	FP42R	((*((__RAM struct specialRegister *)0xe4)).bit2)
#define	FP43R	((*((__RAM struct specialRegister *)0xe4)).bit3)
#define	FP44R	((*((__RAM struct specialRegister *)0xe4)).bit4)
#define	FP45R	((*((__RAM struct specialRegister *)0xe4)).bit5)
#define	FP46R	((*((__RAM struct specialRegister *)0xe4)).bit6)
#define	P5UR	(*((__RAM unsigned int*)0xe5))
#define	FP50R	((*((__RAM struct specialRegister *)0xe5)).bit0)
#define	FP51R	((*((__RAM struct specialRegister *)0xe5)).bit1)
#define	FP52R	((*((__RAM struct specialRegister *)0xe5)).bit2)
#define	FP53R	((*((__RAM struct specialRegister *)0xe5)).bit3)
#define	FP54R	((*((__RAM struct specialRegister *)0xe5)).bit4)
#define	FP55R	((*((__RAM struct specialRegister *)0xe5)).bit5)
#define	FP56R	((*((__RAM struct specialRegister *)0xe5)).bit6)
#define	_HL	(*((__RAM unsigned int*)0xe6))
#define	_YZ	(*((__RAM unsigned int*)0xe7))
#define	P1OC	(*((__RAM unsigned int*)0xe9))
#define	FP10OC	((*((__RAM struct specialRegister *)0xe9)).bit0)
#define	FP11OC	((*((__RAM struct specialRegister *)0xe9)).bit1)
#define	FP12OC	((*((__RAM struct specialRegister *)0xe9)).bit2)
#define	FP13OC	((*((__RAM struct specialRegister *)0xe9)).bit3)
#define	FP50OC	((*((__RAM struct specialRegister *)0xe9)).bit4)
#define	FP51OC	((*((__RAM struct specialRegister *)0xe9)).bit5)
#define	FP52OC	((*((__RAM struct specialRegister *)0xe9)).bit6)
#define	T2M	(*((__RAM unsigned int*)0xea))
#define	FT2ENB	((*((__RAM struct specialRegister *)0xea)).bit7)
#define	FT2rate2	((*((__RAM struct specialRegister *)0xea)).bit6)
#define	FT2rate1	((*((__RAM struct specialRegister *)0xea)).bit5)
#define	FT2rate0	((*((__RAM struct specialRegister *)0xea)).bit4)
#define	FT2CKS	((*((__RAM struct specialRegister *)0xea)).bit3)
#define	T2CL	(*((__RAM unsigned int*)0xeb))
#define	T2CH	(*((__RAM unsigned int*)0xec))
#define	CPT2M	(*((__RAM unsigned int*)0xed))
#define	FCPT2EN	((*((__RAM struct specialRegister *)0xed)).bit7)
#define	FCPT2MD	((*((__RAM struct specialRegister *)0xed)).bit3)
#define	FCPT2Start	((*((__RAM struct specialRegister *)0xed)).bit2)
#define	FCPT2G1	((*((__RAM struct specialRegister *)0xed)).bit1)
#define	FCPT2G0	((*((__RAM struct specialRegister *)0xed)).bit0)
#define	CPT2CL	(*((__RAM unsigned int*)0xee))
#define	CPT2CH	(*((__RAM unsigned int*)0xef))
#define	URRX	(*((__RAM unsigned int*)0xf0))
#define	FURS0	((*((__RAM struct specialRegister *)0xf0)).bit0)
#define	FURS1	((*((__RAM struct specialRegister *)0xf0)).bit1)
#define	FURS2	((*((__RAM struct specialRegister *)0xf0)).bit2)
#define	FUFMER	((*((__RAM struct specialRegister *)0xf0)).bit3)
#define	FURXPC	((*((__RAM struct specialRegister *)0xf0)).bit4)
#define	FURXPS	((*((__RAM struct specialRegister *)0xf0)).bit5)
#define	FURXPEN	((*((__RAM struct specialRegister *)0xf0)).bit6)
#define	FURXEN	((*((__RAM struct specialRegister *)0xf0)).bit7)
#define	URTX	(*((__RAM unsigned int*)0xf1))
#define	FUTXBZ	((*((__RAM struct specialRegister *)0xf1)).bit2)
#define	FURXBZ	((*((__RAM struct specialRegister *)0xf1)).bit3)
#define	FUTXBRK	((*((__RAM struct specialRegister *)0xf1)).bit4)
#define	FUTXPS	((*((__RAM struct specialRegister *)0xf1)).bit5)
#define	FUTXPEN	((*((__RAM struct specialRegister *)0xf1)).bit6)
#define	FUTXEN	((*((__RAM struct specialRegister *)0xf1)).bit7)
#define	URCR	(*((__RAM unsigned int*)0xf2))
#define	FURCR0	((*((__RAM struct specialRegister *)0xf2)).bit0)
#define	FURCR1	((*((__RAM struct specialRegister *)0xf2)).bit1)
#define	FURCR2	((*((__RAM struct specialRegister *)0xf2)).bit2)
#define	FURCR3	((*((__RAM struct specialRegister *)0xf2)).bit3)
#define	FURCR4	((*((__RAM struct specialRegister *)0xf2)).bit4)
#define	FURCR5	((*((__RAM struct specialRegister *)0xf2)).bit5)
#define	FURCR6	((*((__RAM struct specialRegister *)0xf2)).bit6)
#define	FURCR7	((*((__RAM struct specialRegister *)0xf2)).bit7)
#define	UTXD	(*((__RAM unsigned int*)0xf3))
#define	FUTXD0	((*((__RAM struct specialRegister *)0xf3)).bit0)
#define	FUTXD1	((*((__RAM struct specialRegister *)0xf3)).bit1)
#define	FUTXD2	((*((__RAM struct specialRegister *)0xf3)).bit2)
#define	FUTXD3	((*((__RAM struct specialRegister *)0xf3)).bit3)
#define	FUTXD4	((*((__RAM struct specialRegister *)0xf3)).bit4)
#define	FUTXD5	((*((__RAM struct specialRegister *)0xf3)).bit5)
#define	FUTXD6	((*((__RAM struct specialRegister *)0xf3)).bit6)
#define	FUTXD7	((*((__RAM struct specialRegister *)0xf3)).bit7)
#define	URXD	(*((__RAM unsigned int*)0xf4))
#define	FURXD0	((*((__RAM struct specialRegister *)0xf4)).bit0)
#define	FURXD1	((*((__RAM struct specialRegister *)0xf4)).bit1)
#define	FURXD2	((*((__RAM struct specialRegister *)0xf4)).bit2)
#define	FURXD3	((*((__RAM struct specialRegister *)0xf4)).bit3)
#define	FURXD4	((*((__RAM struct specialRegister *)0xf4)).bit4)
#define	FURXD5	((*((__RAM struct specialRegister *)0xf4)).bit5)
#define	FURXD6	((*((__RAM struct specialRegister *)0xf4)).bit6)
#define	FURXD7	((*((__RAM struct specialRegister *)0xf4)).bit7)
#define	INTRQ2	(*((__RAM unsigned int*)0xf5))
#define	FT2IRQ	((*((__RAM struct specialRegister *)0xf5)).bit0)
#define	FT3IRQ	((*((__RAM struct specialRegister *)0xf5)).bit1)
#define	INTEN2	(*((__RAM unsigned int*)0xf6))
#define	FT2IEN	((*((__RAM struct specialRegister *)0xf6)).bit0)
#define	FT3IEN	((*((__RAM struct specialRegister *)0xf6)).bit1)
#define	DAM	(*((__RAM unsigned int*)0xf7))
#define	FDAEN	((*((__RAM struct specialRegister *)0xf7)).bit7)
#define	DABL	(*((__RAM unsigned int*)0xf8))
#define	DABH	(*((__RAM unsigned int*)0xf9))
#define	T3M	(*((__RAM unsigned int*)0xfa))
#define	FT3ENB	((*((__RAM struct specialRegister *)0xfa)).bit7)
#define	FT3rate2	((*((__RAM struct specialRegister *)0xfa)).bit6)
#define	FT3rate1	((*((__RAM struct specialRegister *)0xfa)).bit5)
#define	FT3rate0	((*((__RAM struct specialRegister *)0xfa)).bit4)
#define	FT3CKS	((*((__RAM struct specialRegister *)0xfa)).bit3)
#define	T3CL	(*((__RAM unsigned int*)0xfb))
#define	T3CH	(*((__RAM unsigned int*)0xfc))
#define	CPT3M	(*((__RAM unsigned int*)0xfd))
#define	FCPT3EN	((*((__RAM struct specialRegister *)0xfd)).bit7)
#define	FCPT3MD	((*((__RAM struct specialRegister *)0xfd)).bit3)
#define	FCPT3Start	((*((__RAM struct specialRegister *)0xfd)).bit2)
#define	FCPT3G1	((*((__RAM struct specialRegister *)0xfd)).bit1)
#define	FCPT3G0	((*((__RAM struct specialRegister *)0xfd)).bit0)
#define	CPT3CL	(*((__RAM unsigned int*)0xfe))
#define	CPT3CH	(*((__RAM unsigned int*)0xff))
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SLowMode}
#define SLOW2NORMAL __asm{Slow2Normal}
#endif
