#ifndef _BL08P162_H
#define _BL08P162_H

void _ClearWatchDogTimer(void);
void _ClrRAM(void);

#define NOP(X)  	__asm{	_NOP X }
#define LOG(X)  	__asm{	LOG CNameToAsmLabel(X) }

sfr	L	=	0x80;

sfr	H	=	0x81;

sfr	R	=	0x82;

sfr	Z	=	0x83;

sfr	Y	=	0x84;

sfr	X	=	0x85;

sfr	PFLAG	=	0x86;
	sbit	Z	=	0x86:0;
	sbit	FZ	=	0x86:0;
	sbit	DC	=	0x86:1;
	sbit	FDC	=	0x86:1;
	sbit	C	=	0x86:2;
	sbit	FC	=	0x86:2;
	sbit	PD	=	0x86:6;
	sbit	FPD	=	0x86:6;
	sbit	TO	=	0x86:7;
	sbit	FTO	=	0x86:7;

sfr	RBANK	=	0x87;
	sbit	RBANKS0	=	0x87:0;
	sbit	FRBANKS0	=	0x87:0;

sfr	W0	=	0x88;

sfr	W1	=	0x89;

sfr	W2	=	0x8A;

sfr	W3	=	0x8B;

sfr	W4	=	0x8C;

sfr	W5	=	0x8D;

sfr	W6	=	0x8E;

sfr	W7	=	0x8F;

sfr	PCL	=	0x93;

sfr	PCH	=	0x94;

sfr	OSCM	=	0x95;
	sbit	STPHX	=	0x95:1;
	sbit	FSTPHX	=	0x95:1;
	sbit	CLKMD	=	0x95:2;
	sbit	FCLKMD	=	0x95:2;
	sbit	CPUM0	=	0x95:3;
	sbit	FCPUM0	=	0x95:3;
	sbit	CPUM1	=	0x95:4;
	sbit	FCPUM1	=	0x95:4;
	sbit	XTSEL	=	0x95:5;
	sbit	FXTSEL	=	0x95:5;

sfr	WDTR	=	0x96;

sfr	INTRQ0	=	0x97;
	sbit	INT0IF	=	0x97:0;
	sbit	FINT0IF	=	0x97:0;
	sbit	INT1IF	=	0x97:1;
	sbit	FINT1IF	=	0x97:1;
	sbit	INT2IF	=	0x97:2;
	sbit	FINT2IF	=	0x97:2;
	sbit	T1IF	=	0x97:4;
	sbit	FT1IF	=	0x97:4;
	sbit	TC0IF	=	0x97:5;
	sbit	FTC0IF	=	0x97:5;
	sbit	T2IF	=	0x97:6;
	sbit	FT2IF	=	0x97:6;

sfr	INTRQ1	=	0x98;
	sbit	TC3IF	=	0x98:0;
	sbit	FTC3IF	=	0x98:0;
	sbit	I2CIF	=	0x98:6;
	sbit	FI2CIF	=	0x98:6;

sfr	INTEN0	=	0x99;
	sbit	INT0IE	=	0x99:0;
	sbit	FINT0IE	=	0x99:0;
	sbit	INT1IE	=	0x99:1;
	sbit	FINT1IE	=	0x99:1;
	sbit	INT2IE	=	0x99:2;
	sbit	FINT2IE	=	0x99:2;
	sbit	T1IE	=	0x99:4;
	sbit	FT1IE	=	0x99:4;
	sbit	TC0IE	=	0x99:5;
	sbit	FTC0IE	=	0x99:5;
	sbit	T2IE	=	0x99:6;
	sbit	FT2IE	=	0x99:6;

sfr	INTEN1	=	0x99;
	sbit	TC3IE	=	0x99:0;
	sbit	FTC3IE	=	0x99:0;
	sbit	I2CIE	=	0x99:6;
	sbit	FI2CIE	=	0x99:6;

sfr	P0W	=	0x9B;

sfr	P1W	=	0x9C;

sfr	P2W	=	0x9D;

sfr	P4W	=	0x9E;

sfr	PEDGE	=	0x9F;
	sbit	PG0	=	0x9F:0;
	sbit	FPG0	=	0x9F:0;
	sbit	PG1	=	0x9F:1;
	sbit	FPG1	=	0x9F:1;

sfr	P0M0	=	0xA0;

sfr	P1M0	=	0xA1;

sfr	P2M0	=	0xA2;

sfr	P4M0	=	0xA3;

sfr	P0	=	0xA5;

sfr	P1	=	0xA6;

sfr	P2	=	0xA7;

sfr	P4	=	0xA8;

sfr	P0UR	=	0xAA;

sfr	P1UR	=	0xAB;

sfr	P2UR	=	0xAC;

sfr	P4UR	=	0xAD;

sfr	REMCON	=	0xAF;
	sbit	REM_SEL0	=	0xAF:0;
	sbit	FREM_SEL0	=	0xAF:0;
	sbit	REM_SEL1	=	0xAF:1;
	sbit	FREM_SEL1	=	0xAF:1;
	sbit	REM_SEL2	=	0xAF:2;
	sbit	FREM_SEL2	=	0xAF:2;
	sbit	REM_SEL3	=	0xAF:3;
	sbit	FREM_SEL3	=	0xAF:3;
	sbit	REM_SEL4	=	0xAF:4;
	sbit	FREM_SEL4	=	0xAF:4;
	sbit	ELE_EN	=	0xAF:5;
	sbit	FELE_EN	=	0xAF:5;
	sbit	D_SEL	=	0xAF:6;
	sbit	FD_SEL	=	0xAF:6;
	sbit	IE_SEL	=	0xAF:7;
	sbit	FIE_SEL	=	0xAF:7;

sfr	LCD_CT0	=	0xB0;
	sbit	SCANSEL	=	0xB0:0;
	sbit	FSCANSEL	=	0xB0:0;
	sbit	LCDPR	=	0xB0:2;
	sbit	FLCDPR	=	0xB0:2;
	sbit	DUTY0	=	0xB0:4;
	sbit	FDUTY0	=	0xB0:4;
	sbit	DUTY1	=	0xB0:5;
	sbit	FDUTY1	=	0xB0:5;
	sbit	PUMPEN	=	0xB0:6;
	sbit	FPUMPEN	=	0xB0:6;
	sbit	LCDEN	=	0xB0:7;
	sbit	FLCDEN	=	0xB0:7;

sfr	LCD_DB	=	0xB1;

sfr	LCD_ADDR	=	0xB2;

sfr	LCD_CT2	=	0xB4;
	sbit	COMSX0	=	0xB4:0;
	sbit	FCOMSX0	=	0xB4:0;
	sbit	COMSX1	=	0xB4:1;
	sbit	FCOMSX1	=	0xB4:1;
	sbit	COMSX4	=	0xB4:4;
	sbit	FCOMSX4	=	0xB4:4;

sfr	T1M0	=	0xB5;
	sbit	TCOGN	=	0xB5:0;
	sbit	FTCOGN	=	0xB5:0;
	sbit	TC3GN	=	0xB5:1;
	sbit	FTC3GN	=	0xB5:1;
	sbit	T1CK	=	0xB5:2;
	sbit	FT1CK	=	0xB5:2;
	sbit	TP1SEL	=	0xB5:3;
	sbit	FTP1SEL	=	0xB5:3;
	sbit	TP1S0	=	0xB5:4;
	sbit	FTP1S0	=	0xB5:4;
	sbit	TP1S1	=	0xB5:5;
	sbit	FTP1S1	=	0xB5:5;
	sbit	TP1S2	=	0xB5:6;
	sbit	FTP1S2	=	0xB5:6;
	sbit	TR1	=	0xB5:7;
	sbit	FTR1	=	0xB5:7;

sfr	TC1L	=	0xB6;

sfr	TC1H	=	0xB7;

sfr	TC0M	=	0xB8;
	sbit	PWM0EN	=	0xB8:0;
	sbit	FPWM0EN	=	0xB8:0;
	sbit	RLOAD	=	0xB8:1;
	sbit	FRLOAD	=	0xB8:1;
	sbit	TC0I2	=	0xB8:2;
	sbit	FTC0I2	=	0xB8:2;
	sbit	TC0I1	=	0xB8:3;
	sbit	FTC0I1	=	0xB8:3;
	sbit	TC0S0	=	0xB8:4;
	sbit	FTC0S0	=	0xB8:4;
	sbit	TC0S1	=	0xB8:5;
	sbit	FTC0S1	=	0xB8:5;
	sbit	TC0S2	=	0xB8:6;
	sbit	FTC0S2	=	0xB8:6;
	sbit	TCOTR	=	0xB8:7;
	sbit	FTCOTR	=	0xB8:7;

sfr	TC0C	=	0xB9;

sfr	TC0R	=	0xBA;

sfr	TC0D	=	0xBB;

sfr	TC0M1	=	0xBC;
	sbit	PWM1EN	=	0xBC:0;
	sbit	FPWM1EN	=	0xBC:0;
	sbit	PWM2EN	=	0xBC:1;
	sbit	FPWM2EN	=	0xBC:1;
	sbit	TC0M12	=	0xBC:2;
	sbit	FTC0M12	=	0xBC:2;
	sbit	TC0M13	=	0xBC:3;
	sbit	FTC0M13	=	0xBC:3;

sfr	TC0D1	=	0xBD;

sfr	TC0D2	=	0xBE;

sfr	P0SS	=	0xC0;

sfr	P1SS	=	0xC1;

sfr	P2SS	=	0xC2;

sfr	P4SS	=	0xC3;

sfr	LCD_CT3	=	0xC4;
	sbit	SCANPON0	=	0xC4:0;
	sbit	FSCANPON0	=	0xC4:0;
	sbit	SCANPON1	=	0xC4:1;
	sbit	FSCANPON1	=	0xC4:1;
	sbit	SCANPON2	=	0xC4:2;
	sbit	FSCANPON2	=	0xC4:2;
	sbit	SCANPON3	=	0xC4:3;
	sbit	FSCANPON3	=	0xC4:3;
	sbit	LCDCLKS0	=	0xC4:6;
	sbit	FLCDCLKS0	=	0xC4:6;
	sbit	LCDCLKS1	=	0xC4:7;
	sbit	FLCDCLKS1	=	0xC4:7;

sfr	PICON	=	0xC5;
	sbit	PICON0	=	0xC5:0;
	sbit	FPICON0	=	0xC5:0;
	sbit	PICON1	=	0xC5:1;
	sbit	FPICON1	=	0xC5:1;
	sbit	PICON2	=	0xC5:2;
	sbit	FPICON2	=	0xC5:2;
	sbit	PICON4	=	0xC5:4;
	sbit	FPICON4	=	0xC5:4;
	sbit	PICON5	=	0xC5:5;
	sbit	FPICON5	=	0xC5:5;
	sbit	PICON7	=	0xC5:7;
	sbit	FPICON7	=	0xC5:7;

sfr	PCTRL	=	0xC6;
	sbit	PCTRL7	=	0xC6:7;
	sbit	FPCTRL7	=	0xC6:7;

sfr	WDTRCON	=	0xCC;
	sbit	WDT_PRE0	=	0xCC:4;
	sbit	FWDT_PRE0	=	0xCC:4;
	sbit	WDT_PRE1	=	0xCC:5;
	sbit	FWDT_PRE1	=	0xCC:5;
	sbit	WDT_PRE1	=	0xCC:6;
	sbit	FWDT_PRE1	=	0xCC:6;
	sbit	WDT_EN	=	0xCC:7;
	sbit	FWDT_EN	=	0xCC:7;

sfr	LEDCT0	=	0xCD;
	sbit	LEDPCON	=	0xCD:5;
	sbit	FLEDPCON	=	0xCD:5;
	sbit	LEDODEN	=	0xCD:6;
	sbit	FLEDODEN	=	0xCD:6;
	sbit	LEDEN	=	0xCD:7;
	sbit	FLEDEN	=	0xCD:7;

sfr	LVDCON	=	0xCF;
	sbit	LVD18	=	0xCF:0;
	sbit	FLVD18	=	0xCF:0;
	sbit	LVD2X	=	0xCF:1;
	sbit	FLVD2X	=	0xCF:1;
	sbit	LVDS0	=	0xCF:3;
	sbit	FLVDS0	=	0xCF:3;
	sbit	LVDS1	=	0xCF:4;
	sbit	FLVDS1	=	0xCF:4;
	sbit	REM_SEL5	=	0xCF:5;
	sbit	FREM_SEL5	=	0xCF:5;
	sbit	REM_SEL6	=	0xCF:6;
	sbit	FREM_SEL6	=	0xCF:6;
	sbit	REM_SEL7	=	0xCF:7;
	sbit	FREM_SEL7	=	0xCF:7;

sfr	P0SD	=	0xD0;

sfr	P1SD	=	0xD1;

sfr	P2SD	=	0xD2;

sfr	P4SD	=	0xD3;

sfr	TC3M	=	0xD5;
	sbit	PWMX0EN	=	0xD5:0;
	sbit	FPWMX0EN	=	0xD5:0;
	sbit	RLOADX	=	0xD5:1;
	sbit	FRLOADX	=	0xD5:1;
	sbit	TC3SEL	=	0xD5:2;
	sbit	FTC3SEL	=	0xD5:2;
	sbit	TC3I1	=	0xD5:3;
	sbit	FTC3I1	=	0xD5:3;
	sbit	TC3S0	=	0xD5:4;
	sbit	FTC3S0	=	0xD5:4;
	sbit	TC3S1	=	0xD5:5;
	sbit	FTC3S1	=	0xD5:5;
	sbit	TC3S2	=	0xD5:6;
	sbit	FTC3S2	=	0xD5:6;
	sbit	TC3TR	=	0xD5:7;
	sbit	FTC3TR	=	0xD5:7;

sfr	TC3R	=	0xD6;

sfr	TC3L	=	0xD7;

sfr	TC3H	=	0xD8;

sfr	TC3D0	=	0xD9;

sfr	TC3D1	=	0xDA;

sfr	TC3D2	=	0xDB;

sfr	TC3RH	=	0xDC;

sfr	TC3D0H	=	0xDD;

sfr	TC3D1H	=	0xDE;

sfr	TC3D2H	=	0xDF;

sfr	P0SU	=	0xE0;

sfr	P1SU	=	0xE1;

sfr	P2SU	=	0xE2;

sfr	P4SU	=	0xE3;

sfr	I2CCON	=	0xE5;
	sbit	I2CEN	=	0xE5:0;
	sbit	FI2CEN	=	0xE5:0;
	sbit	I2CPU	=	0xE5:1;
	sbit	FI2CPU	=	0xE5:1;
	sbit	CKP	=	0xE5:2;
	sbit	FCKP	=	0xE5:2;
	sbit	TXAK	=	0xE5:3;
	sbit	FTXAK	=	0xE5:3;
	sbit	SRW	=	0xE5:4;
	sbit	FSRW	=	0xE5:4;
	sbit	HBB	=	0xE5:5;
	sbit	FHBB	=	0xE5:5;
	sbit	HAAS	=	0xE5:6;
	sbit	FHAAS	=	0xE5:6;
	sbit	HCF	=	0xE5:7;
	sbit	FHCF	=	0xE5:7;

sfr	I2CADR	=	0xE6;

sfr	I2CBUF	=	0xE7;

sfr	I2CTOV	=	0xE8;
	sbit	TOS0	=	0xE8:0;
	sbit	FTOS0	=	0xE8:0;
	sbit	TOS1	=	0xE8:1;
	sbit	FTOS1	=	0xE8:1;
	sbit	TOS2	=	0xE8:2;
	sbit	FTOS2	=	0xE8:2;
	sbit	TOVF	=	0xE8:6;
	sbit	FTOVF	=	0xE8:6;
	sbit	TOVEN	=	0xE8:7;
	sbit	FTOVEN	=	0xE8:7;

sfr	T1M1	=	0xE9;
	sbit	T1GN	=	0xE9:0;
	sbit	FT1GN	=	0xE9:0;
	sbit	T1OVS	=	0xE9:1;
	sbit	FT1OVS	=	0xE9:1;
	sbit	PWMW1	=	0xE9:3;
	sbit	FPWMW1	=	0xE9:3;
	sbit	PWMW2	=	0xE9:4;
	sbit	FPWMW2	=	0xE9:4;

sfr	T2M	=	0xEA;
	sbit	TP2S0	=	0xEA:3;
	sbit	FTP2S0	=	0xEA:3;
	sbit	TP2S1	=	0xEA:4;
	sbit	FTP2S1	=	0xEA:4;
	sbit	TP2S2	=	0xEA:5;
	sbit	FTP2S2	=	0xEA:5;
	sbit	T2WS	=	0xEA:6;
	sbit	FT2WS	=	0xEA:6;
	sbit	TR2	=	0xEA:7;
	sbit	FTR2	=	0xEA:7;

sfr	T2CL	=	0xEB;

sfr	TC3M1	=	0xEE;
	sbit	PWMX1EN	=	0xEE:0;
	sbit	FPWMX1EN	=	0xEE:0;
	sbit	PWMX2EN	=	0xEE:1;
	sbit	FPWMX2EN	=	0xEE:1;
	sbit	PWMX0S0	=	0xEE:2;
	sbit	FPWMX0S0	=	0xEE:2;
	sbit	PWMX1S0	=	0xEE:3;
	sbit	FPWMX1S0	=	0xEE:3;
	sbit	PWMX2S0	=	0xEE:4;
	sbit	FPWMX2S0	=	0xEE:4;
	sbit	PWMX1S1	=	0xEE:5;
	sbit	FPWMX1S1	=	0xEE:5;
	sbit	PWMX1S1	=	0xEE:6;
	sbit	FPWMX1S1	=	0xEE:6;
	sbit	PWMX1S1	=	0xEE:7;
	sbit	FPWMX1S1	=	0xEE:7;

sfr	STKP	=	0xEF;
	sbit	STKPB0	=	0xEF:0;
	sbit	FSTKPB0	=	0xEF:0;
	sbit	STKPB1	=	0xEF:1;
	sbit	FSTKPB1	=	0xEF:1;
	sbit	STKPB2	=	0xEF:2;
	sbit	FSTKPB2	=	0xEF:2;
	sbit	GIE	=	0xEF:7;
	sbit	FGIE	=	0xEF:7;

sfr	STK7L	=	0xF0;

sfr	STK7H	=	0xF1;

sfr	STK6L	=	0xF2;

sfr	STK6H	=	0xF3;

sfr	STK5L	=	0xF4;

sfr	STK5H	=	0xF5;

sfr	STK4L	=	0xF6;

sfr	STK4H	=	0xF7;

sfr	STK3L	=	0xF8;

sfr	STK3H	=	0xF9;

sfr	STK2L	=	0xFA;

sfr	STK2H	=	0xFB;

sfr	STK1L	=	0xFC;

sfr	STK1H	=	0xFD;

sfr	STK0L	=	0xFE;

sfr	STK0H	=	0xFF;

//=================================================
#define SLEEPMODE __asm{SleepMode}
#define GREENMODE __asm{GreenMode}
#define SLOWMODE __asm{SlowMode}
#define SLOW2NORMAL __asm{Slow2Normal}

/////////////////////////////////////////////////////
/////////////////////////////////////////////////////
#define HIBYTE(wval)		*(((BYTE*)(&wval))+1)
#define LWBYTE(wval)		*(((BYTE*)(&wval))+0)

#define HIWORD(wval)		*(((WORD*)(&wval))+1)
#define LWWORD(wval)		*(((WORD*)(&wval))+0)


#endif

