
;------------------------------------------------------------------------------
;  CHIP: SN8F22721
;  Revision History
;  
;  V01   2007/11/20
;  V02   2008/04/03  1. Add "RedWrt_FORMAT    1" 
;  V03	 2008/04/22	 Add reseverd ROM address from 0x13F8 ~ 0x13FB
;  V04	 2008/07/02	 modify USB PHY = 151c (0x13fd)
;  V05	 2008/07/23	 modify VREG voltage = 010 (0x13ff bit4~bit6)
;  V06	 2008/09/01    modify INC_VER = 6
;			 modify CHIP_ID = 0x2202
;			 modify Reset_Pin Option : P05 Reset => P16 Reset	
;  V07  2008/10/08	 modify USB PHY = 0x0df7(ROM address 0x13fd)
;  V08 	2010/06/30   1.ADD MACRO:
;					  SleepMode
;					  GreenMode
;					  SlowMode
;					  Slow2Normal
;  V09   2012/07/12  	1. Add "PCL_READ_LIMIT" Key word
;------------------------------------------------------------------------------

.ASSEMBLY    RedWrt_FORMAT    1
.Assembly	INC_VER		9
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	192

.Assembly	INSTRUMENT	SN8F22721
.Assembly	BIT_FILE	SN8F22721

.Assembly	OTP_BODY_SIZE	0x1400
.Assembly	USER_ROM_SIZE	0x13F8

.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000

.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x2202
.Assembly	command		Enable_ORG4_7, RBANK_LIMIT, Enable_ISP, PCL_READ_LIMIT
.Assembly	Port_Pins	3, 7, 0, 0, 0, 4

.Assembly	USB_FIFO_Size	32, 32

; Code Option 0x13FF
.Assembly	OPTION		0		Fix_Low
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 x
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
;For regulator adjust
.Assembly	OPTION		4		Fix_Low
.Assembly OPTION		5		Fix_High
.Assembly	OPTION		6		Fix_Low
;
;.Assembly	OPTION		7		Fix_Low
.Assembly	OPTION		7		Fix_High
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Assembly	OPTION		12		Reset_Pin       P16 	Reset
.Assembly	OPTION		13		Rst_Length  	No 	128*ILRC
.Assembly	OPTION		14		Fix_High
.Assembly	OPTION		15		Fix_Low
;.Assembly	OPTION		14		Lvd		LVD_L	LVD_M	LVD_H	x
;.Help
;{
;	LVD_L		: "Low Voltage Detect	1.65V"
;	LVD_M		: "Low Voltage Detect	2.4V"
;	LVD_H		: "Low Voltage Detect	3.6V"
;}
;.Assembly	OPTION		15		SMODE3      Disable Enable

; Code Option 0x13FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x13FD
.Assembly	OPTION		32 		Fix_High
.Assembly	OPTION		33 		Fix_High
.Assembly	OPTION		34 		Fix_High
.Assembly	OPTION		35 		Fix_low
.Assembly	OPTION		36 		Fix_High
.Assembly	OPTION		37 		Fix_High
.Assembly	OPTION		38 		Fix_High
.Assembly	OPTION		39 		Fix_High

.Assembly	OPTION		40 		Fix_High
.Assembly	OPTION		41 		Fix_low
.Assembly	OPTION		42 		Fix_High
.Assembly	OPTION		43 		Fix_High
.Assembly	OPTION		44 		Fix_low
.Assembly	OPTION		45 		Fix_low
.Assembly	OPTION		46 		Fix_low
.Assembly	OPTION		47		Fix_low

; Code Option 0x13FC

.Assembly	OPTION		48 : 63 		Fix_High


/*
.Assembly	OPTION		48 		Fix_low
.Assembly	OPTION		49 		Fix_low
.Assembly	OPTION		50 		Fix_High
.Assembly	OPTION		51 		Fix_low
.Assembly	OPTION		52 		Fix_High
.Assembly	OPTION		53 		Fix_low
.Assembly	OPTION		54 		Fix_low
.Assembly	OPTION		55 		Fix_low

.Assembly	OPTION		56 		Fix_low
.Assembly	OPTION		57 		Fix_High
.Assembly	OPTION		58		Fix_High
.Assembly	OPTION		59 		Fix_High
.Assembly	OPTION		60 		Fix_High
.Assembly	OPTION		61 		Fix_High
.Assembly	OPTION		62 		Fix_High
.Assembly	OPTION		63 		Fix_High
*/
.Assembly	OPTION		2ffh

	R			EQU		82H
	Z			EQU		83H
	Y			EQU		84H
	
	PFLAG		EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	RBANK		EQU		87H
		FRBNKS0	EQU		RBANK.0
		FRBNKS1	EQU		RBANK.1

	TC0M		EQU		088H
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3
    		FALOAD0 	EQU 	TC0M.2
    		FTC0OUT   	EQU 	TC0M.1
    		FPWM0OUT  	EQU 	TC0M.0 
    
	TC0C			EQU		089H	
	TC0R			EQU		08AH
	
	CFS			EQU		08EH
		FIHRCOEN	EQU	CFS.7
		FCFS2			EQU	CFS.2
		FCFS1			EQU	CFS.1
		FCFS0			EQU	CFS.0
		
	S_STAT	EQU		08FH
		FS_STAT5	EQU	S_STAT.5
		FS_STAT4	EQU	S_STAT.4
		FS_STAT3	EQU	S_STAT.3
		FS_STAT2	EQU	S_STAT.2
		FS_STAT1	EQU	S_STAT.1
		FS_STAT0	EQU	S_STAT.0

	UDA			EQU		090H
		FUDE	EQU		UDA.7
		FUDA6	EQU		UDA.6
		FUDA5	EQU		UDA.5
		FUDA4	EQU		UDA.4
		FUDA3	EQU		UDA.3
		FUDA2	EQU		UDA.2
		FUDA1	EQU		UDA.1
		FUDA0	EQU		UDA.0

	USTATUS	EQU		091H
		FBUS_RST	EQU		USTATUS.4
		FSUSPEND	EQU		USTATUS.3
		FEP0SETUP	EQU		USTATUS.2
		FEP0IN		EQU		USTATUS.1
		FEP0OUT		EQU		USTATUS.0
		
	EP0OUT_CNT		EQU		092H
		FUEP0OC4	EQU		EP0OUT_CNT.4
		FUEP0OC3	EQU		EP0OUT_CNT.3
		FUEP0OC2	EQU		EP0OUT_CNT.2
		FUEP0OC1	EQU		EP0OUT_CNT.1
		FUEP0OC0	EQU		EP0OUT_CNT.0
	
	USB_INT_EN		EQU		093H
		REG_EN		EQU		USB_INT_EN.7
		FDP_PU_EN	EQU		USB_INT_EN.6
		FEP2NAK_INT_EN	EQU		USB_INT_EN.1
		FEP1NAK_INT_EN	EQU		USB_INT_EN.0
	
	EP_ACK		EQU		094H
		FEP2_ACK	EQU		EP_ACK.1
		FEP1_ACK	EQU		EP_ACK.0
	
	EP_NAK		EQU		095H
		FEP2_NAK	EQU		EP_NAK.1
		FEP1_NAK	EQU		EP_NAK.0
		
	UE0R		EQU		096H
		FUE0M1	EQU		UE0R.6
		FUE0M0	EQU		UE0R.5
		FUE0C3	EQU		UE0R.3
		FUE0C2	EQU		UE0R.2
		FUE0C1	EQU		UE0R.1
		FUE0C0	EQU		UE0R.0

	UE1R		EQU		097H
		FUE1E	EQU		UE1R.7
		FUE1M1	EQU		UE1R.6
		FUE1M0	EQU		UE1R.5
		FUE1C4	EQU		UE1R.4
		FUE1C3	EQU		UE1R.3
		FUE1C2	EQU		UE1R.2
		FUE1C1	EQU		UE1R.1
		FUE1C0	EQU		UE1R.0

	UE2R		EQU		098H
		FUE2E	EQU		UE2R.7
		FUE2M1	EQU		UE2R.6
		FUE2M0	EQU		UE2R.5
		FUE2C4	EQU		UE2R.4
		FUE2C3	EQU		UE2R.3
		FUE2C2	EQU		UE2R.2
		FUE2C1	EQU		UE2R.1
		FUE2C0	EQU		UE2R.0
		
	UDP0		EQU		0A3H
		FUDP07	EQU		UDP0.7
		FUDP06	EQU		UDP0.6
		FUDP05	EQU		UDP0.5
		FUDP04	EQU		UDP0.4
		FUDP03	EQU		UDP0.3
		FUDP02	EQU		UDP0.2
		FUDP01	EQU		UDP0.1
		FUDP00	EQU		UDP0.0
	
	UDP0_H	EQU		0A4H
		FWE0	EQU	UDP0_H.7
		FRE0	EQU	UDP0_H.6
	
	UDR0_R		EQU		0A5H
	 	FUDR0_R7	EQU		UDR0_R.7
		FUDR0_R6	EQU		UDR0_R.6
		FUDR0_R5	EQU		UDR0_R.5
		FUDR0_R4	EQU		UDR0_R.4
		FUDR0_R3	EQU		UDR0_R.3
		FUDR0_R2	EQU		UDR0_R.2
		FUDR0_R1	EQU		UDR0_R.1
		FUDR0_R0	EQU		UDR0_R.0
	
	UDR0_W		EQU		0A6H
		FUDR0_W7	EQU		UDR0_W.7
		FUDR0_W6	EQU		UDR0_W.6
		FUDR0_W5	EQU		UDR0_W.5
		FUDR0_W4	EQU		UDR0_W.4
		FUDR0_W3	EQU		UDR0_W.3
		FUDR0_W2	EQU		UDR0_W.2
		FUDR0_W1	EQU		UDR0_W.1
		FUDR0_W0	EQU		UDR0_W.0		
	
	EP1OUT_CNT	EQU		0A7H
		FUEP1OC4	EQU		EP1OUT_CNT.4
		FUEP1OC3	EQU		EP1OUT_CNT.3
		FUEP1OC2	EQU		EP1OUT_CNT.2
		FUEP1OC1	EQU		EP1OUT_CNT.1
		FUEP1OC0	EQU		EP1OUT_CNT.0

	EP2OUT_CNT	EQU		0A8H
	 	FUEP2OC4	EQU		EP2OUT_CNT.4
		FUEP2OC3	EQU		EP2OUT_CNT.3
		FUEP2OC2	EQU		EP2OUT_CNT.2
		FUEP2OC1	EQU		EP2OUT_CNT.1
		FUEP2OC0	EQU		EP2OUT_CNT.0
		
	UPID		EQU		0ABH
		FEP0OUT_EN	EQU		UPID.7
	 	FUBDE		EQU		UPID.2
		FDDP		EQU		UPID.1
		FDDN		EQU		UPID.0

	UTOGGLE		EQU		0ACH
		FEP2_DATA01	EQU		UTOGGLE.1
		FEP1_DATA01	EQU		UTOGGLE.0	

	IHRCU			EQU		0B0H
		FIHRCU5		EQU		IHRCU.5	
		FIHRCU4		EQU		IHRCU.4
		FIHRCU3		EQU		IHRCU.3
		FIHRCU2		EQU		IHRCU.2
		FIHRCU1		EQU		IHRCU.1
		FIHRCU0		EQU		IHRCU.0
	
	IHRCL			EQU		0B1H
		FIHRCL5		EQU		IHRCL.5	
		FIHRCL4		EQU		IHRCL.4
		FIHRCL3		EQU		IHRCL.3
		FIHRCL2		EQU		IHRCL.2
		FIHRCL1		EQU		IHRCL.1
		FIHRCL0		EQU		IHRCL.0	
	
	SIOM			EQU		0B4H
		FSENB		EQU		SIOM.7
		FSTART	EQU		SIOM.6
		FSRATE1	EQU		SIOM.5
		FSRATE0	EQU		SIOM.4
		FMLSB		EQU		SIOM.3
		FSCKMD	EQU		SIOM.2
		FCPOL	EQU		SIOM.1
		FCPHA			EQU		SIOM.0

	SIOR			EQU_W		0B5H
	SIOB			EQU		0B6H

	P0M			EQU		0B8H		
		FP02M	EQU		P0M.2
		FP01M	EQU		P0M.1
		FP00M	EQU		P0M.0

	PECMD	EQU_W	0BAH
	
	PEROML	EQU	0BBH
		
	PEROMH	EQU	0BCH

	PERAML	EQU	0BDH
	
	PERAMCNT	EQU	0BEH
		PERAMCNT4	EQU	PERAMCNT.7
		PERAMCNT3	EQU	PERAMCNT.6
		PERAMCNT2	EQU	PERAMCNT.5
		PERAMCNT1	EQU	PERAMCNT.4
		PERAMCNT0	EQU	PERAMCNT.3
		PERAML8		EQU	PERAMCNT.0

	PEDGE		EQU		0BFH		
		FP01G1	EQU		PEDGE.3
		FP01G0	EQU		PEDGE.2
		FP00G1	EQU		PEDGE.1
		FP00G0	EQU		PEDGE.0

	P1W			EQU		0C0H
		FP16W	EQU		P1W.6
		FP15W	EQU		P1W.5
		FP14W	EQU		P1W.4
		FP13W	EQU		P1W.3
		FP12W	EQU		P1W.2
		FP11W	EQU		P1W.1
		FP10W	EQU		P1W.0

	P1M			EQU		0C1H
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0
		
	P5M			EQU		0C5H
  		FP53M	EQU		P5M.3	  		
  		FP52M	EQU		P5M.2
  		FP51M	EQU		P5M.1
  		FP50M	EQU		P5M.0	
  				
	INTRQ		EQU		0C8H
		FUSBIRQ	EQU		INTRQ.6
		FTC0IRQ	EQU		INTRQ.5
		FT0IRQ	EQU		INTRQ.4
		FSIOIRQ	EQU		INTRQ.3	
		FWAKEIRQ EQU		INTRQ.2
		FP01IRQ	EQU		INTRQ.1
		FP00IRQ	EQU		INTRQ.0

	INTEN		EQU		0C9H
		FUSBIEN	EQU		INTEN.6
		FTC0IEN	EQU		INTEN.5
		FT0IEN	EQU		INTEN.4
		FSIOIEN	EQU		INTEN.3		
		FWAKEIEN EQU	INTEN.2
		FP01IEN	EQU		INTEN.1
		FP00IEN	EQU		INTEN.0

OSCM		EQU		0CAH
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR		EQU_W	0CCH
    
	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU 	0D0H		
		FP02	EQU 	P0.2
		FP01	EQU 	P0.1
		FP00	EQU 	P0.0

	P1			EQU 	0D1H
		FP16	EQU 	P1.6
		FP15	EQU 	P1.5
		FP14	EQU 	P1.4
		FP13	EQU 	P1.3
		FP12	EQU 	P1.2
		FP11	EQU 	P1.1
		FP10	EQU 	P1.0
	
	P5			EQU		0D5H
		FP53	EQU		P5.3		
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0	
		
	T0M			EQU		0D8H
		FT0ENB     EQU	T0M.7
		FT0RATE2   EQU	T0M.6
		FT0RATE1   EQU	T0M.5
		FT0RATE0   EQU	T0M.4

	T0C			EQU		0D9H

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

    P0UR        EQU_W     0E0H

    P1UR        EQU_W     0E1H

    P5UR        EQU_W     0E5H
       
	@YZ			EQU		0E7H

	
	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h

	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

;*******************************************************
; Clear watchdog macro. 
;  
; Total Cycle: 2
    @RST_WDT macro
           MOV  A, #0x5A
           B0MOV  WDTR, A
    endm

;******************************************************
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1
    SleepMode macro          
           B0BSET      FCPUM0
    endm
;******************************************************
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3
    GreenMode macro          
           B0BSET      FCPUM1
           NOP
           NOP
    endm
;******************************************************
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2
    SlowMode macro          
           B0BSET      FCLKMD
           B0BSET      FSTPHX
    endm
;******************************************************
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5
    Slow2Normal       macro          
           B0BCLR     FSTPHX
           NOP
           NOP
           NOP
           B0BCLR     FCLKMD
    endm
;******************************************************
	
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}
