
;------------------------------------------------------------------------------
;  CHIP: SN8P2204
;  Revision History
;  
;  V01   08/22/2005  1. First issue and only for SN8ICE 2K.
;  V02   09/27/2005  1. Modify programming type to 10 for OTP program.
;                    2. Modify ID code from 2410 to 2400.
;  V03	 03/21/2007	 Code option 0x17FF BIT 13 Fix Low for I version
;  V04  12/17/2007  1. "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs. 
;  V05   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;  V06 2010/06/30   1.ADD MACRO:
;					  SleepMode
;					  GreenMode
;					  SlowMode
;					  Slow2Normal
;  V07   2012/07/12  	1. Add "PCL_READ_LIMIT" Key word
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		7
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	256

.Assembly	INSTRUMENT	SN8P2204
.Assembly	BIT_FILE	SN8P2204

.Assembly	OTP_BODY_SIZE	0x1800
.Assembly	USER_ROM_SIZE	0x17FC

;.Assembly	OTP_TEST_SIZE	0x00A0
;.Assembly	MASK_TEST_FILE	SN8A1602A
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	10
.Assembly	CHIP_ID		0x2400
.Assembly	command		Enable_ORG4_7, RBANK_LIMIT, GREEN_NOP_LIMIT, PCL_READ_LIMIT
.Assembly	Port_Pins	7, 8, 0, 0, 0, 8

.Assembly	USB_FIFO_Size	32, 32

; Code Option 0x17FF
.Assembly	OPTION		0		Fix_High
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 x Fosc/4 
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		4		High_Clk	IHRC_6M IHRC_RTC x 6M_X'tal
.Help
{
	IHRC_6M		:	"Internal 6M RC Oscillator"
	IHRC_RTC	:	"Internal 6M RC Oscillator with RTC\nConnect 32768Hz crytal to XIN/XOUT"
	6M_X'tal	:	"Crystal/Resonator: 6Mhz"
}
.Assembly	OPTION		6 : 7		Fix_High
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Assembly	OPTION		12		Reset_Pin   P14 	Reset
;.Assembly	OPTION		13		Rst_Length  No 128*ILRC
.Assembly	OPTION		13		Fix_High
.Assembly	OPTION		14		Fix_High
;.Assembly	OPTION		15		SMODE3      Disable Enable
.Assembly	OPTION		15		Fix_Low

; Code Option 0x17FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x17FD
.Assembly	OPTION		32 : 63	Fix_High

.Assembly	OPTION		2ffh

	R			EQU		82H
	Z			EQU		83H
	Y			EQU		84H
	
	PFLAG		EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	RBANK		EQU		87H
		FRBNKS0	EQU		RBANK.0

	UDA			EQU		0A0H
		FUDE		EQU		UDA.7
		FUDA6	EQU		UDA.6
		FUDA5	EQU		UDA.5
		FUDA4	EQU		UDA.4
		FUDA3	EQU		UDA.3
		FUDA2	EQU		UDA.2
		FUDA1	EQU		UDA.1
		FUDA0	EQU		UDA.0

	UE0R		EQU		0A1H
		FUE0E	EQU		UE0R.7
		FUE0S	EQU		UE0R.6
		FUE0DO	EQU		UE0R.5
		FUE0DI	EQU		UE0R.4
		FUE0C3	EQU		UE0R.3
		FUE0C2	EQU		UE0R.2
		FUE0C1	EQU		UE0R.1
		FUE0C0	EQU		UE0R.0

	UE1R		EQU		0A2H
		FUE1E	EQU		UE1R.7
		FFFS1	EQU		UE1R.6
		FUE1DO	EQU		UE1R.5
		FUE1DI	EQU		UE1R.4
		FUE1C3	EQU		UE1R.3
		FUE1C2	EQU		UE1R.2
		FUE1C1	EQU		UE1R.1
		FUE1C0	EQU		UE1R.0

	UE2R		EQU		0A3H
		FUE2E	EQU		UE2R.7
		FFFS2	EQU		UE2R.6
		FUE2DO	EQU		UE2R.5
		FUE2DI	EQU		UE2R.4
		FUE2C3	EQU		UE2R.3
		FUE2C2	EQU		UE2R.2
		FUE2C1	EQU		UE2R.1
		FUE2C0	EQU		UE2R.0

	UE3R		EQU		0A4H
		FUE3E	EQU		UE3R.7
		FFFS3	EQU		UE3R.6
		FUE3DO	EQU		UE3R.5
		FUE3DI	EQU		UE3R.4
		FUE3C3	EQU		UE3R.3
		FUE3C2	EQU		UE3R.2
		FUE3C1	EQU		UE3R.1
		FUE3C0	EQU		UE3R.0

	UDP0		EQU		0A5H
		FUDP04	EQU		UDP0.4
		FUDP03	EQU		UDP0.3
		FUDP02	EQU		UDP0.2
		FUDP01	EQU		UDP0.1
		FUDP00	EQU		UDP0.0

	UDR0		EQU		0A6H
		FUDR07	EQU		UDR0.7
		FUDR06	EQU		UDR0.6
		FUDR05	EQU		UDR0.5
		FUDR04	EQU		UDR0.4
		FUDR03	EQU		UDR0.3
		FUDR02	EQU		UDR0.2
		FUDR01	EQU		UDR0.1
		FUDR00	EQU		UDR0.0

	UDP1		EQU		0A7H
		FUDP14	EQU		UDP1.4
		FUDP13	EQU		UDP1.3
		FUDP12	EQU		UDP1.2
		FUDP11	EQU		UDP1.1
		FUDP10	EQU		UDP1.0

	UDR1		EQU		0A8H
		FUDR17	EQU		UDR1.7
		FUDR16	EQU		UDR1.6
		FUDR15	EQU		UDR1.5
		FUDR14	EQU		UDR1.4
		FUDR13	EQU		UDR1.3
		FUDR12	EQU		UDR1.2
		FUDR11	EQU		UDR1.1
		FUDR10	EQU		UDR1.0

	USTATUS		EQU		0A9H
		FFFS0	EQU		USTATUS.7
		FUSPND	EQU		USTATUS.6
		FURST	EQU		USTATUS.5
		FUEP0OC4	EQU		USTATUS.4
		FUEP0OC3	EQU		USTATUS.3
		FUEP0OC2	EQU		USTATUS.2
		FUEP0OC1	EQU		USTATUS.1
		FUEP0OC0	EQU		USTATUS.0

	UPID		EQU		0AAH
		FUBDE	EQU		UPID.2
		FDDP		EQU		UPID.1
		FDDN		EQU		UPID.0

	T1M			EQU		0ABH
		FT1ENB	EQU		T1M.7
		FT1rate2	EQU		T1M.6
		FT1rate1	EQU		T1M.5
		FT1rate0	EQU		T1M.4
		FT1G1	EQU		T1M.1
		FT1G0	EQU		T1M.0

	T1C			EQU		0ACH
		FT1C7	EQU		T1C.7
		FT1C6	EQU		T1C.6
		FT1C5	EQU		T1C.5
		FT1C4	EQU		T1C.4
		FT1C3	EQU		T1C.3
		FT1C2	EQU		T1C.2
		FT1C1	EQU		T1C.1
		FT1C0	EQU		T1C.0

	T2M			EQU		0ADH
		FT2ENB	EQU		T2M.7
		FT2rate2	EQU		T2M.6
		FT2rate1	EQU		T2M.5
		FT2rate0	EQU		T2M.4
		FT2G1	EQU		T2M.1
		FT2G0	EQU		T2M.0

	T2C			EQU		0AEH
		FT2C7	EQU		T2C.7
		FT2C6	EQU		T2C.6
		FT2C5	EQU		T2C.5
		FT2C4	EQU		T2C.4
		FT2C3	EQU		T2C.3
		FT2C2	EQU		T2C.2
		FT2C1	EQU		T2C.1
		FT2C0	EQU		T2C.0

	PS2M		EQU		0AFH
		FPS2ENB	EQU		PS2M.7
		FSDA		EQU		PS2M.3
		FSCK		EQU		PS2M.2
		FSDAM	EQU		PS2M.1
		FSCKM	EQU		PS2M.0

	P0M			EQU		0B8H
		FP06M	EQU		P0M.6
		FP05M	EQU		P0M.5
		FP04M	EQU		P0M.4
		FP03M	EQU		P0M.3
		FP02M	EQU		P0M.2
		FP01M	EQU		P0M.1
		FP00M	EQU		P0M.0

	PEDGE		EQU		0BFH		
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P1W			EQU_W		0C0H
		FP17W	EQU_W		P1W.7
		FP16W	EQU_W		P1W.6
		FP15W	EQU_W		P1W.5
		FP14W	EQU_W		P1W.4
		FP13W	EQU_W		P1W.3
		FP12W	EQU_W		P1W.2
		FP11W	EQU_W		P1W.1
		FP10W	EQU_W		P1W.0


	P1M			EQU		0C1H
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P5M			EQU		0C5H
  		FP57M	EQU		P5M.7
  		FP56M	EQU		P5M.6
  		FP55M	EQU		P5M.5
  		FP54M	EQU		P5M.4
  		FP53M	EQU		P5M.3
  		FP52M	EQU		P5M.2
  		FP51M	EQU		P5M.1
  		FP50M	EQU		P5M.0

	P6M			EQU		0C6H
  		FP61M	EQU		P6M.1
  		FP60M	EQU		P6M.0

	INTRQ		EQU		0C8H
		FUSBIRQ	EQU		INTRQ.6
		FTC0IRQ	EQU		INTRQ.5
		FT0IRQ	EQU		INTRQ.4
		FT2IRQ	EQU		INTRQ.2
		FT1IRQ	EQU		INTRQ.1
		FP00IRQ	EQU		INTRQ.0

	INTEN		EQU		0C9H
		FUSBIEN	EQU		INTEN.6
		FTC0IEN	EQU		INTEN.5
		FT0IEN	EQU		INTEN.4
		FT2IEN	EQU		INTEN.2
		FT1IEN	EQU		INTEN.1
		FP00IEN	EQU		INTEN.0

	OSCM		EQU		0CAH
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR		EQU_W	0CCH

    TC0R        EQU_W   0CDH       

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU 	0D0H
		FP06	EQU 	P0.6
		FP05	EQU 	P0.5
		FP04	EQU 	P0.4
		FP03	EQU 	P0.3
		FP02	EQU 	P0.2
		FP01	EQU 	P0.1
		FP00	EQU 	P0.0

	P1			EQU 	0D1H
		FP17	EQU 	P1.7
		FP16	EQU 	P1.6
		FP15	EQU 	P1.5
		FP14	EQU_R 	P1.4
		FP13	EQU 	P1.3
		FP12	EQU 	P1.2
		FP11	EQU 	P1.1
		FP10	EQU 	P1.0

	P5			EQU		0D5H
		FP57	EQU		P5.7
		FP56	EQU		P5.6
		FP55	EQU		P5.5
		FP54	EQU		P5.4
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0
		
	P6			EQU		0D6H
		FP61	EQU		P6.1
		FP60	EQU		P6.0

	T0M			EQU		0D8H
		FT0ENB     EQU	T0M.7
		FT0RATE2   EQU	T0M.6
		FT0RATE1   EQU	T0M.5
		FT0RATE0   EQU	T0M.4
		FT0TB	   EQU	T0M.0

	T0C			EQU		0D9H

	TC0M		EQU		0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3
        FALOAD0     EQU TC0M.2
        FTC0OUT     EQU TC0M.1
        FPWM0OUT    EQU TC0M.0 

	TC0C		EQU		0DBH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

    P0UR        EQU_W     0E0H

    P1UR        EQU_W     0E1H

    P5UR        EQU_W     0E5H

	@YZ			EQU		0E7H

	P1OC		EQU_W	0E9H

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h

	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; -----------------------------------------------------
; System boot macro. 
; -----------------------------------------------------
@BOOT 		MACRO

IF ICE_MODE == 1
; SET P6 OUTPUT MODE
			MOV		A,#0H
			B0MOV   P6,A
			MOV		A,#0FFH
			B0MOV   P6M,A
; SET P1 WAKE-UP FUNCTION
			MOV		A,#0FFH
			B0MOV   P1W,A
ELSE
ENDIF
			ENDM
; -----------------------------------------------------

; -----------------------------------------------------
; USB ENABLE

@USB_ENABLE	MACRO
			B0BSET	FUDE
IF ICE_MODE == 1
			B0BSET  P6.0
ELSE

ENDIF
			ENDM

@USB_DISABLE	MACRO
			B0BCLR	FUDE
IF ICE_MODE == 1
			B0BCLR  P6.0
ELSE

ENDIF
			ENDM

; -----------------------------------------------------
; PS/2 ENABLE

@PS2_ENABLE	MACRO
			B0BSET	FPS2ENB
IF ICE_MODE == 1
			B0BSET  P6.1
ELSE

ENDIF
			ENDM

@PS2_DISABLE	MACRO
			B0BCLR	FPS2ENB
IF ICE_MODE == 1
			B0BCLR  P6.1
ELSE

ENDIF
			ENDM

;*******************************************************
; Clear watchdog macro. 
;  
; Total Cycle: 2
    @RST_WDT macro
           MOV  A, #0x5A
           B0MOV  WDTR, A
    endm

;******************************************************
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1
    SleepMode macro          
           B0BSET      FCPUM0
    endm
;******************************************************
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3
    GreenMode macro          
           B0BSET      FCPUM1
           NOP
           NOP
    endm
;******************************************************
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2
    SlowMode macro          
           B0BSET      FCLKMD
           B0BSET      FSTPHX
    endm
;******************************************************
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5
    Slow2Normal       macro          
           B0BCLR     FSTPHX
           NOP
           NOP
           NOP
           B0BCLR     FCLKMD
    endm
;******************************************************
	
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}
