
;------------------------------------------------------------------------------
;  CHIP: SN8P2236
;  Revision History
;  
;  V01   2007/01/09
;  V02	 2007/07/05	Add 0xAD DPPU control register for SN8P2236 version A
;  V03   12/17/2007     "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs. 
;  V04   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;  V05 2010/06/30   1.ADD MACRO:
;					  SleepMode
;					  GreenMode
;					  SlowMode
;					  Slow2Normal
;  V06   2012/07/12  	1. Add "PCL_READ_LIMIT" Key word
;  V07	 2013/08/27	1. Modify the USTATUS bit3~bit4 to read only.
;			2. Remove the USB_INT_EN, EP_ACK, EP_NAK bit2~bits define.
;			3. Modify the UE1R & UE2R bit6 to read only.
;			4. Add the P0UR bit0~bit4 define.
;			5. Add the P2UR bit0~bit5 define.
;			6. Add the P5UR bit0~bit2 define.
;			7. Add the P1OC bit0~bit3 define.
;			8. Add the STKnH(n=0~7) bit0~bit4 define.
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		6
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	512

.Assembly	INSTRUMENT	SN8P2236
.Assembly	BIT_FILE	SN8P2236

.Assembly	OTP_BODY_SIZE	0x2000
.Assembly	USER_ROM_SIZE	0x1FFC

.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000

.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x2600
.Assembly	command		Enable_ORG4_7, RBANK_LIMIT, GREEN_NOP_LIMIT, PCL_READ_LIMIT
.Assembly	Port_Pins	6, 8, 6, 8, 0, 3

.Assembly	USB_FIFO_Size	480, 480

; Code Option 0x1FFF
.Assembly	OPTION		0		Fix_Low
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 x
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		4		OSC_Sel	6M_X'tal 12M_X'tal x x
.Help
{
;	IHRC_6M		:	"Internal 6M RC Oscillator"
;	IHRC_RTC	:	"Internal 6M RC Oscillator with RTC\nConnect 32768Hz crytal to XIN/XOUT"
	6M_X'tal		:	"Fosc = 12MHz, 6MHz Crystal/Resonator on XIN/XOUT"
	12M_X'tal		: 	"Fosc = 12MHz, 12MHz Crystal/Resonator on XIN/XOUT"
}
.Assembly	OPTION		6 : 7		Fix_High
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Assembly	OPTION		12		Reset_Pin   P05 	Reset
;.Assembly	OPTION		13		Rst_Length  No 128*ILRC
.Assembly	OPTION		13		Fix_High
.Assembly	OPTION		14		Fix_Low
;.Assembly	OPTION		15		SMODE3      Disable Enable
.Assembly	OPTION		15		Fix_Low

; Code Option 0x1FFE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x1FFD
.Assembly	OPTION		32 		Fix_low
.Assembly	OPTION		33 		Fix_low
.Assembly	OPTION		34 		Fix_High
.Assembly	OPTION		35 		Fix_High
.Assembly	OPTION		36 		Fix_High
.Assembly	OPTION		37 		Fix_High
.Assembly	OPTION		38 		Fix_low
.Assembly	OPTION		39 		Fix_low
.Assembly	OPTION		40 		Fix_High
.Assembly	OPTION		41 		Fix_High
.Assembly	OPTION		42 		Fix_High
.Assembly	OPTION		43 		Fix_High
.Assembly	OPTION		44 		Fix_High
.Assembly	OPTION		45 		Fix_High
.Assembly	OPTION		46 		Fix_low
.Assembly	OPTION		47		Fix_low

; Code Option 0x1FFC
.Assembly	OPTION		48 		Fix_low
.Assembly	OPTION		49 		Fix_High
.Assembly	OPTION		50 		Fix_low
.Assembly	OPTION		51 		Fix_low
.Assembly	OPTION		52 : 63 		Fix_High

.Assembly	OPTION		2ffh

	R			EQU		82H
	Z			EQU		83H
	Y			EQU		84H
	
	PFLAG		EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7

	RBANK		EQU		87H
		FRBNKS0	EQU		RBANK.0
		FRBNKS1	EQU		RBANK.1

	UDA			EQU		090H
		FUDE	EQU		UDA.7
		FUDA6	EQU		UDA.6
		FUDA5	EQU		UDA.5
		FUDA4	EQU		UDA.4
		FUDA3	EQU		UDA.3
		FUDA2	EQU		UDA.2
		FUDA1	EQU		UDA.1
		FUDA0	EQU		UDA.0

	USTATUS	EQU		091H
		FSOF			EQU		USTATUS.5				
		FBUS_RST	EQU_R		USTATUS.4
		FSUSPEND	EQU_R		USTATUS.3
		FEP0SETUP	EQU		USTATUS.2
		FEP0IN		EQU		USTATUS.1
		FEP0OUT		EQU		USTATUS.0
		
	EP0OUT_CNT		EQU		092H
		FUEP0OC4	EQU		EP0OUT_CNT.4
		FUEP0OC3	EQU		EP0OUT_CNT.3
		FUEP0OC2	EQU		EP0OUT_CNT.2
		FUEP0OC1	EQU		EP0OUT_CNT.1
		FUEP0OC0	EQU		EP0OUT_CNT.0
	
	USB_INT_EN		EQU		093H
		FREG_EN				EQU	USB_INT_EN.7
		FDP_PU_EN			EQU	USB_INT_EN.6
		FSOF_INT_EN		EQU		USB_INT_EN.5
		FEP2NAK_INT_EN	EQU		USB_INT_EN.1
		FEP1NAK_INT_EN	EQU		USB_INT_EN.0
	
	EP_ACK		EQU		094H
		FEP6_OUT	EQU		EP_ACK.5
		FEP5_IN	EQU		EP_ACK.4
		FEP2_ACK	EQU		EP_ACK.1
		FEP1_ACK	EQU		EP_ACK.0
	
	EP_NAK		EQU		095H
		FEP2_NAK	EQU		EP_NAK.1
		FEP1_NAK	EQU		EP_NAK.0
		
	UE0R		EQU		096H
		FUE0M1	EQU		UE0R.6
		FUE0M0	EQU		UE0R.5
		FUE0C3	EQU		UE0R.3
		FUE0C2	EQU		UE0R.2
		FUE0C1	EQU		UE0R.1
		FUE0C0	EQU		UE0R.0

	UE1R		EQU		097H
		FUE1E	EQU		UE1R.7
		FUE1M1	EQU_R		UE1R.6
		FUE1M0	EQU		UE1R.5
		FUE1C4	EQU		UE1R.4
		FUE1C3	EQU		UE1R.3
		FUE1C2	EQU		UE1R.2
		FUE1C1	EQU		UE1R.1
		FUE1C0	EQU		UE1R.0

	UE2R		EQU		098H
		FUE2E	EQU		UE2R.7
		FUE2M1	EQU_R		UE2R.6
		FUE2M0	EQU		UE2R.5
		FUE2C4	EQU		UE2R.4
		FUE2C3	EQU		UE2R.3
		FUE2C2	EQU		UE2R.2
		FUE2C1	EQU		UE2R.1
		FUE2C0	EQU		UE2R.0
		
	UE3R		EQU		099H
		FUE3E	EQU		UE3R.7
		FUE3M1	EQU		UE3R.6
		FUE3M0	EQU		UE3R.5
		FUE3C3	EQU		UE3R.3
		FUE3C2	EQU		UE3R.2
		FUE3C1	EQU		UE3R.1
		FUE3C0	EQU		UE3R.0
		
	UE4R		EQU		09AH
		FUE4E		EQU		UE4R.7
		FUE4M1	EQU		UE4R.6
		FUE4M0	EQU		UE4R.5
		FUE4C3	EQU		UE4R.3
		FUE4C2	EQU		UE4R.2
		FUE4C1	EQU		UE4R.1
		FUE4C0	EQU		UE4R.0

	UEER		EQU		09BH
		FUE6E	EQU		UEER.1
		FUE5E	EQU		UEER.0

	EP5IN_CNT		EQU		09CH
		FEP5IN_CNT_5			EQU		EP5IN_CNT.5
		FEP5IN_CNT_4			EQU		EP5IN_CNT.4
		FEP5IN_CNT_3			EQU		EP5IN_CNT.3
		FEP5IN_CNT_2			EQU		EP5IN_CNT.2
		FEP5IN_CNT_1			EQU		EP5IN_CNT.1
		FEP5IN_CNT_0			EQU		EP5IN_CNT.0

	EP6OUT_CNT_L	EQU		09EH
		FEP6OUT_CNT_7			EQU		EP6OUT_CNT_L.7
		FEP6OUT_CNT_6			EQU		EP6OUT_CNT_L.6
		FEP6OUT_CNT_5			EQU		EP6OUT_CNT_L.5
		FEP6OUT_CNT_4			EQU		EP6OUT_CNT_L.4
		FEP6OUT_CNT_3			EQU		EP6OUT_CNT_L.3
		FEP6OUT_CNT_2			EQU		EP6OUT_CNT_L.2
		FEP6OUT_CNT_1			EQU		EP6OUT_CNT_L.1
		FEP6OUT_CNT_0			EQU		EP6OUT_CNT_L.0
	
	EP6OUT_CNT_H	EQU		09FH
		FEP6OUT_CNT_8			EQU		EP6OUT_CNT_H.0

	;FIFO_CTRL		EQU		0A2H
	;	FFFS0	EQU_R		FIFO_CTRL.0

	UDP0_L		EQU		0A3H
		FUDP07	EQU		UDP0_L.7
		FUDP06	EQU		UDP0_L.6
		FUDP05	EQU		UDP0_L.5
		FUDP04	EQU		UDP0_L.4
		FUDP03	EQU		UDP0_L.3
		FUDP02	EQU		UDP0_L.2
		FUDP01	EQU		UDP0_L.1
		FUDP00	EQU		UDP0_L.0
		
	UDP0_H		EQU		0A4H
		FWE0	EQU		UDP0_H.7
		FRE0	EQU		UDP0_H.6
		FUDP08	EQU		UDP0_H.0
			
	UDR0_R		EQU		0A5H
		FUDR0_R7	EQU		UDR0_R.7
		FUDR0_R6	EQU		UDR0_R.6
		FUDR0_R5	EQU		UDR0_R.5
		FUDR0_R4	EQU		UDR0_R.4
		FUDR0_R3	EQU		UDR0_R.3
		FUDR0_R2	EQU		UDR0_R.2
		FUDR0_R1	EQU		UDR0_R.1
		FUDR0_R0	EQU		UDR0_R.0
		
	UDR0_W		EQU		0A6H
		FUDR0_W7	EQU		UDR0_W.7
		FUDR0_W6	EQU		UDR0_W.6
		FUDR0_W5	EQU		UDR0_W.5
		FUDR0_W4	EQU		UDR0_W.4
		FUDR0_W3	EQU		UDR0_W.3
		FUDR0_W2	EQU		UDR0_W.2
		FUDR0_W1	EQU		UDR0_W.1
		FUDR0_W0	EQU		UDR0_W.0	

	EP1OUT_CNT	EQU		0A7H
		FUEP1OC4	EQU		EP1OUT_CNT.4
		FUEP1OC3	EQU		EP1OUT_CNT.3
		FUEP1OC2	EQU		EP1OUT_CNT.2
		FUEP1OC1	EQU		EP1OUT_CNT.1
		FUEP1OC0	EQU		EP1OUT_CNT.0

	EP2OUT_CNT	EQU		0A8H
		FUEP2OC4	EQU		EP2OUT_CNT.4
		FUEP2OC3	EQU		EP2OUT_CNT.3
		FUEP2OC2	EQU		EP2OUT_CNT.2
		FUEP2OC1	EQU		EP2OUT_CNT.1
		FUEP2OC0	EQU		EP2OUT_CNT.0
	
	EP3OUT_CNT	EQU		0A9H		
		FUEP3OC3	EQU		EP3OUT_CNT.3
		FUEP3OC2	EQU		EP3OUT_CNT.2
		FUEP3OC1	EQU		EP3OUT_CNT.1
		FUEP3OC0	EQU		EP3OUT_CNT.0
	
	EP4OUT_CNT	EQU		0AAH		
		FUEP4OC3	EQU		EP4OUT_CNT.3
		FUEP4OC2	EQU		EP4OUT_CNT.2
		FUEP4OC1	EQU		EP4OUT_CNT.1
		FUEP4OC0	EQU		EP4OUT_CNT.0

	UPID		EQU		0ABH
		FUBDE	EQU		UPID.2
		FDDP		EQU		UPID.1
		FDDN		EQU		UPID.0

	SIOM			EQU		0B4H
		FSENB		EQU		SIOM.7
		FSTART	EQU		SIOM.6
		FSRATE1	EQU		SIOM.5
		FSRATE0	EQU		SIOM.4
		FMLSB		EQU		SIOM.3
		FSCKMD	EQU		SIOM.2
		FSEDGE	EQU		SIOM.1
		FSP			EQU		SIOM.0

	SIOR			EQU_W		0B5H
	SIOB			EQU		0B6H

	P0M			EQU		0B8H		
		FP04M	EQU		P0M.4
		FP03M	EQU		P0M.3
		FP02M	EQU		P0M.2
		FP01M	EQU		P0M.1
		FP00M	EQU		P0M.0

	PEDGE		EQU		0BFH		
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3
		FP01G1	EQU		PEDGE.2
		FP01G0	EQU		PEDGE.1

	P1W			EQU		0C0H
		FP17W	EQU		P1W.7
		FP16W	EQU		P1W.6
		FP15W	EQU		P1W.5
		FP14W	EQU		P1W.4
		FP13W	EQU		P1W.3
		FP12W	EQU		P1W.2
		FP11W	EQU		P1W.1
		FP10W	EQU		P1W.0

	P1M			EQU		0C1H
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0
		
	P2M			EQU		0C2H
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0
	
	P3M			EQU		0C3H
		FP37M	EQU		P3M.7
		FP36M	EQU		P3M.6
		FP35M	EQU		P3M.5
		FP34M	EQU		P3M.4
		FP33M	EQU		P3M.3
		FP32M	EQU		P3M.2
		FP31M	EQU		P3M.1
		FP30M	EQU		P3M.0		
		
	P5M			EQU		0C5H  		
  		FP52M	EQU		P5M.2
  		FP51M	EQU		P5M.1
  		FP50M	EQU		P5M.0

	INTRQ		EQU		0C8H
		FSOFIRQ EQU		INTRQ.7
		FUSBIRQ	EQU		INTRQ.6
		FT1IRQ	EQU		INTRQ.5
		FT0IRQ	EQU		INTRQ.4
		FSIOIRQ	EQU		INTRQ.3	
		FWAKEIRQ EQU	INTRQ.2
		FP01IRQ	EQU		INTRQ.1
		FP00IRQ	EQU		INTRQ.0

	INTEN		EQU		0C9H
		FSOFIEN EQU		INTEN.7
		FUSBIEN	EQU		INTEN.6
		FT1IEN	EQU		INTEN.5
		FT0IEN	EQU		INTEN.4
		FSIOIEN	EQU		INTEN.3		
		FWAKEIEN EQU	INTEN.2
		FP01IEN	EQU		INTEN.1
		FP00IEN	EQU		INTEN.0

	OSCM		EQU		0CAH
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR		EQU_W	0CCH
    
	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU 	0D0H		
		FP05	EQU_R 	P0.5
		FP04	EQU 	P0.4
		FP03	EQU 	P0.3
		FP02	EQU 	P0.2
		FP01	EQU 	P0.1
		FP00	EQU 	P0.0

	P1			EQU 	0D1H
		FP17	EQU 	P1.7
		FP16	EQU 	P1.6
		FP15	EQU 	P1.5
		FP14	EQU 	P1.4
		FP13	EQU 	P1.3
		FP12	EQU 	P1.2
		FP11	EQU 	P1.1
		FP10	EQU 	P1.0
		
	P2			EQU 	0D2H
		FP25	EQU 	P2.5
		FP24	EQU 	P2.4
		FP23	EQU 	P2.3
		FP22	EQU 	P2.2
		FP21	EQU 	P2.1
		FP20	EQU 	P2.0	
		
	P3			EQU 	0D3H
		FP37	EQU 	P3.7
		FP36	EQU 	P3.6
		FP35	EQU 	P3.5
		FP34	EQU 	P3.4
		FP33	EQU 	P3.3
		FP32	EQU 	P3.2
		FP31	EQU 	P3.1
		FP30	EQU 	P3.0	
		
	P5			EQU		0D5H		
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0
		
	T0M			EQU		0D8H
		FT0ENB     EQU	T0M.7
		FT0RATE2   EQU	T0M.6
		FT0RATE1   EQU	T0M.5
		FT0RATE0   EQU	T0M.4

	T0C			EQU		0D9H

	T1M		EQU		0DAH
		FT1ENB		EQU	T1M.7
		FT1RATE2	EQU	T1M.6
		FT1RATE1	EQU	T1M.5
		FT1RATE0	EQU	T1M.4

	T1C_L		EQU		0DBH
		FT1C7	EQU		T1C_L.7
		FT1C6	EQU		T1C_L.6
		FT1C5	EQU		T1C_L.5
		FT1C4	EQU		T1C_L.4
		FT1C3	EQU		T1C_L.3
		FT1C2	EQU		T1C_L.2
		FT1C1	EQU		T1C_L.1
		FT1C0	EQU		T1C_L.0

	T1C_H		EQU		0DCH
		FT1C15	EQU		T1C_H.7
		FT1C14	EQU		T1C_H.6
		FT1C13	EQU		T1C_H.5
		FT1C12	EQU		T1C_H.4
		FT1C11	EQU		T1C_H.3
		FT1C10	EQU		T1C_H.2
		FT1C9	EQU		T1C_H.1
		FT1C8	EQU		T1C_H.0


	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

    P0UR        EQU_W     0E0H
		FP04R	EQU_W		P0UR.4
		FP03R	EQU_W		P0UR.3
		FP02R	EQU_W		P0UR.2
		FP01R	EQU_W		P0UR.1
		FP00R	EQU_W		P0UR.0
    P1UR        EQU_W     0E1H
		P2UR				EQU_W			0E2H
		FP25R	EQU_W		P2UR.5
		FP24R	EQU_W		P2UR.4
		FP23R	EQU_W		P2UR.3
		FP22R	EQU_W		P2UR.2
		FP21R	EQU_W		P2UR.1
		FP20R	EQU_W		P2UR.0
		P3UR				EQU_W			0E3H
    P5UR        EQU_W     0E5H
		FP52R	EQU_W		P5UR.2
		FP51R	EQU_W		P5UR.1
		FP50R	EQU_W		P5UR.0
       
	@YZ			EQU		0E7H

	P1OC		EQU_W	0E9H
		FP52OC	EQU_W		P1OC.3
		FP50OC	EQU_W		P1OC.2
		FP11OC	EQU_W		P1OC.1
		FP10OC	EQU_W		P1OC.0

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
		FS7PC12		EQU	STK7H.4
		FS7PC11		EQU	STK7H.3
		FS7PC10		EQU	STK7H.2
		FS7PC9		EQU	STK7H.1
		FS7PC8		EQU	STK7H.0
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
		FS6PC12		EQU	STK6H.4
		FS6PC11		EQU	STK6H.3
		FS6PC10		EQU	STK6H.2
		FS6PC9		EQU	STK6H.1
		FS6PC8		EQU	STK6H.0
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
		FS5PC12		EQU	STK5H.4
		FS5PC11		EQU	STK5H.3
		FS5PC10		EQU	STK5H.2
		FS5PC9		EQU	STK5H.1
		FS5PC8		EQU	STK5H.0
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
		FS4PC12		EQU	STK4H.4
		FS4PC11		EQU	STK4H.3
		FS4PC10		EQU	STK4H.2
		FS4PC9		EQU	STK4H.1
		FS4PC8		EQU	STK4H.0

	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
		FS3PC12		EQU	STK3H.4
		FS3PC11		EQU	STK3H.3
		FS3PC10		EQU	STK3H.2
		FS3PC9		EQU	STK3H.1
		FS3PC8		EQU	STK3H.0
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
		FS2PC12		EQU	STK2H.4
		FS2PC11		EQU	STK2H.3
		FS2PC10		EQU	STK2H.2
		FS2PC9		EQU	STK2H.1
		FS2PC8		EQU	STK2H.0
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
		FS1PC12		EQU	STK1H.4
		FS1PC11		EQU	STK1H.3
		FS1PC10		EQU	STK1H.2
		FS1PC9		EQU	STK1H.1
		FS1PC8		EQU	STK1H.0
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh
		FS0PC12		EQU	STK0H.4
		FS0PC11		EQU	STK0H.3
		FS0PC10		EQU	STK0H.2
		FS0PC9		EQU	STK0H.1
		FS0PC8		EQU	STK0H.0
;*******************************************************
; Clear watchdog macro. 
;  
; Total Cycle: 2
    @RST_WDT macro
           MOV  A, #0x5A
           B0MOV  WDTR, A
    endm

;******************************************************
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1
    SleepMode macro          
           B0BSET      FCPUM0
    endm
;******************************************************
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3
    GreenMode macro          
           B0BSET      FCPUM1
           NOP
           NOP
    endm
;******************************************************
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2
    SlowMode macro          
           B0BSET      FCLKMD
           B0BSET      FSTPHX
    endm
;******************************************************
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5
    Slow2Normal       macro          
           B0BCLR     FSTPHX
           NOP
           NOP
           NOP
           B0BCLR     FCLKMD
    endm
;******************************************************
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}
