;*******************************************************************************
;  CHIP: SN8P2501C
;  Revision History
;  
;  V01   02/11/2010  1. First issue and only for SN8ICE 2K Plus. 
;  V02   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;  V03   10/20/2010  1. modify Low_Power CodeOption limit : Low_Power enable, Fcpu < 4MIPS
;  V04   08/28/2013  1. Modify  P1W/P0UR/P1UR/P2UR/P5UR/P1OC register property.
;*******************************************************************************
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	INC_VER		3
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	48

.Assembly	INSTRUMENT	SN8P2501C
.Assembly	BIT_FILE	SN8P2501C

.Assembly	OTP_BODY_SIZE	0x0400 
.Assembly	USER_ROM_SIZE	0x03FC

.Assembly	OTP_TEST_SIZE	0x00E0
;.Assembly	MASK_TEST_FILE
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	
.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x3130		
.Assembly	COMMAND		Enable_ORG4_7, GREEN_NOP_LIMIT
.Assembly	Port_Pins	1,4,2,0,0,1
;*******************************************************************************
; Code Option 0x03FF
.Assembly	OPTION		0		Fix_High
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		5 : 7		Fix_High
.Assembly	OPTION		8		Watch_Dog 	Always_On x x x x Enable x x x x Disable x x x x x 
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin 	P11	Reset
;.Assembly	OPTION   	13		Rst_Len		No	128_ILRC
.Assembly	OPTION   	13		Fix_High
.Assembly	OPTION   	14		Low_Power	Enable	Disable
.Help
{
	Enable	:	"If Low_Power enable, Fcpu should be\nless than or equal to 2MIPS."
}
;.Assembly	OPTION   	15		LowPower_Selet	120ns	80ns
.Assembly	OPTION   	15		Fix_High
;*******************************************************************************
; Code Option 0x03FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High
;*******************************************************************************
; Code Option 0x03FD
.Assembly	OPTION		32 : 40		Fix_High
.Assembly	OPTION		41		LVDM     	LVD_Max	LVD_H	LVD_M	LVD_L
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"	
	LVD_Max		:	"3.6V Reset"	
}
;.Assembly	OPTION		43		LVDB		No 2_ILRC 
.Assembly	OPTION		43		Fix_Low
.Assembly	OPTION		44 : 63		Fix_High
;*******************************************************************************
.Assembly	OPTION		2ffh

	R		EQU		0x82
	Z		EQU		0x83
	Y		EQU		0x84
;*******************************************************************************
	PFLAG		EQU		0x86
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FLVD24		EQU_R		PFLAG.4
		FLVD36		EQU_R		PFLAG.5
		FNPD		EQU		PFLAG.6
		FNT0		EQU		PFLAG.7
;*******************************************************************************
	P0M		EQU		0B8H
		FP00M		EQU		P0M.0
;*******************************************************************************
	PEDGE		EQU		0BFH
		FP00G1		EQU		PEDGE.4
		FP00G0		EQU		PEDGE.3
;*******************************************************************************
	P1W		EQU_W		0C0H
;*******************************************************************************
	P1M		EQU		0C1H
		FP13M		EQU		P1M.3
		FP12M		EQU		P1M.2
		FP10M		EQU		P1M.0
;*******************************************************************************
	P2M		EQU		0C2H
		FP21M		EQU		P2M.1
		FP20M		EQU		P2M.0
;*******************************************************************************
	P5M		EQU		0C5H
	     	FP54M		EQU		P5M.4
;*******************************************************************************
	INTRQ		EQU		0C8H
		FTC0IRQ		EQU		INTRQ.5
    		FT0IRQ  	EQU 		INTRQ.4
		FP00IRQ		EQU		INTRQ.0
;*******************************************************************************
	INTEN		EQU		0C9H
		FTC0IEN		EQU		INTEN.5
		FT0IEN		EQU 		INTEN.4
		FP00IEN		EQU		INTEN.0
;*******************************************************************************
	OSCM		EQU		0CAH
		FCPUM1		EQU		OSCM.4
		FCPUM0		EQU		OSCM.3
		FCLKMD		EQU		OSCM.2
		FSTPHX		EQU		OSCM.1
;*******************************************************************************
	WDTR		EQU		0CCH
	TC0R		EQU_W		0CDH
	PCL		EQU		0CEH
	PCH		EQU		0CFH
;*******************************************************************************
	P0		EQU 		0D0H
		FP00		EQU 		P0.0
;*******************************************************************************
	P1		EQU		0D1H
		FP13		EQU		P1.3
		FP12		EQU		P1.2
		FP11		EQU_R		P1.1
		FP10		EQU		P1.0
;*******************************************************************************
	P2		EQU		0D2H
		FP21		EQU		P2.1
		FP20		EQU		P2.0
;*******************************************************************************
	P5		EQU		0D5H
		FP54		EQU		P5.4
;*******************************************************************************
	T0M		EQU		0D8H
		FT0ENB	 	EQU   		T0M.7
		FT0RATE2 	EQU  	 	T0M.6
		FT0RATE1 	EQU  	 	T0M.5
		FT0RATE0 	EQU  	 	T0M.4
;*******************************************************************************
   	T0C		EQU		0D9H
;*******************************************************************************
	TC0M		EQU		0DAH
		FTC0ENB		EQU		TC0M.7
		FTC0RATE2	EQU		TC0M.6
		FTC0RATE1	EQU		TC0M.5
		FTC0RATE0	EQU		TC0M.4
		FTC0CKS		EQU		TC0M.3
       		FALOAD0    	EQU		TC0M.2
       		FTC0OUT   	EQU		TC0M.1
       		FPWM0OUT   	EQU		TC0M.0
;*******************************************************************************
	TC0C		EQU		0DBH
;*******************************************************************************
	STKP		EQU		0DFH
		FGIE		EQU		STKP.7
		FSTKPB1		EQU		STKP.1
		FSTKPB0		EQU		STKP.0
;*******************************************************************************
    	P0UR		EQU_W  		0E0H
;*******************************************************************************	
    	P1UR		EQU_W   	0E1H
;*******************************************************************************
    	P2UR		EQU_W  	 	0E2H
;*******************************************************************************		
    	P5UR		EQU_W   	0E5H
;*******************************************************************************		
	@YZ		EQU		0E7H
	P1OC		EQU_W		0E9H
;*******************************************************************************
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh
;*******************************************************************************
; Clear watchdog macro. 
;  
; Total Cycle: 2

	@RST_WDT	macro
		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
;*******************************************************************************
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
;*******************************************************************************
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
;*******************************************************************************
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
;*******************************************************************************
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
;*******************************************************************************
.TEXT
{
		//{{SONIX_OPTION_RULE
	IF Low_Power == Enable
	{
		OPTION		2		Fcpu		x x x Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128  
  	}
	ELSE	
	{

		OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128  
  	}
	ENDP
	//}}SONIX_OPTION_RULE
}
;*******************************************************************************