
;------------------------------------------------------------------------------
;  CHIP: SN8P2715
;  Revision History
;
;  V01   09/21/2004  1. First issue and only for SN8ICE 2K.
;
;  V02   09/25/2004  1. Add STPHX bit in OSCM register
;                    2. Remove CPUM1, remove green modes
;  V03   01/05/2005  1. Change LVD code option name
;                  
;  V04   04/01/2005  1. Remove Low_Power code option. 
;                    2. Remove LVD_MAX code option. LVD 3.6V only supports flag function
;                    3. Modify Noise_Filter enable Fcpu limitation. Fcpu= Fosc/1~Fosc/8
;
;  V05   12/12/2005  1. Remove 32K_X'Tal mode code option. 
;                    2. Limit Fcpu 1T, 2T rate when Noise_Filter enable.
;  V06   12/17/2007  1. "GreenMode","SleepMode","SlowMode","Slow2Normal" macro programs. 
;  V07   04/03/2008  1. Add "RedWrt_FORMAT    1"  	
;  V08   05/21/2010  1. Modify ADR register.
;  V09   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;------------------------------------------------------------------------------
.ASSEMBLY    RedWrt_FORMAT    1

.Assembly	INC_VER		9
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	80h

.Assembly	INSTRUMENT	SN8P2715
.Assembly	BIT_FILE	SN8P2715

.Assembly	OTP_BODY_SIZE	0x0800
.Assembly	USER_ROM_SIZE	0x07FC

;.Assembly	OTP_TEST_SIZE	0x00E0
;.Assembly	MASK_TEST_FILE
;.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	6
.Assembly	MASK_TEST_CODE	0x0000, 0x000, 0x0000, 0x0000
.Assembly	Port_Pins	4, 0, 8, 0, 8, 7
.Assembly	COMMAND		Enable_ORG4_7, PCL_LIMIT, GREEN_NOP_LIMIT
.Assembly	CHIP_ID		0x6500

; Code Option 0x3FF
.Assembly	OPTION   	0		Noise_Filter	Disable	Enable
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1  Fosc/2 Fosc/4 Fosc/8
.Help
{
	Fcpu		: 	"Fcpu is instruction clock\nFosc is system clock\nOnly Effective for HIGH Clock"
}
;for SN8PEV2715  .Assembly	OPTION		4		RST_debounce    NO   128*ILOSC
.Assembly	OPTION		4		Fix_High
.Assembly	OPTION		5		High_Clk	RC   x 	12M_X'tal	4M_X'tal
.Help
{	
	RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin\nEnable P5.6 I/O pin"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}
.Assembly	OPTION		7		Fix_High
.Assembly	OPTION   	8		Watch_Dog	Always_ON x x x x Enable x x x x Disable x x x x x
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
}
.Assembly	OPTION		12		RST_P0.3	Reset   X  	P0.3	X

.Assembly	OPTION		14		LVD     	X	LVD_H	LVD_M	LVD_L
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"	
}


; Code Option 0x3FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High
; Code Option 0x3FD
;.Assembly	OPTION		32		Fosc_Div	/1	/2
.Assembly	OPTION		32 : 63		Fix_High
.Assembly	OPTION		2ffh
;.Assembly	OTP2MSK		0xFFFF, 0x000C, 0x0000

	R			EQU		0x82
	Z			EQU		0x83
	Y			EQU		0x84

	PFLAG			EQU		0x86
		FZ	EQU		PFLAG.0
		FDC	EQU		PFLAG.1
		FC	EQU		PFLAG.2
		FLVD24	EQU		PFLAG.4
		FLVD36	EQU		PFLAG.5		
		FNPD	EQU		PFLAG.6
		FNT0	EQU		PFLAG.7
   
	;P4CON is ADC analog gating control register
	P4CON			EQU		0xAE
		FP4CON7	EQU		P4CON.7
		FP4CON6	EQU		P4CON.6
		FP4CON5	EQU		P4CON.5
		FP4CON4	EQU		P4CON.4
		FP4CON3	EQU		P4CON.3
		FP4CON2	EQU		P4CON.2
		FP4CON1	EQU		P4CON.1
		FP4CON0	EQU		P4CON.0

	DAM			EQU		0xB0
		FDAENB	EQU		DAM.7
		FDAB6	EQU		DAM.6
		FDAB5	EQU		DAM.5
		FDAB4	EQU		DAM.4
		FDAB3	EQU		DAM.3
		FDAB2	EQU		DAM.2
		FDAB1	EQU		DAM.1
		FDAB0	EQU		DAM.0

	ADM			EQU		0xB1
		FADENB	EQU		ADM.7
		FADS	EQU		ADM.6
		FEOC	EQU		ADM.5
		FGCHS	EQU		ADM.4
		FCHS2	EQU		ADM.2
		FCHS1	EQU		ADM.1
		FCHS0	EQU		ADM.0
		
	ADB			EQU_R	0B2H

	ADR			EQU		0B3H
		FADCKS1	EQU		ADR.6
		FADCKS0	EQU		ADR.4
		FADB3	EQU_R		ADR.3
		FADB2	EQU_R		ADR.2
		FADB1	EQU_R		ADR.1
		FADB0	EQU_R		ADR.0		

	
		PEDGE		EQU		0BFH
		FP00G1	EQU		PEDGE.4
		FP00G0	EQU		PEDGE.3

	P2M			EQU		0C2H
		FP27M	EQU		P2M.7
		FP26M	EQU		P2M.6
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0
	P4M			EQU		0C4H
		FP47M	EQU		P4M.7
		FP46M	EQU		P4M.6
		FP45M	EQU		P4M.5
		FP44M	EQU		P4M.4
		FP43M	EQU		P4M.3
		FP42M	EQU		P4M.2
		FP41M	EQU		P4M.1
		FP40M	EQU		P4M.0

	P5M			EQU		0C5H
		FP56M	EQU		P5M.6
		FP55M	EQU		P5M.5
		FP54M	EQU		P5M.4
		FP53M	EQU		P5M.3
		FP52M	EQU		P5M.2
		FP51M	EQU		P5M.1
		FP50M	EQU		P5M.0		

	INTRQ			EQU		0C8H
		FTC1IRQ	EQU		INTRQ.6
		FTC0IRQ	EQU		INTRQ.5
		FP01IRQ	EQU		INTRQ.1
		FP00IRQ	EQU		INTRQ.0

	INTEN			EQU		0C9H
		FTC1IEN	EQU		INTEN.6
		FTC0IEN	EQU		INTEN.5
		FP01IEN	EQU		INTEN.1
		FP00IEN	EQU		INTEN.0

	OSCM			EQU		0CAH	
		FSTPHX	EQU	OSCM.1		
		FCLKMD	EQU	OSCM.2		
		FCPUM0	EQU	OSCM.3

		
	WDTR		EQU_W		0CCH				

	TC0R			EQU_W		0CDH

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU_R		0D0H
	        FP03	EQU_r		P0.3
		FP02	EQU_r		P0.2
		FP01	EQU_r		P0.1
		FP00	EQU_r		P0.0	

	P2			EQU		0D2H
		FP27	EQU		P2.7
		FP26	EQU		P2.6
		FP25	EQU		P2.5
		FP24	EQU		P2.4
		FP23	EQU		P2.3
		FP22	EQU		P2.2
		FP21	EQU		P2.1
		FP20	EQU		P2.0


	P4			EQU		0D4H
		FP47	EQU		P4.7
		FP46	EQU		P4.6
		FP45	EQU		P4.5
		FP44	EQU		P4.4
		FP43	EQU		P4.3
		FP42	EQU		P4.2
		FP41	EQU		P4.1
		FP40	EQU		P4.0

	P5			EQU		0D5H
		FP56	EQU		P5.6
		FP55	EQU		P5.5
		FP54	EQU		P5.4
		FP53	EQU		P5.3
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0		

	T0M			EQU		0D8H
		FTC1X8	        EQU	T0M.3
		FTC0X8   	EQU	T0M.2	


	TC0M			EQU		0DAH
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
		FTC0CKS		EQU	TC0M.3
		FALOAD0		EQU	TC0M.2
		FTC0OUT		EQU	TC0M.1
		FPWM0OUT	EQU	TC0M.0

	TC0C			EQU		0DBH

	TC1M			EQU		0DCH
		FTC1ENB		EQU	TC1M.7
		FTC1RATE2	EQU	TC1M.6
		FTC1RATE1	EQU	TC1M.5
		FTC1RATE0	EQU	TC1M.4
		FTC1CKS		EQU	TC1M.3
		FALOAD1		EQU	TC1M.2
		FTC1OUT		EQU	TC1M.1
		FPWM1OUT	EQU	TC1M.0

	TC1C			EQU		0DDH
	TC1R			EQU_W		0DEH

	STKP		EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	P0UR			EQU_W		0E0H
		FP03R	EQU_W		P0UR.3
		FP02R	EQU_W		P0UR.2
		FP01R	EQU_W		P0UR.1
		FP00R	EQU_W		P0UR.0

	P2UR			EQU_W		0E2H
		FP27R	EQU_W		P2UR.7
		FP26R	EQU_W		P2UR.6
		FP25R	EQU_W		P2UR.5
		FP24R	EQU_W		P2UR.4
		FP23R	EQU_W		P2UR.3
		FP22R	EQU_W		P2UR.2
		FP21R	EQU_W		P2UR.1
		FP20R	EQU_W		P2UR.0

	P4UR			EQU_W		0E4H
		FP47R	EQU_W		P4UR.7
		FP46R	EQU_W		P4UR.6
		FP45R	EQU_W		P4UR.5
		FP44R	EQU_W		P4UR.4
		FP43R	EQU_W		P4UR.3
		FP42R	EQU_W		P4UR.2
		FP41R	EQU_W		P4UR.1
		FP40R	EQU_W		P4UR.0

	P5UR			EQU_W		0E5H

		FP56R	EQU_W		P5UR.6
		FP55R	EQU_W		P5UR.5
		FP54R	EQU_W		P5UR.4
		FP53R	EQU_W		P5UR.3
		FP52R	EQU_W		P5UR.2
		FP51R	EQU_W		P5UR.1
		FP50R	EQU_W		P5UR.0

	@YZ			EQU		0E7H
	DP1X			EQU		0E7H

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh
	
;; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------	

.TEXT
{
	//{{SONIX_OPTION_RULE
	IF Noise_Filter == Enable
	{
		OPTION		2		Fcpu		x  x Fosc/4 Fosc/8
 
  	}
	ELSE	
	{
		OPTION		2		Fcpu		Fosc/1  Fosc/2 Fosc/4 Fosc/8

  	}
	ENDP
	//}}SONIX_OPTION_RULE
}
