;------------------------------------------------------------------------------
;  CHIP: SN8P2723
;  Revision History
;  
;  V01   05/22/2012  1. First issue and only for SN8ICE 2K Plus 2.
;  V01   05/03/2013  1. Add NEW_CODEOPTION for read/write file trim 16 word fix high
;------------------------------------------------------------------------------
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	INC_VER		1
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	128

.Assembly	INSTRUMENT	SN8P2723
.Assembly	BIT_FILE	SN8P2723

.Assembly	OTP_BODY_SIZE	0x0810
.Assembly	USER_ROM_SIZE	0x0800

;.Assembly	OTP_TEST_SIZE	0x00A0
;.Assembly	MASK_TEST_FILE	SN8A1602A
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	15
.Assembly	CHIP_ID		0x6240
.Assembly	command		Enable_ORG4_7, NEW_CODEOPTION 
.Assembly	Port_Pins	0, 8, 2, 0, 8, 0

; Code Option 0x080F
.Assembly	OPTION		0		Noise_Filter	Disable Enable	
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 Fosc/32 Fosc/64 Fosc/128
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		5		High_Clk	Ext_RC 32K_X'tal 16M_X'tal 4M_X'tal x IHRC_RTC x IHRC_16M
.Help
{	
	IHRC_16M	:	"Internal 16M RC Oscillator"
	IHRC_RTC	:	"Internal 16M RC Oscillator with RTC.\n" \
	               		"Connect 32.768K crystal to Xin/Xout"
	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
	16M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}
.Assembly	OPTION		8		Watch_Dog 	Always_On x x x x Enable x x x x Disable x x x x x 
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin 	P12	Reset
;.Assembly	OPTION   	13		Rst_Length	No	128_ILRC
.Assembly	OPTION   	13		Fix_High
;.Assembly	OPTION   	14		Fix_High
;.Assembly	OPTION   	15		Fix_High

.Assembly	OPTION   	14		Low_Power	Enable	Disable
.Help
{
	Enable	:	"If Low_Power enable, Fcpu should be\nless than or equal to 1MIPS."
}
;.Assembly	OPTION   	15		LP_EnTime	160ns	120ns
.Assembly	OPTION		15		Fix_Low

; Code Option 0x080E
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x080D
.Assembly	OPTION		32 : 40		Fix_High
.Assembly	OPTION		41		LVD     	x LVD_H LVD_M LVD_L
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"	
;	LVD_Max		:	"3.6V Reset"
}
;.Assembly	OPTION		43	LVDB		No 2_ILRC 4_ILRC 8_ILRC

.Assembly	OPTION		43 : 47		Fix_High

; Code Option 0x080C~0x800
.Assembly	OPTION		48 : 255	Fix_High
;.Assembly	OPTION		48 : 63		Fix_Low

.Assembly	OPTION		2ffh
	L		EQU		80H
	H		EQU		81H
	R		EQU		82H
	Z		EQU		83H
	Y		EQU		84H
	
	PFLAG		EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FLVD24		EQU_R		PFLAG.4
		FLVD36		EQU_R		PFLAG.5
		FNPD		EQU		PFLAG.6
		FNT0		EQU		PFLAG.7

	TC1M		EQU		0A0H
	       	FPWM1OUT   	EQU		TC1M.0 
       		FTC1PO    	EQU		TC1M.1
		FTC1RATE0	EQU		TC1M.4
		FTC1RATE1	EQU		TC1M.5
		FTC1RATE2	EQU		TC1M.6
		FTC1ENB		EQU		TC1M.7

	TC1C		EQU		0A1H
	TC1R		EQU_W		0A2H
	TC1D		EQU		0A3H

	TC2M		EQU		0A4H
	       	FPWM2OUT   	EQU		TC2M.0 
       		FTC2PO    	EQU		TC2M.1
		FTC2RATE0	EQU		TC2M.4
		FTC2RATE1	EQU		TC2M.5
		FTC2RATE2	EQU		TC2M.6
		FTC2ENB		EQU		TC2M.7

	TC2C		EQU		0A5H
	TC2R		EQU_W		0A6H
	TC2D		EQU		0A7H

	TC3M		EQU		0A8H
	       	FPWM3OUT   	EQU		TC3M.0 
       		FTC3PO    	EQU		TC3M.1
		FTC3RATE0	EQU		TC3M.4
		FTC3RATE1	EQU		TC3M.5
		FTC3RATE2	EQU		TC3M.6
		FTC3ENB		EQU		TC3M.7

	TC3C		EQU		0A9H
	TC3R		EQU_W		0AAH
	TC3D		EQU		0ABH

	PWCH		EQU		0ACH
		FPWCH10		EQU		PWCH.0
		FPWCH11		EQU		PWCH.1
		FPWCH20		EQU		PWCH.2
		FPWCH21		EQU		PWCH.3
		FPWCH30		EQU		PWCH.4
		FPWCH31		EQU		PWCH.5
	P4CON		EQU_W		0AEH
	P1CON		EQU_W		0AFH
		FP2CON0		EQU_W		P1CON.0
		FP2CON1		EQU_W		P1CON.1
		FP1CON6		EQU_W		P1CON.6
		FP1CON7		EQU_W		P1CON.7

	VREFH 		EQU		0xB0
		FVHS0		EQU		VREFH.0
		FVHS1		EQU		VREFH.1
		FEVHENB		EQU		VREFH.7
	ADM 		EQU		0xB1
		FCHS0		EQU		ADM.0
		FCHS1		EQU		ADM.1
		FCHS2		EQU		ADM.2
		FCHS3		EQU		ADM.3
		FGCHS		EQU		ADM.4
		FEOC		EQU		ADM.5
		FADS		EQU		ADM.6
		FADENB		EQU		ADM.7

	ADB 		EQU_R		0xB2

	ADR 		EQU		0xB3
		FADB0		EQU_R		ADR.0
		FADB1		EQU_R		ADR.1
		FADB2		EQU_R		ADR.2
		FADB3		EQU_R		ADR.3
		FADCKS0		EQU		ADR.4
		FADLEN		EQU		ADR.5
		FADCKS1		EQU		ADR.6
	ADT 		EQU		0xB4
		FADT0		EQU		ADT.0
		FADT1		EQU		ADT.1
		FADT2		EQU		ADT.2
		FADT3		EQU		ADT.3
		FADT4		EQU		ADT.4
		FADTS0		EQU		ADT.6
		FADTS1		EQU		ADT.7

	PEDGE		EQU		0BFH		
		FP40G0		EQU		PEDGE.0
		FP40G1		EQU		PEDGE.1
		FP41G0		EQU		PEDGE.2
		FP41G1		EQU		PEDGE.3
		FP42G0		EQU		PEDGE.4
		FP42G1		EQU		PEDGE.5

	P1W		EQU_W		0C0H

	P1M		EQU		0C1H
  		FP10M		EQU		P1M.0
  		FP11M		EQU		P1M.1
  		FP12M		EQU		P1M.2
  		FP13M		EQU		P1M.3
  		FP14M		EQU		P1M.4
  		FP15M		EQU		P1M.5
  		FP16M		EQU		P1M.6
  		FP17M		EQU		P1M.7
	P2M		EQU		0C2H
  		FP20M		EQU		P2M.0
  		FP21M		EQU		P2M.1
	P4M		EQU		0C4H
		FP40M		EQU		P4M.0
		FP41M		EQU		P4M.1
		FP42M		EQU		P4M.2
		FP43M		EQU		P4M.3
		FP44M		EQU		P4M.4
		FP45M		EQU		P4M.5
		FP46M		EQU		P4M.6
		FP47M		EQU		P4M.7
	INTRQ1		EQU		0C6H
		FTC2IRQ		EQU		INTRQ1.0
		FTC3IRQ		EQU		INTRQ1.1
	INTEN1		EQU		0C7H
		FTC2IEN		EQU		INTEN1.0
		FTC3IEN		EQU		INTEN1.1
	INTRQ0		EQU		0C8H
		FP40IRQ		EQU		INTRQ0.0
		FP41IRQ		EQU		INTRQ0.1
		FP42IRQ		EQU		INTRQ0.2
		FT0IRQ		EQU		INTRQ0.4
		FTC0IRQ		EQU		INTRQ0.5
		FTC1IRQ		EQU		INTRQ0.6
		FADCIRQ		EQU		INTRQ0.7
	INTEN0		EQU		0C9H
		FP40IEN		EQU		INTEN0.0
		FP41IEN		EQU		INTEN0.1
		FP42IEN		EQU		INTEN0.2
		FT0IEN		EQU		INTEN0.4
		FTC0IEN		EQU		INTEN0.5
		FTC1IEN		EQU		INTEN0.6
		FADCIEN		EQU		INTEN0.7
	OSCM		EQU		0CAH
		FCPUM1		EQU		OSCM.4
		FCPUM0		EQU		OSCM.3
		FCLKMD		EQU		OSCM.2
		FSTPHX		EQU		OSCM.1

	WDTR		EQU_W		0CCH

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P1		EQU		0D1H
		FP10		EQU		P1.0
		FP11		EQU		P1.1
		FP12		EQU		P1.2
		FP13		EQU		P1.3
		FP14		EQU		P1.4
		FP15		EQU		P1.5
		FP16		EQU		P1.6
		FP17		EQU		P1.7
	P2		EQU		0D2H
		FP20		EQU		P2.0
		FP21		EQU		P2.1		
	P4		EQU		0D4H
		FP40		EQU		P4.0
		FP41		EQU		P4.1
		FP42		EQU		P4.2
		FP43		EQU		P4.3
		FP44		EQU		P4.4
		FP45		EQU		P4.5
		FP46		EQU		P4.6		
		FP47		EQU		P4.7

	P1DR		EQU_W		0D6H
		FP13DR		EQU_W		P1DR.0
		FP14DR		EQU_W		P1DR.1
		FP15DR		EQU_W		P1DR.2
		FP16DR		EQU_W		P1DR.3
		FP13SC		EQU_W		P1DR.4
		FP14SC		EQU_W		P1DR.5
		FP15SC		EQU_W		P1DR.6		
		FP16SC		EQU_W		P1DR.7
	T0M		EQU		0D8H
		FT0TB		EQU  	  	T0M.0
		FT0RATE0 	EQU  	  	T0M.4
		FT0RATE1 	EQU  	  	T0M.5
		FT0RATE2 	EQU  	  	T0M.6
		FT0ENB	 	EQU  	 	T0M.7

	T0C		EQU		0D9H

	TC0M		EQU		0DAH
	       	FPWM0OUT   	EQU		TC0M.0 
       		FTC0PO    	EQU		TC0M.1
       		FTC0CKS    	EQU		TC0M.3
		FTC0RATE0	EQU		TC0M.4
		FTC0RATE1	EQU		TC0M.5
		FTC0RATE2	EQU		TC0M.6
		FTC0ENB		EQU		TC0M.7

	TC0C		EQU		0DBH
	TC0R		EQU_W		0DCH
	TC0D		EQU		0DDH

	PWES		EQU		0DEH
		FPW1ES0		EQU		PWES.0
		FPW1ES1		EQU		PWES.1
		FPW2ES0		EQU		PWES.2
		FPW2ES1		EQU		PWES.3
		FPW3ES0		EQU		PWES.4
		FPW3ES1		EQU		PWES.5

	STKP		EQU		0DFH
		FSTKPB0		EQU		STKP.0
		FSTKPB1		EQU		STKP.1
		FSTKPB2		EQU		STKP.2
		FGIE		EQU		STKP.7

	P1UR		EQU_W		0E1H
	P2UR		EQU_W		0E2H
	P4UR		EQU_W		0E4H



	@HL		EQU		0E6H
	@YZ		EQU		0E7H

	STK7L		EQU		0xF0
	STK7H		EQU		0xF1
	STK6L		EQU		0xF2
	STK6H		EQU		0xF3
	STK5L		EQU		0xF4
	STK5H		EQU		0xF5
	STK4L		EQU		0xF6
	STK4H		EQU		0xF7
	STK3L		EQU		0xF8
	STK3H		EQU		0xF9
	STK2L		EQU		0xFA
	STK2H		EQU		0xFB
	STK1L		EQU		0xFC
	STK1H		EQU		0xFD
	STK0L		EQU		0xFE
	STK0H		EQU		0xFF
; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1
;
;	SleepMode	macro	
;		B0BSET	FCPUM0
;	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3
;
;	GreenMode	macro	
;		B0BSET	FCPUM1
;		NOP
;		NOP
;	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2
;
;	SLowMode	macro	
;		B0BSET	FCLKMD
;		B0BSET	FSTPHX
;	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5
;
;	Slow2Normal	macro	
;		B0BCLR	FSTPHX
;		NOP
;		NOP
;		NOP
;		B0BCLR	FCLKMD
;	endm
; -----------------------------------------------------	
.TEXT
{
	//{{SONIX_OPTION_RULE
	ENDP
	//}}SONIX_OPTION_RULE
}