;------------------------------------------------------------------------------
;  CHIP: SN8P2743
;  Revision History
;  
;  V01   02/09/2010  1. First issue and only for SN8ICE 2K. 
;  V02   03/25/2010  1. Modify OPM : FOP3EN ->> FOPEN 
;  V03   03/30/2010  1. Modify FCM0MOUT Read only
;		     2. Modify FCM1MOUT Read only 
;                    3. Modify FCM2MOUT Read only
;		     4. add COMMAND : GREEN_NOP_LIMIT
;  V04   06/29/2010  1. modify MACRO text "SLowMode" to "SlowMode"
;  V05   02/13/2012  1. set FLVD24/FLVD36 EQU_R (read only)
;------------------------------------------------------------------------------
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	INC_VER		5
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	128

.Assembly	INSTRUMENT	SN8P2743
.Assembly	BIT_FILE	SN8P2743

.Assembly	OTP_BODY_SIZE	0x1000 
.Assembly	USER_ROM_SIZE	0x0FFC

.Assembly	OTP_TEST_SIZE	0x00E0
;.Assembly	MASK_TEST_FILE
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	
.Assembly	PGM_TYPE	13
.Assembly	CHIP_ID		0x6300		
.Assembly	COMMAND		Enable_ORG4_7, GREEN_NOP_LIMIT
.Assembly	Port_Pins	7,7,0,0,8,0

; Code Option 0x0FFF
.Assembly	OPTION		0		Fix_High
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/4 Fosc/8 Fosc/16 x
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		4		Fix_High
.Assembly	OPTION		5		High_Clk	IHRC_16M x x x Ext_RC 32K_X'tal 12M_X'tal 4M_X'tal
.Help
{	
	IHRC_16M	:	"Internal 16M RC Oscillator"
	Ext_RC		:	"Connect R to VDD and Xin\nConnect C to GND and Xin"
	32K_X'tal	:	"32.768K Crystal"
	12M_X'tal	:	"Crystal/Resonator: 10Mhz~16Mhz"
	4M_X'tal	:	"Crystal/Resonator: 2Mhz~10Mhz"
}

.Assembly	OPTION		8		Watch_Dog 	Always_On x x x x Enable x x x x Disable x x x x x 
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin 	P04	Reset
;.Assembly	OPTION   	13		Rst_Len		No	128_ILRC
.Assembly	OPTION   	13		Fix_High
.Assembly	OPTION   	14		Fix_High
.Assembly	OPTION   	15		Fix_High

; Code Option 0x0FFE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x0FFD
.Assembly	OPTION		32 : 40		Fix_High
.Assembly	OPTION		41		LVDM     	LVD_Max	LVD_H LVD_M LVD_L
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"	
	LVD_Max		:	"3.6V Reset"	
}
;.Assembly	OPTION		43		LVDB		No 2_ILRC
.Assembly	OPTION		43		Fix_Low
.Assembly	OPTION		44 : 63		Fix_High

.Assembly	OPTION		2ffh

	L		EQU		0x80
	H		EQU		0x81
	R		EQU		0x82
	Z		EQU		0x83
	Y		EQU		0x84
	PFLAG		EQU		0x86
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FLVD24		EQU_R		PFLAG.4
		FLVD36		EQU_R		PFLAG.5
		FNPD		EQU		PFLAG.6
		FNT0		EQU		PFLAG.7

	CMDB0		EQU		09AH
		FCM1D3		EQU		CMDB0.7
		FCM1D2		EQU		CMDB0.6
		FCM1D1		EQU		CMDB0.5
		FCM1D0		EQU		CMDB0.4
		FCM0D3		EQU		CMDB0.3
		FCM0D2		EQU		CMDB0.2
		FCM0D1		EQU		CMDB0.1
		FCM0D0		EQU		CMDB0.0

	CMDB1		EQU		09BH
		FCM2D3		EQU		CMDB1.3
		FCM2D2		EQU		CMDB1.2
		FCM2D1		EQU		CMDB1.1
		FCM2D0		EQU		CMDB1.0

	CM0M		EQU		09CH
		FCM0EN		EQU		CM0M.7
		FCM0OEN		EQU		CM0M.6
		FCM0OUT		EQU_R	 	CM0M.5
		FCM0SF		EQU		CM0M.4
		FCM0G		EQU		CM0M.3

	CM1M		EQU		09DH
		FCM1EN		EQU		CM1M.7
		FCM1OEN		EQU		CM1M.6
		FCM1OUT		EQU_R	 	CM1M.5
		FCM1SF		EQU		CM1M.4
		FCM1G		EQU		CM1M.3
		FCM1RS2		EQU		CM1M.2
		FCM1RS1		EQU		CM1M.1
		FCM1RS0		EQU		CM1M.0

	CM2M		EQU		09EH
		FCM2EN		EQU		CM2M.7
		FCM2OEN		EQU		CM2M.6
		FCM2OUT		EQU_R	 	CM2M.5
		FCM2SF		EQU		CM2M.4
		FCM2G		EQU		CM2M.3
		FCM2RS2		EQU		CM2M.2
		FCM2RS1		EQU		CM2M.1
		FCM2RS0		EQU		CM2M.0

	OPM		EQU		09FH
		FOPEN		EQU		OPM.0
	
	P4CON		EQU_W		0AEH

	ADM		EQU		0xB1
		FADENB		EQU		ADM.7
		FADS		EQU		ADM.6
		FEOC		EQU		ADM.5
		FGCHS		EQU		ADM.4
		FAVREFH		EQU		ADM.3
		FCHS2		EQU		ADM.2
		FCHS1		EQU		ADM.1
		FCHS0		EQU		ADM.0
	ADB		EQU_R  		0B2H

	ADR		EQU		0B3H
		FADCKS1		EQU		ADR.6
		FADLEN		EQU		ADR.5
		FADCKS0		EQU		ADR.4
		FADB3		EQU_R	 	ADR.3
		FADB2		EQU_R	 	ADR.2
		FADB1		EQU_R 		ADR.1
		FADB0		EQU_R 		ADR.0
	
	ADT		EQU		0B4H
		FADTS1		EQU		ADT.7
		FADTS0		EQU		ADT.6
		FADT4		EQU		ADT.4
		FADT3		EQU		ADT.3
		FADT2		EQU		ADT.2
		FADT1		EQU		ADT.1
		FADT0		EQU		ADT.0

	P0M		EQU		0B8H
		FP06M		EQU		P0M.6
		FP05M		EQU		P0M.5
		FP03M		EQU		P0M.3
		FP02M		EQU		P0M.2
		FP00M		EQU		P0M.0

	PEDGE		EQU		0BFH
		FP00G1		EQU		PEDGE.1
		FP00G0		EQU		PEDGE.0

	P1W		EQU_W  		0C0H

	P1M		EQU		0C1H
		FP16M		EQU		P1M.6
		FP15M		EQU		P1M.5
		FP14M		EQU		P1M.4
		FP13M		EQU		P1M.3
		FP12M		EQU		P1M.2
		FP11M		EQU		P1M.1
		FP10M		EQU		P1M.0

	P4M		EQU		0C4H
		FP47M		EQU		P4M.7
		FP46M		EQU		P4M.6
		FP45M		EQU		P4M.5
		FP44M		EQU		P4M.4
		FP43M		EQU		P4M.3
		FP42M		EQU		P4M.2
		FP41M		EQU		P4M.1
		FP40M		EQU		P4M.0

	INTRQ		EQU		0C8H
		FADCIRQ		EQU		INTRQ.7
		FTC0IRQ		EQU		INTRQ.5
  		FT0IRQ  	EQU	  	INTRQ.4
		FCM2IRQ		EQU		INTRQ.3
		FCM1IRQ		EQU		INTRQ.2
		FCM0IRQ		EQU		INTRQ.1
		FP00IRQ		EQU		INTRQ.0

	INTEN		EQU		0C9H
		FADCIEN		EQU		INTEN.7
		FTC0IEN		EQU		INTEN.5
		FT0IEN		EQU 		INTEN.4
		FCM2IEN		EQU		INTEN.3
		FCM1IEN		EQU		INTEN.2
		FCM0IEN		EQU		INTEN.1
		FP00IEN		EQU		INTEN.0

	OSCM		EQU		0CAH
		FCPUM1		EQU		OSCM.4
		FCPUM0		EQU		OSCM.3
		FCLKMD		EQU		OSCM.2
		FSTPHX		EQU		OSCM.1

	WDTR		EQU_W		0CCH

	TC0R		EQU_W	  	0CDH

	PCL		EQU		0CEH
	PCH		EQU		0CFH

	P0		EQU  		0D0H
		FP06		EQU   		P0.6
		FP05		EQU   		P0.5
		FP04		EQU_R  	 	P0.4
		FP03		EQU 		P0.3
		FP02		EQU  	 	P0.2
		FP01		EQU_W  	 	P0.1
		FP00		EQU  	 	P0.0

	P1		EQU		0D1H
		FP16		EQU		P1.6
		FP15		EQU		P1.5
		FP14		EQU		P1.4
		FP13		EQU		P1.3
		FP12		EQU		P1.2
		FP11		EQU		P1.1
		FP10		EQU		P1.0

	P4		EQU		0D4H
		FP47		EQU		P4.7
		FP46		EQU		P4.6
		FP45		EQU		P4.5
		FP44		EQU		P4.4
		FP43		EQU		P4.3
		FP42		EQU		P4.2
		FP41		EQU		P4.1
		FP40		EQU		P4.0

	T0M		EQU		0D8H
		FT0ENB	 	EQU  	 	T0M.7
		FT0RATE2 	EQU  	  	T0M.6
		FT0RATE1 	EQU  	  	T0M.5
		FT0RATE0 	EQU  	  	T0M.4

   	T0C		EQU		0D9H

	TC0M  		EQU		0DAH
		FTC0ENB		EQU		TC0M.7
		FTC0RATE2	EQU		TC0M.6
		FTC0RATE1	EQU		TC0M.5
		FTC0RATE0	EQU		TC0M.4
		FTC0CKS		EQU		TC0M.3
   	 	FTC0DIR    	EQU		TC0M.2
    		FTC0PO    	EQU		TC0M.1
    		FPWM0OUT   	EQU		TC0M.0 

	TC0C		EQU		0DBH

	BZM		EQU		0DCH
		FBZEN		EQU		BZM.7
		FBZRATE2	EQU		BZM.6
		FBZRATE1	EQU		BZM.5

	STKP		EQU		0DFH
		FGIE		EQU		STKP.7
		FSTKPB2		EQU		STKP.2
		FSTKPB1		EQU		STKP.1
		FSTKPB0		EQU		STKP.0

    	P0UR		EQU_W  		0E0H
    	P1UR		EQU_W  		0E1H
    	P4UR		EQU_W  		0E4H
 
	@HL		EQU		0E6H
	@YZ		EQU		0E7H

	TC0D		EQU		0E8H

	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h
	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SlowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------
.TEXT
{
	//{{SONIX_OPTION_RULE
	ENDP
	//}}SONIX_OPTION_RULE
}
