;------------------------------------------------------------------------------
;  CHIP: SN8P2761
;  Revision History
;  
;  V01   04/28/2015  1. First issue and only for SN8ICE 2K Plus 2.
;------------------------------------------------------------------------------
.ASSEMBLY	RedWrt_FORMAT	1
.Assembly	INC_VER		1
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	64

.Assembly	INSTRUMENT	SN8P2761
.Assembly	BIT_FILE	SN8P2761

.Assembly	OTP_BODY_SIZE	0x0400
.Assembly	USER_ROM_SIZE	0x03FC

;.Assembly	OTP_TEST_SIZE	0x00A0
;.Assembly	MASK_TEST_FILE	SN8A1602A
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
;.Assembly	OTP_TEST_FILE	SN86P
.Assembly	PGM_TYPE	8
.Assembly	CHIP_ID		0x6170
;.Assembly	command		Enable_ORG4_7, STACK_LIMIT, GREEN_NOP_LIMIT
.Assembly	command		Enable_ORG4_7
.Assembly	Port_Pins	7, 7, 0, 0, 0, 0

; Code Option 0x03FF
.Assembly	OPTION		0		Fix_High	
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fhosc/2 Fhosc/4 Fhosc/8 Fhosc/16 Fhosc/32 Fhosc/64 Fhosc/128 Fhosc/256
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
.Assembly	OPTION		5		Fix_High
.Assembly	OPTION		6		Fix_High
.Assembly	OPTION		7		Fix_High
.Assembly	OPTION		8		Watch_Dog 	Always_On x x x x Enable x x x x Disable x x x x x
;.Assembly	OPTION		8		Watch_Dog 	Always_On Always_On Always_On Always_On Always_On Enable Always_On Always_On Always_On Always_On Disable Always_On Always_On Always_On Always_On Always_On
.Help
{
	Always_ON	:	"Watchdog still enable even in\nGreen and Sleep mode"
	Enable		:	"Normal mode: Enable Watchdog\nGreen and Sleep mode: Stop Watchdog"
	Disable         :       "Disable Watchdog"
} 
.Assembly	OPTION		12		Reset_Pin 	P04	Reset
;.Assembly	OPTION		13		Rst_Length  	No 128*ILRC
.Assembly	OPTION   	13		Fix_High
.Assembly	OPTION   	14		Fix_High
.Assembly	OPTION   	15		Fix_High

; Code Option 0x03FE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x03FD
.Assembly	OPTION		32 : 40	Fix_High
.Assembly	OPTION		41		LVD     	LVD_Max LVD_H LVD_M LVD_L
.Help
{
	LVD_L		:	"2.0V Reset"
	LVD_M		:	"2.0V Reset\nEnable LVD24 bit of PFLAG for\n2.4V Low Voltage Indicator"
	LVD_H		:	"2.4V Reset\nEnable LVD36 bit of PFLAG for\n3.6V Low Voltage Indicator"	
	LVD_Max		:	"3.6V Reset"
}
.Assembly	OPTION		43		Fix_High
.Assembly	OPTION		44		Fix_High

.Assembly	OPTION		45 : 63	Fix_High

.Assembly	OPTION		2ffh

	R		EQU		82H
	Z		EQU		83H
	Y		EQU		84H
	
	PFLAG		EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FLVD24		EQU_R		PFLAG.4
		FLVD36		EQU_R		PFLAG.5
		FNPD		EQU		PFLAG.6
		FNT0		EQU		PFLAG.7

	CM0M		EQU		9CH
		FCM0G0		EQU		CM0M.0
		FCM0G1		EQU		CM0M.1
		FCM0OUT		EQU_R		CM0M.2
		FCM0OEN		EQU		CM0M.3
		FCM0S0		EQU		CM0M.4
		FCM0S1		EQU		CM0M.5
		FCM0T		EQU		CM0M.6
		FCM0EN		EQU		CM0M.7

	PW1M		EQU		0A0H
		FPW1PO		EQU		PW1M.0
		FPWNV10		EQU		PW1M.2
		FPWNV11		EQU		PW1M.3
		FPW1RATE0	EQU		PW1M.4
		FPW1RATE1	EQU		PW1M.5
		FPW1RATE2	EQU		PW1M.6
		FPW1EN		EQU		PW1M.7

	PWCH		EQU		0A1H
		FPWCH10		EQU		PWCH.0
		FPWCH11		EQU		PWCH.1
		FPWCH10A	EQU		PWCH.2
		FPWCH11A	EQU		PWCH.3
		FPWCH10B	EQU		PWCH.4
		FPWCH11B	EQU		PWCH.5

	PW1YL		EQU		0A2H
		FPW1Y0		EQU		PW1YL.0
		FPW1Y1		EQU		PW1YL.1
		FPW1Y2		EQU		PW1YL.2
		FPW1Y3		EQU		PW1YL.3
		FPW1Y4		EQU		PW1YL.4
		FPW1Y5		EQU		PW1YL.5
		FPW1Y6		EQU		PW1YL.6
		FPW1Y7		EQU		PW1YL.7

	PW1YH		EQU		0A3H
		FPW1Y8		EQU		PW1YH.0
		FPW1Y9		EQU		PW1YH.1

	PW1BL		EQU		0A4H
		FPW1B0		EQU		PW1BL.0
		FPW1B1		EQU		PW1BL.1
		FPW1B2		EQU		PW1BL.2
		FPW1B3		EQU		PW1BL.3
		FPW1B4		EQU		PW1BL.4
		FPW1B5		EQU		PW1BL.5
		FPW1B6		EQU		PW1BL.6
		FPW1B7		EQU		PW1BL.7

	PW1BH		EQU		0A5H
		FPW1B8		EQU		PW1BH.0
		FPW1B9		EQU		PW1BH.1

	PW1DL		EQU		0A6H
		FPW1D0		EQU		PW1DL.0
		FPW1D1		EQU		PW1DL.1
		FPW1D2		EQU		PW1DL.2
		FPW1D3		EQU		PW1DL.3
		FPW1D4		EQU		PW1DL.4
		FPW1D5		EQU		PW1DL.5
		FPW1D6		EQU		PW1DL.6
		FPW1D7		EQU		PW1DL.7

	PW1DH		EQU		0A7H
		FPW1D8		EQU		PW1DH.0
		FPW1D9		EQU		PW1DH.1

	PW1A		EQU		0A8H
		FPW1A0		EQU		PW1A.0
		FPW1A1		EQU		PW1A.1
		FPW1A2		EQU		PW1A.2
		FPW1A3		EQU		PW1A.3
		FPW1A4		EQU		PW1A.4
		FPW1A5		EQU		PW1A.5
		FPW1A6		EQU		PW1A.6
		FPW1A7		EQU		PW1A.7

	P1CON		EQU_W		0AFH

	VREFH 		EQU		0B0H
		FVHS0   	EQU		VREFH.0
		FVHS1   	EQU		VREFH.1
		FVHS2   	EQU		VREFH.2
		FQCM0   	EQU		VREFH.3
		FQCM1   	EQU		VREFH.4
		FQCEN   	EQU		VREFH.5
		FEVHENB 	EQU		VREFH.7

	ADM		EQU		0B1H
		FCHS0		EQU		ADM.0
		FCHS1		EQU		ADM.1
		FCHS2		EQU		ADM.2
		FGCHS		EQU		ADM.4
		FEOC		EQU		ADM.5
		FADS		EQU		ADM.6
		FADENB		EQU		ADM.7
		
	ADB		EQU_R		0B2H

	ADR		EQU		0B3H
		FADB0		EQU_R		ADR.0
		FADB1		EQU_R		ADR.1
		FADB2		EQU_R		ADR.2
		FADB3		EQU_R		ADR.3
		FADCKS0		EQU		ADR.4

	ADT		EQU		0B4H
		FADT0		EQU		ADT.0
		FADT1		EQU		ADT.1
		FADT2		EQU		ADT.2
		FADT3		EQU		ADT.3
		FADT4		EQU		ADT.4
		FADTS0		EQU		ADT.6
		FADTS1		EQU		ADT.7

	P0M		EQU		0B8H
		FP00M		EQU		P0M.0
		FP01M		EQU		P0M.1
		FP02M		EQU		P0M.2
		FP03M		EQU		P0M.3
		FP04M		EQU		P0M.4
		FP05M		EQU		P0M.5
		FP06M		EQU		P0M.6

	PEDGE		EQU		0BFH		
		FP00G0		EQU		PEDGE.3
		FP00G1		EQU		PEDGE.4

	P1W		EQU_W		0C0H

	P1M		EQU		0C1H
  		FP10M		EQU		P1M.0
  		FP11M		EQU		P1M.1
  		FP12M		EQU		P1M.2
  		FP13M		EQU		P1M.3
  		FP14M		EQU		P1M.4
  		FP15M		EQU		P1M.5
  		FP16M		EQU		P1M.6

	INTRQ		EQU		0C8H
		FP00IRQ		EQU		INTRQ.0
		FT0IRQ		EQU		INTRQ.4
		FPW1IRQ		EQU		INTRQ.5
		FCM0IRQ		EQU		INTRQ.6
		FADCIRQ		EQU		INTRQ.7

	INTEN		EQU		0C9H
		FP00IEN		EQU		INTEN.0
		FT0IEN		EQU		INTEN.4
		FPW1IEN		EQU		INTEN.5
		FCM0IEN		EQU		INTEN.6
		FADCIEN		EQU		INTEN.7

	OSCM		EQU		0CAH
		FCPUM1		EQU		OSCM.4
		FCPUM0		EQU		OSCM.3
		FCLKMD		EQU		OSCM.2
		FSTPHX		EQU		OSCM.1

	WDTR		EQU_W		0CCH

	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0		EQU	 	0D0H
		FP00		EQU 		P0.0
		FP01		EQU 		P0.1
		FP02		EQU 		P0.2
		FP03		EQU 		P0.3
		FP04		EQU		P0.4
		FP05		EQU 		P0.5
		FP06		EQU		P0.6

	P1		EQU		0D1H
		FP10		EQU		P1.0
		FP11		EQU		P1.1
		FP12		EQU		P1.2
		FP13		EQU		P1.3
		FP14		EQU		P1.4
		FP15		EQU		P1.5
		FP16		EQU		P1.6
	
	P0DR		EQU_W		0D6H
		
	T0M		EQU		0D8H
		FT0RATE0 	EQU  	  	T0M.4
		FT0RATE1 	EQU  	  	T0M.5
		FT0RATE2 	EQU  	  	T0M.6
		FT0ENB	 	EQU  	 	T0M.7

	T0C		EQU		0D9H

	STKP		EQU		0DFH
		FSTKPB0		EQU		STKP.0
		FSTKPB1		EQU		STKP.1
		FGIE		EQU		STKP.7

	P0UR		EQU_W		0E0H
	P1UR		EQU_W		0E1H

	@YZ		EQU		0E7H


	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh
; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SLowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------	
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}
