
;------------------------------------------------------------------------------
;  CHIP: SN8P2839A, OTP Only
;  Revision History:
;  V1.0  06/27/2011 1.Modify from SN8P2839 V24.
;                   2.Disable IHRC Writer calibration.
;  V2.0  09/22/2011 1.Add PCL_LIMIT_2839, RBANK_LIMIT
;  V3.0  02/15/2012 1.Modify CHIP ID=0x8943
;		    2.IHRC Cal=Fix Writer.	 
;------------------------------------------------------------------------------
.Assembly	INC_VER		3
.Assembly	ASM_FORMAT	1
.Assembly RedWrt_FORMAT 1
.Assembly	L_ROM_Size 1

.Assembly	RAM_Size	2048

.Assembly	INSTRUMENT	SN8P2839
.Assembly	BIT_FILE	SN8P2839

.Assembly	OTP_BODY_SIZE	0x6000
.Assembly	USER_ROM_SIZE	0x5FFC
.Assembly	COMMAND		Enable_ORG4_7, PCL_LIMIT_2839, RBANK_LIMIT
.Assembly	PGM_TYPE	6
.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000
.Assembly	Port_Pins	2, 6, 4, 0, 7, 7
.Assembly	LCD_Size 	36,4
.Assembly	CHIP_ID		0x8943

; Code Option 0x5FFF
.Assembly	OPTION				0		Noise_Filter	Disable Enable
.Assembly	OPTION				1		Security			Enable	Disable
.Assembly	OPTION				2		Fcpu					Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 x x x
.Assembly	OPTION				5		High_Clk			IHRC_16M x x x Ext_RC 32K_X'tal 12M_X'tal 4M_X'tal
.Assembly	OPTION				8		Watch_Dog 		x x x x x Enable x x x x Disable x x x x Always_On 
.Assembly	OPTION				12	Fix_High
.Assembly	OPTION				13	Ext_Reset_Length   No 128*ILRC
.Assembly	OPTION				14	Fix_Low
.Assembly	OPTION				15	Low_Power			Disable Enable

; Code Option 0x5FFE
.Assembly	OPTION				16				Fix_Low
.Assembly	OPTION				17				Fix_High
.Assembly	OPTION				18				Fix_Low
.Assembly	OPTION				19				Fix_High
.Assembly	OPTION				20				Fix_High
.Assembly	OPTION				21				Fix_Low
.Assembly	OPTION				22				Fix_High
.Assembly	OPTION				23				Fix_Low
.Assembly	OPTION				24				Fix_Low
.Assembly	OPTION				25				Fix_High
.Assembly	OPTION				26				Fix_Low
.Assembly	OPTION				27				Fix_High
.Assembly	OPTION				28 : 31		Fix_High

; Code Option 0x5FFD
.Assembly	OPTION		  	32 : 40		Fix_High
.Assembly	OPTION		  	41				LVD			LVD_MAX LVD_H LVD_M LVD_L
.Assembly	OPTION		  	43 				Fix_High		 
.Assembly	OPTION		  	44 : 47		Fix_High

; Code Option 0x5FFC
.Assembly	OPTION				48 : 63		Fix_High
.Assembly	OPTION				2ffh
	L					EQU		0x80
	H					EQU		0x81
	R					EQU		0x82
	Z					EQU		0x83
	Y					EQU		0x84
	X					EQU		0x85
	
	PFLAG			EQU		0x86
	FZ				EQU		PFLAG.0
	FDC				EQU		PFLAG.1
	FC				EQU		PFLAG.2
	FLVD24		EQU		PFLAG.4
	FLVD36		EQU		PFLAG.5	
	FNPD			EQU		PFLAG.6
	FNT0			EQU		PFLAG.7

	RBANK			EQU		0x87
	FRBNKS0		EQU		RBANK.0
	FRBNKS1		EQU		RBANK.1
	FRBNKS2		EQU		RBANK.2
	FRBNKS3		EQU		RBANK.3

	LCDM			EQU		0x89
	FLCDENB		EQU		LCDM.0
	FP2SEG		EQU		LCDM.2
	FRCLK			EQU		LCDM.3
	FRES0			EQU		LCDM.6
	FRES1			EQU		LCDM.7

	CPM				EQU		0x8A
	FAREGEN1	EQU		CPM.0
	FAREGEN2	EQU		CPM.1

	CPCKS			EQU		0x8B
	FCPCKS0		EQU		CPCKS.0
	FCPCKS1		EQU		CPCKS.1

	CALIHRCH	EQU		0x8C
	FCALIHRCH0 EQU		CALIHRCH.0
	FCALIHRCH1 EQU		CALIHRCH.1
	FCALIHRCH2 EQU		CALIHRCH.2
	FTC1CALCKS EQU		CALIHRCH.6
	FCALSTART  EQU		CALIHRCH.7
		
	CALIHRCL	EQU		0x8D
	FCALIHRCL0 EQU		CALIHRCL.0
	FCALIHRCL1 EQU		CALIHRCL.1
	FCALIHRCL2 EQU		CALIHRCL.2
	FCALIHRCL3 EQU		CALIHRCL.3
	FCALIHRCL4 EQU		CALIHRCL.4
	FCALIHRCL5 EQU		CALIHRCL.5
	
	TRIM2			EQU		0x8E
	FDVDDR_0	EQU		TRIM2.0
	FDVDDR_1	EQU		TRIM2.1
	FDVDDR_2	EQU		TRIM2.2	
	FDVDDR_3	EQU		TRIM2.3
	
	TRIM1			EQU		0x8F
	FAVDDR2_0	EQU		TRIM1.0
	FAVDDR2_1	EQU		TRIM1.1
	FAVDDR2_2	EQU		TRIM1.2	
	FAVDDR2_3	EQU		TRIM1.3	
	FAVDDR1_0	EQU		TRIM1.4
	FAVDDR1_1	EQU		TRIM1.5
	FAVDDR1_2	EQU		TRIM1.6	
	FAVDDR1_3	EQU		TRIM1.7		

	STK15L		EQU		090h
	STK15H		EQU		091h
	STK14L		EQU		092h
	STK14H		EQU		093h
	STK13L		EQU		094h
	STK13H		EQU		095h
	STK12L		EQU		096h
	STK12H		EQU		097h
	STK11L		EQU		098h
	STK11H		EQU		099h
	STK10L		EQU		09Ah
	STK10H		EQU		09Bh
	STK9L			EQU		09Ch
	STK9H			EQU		09Dh
	STK8L			EQU		09Eh
	STK8H			EQU		09Fh
	STK7L			EQU		0A0h
	STK7H			EQU		0A1h
	STK6L			EQU		0A2h
	STK6H			EQU		0A3h
	STK5L			EQU		0A4h
	STK5H			EQU		0A5h
	STK4L			EQU		0A6h
	STK4H			EQU		0A7h
	STK3L			EQU		0A8h
	STK3H			EQU		0A9h
	STK2L			EQU		0AAh
	STK2H			EQU		0ABh
	STK1L			EQU		0ACh
	STK1H			EQU		0ADh
	STK0L			EQU		0AEh
	STK0H			EQU		0AFh

	ADM				EQU		0B1H
	FCHS0			EQU		ADM.0
	FCHS1			EQU		ADM.1
	FCHS2			EQU		ADM.2
	FGCHS			EQU		ADM.4
	FEOC			EQU		ADM.5
	FADS			EQU		ADM.6
	FADENB		EQU		ADM.7
		
	ADB				EQU_R	0B2H

	ADR				EQU		0B3H
	FADB0			EQU_R	ADR.0		
	FADB1			EQU_R	ADR.1
	FADB2			EQU_R	ADR.2
	FADB3			EQU_R	ADR.3
	FADCKS0		EQU		ADR.4
	FADCKS1		EQU		ADR.5
	FADCKS2		EQU		ADR.6												

	SIOM			EQU		0B4H
	FCPHA			EQU		SIOM.0
	FCPOL			EQU		SIOM.1
	FSCKMD		EQU		SIOM.2
	FMLSB			EQU		SIOM.3
	FSRATE0		EQU		SIOM.4
	FSRATE1		EQU		SIOM.5
	FSTART		EQU		SIOM.6						
	FSENB			EQU		SIOM.7

	SIOR			EQU_W	0B5H
	SIOB			EQU		0B6H

	P0M				EQU		0B8H
	FP00M			EQU		P0M.0	
	FP01M			EQU		P0M.1

	PGIA2CKS	EQU		0B9H
	
	PGIA2M		EQU		0BAH
	FPGIA2ENB	EQU		PGIA2M.0	
	FP3GS0		EQU		PGIA2M.1	
	FP3GS1		EQU		PGIA2M.2	
	FP4GS0		EQU		PGIA2M.4	
	FP4GS1		EQU		PGIA2M.5	
	FP4GS2		EQU		PGIA2M.6	
	FP4GS3		EQU		PGIA2M.7	

	PGIA1CKS	EQU		0BBH

	PGIA1M		EQU		0BCH
	FPGIA1ENB	EQU		PGIA1M.0	
	FP1GS0		EQU		PGIA1M.1	
	FP1GS1		EQU		PGIA1M.2	
	FP2GS0		EQU		PGIA1M.4	
	FP2GS1		EQU		PGIA1M.5	
	FP2GS2		EQU		PGIA1M.6	
	FP2GS3		EQU		PGIA1M.7	

	OPM				EQU		0BDH
	FOP1ENB		EQU		OPM.0	
	FOP2ENB		EQU		OPM.1
	FOP1UGB		EQU		OPM.2	
	FOP2UGB		EQU		OPM.3

	P4CON			EQU_W	0xBE
	FP4CON0		EQU_W	P4CON.0
	FP4CON1		EQU_W	P4CON.1
	FP4CON2		EQU_W	P4CON.2
	FP4CON3		EQU_W	P4CON.3
	FP4CON4		EQU_W	P4CON.4
	FP4CON5		EQU_W	P4CON.5
	FP4CON6		EQU_W	P4CON.6

	PEDGE			EQU		0BFH
	FP00G0		EQU		PEDGE.0
	FP00G1		EQU		PEDGE.1	
	FP01G0		EQU		PEDGE.2		
	FP01G1		EQU		PEDGE.3

	P1W				EQU_W	0C0H
	FP10W			EQU_W	P1W.0
	FP11W			EQU_W	P1W.1
	FP12W			EQU_W	P1W.2
	FP13W			EQU_W	P1W.3
	FP14W			EQU_W	P1W.4
	FP15W			EQU_W	P1W.5

	P1M				EQU		0C1H
	FP10M			EQU		P1M.0
	FP11M			EQU		P1M.1
	FP12M			EQU		P1M.2
	FP13M			EQU		P1M.3
	FP14M			EQU		P1M.4
	FP15M			EQU		P1M.5

	P2M				EQU		0C2H
	FP20M			EQU		P2M.0
	FP21M			EQU		P2M.1
	FP22M			EQU		P2M.2
	FP23M			EQU		P2M.3

	P4M				EQU		0C4H
	FP40M			EQU		P4M.0
	FP41M			EQU		P4M.1
	FP42M			EQU		P4M.2
	FP43M			EQU		P4M.3
	FP44M			EQU		P4M.4
	FP45M			EQU		P4M.5
	FP46M			EQU		P4M.6


	P5M				EQU		0C5H
	FP50M			EQU		P5M.0
	FP51M			EQU		P5M.1
	FP52M			EQU		P5M.2
	FP53M			EQU		P5M.3
	FP54M			EQU		P5M.4
	FP55M			EQU		P5M.5
	FP56M			EQU		P5M.6

	INTRQ1		EQU		0C6H
	FP10IRQ		EQU		INTRQ1.0
	FP11IRQ		EQU		INTRQ1.1
	FP12IRQ		EQU		INTRQ1.2
	FP13IRQ		EQU		INTRQ1.3
	FP14IRQ		EQU		INTRQ1.4
	FP15IRQ		EQU		INTRQ1.5
	FADCIRQ		EQU		INTRQ1.6
	FSIOIRQ		EQU		INTRQ1.7

	INTEN1		EQU		0C7H
	FP10IEN		EQU		INTEN1.0
	FP11IEN		EQU		INTEN1.1	
	FP12IEN		EQU		INTEN1.2
	FP13IEN		EQU		INTEN1.3	
	FP14IEN		EQU		INTEN1.4	
	FP15IEN		EQU		INTEN1.5	
	FADCIEN		EQU		INTEN1.6	
	FSIOIEN		EQU		INTEN1.7	

	INTRQ0		EQU		0C8H
	FP00IRQ		EQU		INTRQ0.0
	FP01IRQ		EQU		INTRQ0.1
	FTXIRQ		EQU		INTRQ0.2
	FRXIRQ		EQU		INTRQ0.3
	FT0IRQ		EQU		INTRQ0.4
	FT1IRQ		EQU		INTRQ0.5
	FTC0IRQ		EQU		INTRQ0.6
	FTC1IRQ		EQU		INTRQ0.7

	INTEN0		EQU		0C9H
	FP00IEN		EQU		INTEN0.0
	FP01IEN		EQU		INTEN0.1
	FTXIEN		EQU		INTEN0.2
	FRXIEN		EQU		INTEN0.3
	FT0IEN		EQU		INTEN0.4
	FT1IEN		EQU		INTEN0.5
	FTC0IEN		EQU		INTEN0.6
	FTC1IEN		EQU		INTEN0.7

	OSCM			EQU		0CAH
	FSTPHX		EQU		OSCM.1
	FCLKMD		EQU		OSCM.2
	FCPUM0		EQU		OSCM.3							
	FCPUM1		EQU		OSCM.4
		
	WDTR			EQU_W	0CCH				
	TC0R			EQU_W	0CDH
	PCL				EQU		0CEH
	PCH				EQU		0CFH

	P0				EQU		0D0H
	FP00			EQU		P0.0
	FP01			EQU		P0.1

	P1				EQU		0D1H
	FP10			EQU		P1.0
	FP11			EQU		P1.1
	FP12			EQU		P1.2
	FP13			EQU		P1.3
	FP14			EQU		P1.4
	FP15			EQU		P1.5

	P2				EQU		0D2H
	FP20			EQU		P2.0
	FP21			EQU		P2.1
	FP22			EQU		P2.2
	FP23			EQU		P2.3

	P4				EQU		0D4H
	FP40			EQU		P4.0
	FP41			EQU		P4.1
	FP42			EQU		P4.2
	FP43			EQU		P4.3
	FP44			EQU		P4.4
	FP45			EQU		P4.5
	FP46			EQU		P4.6

	P5				EQU		0D5H
	FP50			EQU		P5.0
	FP51			EQU		P5.1
	FP52			EQU		P5.2
	FP53			EQU		P5.3
	FP54			EQU		P5.4
	FP55			EQU		P5.5
	FP56			EQU		P5.6

	T1M				EQU		0D6H
	FT1CKS		EQU		T1M.3
	FT1RATE0	EQU		T1M.4
	FT1RATE1	EQU		T1M.5
	FT1RATE2	EQU		T1M.6
	FT1ENB		EQU		T1M.7

	T1C				EQU		0D7H

	T0M				EQU		0D8H
	FT0TB			EQU		T0M.0	
	FTC0GN		EQU		T0M.1		
	FTC0X8		EQU		T0M.2	
	FTC1X8		EQU		T0M.3
	FT0RATE0	EQU		T0M.4
	FT0RATE1	EQU		T0M.5
	FT0RATE2	EQU		T0M.6				
	FT0ENB		EQU		T0M.7

	T0C				EQU		0D9H

	TC0M			EQU		0DAH
	FPWM0OUT	EQU		TC0M.0
	FTC0OUT		EQU		TC0M.1
	FALOAD0		EQU		TC0M.2
	FTC0CKS		EQU		TC0M.3
	FTC0RATE0	EQU		TC0M.4
	FTC0RATE1	EQU		TC0M.5
	FTC0RATE2	EQU		TC0M.6													
	FTC0ENB		EQU		TC0M.7

	TC0C			EQU		0DBH

	TC1M			EQU		0DCH
	FPWM1OUT	EQU		TC1M.0
	FTC1OUT		EQU		TC1M.1
	FALOAD1		EQU		TC1M.2
	FTC1CKS		EQU		TC1M.3
	FTC1RATE0	EQU		TC1M.4
	FTC1RATE1	EQU		TC1M.5
	FTC1RATE2	EQU		TC1M.6													
	FTC1ENB		EQU		TC1M.7

	TC1C			EQU		0DDH
	TC1R			EQU_W	0DEH

	STKP			EQU		0DFH
	FSTKPB0		EQU		STKP.0
	FSTKPB1		EQU		STKP.1
	FSTKPB2		EQU		STKP.2					
	FSTKPB3		EQU		STKP.3
	FSTKPB4		EQU		STKP.4				
	FGIE			EQU		STKP.7

	P0UR			EQU_W	0E0H
	FP00R			EQU_W	P0UR.0
	FP01R			EQU_W	P0UR.1

	P1UR			EQU_W	0E1H
	FP10R			EQU_W	P1UR.0
	FP11R			EQU_W	P1UR.1
	FP12R			EQU_W	P1UR.2
	FP13R			EQU_W	P1UR.3

	P2UR			EQU_W	0E2H
	FP20R			EQU_W	P2UR.0
	FP21R			EQU_W	P2UR.1
	FP22R			EQU_W	P2UR.2
	FP23R			EQU_W	P2UR.3

	P4UR			EQU_W	0E4H
	FP40R			EQU_W	P4UR.0
	FP41R			EQU_W	P4UR.1
	FP42R			EQU_W	P4UR.2
	FP43R			EQU_W	P4UR.3
	FP44R			EQU_W	P4UR.4
	FP45R			EQU_W	P4UR.5
	FP46R			EQU_W	P4UR.6

	P5UR			EQU_W	0E5H
	FP50R			EQU_W	P5UR.0
	FP51R			EQU_W	P5UR.1
	FP52R			EQU_W	P5UR.2
	FP53R			EQU_W	P5UR.3
	FP54R			EQU_W	P5UR.4
	FP55R			EQU_W	P5UR.5
	FP56R			EQU_W	P5UR.6

	@HL				EQU		0E6H
	@YZ				EQU		0E7H
	
	P1OC    	EQU_W	0E9H
	FP10OC  	EQU_W	P1OC.0
  FP11OC  	EQU_W	P1OC.1
	FP12OC  	EQU_W	P1OC.2
  FP13OC  	EQU_W	P1OC.3
  FP50OC  	EQU_W	P1OC.4    
  FP51OC  	EQU_W	P1OC.5
  FP52OC  	EQU_W	P1OC.6

	T2M	    	EQU		0EAH
	FT2ENB  	EQU		T2M.7
  FT2rate2 	EQU		T2M.6
	FT2rate1 	EQU		T2M.5
  FT2rate0 	EQU		T2M.4
	FT2CKS  	EQU		T2M.3

	T2CL    	EQU		0EBH
	T2CH    	EQU		0ECH
	
	CPT2M    	EQU		0EDH
	FCPT2EN  	EQU		CPT2M.7
	FCPT2MD  	EQU		CPT2M.3
	FCPT2Start EQU	CPT2M.2
	FCPT2G1  	EQU		CPT2M.1				
	FCPT2G0  	EQU		CPT2M.0
		
	CPT2CL   	EQU		0EEH
	CPT2CH   	EQU		0EFH

	URRX			EQU		0F0H
	FURS0			EQU		URRX.0
	FURS1			EQU		URRX.1
	FURS2			EQU		URRX.2					
	FUFMER		EQU		URRX.3
	FURXPC		EQU		URRX.4				
	FURXPS		EQU		URRX.5
	FURXPEN		EQU		URRX.6				
	FURXEN		EQU		URRX.7
	
	URTX			EQU		0F1H
	FUTXBZ		EQU		URTX.2
	FURXBZ		EQU		URTX.3
	FUTXBRK		EQU		URTX.4					
	FUTXPS		EQU		URTX.5
	FUTXPEN		EQU		URTX.6
	FUTXEN		EQU		URTX.7	

	URCR			EQU		0F2H
	FURCR0		EQU		URCR.0
	FURCR1		EQU		URCR.1
	FURCR2		EQU		URCR.2
	FURCR3		EQU		URCR.3
	FURCR4		EQU		URCR.4
	FURCR5		EQU		URCR.5
	FURCR6		EQU		URCR.6													
	FURCR7		EQU		URCR.7

	UTXD			EQU		0F3H
	FUTXD0		EQU		UTXD.0
	FUTXD1		EQU		UTXD.1
	FUTXD2		EQU		UTXD.2
	FUTXD3		EQU		UTXD.3
	FUTXD4		EQU		UTXD.4
	FUTXD5		EQU		UTXD.5
	FUTXD6		EQU		UTXD.6
	FUTXD7		EQU		UTXD.7						
	
	URXD			EQU		0F4H
	FURXD0		EQU		URXD.0	
	FURXD1		EQU		URXD.1	
	FURXD2		EQU		URXD.2	
	FURXD3		EQU		URXD.3		
	FURXD4		EQU		URXD.4		
	FURXD5		EQU		URXD.5		
	FURXD6		EQU		URXD.6	
	FURXD7		EQU		URXD.7		

	INTRQ2		EQU		0F5H
	FT2IRQ		EQU		INTRQ2.0	
	FT3IRQ		EQU		INTRQ2.1
	
	INTEN2		EQU		0F6H
	FT2IEN		EQU		INTEN2.0	
	FT3IEN		EQU		INTEN2.1
			
	DAM				EQU		0F7H
	FDAEN			EQU		DAM.7

	DABL			EQU		0F8H
	DABH			EQU		0F9H
	
	T3M	    	EQU		0FAH
	FT3ENB  	EQU		T3M.7
  FT3rate2 	EQU		T3M.6
	FT3rate1 	EQU		T3M.5
  FT3rate0 	EQU		T3M.4
	FT3CKS  	EQU		T3M.3

	T3CL    	EQU		0FBH
	T3CH    	EQU		0FCH
	
	CPT3M    	EQU		0FDH
	FCPT3EN  	EQU		CPT3M.7
	FCPT3MD  	EQU		CPT3M.3
	FCPT3Start EQU	CPT3M.2
	FCPT3G1  	EQU		CPT3M.1				
	FCPT3G0  	EQU		CPT3M.0
		
	CPT3CL   	EQU		0FEH
	CPT3CH   	EQU		0FFH	

; -----------------------------------------------------
; Clear watchdog macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2 

	@RST_WDT	macro		
 		   MOV  A, #0x5A
		   B0MOV  WDTR, A
	endm
	
; -----------------------------------------------------
; Sleep Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 1

	SleepMode	macro	
		B0BSET	FCPUM0
	endm
; -----------------------------------------------------
; Green Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 3

	GreenMode	macro	
		B0BSET	FCPUM1
		NOP
		NOP
	endm
; -----------------------------------------------------
; Slow Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 2

	SLowMode	macro	
		B0BSET	FCLKMD
		B0BSET	FSTPHX
	endm
; -----------------------------------------------------
;  Slow mode to Normal Mode control macro for compatibility in S8KD-2 ICE
;  
; Total Cycle: 5

	Slow2Normal	macro	
		B0BCLR	FSTPHX
		NOP
		NOP
		NOP
		B0BCLR	FCLKMD
	endm
; -----------------------------------------------------	
.TEXT
{
	//{{SONIX_OPTION_RULE		
	
	IF Noise_Filter == Enable
	{

	   OPTION    2 	Fcpu	Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 x x x
	}
	
	IF Noise_Filter == Disable
	{

	   OPTION    2	Fcpu	Fosc/1 Fosc/2 Fosc/4 Fosc/8 Fosc/16 x x x
 	}   
	ENDP
	//}}SONIX_OPTION_RULE
}