 
/*------------------------------------------------------------------------------
;  CHIP: SZK671
;  Revision History
;
;  IHRC auto adjust Enable
;
;  V02   2012/06/22	Fourth Version
;  V03   2012/07/12  	1. Add "PCL_READ_LIMIT" Key word
;-----------------------------------------------------------------------------*/

.ASSEMBLY    	RedWrt_FORMAT	1
.Assembly	INC_VER		3
.Assembly	ASM_FORMAT	1
.Assembly	RAM_Size	160

.Assembly	INSTRUMENT	SZK671
.Assembly	BIT_FILE	SZK671

.Assembly	OTP_BODY_SIZE	0x1000
.Assembly	USER_ROM_SIZE	0x0FFC

.Assembly	MASK_TEST_CODE	0x0000, 0x0000, 0x0000, 0x0000

.Assembly	PGM_TYPE	6
.Assembly	CHIP_ID		0x2815
.Assembly	command	Enable_ORG4_7, RBANK_LIMIT, PCL_READ_LIMIT
.Assembly	Port_Pins		8, 8, 8, 8, 0, 6

.Assembly	USB_FIFO_Size	32, 32

.Assembly	USB_FIFO_Start_Address	0x120, 0x120

; Code Option 0x0FFF
.Assembly	OPTION		0		Fix_Low
.Assembly	OPTION		1		Security	Enable	Disable
.Assembly	OPTION		2		Fcpu		Fosc/1 Fosc/2 Fosc/4 x
.Help
{
	Fcpu		: 	"Only Effective for HIGH Clock"
}
;For regulator adjust
.Assembly	OPTION		4		Fix_High
.Assembly 	OPTION		5		Fix_Low
.Assembly	OPTION		6		Fix_Low
;
.Assembly	OPTION		7		Fix_Low
.Assembly	OPTION		8		Watch_Dog	Always_On x x x x Enable x x x x Disable x x x x x
.Assembly	OPTION		12		Reset_Pin       P37 	Reset
.Assembly	OPTION		13		Rst_Length  	No 	128*ILRC
.Assembly	OPTION		14		Fix_High
.Assembly	OPTION		15		Fix_Low

; Code Option 0x0FFE
.Assembly	OPTION		16		Fix_Low
.Assembly	OPTION		17		Fix_High
.Assembly	OPTION		18		Fix_Low
.Assembly	OPTION		19		Fix_High
.Assembly	OPTION		20		Fix_High
.Assembly	OPTION		21		Fix_Low
.Assembly	OPTION		22		Fix_High
.Assembly	OPTION		23		Fix_Low
.Assembly	OPTION		24		Fix_Low
.Assembly	OPTION		25		Fix_High
.Assembly	OPTION		26		Fix_Low
.Assembly	OPTION		27		Fix_High
.Assembly	OPTION		28 : 31		Fix_High

; Code Option 0x0FFD
;.Assembly	OPTION		32 : 47 		Fix_High

.Assembly	OPTION		32 		Fix_low
.Assembly	OPTION		33 		Fix_High
.Assembly	OPTION		34 		Fix_High
.Assembly	OPTION		35 		Fix_low
.Assembly	OPTION		36 		Fix_low
.Assembly	OPTION		37 		Fix_High
.Assembly	OPTION		38 		Fix_low
.Assembly	OPTION		39 		Fix_High

.Assembly	OPTION		40 		Fix_High
.Assembly	OPTION		41 		Fix_low
.Assembly	OPTION		42 		Fix_low
.Assembly	OPTION		43 		Fix_High
.Assembly	OPTION		44 		Fix_low
.Assembly	OPTION		45 		Fix_low
.Assembly	OPTION		46 		Fix_low
.Assembly	OPTION		47		Fix_low

; Code Option 0x0FFC

;.Assembly	OPTION		48 : 63 		Fix_High

.Assembly	OPTION		48 		Fix_High
.Assembly	OPTION		49 		Fix_High
.Assembly	OPTION		50 		Fix_High
.Assembly	OPTION		51 		Fix_High
.Assembly	OPTION		52 		Fix_High
.Assembly	OPTION		53 		Fix_High
.Assembly	OPTION		54 		Fix_High
.Assembly	OPTION		55 		Fix_High

.Assembly	OPTION		56 		Fix_low
.Assembly	OPTION		57 		Fix_low
.Assembly	OPTION		58		Fix_low
.Assembly	OPTION		59 		Fix_low
.Assembly	OPTION		60 		Fix_High
.Assembly	OPTION		61 		Fix_low
.Assembly	OPTION		62 		Fix_low
.Assembly	OPTION		63 		Fix_low

.Assembly	OPTION		2ffh

	L			EQU		80H
	H			EQU		81H
	R			EQU		82H
	Z			EQU		83H
	Y			EQU		84H
	
	PFLAG		EQU		86H
		FZ		EQU		PFLAG.0
		FDC		EQU		PFLAG.1
		FC		EQU		PFLAG.2
		FLVD36		EQU		PFLAG.5
		FNPD		EQU		PFLAG.6
		FNT0		EQU		PFLAG.7

	RBANK		EQU		87H
		FRBNKS0		EQU		RBANK.0

	TC0M		EQU		088H
		FTC0ENB		EQU	TC0M.7
		FTC0RATE2	EQU	TC0M.6
		FTC0RATE1	EQU	TC0M.5
		FTC0RATE0	EQU	TC0M.4
    		FALOAD0 	EQU 	TC0M.2
    
	TC0C		EQU		089H	
	TC0R			EQU_W		08AH
	CFS			EQU		08EH
		FIHRCOEN	EQU	CFS.7
	
	UDA		EQU		090H
		FUDE		EQU	UDA.7
		FUDA6		EQU	UDA.6
		FUDA5		EQU	UDA.5
		FUDA4		EQU	UDA.4
		FUDA3		EQU	UDA.3
		FUDA2		EQU	UDA.2
		FUDA1		EQU	UDA.1
		FUDA0		EQU	UDA.0

	USTATUS		EQU		091H
		FBUS_RST	EQU_R	USTATUS.4
		FSUSPEND	EQU_R	USTATUS.3
		FEP0SETUP	EQU	USTATUS.2
		FEP0IN		EQU	USTATUS.1
		FEP0OUT		EQU	USTATUS.0
		
	EP0OUT_CNT	EQU		092H
		FUEP0OC4	EQU	EP0OUT_CNT.4
		FUEP0OC3	EQU	EP0OUT_CNT.3
		FUEP0OC2	EQU	EP0OUT_CNT.2
		FUEP0OC1	EQU	EP0OUT_CNT.1
		FUEP0OC0	EQU	EP0OUT_CNT.0
	
	USB_INT_EN	EQU		093H
		FREG_EN		EQU	USB_INT_EN.7
		FDP_PU_EN	EQU	USB_INT_EN.6
		FEP2_NAK_EN	EQU		USB_INT_EN.3
		FEP1_NAK_EN	EQU		USB_INT_EN.2
		FUE2D		EQU	USB_INT_EN.1
		FUE1D		EQU	USB_INT_EN.0
	
	EP_ACK		EQU		094H
		FEP2_NAK	EQU	EP_ACK.3
		FEP1_NAK	EQU	EP_ACK.2
		FEP2_ACK	EQU	EP_ACK.1
		FEP1_ACK	EQU	EP_ACK.0
	
		
	UE0R		EQU		096H
		FUE0E		EQU	UE0R.7
		FUE0M1		EQU	UE0R.6
		FUE0M0		EQU	UE0R.5
		FUE0C3		EQU	UE0R.3
		FUE0C2		EQU	UE0R.2
		FUE0C1		EQU	UE0R.1
		FUE0C0		EQU	UE0R.0

	UE1R		EQU		097H
		FUE1E		EQU	UE1R.7
		FUE1M1		EQU	UE1R.6
		FUE1M0		EQU	UE1R.5
		FUE1C3		EQU	UE1R.3
		FUE1C2		EQU	UE1R.2
		FUE1C1		EQU	UE1R.1
		FUE1C0		EQU	UE1R.0

	UE2R		EQU		098H
		FUE2E		EQU	UE2R.7
		FUE2M1		EQU	UE2R.6
		FUE2M0		EQU	UE2R.5
		FUE2C3		EQU	UE2R.3
		FUE2C2		EQU	UE2R.2
		FUE2C1		EQU	UE2R.1
		FUE2C0		EQU	UE2R.0
		
	UPID		EQU		0ABH
		FEP0OUT_EN	EQU	UPID.7
	 	FUBDE		EQU	UPID.2
		FDDP		EQU	UPID.1
		FDDN		EQU	UPID.0

	UTOGGLE		EQU		0ACH
		FEP2_DATA01	EQU	UTOGGLE.1
		FEP1_DATA01	EQU	UTOGGLE.0	

	UNDT_EN		EQU		0ADH

	UNDT		EQU		0AEH
		FNDT		EQU	UNDT.0

	EP0_STALL	EQU		0B0H
		FEP0_OUT_STALL	EQU	EP0_STALL.1
		FEP0_IN_STALL	EQU	EP0_STALL.0

	P0M		EQU		0B8H		
		FP07M		EQU	P0M.7
		FP06M		EQU	P0M.6
		FP05M		EQU	P0M.5
		FP04M		EQU	P0M.4
		FP03M		EQU	P0M.3
		FP02M		EQU	P0M.2
		FP01M		EQU	P0M.1
		FP00M		EQU	P0M.0
	
	PEDGE		EQU		0BFH		
		FP00G1	EQU		PEDGE.1
		FP00G0	EQU		PEDGE.0

	P1M			EQU		0C1H
		FP17M	EQU		P1M.7
		FP16M	EQU		P1M.6
		FP15M	EQU		P1M.5
		FP14M	EQU		P1M.4
		FP13M	EQU		P1M.3
		FP12M	EQU		P1M.2
		FP11M	EQU		P1M.1
		FP10M	EQU		P1M.0

	P2M			EQU		0C2H
		FP27M	EQU		P2M.7
		FP26M	EQU		P2M.6
		FP25M	EQU		P2M.5
		FP24M	EQU		P2M.4
		FP23M	EQU		P2M.3
		FP22M	EQU		P2M.2
		FP21M	EQU		P2M.1
		FP20M	EQU		P2M.0

	P3M			EQU		0C3H
		FP36M	EQU		P3M.6
		FP35M	EQU		P3M.5
		FP34M	EQU		P3M.4
		FP33M	EQU		P3M.3
		FP32M	EQU		P3M.2
		FP31M	EQU		P3M.1
		FP30M	EQU		P3M.0
		
	P5M			EQU		0C5H
  		FP55M	EQU		P5M.5	  		
  		FP54M	EQU		P5M.4
  		FP53M	EQU		P5M.3	  		
  		FP52M	EQU		P5M.2
  		FP51M	EQU		P5M.1
  		FP50M	EQU		P5M.0	
  				
	INTRQ		EQU		0C8H
		FNDTIRQ	EQU		INTRQ.7
		FUSBIRQ	EQU		INTRQ.6
		FTC0IRQ	EQU		INTRQ.5
		FWAKEIRQ 	EQU		INTRQ.2
		FP00IRQ	EQU		INTRQ.0

	INTEN		EQU		0C9H
		FNDTIEN	EQU		INTEN.7
		FUSBIEN	EQU		INTEN.6
		FTC0IEN	EQU		INTEN.5
		FWAKEIEN 	EQU		INTEN.2
		FP00IEN	EQU		INTEN.0

	OSCM		EQU		0CAH
		FCPUM1	EQU		OSCM.4
		FCPUM0	EQU		OSCM.3
		FCLKMD	EQU		OSCM.2
		FSTPHX	EQU		OSCM.1

	WDTR		EQU_W	0CCH
    
	PCL			EQU		0CEH
	PCH			EQU		0CFH

	P0			EQU 	0D0H		
		FP07	EQU 	P0.7
		FP06	EQU 	P0.6
		FP05	EQU 	P0.5
		FP04	EQU 	P0.4
		FP03	EQU 	P0.3
		FP02	EQU 	P0.2
		FP01	EQU 	P0.1
		FP00	EQU 	P0.0

	P1			EQU 	0D1H
		FP17	EQU 	P1.7
		FP16	EQU 	P1.6
		FP15	EQU 	P1.5
		FP14	EQU 	P1.4
		FP13	EQU 	P1.3
		FP12	EQU 	P1.2
		FP11	EQU 	P1.1
		FP10	EQU 	P1.0

	P2			EQU 	0D2H
		FP27	EQU 	P2.7
		FP26	EQU 	P2.6
		FP25	EQU 	P2.5
		FP24	EQU 	P2.4
		FP23	EQU 	P2.3
		FP22	EQU 	P2.2
		FP21	EQU 	P2.1
		FP20	EQU 	P2.0

	P3			EQU 	0D3H
		FP37	EQU_R 	P3.7
		FP36	EQU 	P3.6
		FP35	EQU 	P3.5
		FP34	EQU 	P3.4
		FP33	EQU 	P3.3
		FP32	EQU 	P3.2
		FP31	EQU 	P3.1
		FP30	EQU 	P3.0
	
	P5			EQU		0D5H
		FP55	EQU		P5.5
		FP54	EQU		P5.4		
		FP53	EQU		P5.3		
		FP52	EQU		P5.2
		FP51	EQU		P5.1
		FP50	EQU		P5.0	

	STKP			EQU		0DFH
		FGIE	EQU		STKP.7
		FSTKPB2	EQU		STKP.2
		FSTKPB1	EQU		STKP.1
		FSTKPB0	EQU		STKP.0

	P0UR        EQU_W     0E0H

	P1UR        EQU_W     0E1H

	P2UR        EQU_W     0E2H

	P3UR        EQU_W     0E3H

	P5UR        EQU_W     0E5H
       
	@HL			EQU		0E6H
	@YZ			EQU		0E7H

	NDT_HW		EQU		0E8h
	EFT_FLAG	EQU		NDT_HW.0
	NDT_ENB		EQU		NDT_HW.1
	
	STK7L		EQU		0F0h
	STK7H		EQU		0F1h
	STK6L		EQU		0F2h
	STK6H		EQU		0F3h
	STK5L		EQU		0F4h
	STK5H		EQU		0F5h
	STK4L		EQU		0F6h
	STK4H		EQU		0F7h

	STK3L		EQU		0F8h
	STK3H		EQU		0F9h
	STK2L		EQU		0FAh
	STK2H		EQU		0FBh
	STK1L		EQU		0FCh
	STK1H		EQU		0FDh
	STK0L		EQU		0FEh
	STK0H		EQU		0FFh

; -----------------------------------------------------
; Clear watchdog macro. 
;  
; Total Cycle: 2

	@RST_WDT	macro
		MOV	A, #0x5A
		B0MOV	WDTR, A
	endm
; -----------------------------------------------------
	
.TEXT
{
	//{{SONIX_OPTION_RULE
        
	ENDP
	//}}SONIX_OPTION_RULE
}