//================================================================================
//Author	: Maple
//Date  	: 2023-6-19
//Project	: 
//================================================================================


//================================================================================
//			  				BL08P150-S8         
//						  VDD |1     8| VSS           
//	  		  PWM01X/OSC1/PB5 |2     7| PB0/PWM0X/INT/CIN+           
// MODEL/CIN-/PWM01X/OSCO/PB4 |3     6| PB1/PWM01X/CIN-/SDA
//	 	   VPP/PWM1X/RSTB/PB3 |4     5| PB2/PWM1X/T0CK1/SCK  

//							RW1602B0P8-S8         
//						  PB2 |1     8| PB3           
//	  		              PB1 |2     7| VDD           
//                        PB4 |3     6| GND
//	 	   				  XTP |4     5| ANT  
//================================================================================
//ע⣺1,дĴBANK,CҪûBANK
//		2,5Ӳȶջ,5
//================================================================================
#include 	<BL08P150.h> 
#include 	"HS6220.h"

//붨
#define		D_TEST				0
//================================================================================


//================================================================================
#define		D_PIN_HIGH			1
#define		D_PIN_LOW			0

#define		D_BIT0				0x01
#define		D_BIT1				0x02
#define		D_BIT2				0x04
#define		D_BIT3				0x08
#define		D_BIT4				0x10
#define		D_BIT5				0x20
#define		D_BIT6				0x40
#define		D_BIT7				0x80

#define		u8					unsigned char
#define		u16					unsigned int
#define		u32					unsigned long
//--------------------------------------------------------------------------------
//IO
#define		p_key1				IOB1
#define		p_key2				IOB2
#define		p_led				IOB3
#define		p_test				IOB3
//RF 
//#define		p_spi_csn			IOB5		//output high
//#define		p_spi_clk			IOB0		//output low
//#define		p_spi_mosi			IOB4		//input pull high
//--------------------------------------------------------------------------------
//


//--------------------------------------------------------------------------------
//
//ע:ȫֱҪʵʹ,ᱻŻ
//volatileͲᱻŻ
volatile	bit	b_tc0 = 0;
volatile	u8	u8_delay;
volatile 	u8	u8_trisb;						//洢PBƼĴֵ
volatile	u8	u8_tmp1;
volatile	u8	u8_tmp2;
//------------------------------------------------------------
volatile	bit	b_key1_short = 0;
volatile	bit	b_key1_long = 0;
volatile	bit	b_key2_short = 0;
volatile	bit	b_key2_long = 0;
volatile	u8	u8_key_new = 0;
volatile	u8	u8_key_old = 0;
volatile	u8	u8_key_val = 0;
volatile	u16	u16_key_cnt = 0;
#define		D_SHORTKEY_CNT		500				//0.5S
#define		D_LONGKEY_CNT		1000			//1S
#define		D_KEY_PORT			PORTB
#define		D_KEY_BIT			(D_BIT1+D_BIT2)
#define		D_KEY_BOUNCE		30				//about 30ms
#define		D_KEY1				D_BIT1
#define		D_KEY2				D_BIT2
//------------------------------------------------------------
volatile	u16	u16_timer = 0;
//------------------------------------------------------------
volatile	bit	b_tx_end;

#define		D_RF_DATA_NUM		5				//RFշݵĸ
u8	u8_data_buf[D_RF_DATA_NUM];
volatile	u8	u8_rf_ch;						//RF ͨ
volatile	u8	u8_rf_mark;						//RFݰʶ(0~255,ͬ֡Զ1,նͬ)
//================================================================================
//궨
#define		clr_wdt()			asm("clrwdt")
#define		nop()				asm("NOP")
#define		sleep()				asm("SLEEP")
#define		enable_int()		{FGIE = 1;}
#define		disable_int()		{FGIE = 0;}
//--------------------------------------------------------------------------------
#define		turnon_led()		{p_led = D_PIN_HIGH;}
#define		turnoff_led()		{p_led = D_PIN_LOW;}
//================================================================================
void system_stop(void);
void tx_key_scan(void);
void tx_key_process(void);
void rf_write_reg(u8 u8_addr, u8 u8_data);
u8	 rf_read_reg(u8 u8_addr);
void rf_write_reg_buf(u8 u8_addr, u8* u8_buf, u8 u8_len);
void rf_set_cmd(u8 u8_cmd);
void rf_init(void);
void rf_power_down(void);
void rf_power_on(void);

#define		rf_ce_low()			{rf_set_cmd(HS6220_CMD_CE_LOW);}
#define		rf_ce_high()		{rf_set_cmd(HS6220_CMD_CE_HIGH);}
#define		rf_flush_tx()		{rf_set_cmd(HS6220_FLUSH_TX);}
#define		rf_flush_rx()		{rf_set_cmd(HS6220_FLUSH_RX);}
#define		rf_tx_mode()		{rf_write_reg(HS6220_BANK0_CONFIG, 0xFA);}
#define		rf_rx_mode()		{rf_write_reg(HS6220_BANK0_CONFIG, 0xFB);}
#define		rf_carrier_mode()	{rf_write_reg(HS6220_BANK0_RF_SETUP, 0xC7);}
//================================================================================
//	ʼ GPIO
//-------------------------------------------------------------------------------- 
void gpio_init(void)
{
	OPTION = 0b00000010;
	PCON = 0b10100000;						//ʹLVR & WDT
	
//	pb0: output low			[SPI_CLK]
//	pb1: input pull high	[KEY]
//	pb2: input pull high	[KEY]
//	pb3: ouput low			[LED]
//	pb4: input pull high	[SPI_MOSI]
//	pb5: output high		[SPI_CSN]
	
	PORTB = 0x20;
//ƼĴ(PB0~5) ֻдĴ,ñݴдֵ(0:1 ->  : )
	TRISB = 0x16;
	u8_trisb = 0x16;
//ڲ(PB0~5)(0:1 -> ʹ : ֹ)
	PHCON = 0x29;
//ڲ(PB0~3)(0:1 -> ʹ : ֹ)[4λӦPB3~PB0]
	PDCON = 0xF0;
//©·(PB0~5)(0:1 -> ֹ : ʹ)
	ODCON = 0;
//˿ѡ(PB0~5)(0:1 -> Ĭ : )
	PBIC0 = 0;
//˿״̬仯ж/ѿ(PB0~5)(0:1 -> ر : ʹ)
	WUCON = 0x06;
}
//================================================================================ 


//================================================================================
//	TC0ʱ(8λۼӼʱ)
//--------------------------------------------------------------------------------
void tc0_init(void)
{	//TC0ʱ1MS
	TC0L = 0x06;				//250(1MS)		
	TC0M = 0x50;				//TC0 8λ,ʱԴ Fcpu/8=1/4M,رTC0ʱ
	
	FTC0IF = 0;
	FTC0IE = 1;					//ʹ TC0 ж
	FTC0TR = 1;					// TC0
}
//================================================================================


//================================================================================
//	ָʱ(MS) Fcpu = 2M
//--------------------------------------------------------------------------------
void delay_ms(u8 u8_ms)
{
	u16	i;
	while(u8_ms)
	{
		clr_wdt();
		for(i=0; i<142; i++)
		{	//delay 1ms(cpu = 2M)
			nop();
		}
		u8_ms--;
	}
}
//================================================================================
//	ָʱ20US Fcpu = 2M
//--------------------------------------------------------------------------------
void delay_20us(void)
{
	u8 i;

	for(i=0; i<4; i++)
	{	
		nop();
	}
}
//================================================================================
//	жʱ(ʱΪж϶ʱı)
//--------------------------------------------------------------------------------
void delay_int(u8 u8_cnt)
{
	u8_delay = u8_cnt;
	while(u8_delay)
	{
		clr_wdt();
	}
}
//================================================================================


//================================================================================
//оƬ(IDE)
//PB3ѡ	:	IO
//PB4ѡ	:	IO
//λʱ		:	PWRT=WDT=18ms
//IRCƵ		:	8M
//LVD			:	2.2V
//ģʽ	:	IRC(ڲ)
//BOR˲   	:	Enable
//ָ		:	Full(ȫ)
//˿		:	Form PIN
//Ƶѡ	:	4Ƶ(8M/4=2M,ָʱ0.5US)
//			:	Enable
//Ź		:	Enable
//================================================================================
void main(void)
{	//	Fosc = 8M; Fcpu = 2M;
//------------------------------------------------------------
	gpio_init();
	tc0_init();
//RF ϵҪ 10ms ʱϵ縴λ,֮ͨ SPI  RF в
	delay_ms(10);
	rf_init();
	enable_int();
//------------------------------------------------------------
	rf_ce_low();
	rf_tx_mode();
	
	while(1)
	{
		clr_wdt();
		
		if(b_tc0)
		{
			b_tc0 = 0;
			
			tx_key_scan();
			tx_key_process();
		}
		
		if(u8_key_new || (u16_key_cnt < D_LONGKEY_CNT))
		{	
			continue;
		}
		
		rf_ce_low();
		rf_power_down();
		system_stop();
		rf_power_on(); 
		rf_tx_mode();	
	}
}
//================================================================================
//	жϴ
//--------------------------------------------------------------------------------
void interrupt	isr(void)
{
//------------------------------------------------------------
//	TC0ж
	if(FTC0IF) 
	{
        TC0L = 0x6;			//ֵ(ʱ1MS)
		FTC0IF = 0;			//жϱ־
		
        b_tc0 = 1;			//1msʱ־
        
        if(u8_delay)
        {
        	u8_delay--;
        }
//test
    // 	p_test = ~p_test;
	}
//------------------------------------------------------------
	if(FPBIF)
	{
		FPBIF = 0;
	}
}
//================================================================================


//================================================================================
//	ϵͳ	
//--------------------------------------------------------------------------------

//================================================================================
void system_stop(void)
{
	INTFLAG = 0;					//жϱ־λ
	INTEN = 0x82;					//ʹPORTB˿ڱ仯ж(BIT7ȫжʹλ)
	PCON = 0;						//ѹֹ,IOB0ΪIO,Źֹ 
	sleep();
	nop();
	nop();
	nop();
	clr_wdt();
	PCON = 0b10100000;				//ʹLVR & WDT
	INTFLAG = 0;					//жϱ־λ
	INTEN = 0x88;					//ʹTC0 INT
}
//================================================================================
//	
//--------------------------------------------------------------------------------
void spi_write_byte(u8 u8_data)
{	//SPI дһBYTE(3ͨѶ)
	u8 i;
	
//p_spi_mosi Ϊ
	u8_trisb &= ~D_BIT4;
	TRISB = u8_trisb;
	
	for(i=0; i<8; i++)
	{
		p_spi_clk = 0;
		if(u8_data & 0x80)
		{
			p_spi_mosi = 1;
		}
		else
		{
			p_spi_mosi = 0;
		}
		p_spi_clk = 1;
		u8_data <<= 1;
	}
	p_spi_clk = 0;
	p_spi_mosi = 0;
}	
//--------------------------------------------------------------------------------
u8 spi_read_byte(void)
{	//SPI һBYTE(3ͨѶ)
	u8 i,k;
	
//p_spi_mosi Ϊ
	u8_trisb |= D_BIT4;
	TRISB = u8_trisb;
	
	for(i=0,k=0; i<8; i++)
	{
		p_spi_clk = 1;
		k <<= 1;
		if(p_spi_mosi)
		{
			k |= 1;
		}
		else
		{
			k &= 0xFE;
		}
		p_spi_clk = 0;
	}
	
	return k;
}
//================================================================================
void rf_write_reg(u8 u8_addr, u8 u8_data)
{	// Ĵַдһֵ
	p_spi_csn = 0;
	u8_addr |= HS6220_W_REGISTER;
	spi_write_byte(u8_addr);
	spi_write_byte(u8_data);				
	p_spi_csn = 1;
}
//--------------------------------------------------------------------------------
u8 rf_read_reg(u8 u8_addr)
{	//	Ĵһֵ
	u8 i;
	
	p_spi_csn = 0;
//	u8_addr |= HS6220_R_REGISTER;
	spi_write_byte(u8_addr);						
	i = spi_read_byte();		
	p_spi_csn = 1;
	
	return i;
}
//================================================================================
void rf_write_reg_buf(u8 u8_addr, u8* u8_buf, u8 u8_len)
{	// ֱӸĴַдֵ
	p_spi_csn = 0;
	u8_addr |= HS6220_W_REGISTER;
	spi_write_byte(u8_addr);
	while(u8_len)
	{
		spi_write_byte(*u8_buf);
		u8_buf++;
		u8_len--;
	}
	p_spi_csn = 1;
}
//--------------------------------------------------------------------------------
void rf_read_reg_buf(u8 u8_addr, u8* u8_buf, u8 u8_len)
{	//	ĴĶֵ
	p_spi_csn = 0;
//	u8_addr |= HS6220_R_REGISTER;
	spi_write_byte(u8_addr);
	while(u8_len)
	{
		*u8_buf = spi_read_byte();
		u8_buf++;
		u8_len--;
	}
	p_spi_csn = 1;
}
//================================================================================
void rf_set_cmd(u8 u8_cmd)
{
	p_spi_csn = 0;
	spi_write_byte(u8_cmd);
	p_spi_csn = 1;
}
//--------------------------------------------------------------------------------
void rf_clear_all_irq(void)
{	//жϱ־
	p_spi_csn = 0;
	spi_write_byte(HS6220_BANK0_STATUS + HS6220_W_REGISTER);
	spi_write_byte(0x70);
	p_spi_csn = 1;
}
//================================================================================
void rf_bank_switch(u8 u8_bank)
{
	//HS6220_BANK0_STATUS ĵ7λΪ1ʾǰBANK 1,Ϊ0ʾǰBANK 0
	u8_tmp1 = rf_read_reg(HS6220_BANK0_STATUS);
	u8_tmp1 &= D_BIT7;
	if((u8_bank && (0 == u8_tmp1)) || ((0 == u8_bank) && u8_tmp1))
	{
		p_spi_csn = 0;
		spi_write_byte(HS6220_ACTIVATE);
		spi_write_byte(HS6220_ACTIVATE_DATA);
		p_spi_csn = 1;
	}
}
//================================================================================
void rf_init(void)
{	//RF ʼ
reset_rf_int:
//RF λ	
	rf_write_reg(HS6220_BANK0_FEATURE,SOFT_RST);
	
//Ĭ3SPI,ʹ4Ҫ
//	rf_write_reg(HS6220_BANK0_DYNPD,0x08);	//4SPI
	rf_write_reg(HS6220_BANK0_DYNPD,0);		//3SPI
	
	rf_ce_low();
//RF ϵ(RXģʽ)
	rf_write_reg(HS6220_BANK0_CONFIG,0x8B);
	delay_ms(3);							//ʱ3MS()
//ģʽ
	rf_write_reg(HS6220_BANK0_PMU_CTL,0xA8);
	delay_ms(2);							//ʱ2MS()
//迪˹˲
	rf_write_reg(HS6220_BANK0_FEATURE,0x10);

//лBANK1
	rf_bank_switch(RF_BANK1);
//TEST_PKDET(üĴ24λ)ĵ5λΪ1
	rf_write_reg(HS6220_BANK1_TEST_PKDET,0x20);
//FAGC_CTRL_1(üĴ32λ)
//6220Ϊ߿,VCO.,ǿ˱й¶,ֲ֤ù. 
//еĽ취:СתʱVCO,תʱָԭֵ
//ʱ:CE,лBANK1,üĴ(ն300MSղݻḴλRF,ͻָԭֵ)				
	rf_write_reg(HS6220_BANK1_FAGC_CTRL_1,0x01);	//ϵʼֻҪд8λ
//AGC_CTRL(üĴ32λ)
	u8_data_buf[0] = 0xCF;
	u8_data_buf[1] = 0xB2;
	rf_write_reg_buf(HS6220_BANK1_AGC_CTRL, u8_data_buf, 2);

//лBANK0	
	rf_bank_switch(RF_BANK0);
//巽ʽڲУ׼RF(CE40USĸ弤RFУ׼)	
	rf_ce_high();
	delay_ms(1);							//1MS
	rf_ce_low();							//У׼ʱ,CEΪ
	
	u8_tmp1 = 35;							//Լ35MS
//CEߵУ׼Ҫ29MS,35MSûжУ׼ɱ־¿ʼʼ
//ȴУ׼	
	while(1)					
	{
		u8_tmp2 = rf_read_reg(HS6220_BANK0_RF_SETUP);
		if(u8_tmp2 & D_BIT5)
		{
			break;
		}
		delay_ms(1);						//ʱ1MS
		u8_tmp1--;
		if(0 == u8_tmp1)
		{	//³ʼ
			goto reset_rf_int;
		}
	}
//رУ׼(CAL_EN0,ʵ趨)
	rf_write_reg(HS6220_BANK0_RF_SETUP,0x40);
	
//лBANK1
	rf_bank_switch(RF_BANK1);
// CAL_CTL(üĴ32λ)
	u8_data_buf[0] = 0x20;
	u8_data_buf[1] = 0x98;
	u8_data_buf[2] = 0x75;
	rf_write_reg_buf(HS6220_BANK1_CAL_CTL, u8_data_buf, 3);

//лBANK0
	rf_bank_switch(RF_BANK0);
//ýյַ(5BYTE)
	u8_data_buf[0] = D_RF_ADDR0;
	u8_data_buf[1] = D_RF_ADDR1;
	u8_data_buf[2] = D_RF_ADDR2;
	u8_data_buf[3] = D_RF_ADDR3;
	u8_data_buf[4] = D_RF_ADDR4;
	rf_write_reg_buf(HS6220_BANK0_RX_ADDR_P0, u8_data_buf, 5);	
//÷͵ַ(5BYTE)
	u8_data_buf[0] = D_RF_ADDR0;
	u8_data_buf[1] = D_RF_ADDR1;
	u8_data_buf[2] = D_RF_ADDR2;
	u8_data_buf[3] = D_RF_ADDR3;
	u8_data_buf[4] = D_RF_ADDR4;
	rf_write_reg_buf(HS6220_BANK0_TX_ADDR, u8_data_buf, 5);	

//迪˹˲,ʹ̬ܶݰ
	rf_write_reg(HS6220_BANK0_FEATURE,0x10);
//ʹRXԶӦ	
	rf_write_reg(HS6220_BANK0_EN_AA,0);		//ֹRXԶӦ			
//	rf_write_reg(HS6220_BANK0_EN_AA,0x01);	//ʹRX PIPE0 ԶӦ
//CONFIG(RX MODE : 0xFB;TX MODE : 0xFA)
	rf_write_reg(HS6220_BANK0_CONFIG,0xFA);
//շݳ
	rf_write_reg(HS6220_BANK0_RX_PW_P0,D_RF_DATA_NUM);	
//ͨ
	rf_write_reg(HS6220_BANK0_RF_CH,D_RF_CHANNEL_L);
//ʹRX PIPE
	rf_write_reg(HS6220_BANK0_EN_RXADDR,0x01);
//ʹԶش
//	rf_write_reg(HS6220_BANK0_SETUP_RETR,0);	//ֹԶط
	rf_write_reg(HS6220_BANK0_SETUP_RETR,0x43);	//1MSԶط3
//ù
	rf_write_reg(HS6220_BANK0_RF_SETUP,0x47);
//ʹ̬ܶݰ PIPE
	rf_write_reg(HS6220_BANK0_DYNPD,0x07);
	
	rf_flush_tx();
	rf_flush_rx();
	rf_clear_all_irq();
}
//================================================================================
void rf_tx_send_data(void)
{	//RF TX 
	rf_ce_low();
	rf_flush_tx();
	rf_clear_all_irq();
	
//ע:ú rf_write_reg_buf ,ʵдRF Ĵ.
//ĵ5λΪ1,Դ˴ rf_write_reg_buf д
//	rf_write_reg_buf(HS6220_W_ACK_PAYLOAD, u8_data_buf, D_RF_DATA_NUM);
	rf_write_reg_buf(HS6220_W_TX_PAYLOAD_NOACK, u8_data_buf, D_RF_DATA_NUM);
	rf_ce_high();									//TX 
//	delay_ms(1);									//ȴͽ
	
	//ȴͽ(5MSȴʱ)
	b_tx_end = 0;
	u8_tmp1 = 5;				//5MS,1MSԶش3(ʱԼ5MS) & ԶӦ
	while(u8_tmp1)
	{
		u8_tmp2 = rf_read_reg(HS6220_BANK0_STATUS);
		if(u8_tmp2 & D_BIT5)
		{	//ԶӦʱ,TX˱յRXӦʱλ
			b_tx_end = 1;							//TXյӦź
		}
		delay_ms(1);
		u8_tmp1--;
	}
	rf_ce_low();
}
//================================================================================
void rf_power_down(void)
{	// rf 
	rf_write_reg(HS6220_BANK0_PMU_CTL,0xAD);		//RF ˯ģʽ
	delay_ms(2);									//ʱ1ms
	rf_write_reg(HS6220_BANK0_CONFIG,0xF8);			//rf µ(tx mode)
	delay_ms(2);									//ʱ1ms
}
//--------------------------------------------------------------------------------
void rf_power_on(void)
{	// rf ϵ
	rf_write_reg(HS6220_BANK0_CONFIG,0xFA);			//rf ϵ(tx mode)
	delay_ms(2);									//ʱ1ms
	rf_write_reg(HS6220_BANK0_PMU_CTL,0xAC);		//RF ģʽ
}
//================================================================================



//================================================================================
//	ɨ
//--------------------------------------------------------------------------------
void tx_key_scan(void)
{
	u8_tmp1 = D_KEY_PORT & D_KEY_BIT;
	u8_tmp1 ^= D_KEY_BIT;
	if(u8_tmp1 == u8_key_new)
	{	//ֵֵͬ,ȥ
		u16_key_cnt++;
		if(u16_key_cnt >= D_KEY_BOUNCE)
		{	//ȥ
			if(u8_key_old != u8_key_new)
			{
				u8_key_old = u8_key_new;
				u8_key_val = u8_key_new;
			}
		}
		if(u16_key_cnt > D_LONGKEY_CNT)
		{
			u16_key_cnt = D_LONGKEY_CNT;
		}
	}
	else
	{
		u8_key_new = u8_tmp1;
		u16_key_cnt = 0;
	}
	
	//жϰ
	if(0 == u8_key_new)
	{	//ͷ,̰
		if(D_KEY1 == u8_key_val)
		{
			b_key1_short = 1;
		}
		else if(D_KEY2 == u8_key_val)
		{
			b_key2_short = 1;
		}
		u8_key_val = 0;
	}
	else
	{
		if(u16_key_cnt >= D_LONGKEY_CNT)
		{	//
			if(D_KEY1 == u8_key_val)
			{
				b_key1_long = 1;
			}
			else if(D_KEY2 == u8_key_val)
			{
				b_key2_long = 1;
			}
			u8_key_val = 0;			//жϴ
		}
	}
}
//================================================================================
void tx_key_process(void)
{	
	//жϴ

	if(b_key1_short)
	{	//
		b_key1_short = 0;
		
		u8_rf_mark++;
		u8_data_buf[0] = 0x55;
		u8_data_buf[1] = 0xAA;
		u8_data_buf[2] = u8_rf_mark;
		u8_data_buf[3] = u8_rf_ch;
		u8_data_buf[4] = 0x01;

		rf_tx_send_data();
		turnon_led();
		delay_int(100);
		turnoff_led();
	}
	
	if(b_key1_long)
	{
		b_key1_long = 0;
		
		u8_rf_mark++;
		u8_data_buf[0] = 0x55;
		u8_data_buf[1] = 0xAA;
		u8_data_buf[2] = u8_rf_mark;
		u8_data_buf[3] = u8_rf_ch;
		u8_data_buf[4] = 0x02;

		rf_tx_send_data();
		turnon_led();
		delay_int(100);
		turnoff_led();
	}
}
//================================================================================
