/**
*   ************************************************************************************


*   ************************************************************************************
**/


#ifndef __USER_H__
#define	__USER_H__
/**************************************************************************************/
#ifdef	_USER_
#define	_USER_
#else
#define	_USER_ extern
#endif
/**************************************************************************************/
//USER IO 
#define	p_test							P0_0			//PIN

#define	p_sck							P0_3			//PIN,SCK

#define	p_led1							P1_0
#define	p_led2							P1_1

#define	p_pwm_ch1						P2_0
#define	p_sda							P2_1			//SDA	
#define	p_pwm_ch2						P2_2
#define	p_ad_volt						P2_5
#define	p_key1							P2_6
#define	p_key2							P2_7

#define test_out_pin_att()				att_p00(IO_OUT_PUSH_PULL)
#define	test_in_pin_att()				att_p00(IO_SMTIN)
#define	test_pin_status(x)				pin_out(P0_0,x)

#define	led1_pin_att()					att_p04(IO_OUT_PUSH_PULL)
#define	led1_pin_status(x)				pin_out(P0_4,x)

#define	led2_pin_att()					att_p05(IO_OUT_PUSH_PULL)
#define	led2_pin_status(x)				pin_out(P0_5,x)

#define	pwm_ch1_pin_att()				att_p20(IO_OUT_PUSH_PULL)
#define	pwm_ch1_pin_status(x)			pin_out(P2_0,x)

#define	pwm_ch2_pin_att()				att_p22(IO_OUT_PUSH_PULL)
#define	pwm_ch2_pin_status(x)			pin_out(P2_2,x)

#define	ad_volt_pin_att()				att_p25(IO_IN_ANALOG);

//#define	key1_pin_att()					att_p26(IO_SMTIN_PULL_UP)
//#define	key2_pin_att()					att_p27(IO_SMTIN_PULL_UP)
/**************************************************************************************/
#define	led1_tog()						pin_tog(p_led1)
#define	led1_on()						led1_pin_status(1)
#define	led1_off()						led1_pin_status(0)
#define	led2_on()						led2_pin_status(1)
#define	led2_off()						led2_pin_status(0)
/**************************************************************************************/
_USER_	bit b_base_1ms_int;								//1MSʱ־,же
_USER_	u8 	u8_cnt_1_int;								//же
_USER_	u8 	u8_cnt_2_int;								//же
_USER_	u16 u16_cnt_3_int;								//же
_USER_	u8 	u8_delay_int;								//же

_USER_	u8	u8_rtc_second;								//же
_USER_	u8	u8_rtc_minute;								//же
_USER_	u8	u8_rtc_hour;								//же
//------------------------------------------------------------------------------/
_USER_ u8 u8_wake_time;										//ʱ100ms
#define	D_WAKE_TIME						(2000UL/50)			//2S

_USER_ u16 u16_wave_time;									//ʱ1000ms
#define	D_WAVE_TIME_10					(10*60*1000UL/100)	//10
#define	D_WAVE_TIME_15					(15*60*1000UL/100)	//15
//óʱ,ڴ255ǿдUL,ʱݳ
//------------------------------------------------------------------------------/
_USER_ bit	b_pwmen_flag;
_USER_ bit	b_aden_flag;
_USER_ u8	u8_led2_cnt;
_USER_ u8	u8_led1_cnt;
_USER_ u16	u16_ad_val;
_USER_ u32	u32_tmp;
//------------------------------------------------------------------------------/
typedef struct{
	u8	mark;
	u8	len;
	u8	cnt;
	u8	buf[32];
}RF_FRAME;
_USER_  RF_FRAME rf;
/*******************************************************************************/
_USER_ void user_gpio_initial(void);
_USER_ void user_register_initial(void);
_USER_ void system_timer_pro(void);

_USER_ void system_flow_control(void);
/*******************************************************************************/
#endif

