
#ifndef	_HTC_H_
#endif


#ifndef __PIC15P013A0_H
#define __PIC15P013A0_H


// Special function register definitions
//
//----- BANK0 Register -----------------------------------------------------
volatile   unsigned char           INDF                @ 0x000;
volatile   unsigned char           T0                  @ 0x001;
volatile   unsigned char           PCL                 @ 0x002;
volatile   unsigned char           STATUS              @ 0x003;
volatile   unsigned char           FSR                 @ 0x004;
volatile   unsigned char           PORTB               @ 0x006;

volatile  unsigned char            LVDCR                @ 0x008;
volatile  unsigned char            IOCB                @ 0x009;
volatile  unsigned char            PCLATH              @ 0x00A;
volatile  unsigned char            PDCON               @ 0x00B;
volatile  unsigned char            ODCON               @ 0x00C;
volatile  unsigned char            PHCON               @ 0x00D;
volatile  unsigned char            INTECON             @ 0x00E;

volatile  unsigned char           OPTION              @ 0x041;
volatile  unsigned char           occupy0             @ 0x042;
volatile  unsigned char           occupy1             @ 0x043;
volatile  unsigned char           occupy2             @ 0x044;
volatile  unsigned char           occupy3             @ 0x045;
volatile  unsigned char           TRISB               @ 0x046;

volatile  unsigned char           T1CR_AUXR           @ 0x04B;
volatile  unsigned char           T1CON               @ 0x04C;
volatile  unsigned char           T1                  @ 0x04D;
volatile  unsigned char           T1LOAD              @ 0x04E;
volatile  unsigned char           PWM0P               @ 0x04F;


//----- BANK1 Register -----------------------------------------------------
// bit and bitfield definitions
volatile bit C                   @ ((unsigned)&STATUS*8)+0;
volatile bit DC                  @ ((unsigned)&STATUS*8)+1;
volatile bit Z                   @ ((unsigned)&STATUS*8)+2;
volatile bit PD                  @ ((unsigned)&STATUS*8)+3;
volatile bit TO                  @ ((unsigned)&STATUS*8)+4;
volatile bit RST                 @ ((unsigned)&STATUS*8)+7;

// bit and bitfield definitions
volatile bit PORTB0                 @ ((unsigned)&PORTB*8)+0;
volatile bit PORTB1                 @ ((unsigned)&PORTB*8)+1;
volatile bit PORTB2                 @ ((unsigned)&PORTB*8)+2;
volatile bit PORTB3                 @ ((unsigned)&PORTB*8)+3;
volatile bit PORTB4                 @ ((unsigned)&PORTB*8)+4;
volatile bit PORTB5                 @ ((unsigned)&PORTB*8)+5;

// bit and bitfield definitions
volatile bit LVDEN                  @ ((unsigned)&LVDCR*8)+0;
volatile bit LVDSEL0                @ ((unsigned)&LVDCR*8)+1;
volatile bit LVDSEL1                @ ((unsigned)&LVDCR*8)+2;
volatile bit LVDSEL2                @ ((unsigned)&LVDCR*8)+3;
volatile bit LVDSEL3                @ ((unsigned)&LVDCR*8)+4;
volatile bit LVDF                   @ ((unsigned)&LVDCR*8)+7;

/* Definitions for IOCB register */
volatile bit IOCB0                 @ ((unsigned)&IOCB*8)+0;
volatile bit IOCB1                 @ ((unsigned)&IOCB*8)+1;
volatile bit IOCB2                 @ ((unsigned)&IOCB*8)+2;
volatile bit IOCB3                 @ ((unsigned)&IOCB*8)+3;
volatile bit IOCB4                 @ ((unsigned)&IOCB*8)+4;
volatile bit IOCB5                 @ ((unsigned)&IOCB*8)+5;

// bit and bitfield definitions
volatile bit PDB0                 @ ((unsigned)&PDCON*8)+0;
volatile bit PDB1                 @ ((unsigned)&PDCON*8)+1;
volatile bit PDB2                 @ ((unsigned)&PDCON*8)+2;
volatile bit PDB3                 @ ((unsigned)&PDCON*8)+3;
volatile bit PDB4                 @ ((unsigned)&PDCON*8)+4;
volatile bit PDB5                 @ ((unsigned)&PDCON*8)+5;

// bit and bitfield definitions
volatile bit ODB0                 @ ((unsigned)&ODCON*8)+0;
volatile bit ODB1                 @ ((unsigned)&ODCON*8)+1;
volatile bit ODB2                 @ ((unsigned)&ODCON*8)+2;
volatile bit ODB3                 @ ((unsigned)&ODCON*8)+3;
volatile bit ODB4                 @ ((unsigned)&ODCON*8)+4;
volatile bit ODB5                 @ ((unsigned)&ODCON*8)+5;

// bit and bitfield definitions
volatile bit PHB0                 @ ((unsigned)&PHCON*8)+0;
volatile bit PHB1                 @ ((unsigned)&PHCON*8)+1;
volatile bit PHB2                 @ ((unsigned)&PHCON*8)+2;
volatile bit PHB3                 @ ((unsigned)&PHCON*8)+3;
volatile bit PHB4                 @ ((unsigned)&PHCON*8)+4;
volatile bit PHB5                 @ ((unsigned)&PHCON*8)+5;

// bit and bitfield definitions
volatile bit T0IE                 @ ((unsigned)&INTECON*8)+0;
volatile bit PBIE                 @ ((unsigned)&INTECON*8)+1;
volatile bit INTE                 @ ((unsigned)&INTECON*8)+2;
volatile bit T0IF                 @ ((unsigned)&INTECON*8)+3;
volatile bit PBIF                 @ ((unsigned)&INTECON*8)+4;
volatile bit INTF                  @ ((unsigned)&INTECON*8)+5;
volatile bit GIE                  @ ((unsigned)&INTECON*8)+7;


// bit and bitfield definitions
volatile bit PS0                 @ ((unsigned)&OPTION*8)+0;
volatile bit PS1                 @ ((unsigned)&OPTION*8)+1;
volatile bit PS2                 @ ((unsigned)&OPTION*8)+2;
volatile bit PSA                 @ ((unsigned)&OPTION*8)+3;
volatile bit T0SE                 @ ((unsigned)&OPTION*8)+4;
volatile bit T0CS                 @ ((unsigned)&OPTION*8)+5;
volatile bit INTEDG                 @ ((unsigned)&OPTION*8)+6;
volatile bit WDTEN                 @ ((unsigned)&OPTION*8)+7;

// bit and bitfield definitions
volatile bit TRISB0               @ ((unsigned)&TRISB*8)+0;
volatile bit TRISB1               @ ((unsigned)&TRISB*8)+1;
volatile bit TRISB2               @ ((unsigned)&TRISB*8)+2;
volatile bit TRISB3               @ ((unsigned)&TRISB*8)+3;
volatile bit TRISB4               @ ((unsigned)&TRISB*8)+4;
volatile bit TRISB5               @ ((unsigned)&TRISB*8)+5;

// bit and bitfield definitions
volatile bit T1IF                 @ ((unsigned)&T1CR_AUXR*8)+0;
volatile bit T1IE                 @ ((unsigned)&T1CR_AUXR*8)+1;
volatile bit BOREN                 @ ((unsigned)&T1CR_AUXR*8)+2;
volatile bit BOR                 @ ((unsigned)&T1CR_AUXR*8)+3;
volatile bit POR                 @ ((unsigned)&T1CR_AUXR*8)+4;
volatile bit T0CK                 @ ((unsigned)&T1CR_AUXR*8)+7;

// bit and bitfield definitions
volatile bit T1PR0                   @ ((unsigned)&T1CON*8)+0;
volatile bit T1PR1                   @ ((unsigned)&T1CON*8)+1;
volatile bit T1PR2                   @ ((unsigned)&T1CON*8)+2;
volatile bit T1CK0                   @ ((unsigned)&T1CON*8)+3;
volatile bit T1CK1                   @ ((unsigned)&T1CON*8)+4;
volatile bit PWM0E                   @ ((unsigned)&T1CON*8)+6;
volatile bit T1EN                    @ ((unsigned)&T1CON*8)+7;

#endif
