//================================================================================
//Author	: Maple
//Date  	: 2024-2-20
//Project	: BL08P122(RW1602B3SA)
//================================================================================
//			  BL08P122-S16(150mil)		
//			  VDD |1    16| GND                
//	OSC1/AN15/PB7 |2    15| PA0/AN0/TM1PWM           
//	OSCO/AN14/PB6 |3    14| PA1/AN1/TM2PWM             
//		  VPP/PB5 |4    13| PA2/AN2/TM1PWM/PCK            
//TM2PWM/AN11/PB3 |5    12| PA3/AN3            
//TM1PWM/AN10/PB2 |6    11| PA4/AN4            
// TM2PWM/AN9/PB1 |7    10| PA6/AN6            
// TM1PWM/AN8/PB0 |8     9| PA7/AN7/TM2PWM
  		
//			  RW1602B3SA-SSOP10		
//		  	  PA1 |1    16| PA2                
//		      PA0 |2     9| PA3           
//		      PA7 |3     8| VDD            
//		      PB5 |4     7| GND           
//		    XTALP |5     6| RF 

//¼PIN : PA0(PGC),PA1(PGD),PA2(PCK),PB5(VPP),GND,VDD 
//ע:	ģʽʱҪõPA0,PA1,PA2ͨѶ,PB5VPPѹ,ĸPIN
//			ʱӰ,ʱҪ4PIN(Ҳ4PINʱʹ,
//			书¼оƬ֤)      
//================================================================================


//================================================================================
#include "bl08p122.h"
#include "main.h"
#include "hs6220.h"
#include "user.h"
//================================================================================
#define	D_T0_BASE_CNT			(256-125)		//һ8US
volatile bit b_base_ms = 0;
volatile u8	u8_base_cnt;
#define	D_BASECNT				10				//10MS(ʱ:1MS)

volatile u8 u8_wake_time;
#if D_ROLL_ON
#if	D_DEBUG
volatile u8 u8_roll_adr0 = 0xF1;
volatile u8 u8_roll_adr1 = 0x11;
volatile u8 u8_roll_adr2 = 0x12;
#else
const unsigned char u8_roll_adr0@0x07F8;
const unsigned char u8_roll_adr1@0x07F9;
const unsigned char u8_roll_adr2@0x07FA;
//const unsigned char u8_roll_adr3@0x07FB;
#endif
#endif
//================================================================================


//================================================================================
//	
//--------------------------------------------------------------------------------
void ram_clear(void)
{
	//bank0ͨüĴINITIAL RAM
	FSR = 0x3f;
	do
	{
		INDF = 0;
		FSR--;
	}while(FSR != 0x0f);
	
	//bank1ͨüĴINITIAL RAM
	FSR = 0xdf;
	do
	{
		INDF = 0;
		FSR--;
	}while(FSR != 0x8f);
}
//--------------------------------------------------------------------------------
void clear_wdt(void)
{
	#asm
	clrwdt
	#endasm
}
//--------------------------------------------------------------------------------	
void system_stop(void)
{
	//˯ǰرWDTBORģ齵͹
	disable_bor();
	disable_wdt();
	//ʹIOжϻ
	GIE = 0;
	PAIE = 1;
	GIE = 1;
	
	#asm
	nop
	nop
	sleep
	nop
	nop
	#endasm
	
	PAIF = 0;
	GIE = 0;
	PAIE = 0;
	enable_bor();
	enable_wdt();
	clear_wdt();
	GIE = 1;	
}
//--------------------------------------------------------------------------------
//
//================================================================================
//	
//--------------------------------------------------------------------------------
void hardware_init(void)
{
//--------------------------------------------------------------------------------
//IO
#if D_DEBUG	
//	0:; 1:ģ	
	ANSELL = 0x07;				//PA0~2
	ANSELH = 0x00;				 			 
//	0:͵ƽ; 1:ߵƽ
	PORTA = 0;
	PORTB = 0x01;
//	0:; 1:
	TRISA = 0x5F;
	TRISB = 0x84;
//	0:ʹ; 1:ֹ
	PHCON1 = 0xA7;				//PA3,4,6 pull high
	PHCON = 0xFB;				//PB2 pull high
//	0:ʹ; 1:ֹ
	PDCON1 = 0xFF;
	PDCON = 0xFF;
//	0:ֹIO; 1:ʹIO
	IOCA = BIT6 | BIT4 | BIT3;	//PA3,PA4,PA6
	IOCB = 0;
#else
//	IO
//	PA0	:	ipput pull high		KEY_F
//	PA1	:	input pull high		KEY_B
//	PA2	:	input pull high		KEY_L
//	PA3	:	output high 		LED
//	PA7	:	output low			PWM
//	PB0	:	output high			CSN
//	PB1	:	output low			SCK	
//	PB2	:	input pull high		MOSI
//	PB3	:	input pull high		IRQ
//	PB5	:	output low			LED

//	0:; 1:ģ	
	ANSELL = 0;				
	ANSELH = 0;
//	0:͵ƽ; 1:ߵƽ
	PORTA = 0x00;
	PORTB = 0x01;
//	0:; 1:
	TRISA = 0x0F;
	TRISB = 0x0C;
//	0:ʹ; 1:ֹ
	PHCON1 = 0xF8;				//PA0~PA2 pull high
	PHCON = 0xF3;				//PB2~PB3 pull high
//	0:ʹ; 1:ֹ
	PDCON1 = 0xFF;
	PDCON = 0xFF;
//	0:ֹIO; 1:ʹIO
	IOCA = BIT2 | BIT1 | BIT0;	//PA0,PA1,PA2
	IOCB = 0x00;
#endif
//--------------------------------------------------------------------------------
//T0,ʱ1MS(һ8US)
	T0IE = 0;					//ֹT0ж
//	T0SE = 0;					//T0ؼ
//	T0CS = 0;					//T0ʱԴFcpu 
	OPTION = 0x03;				//T0Ƶ1:16,T0ʱ=2M/16
	T0 = D_T0_BASE_CNT;			//256-125(1MS)
	T0IE = 1;					//ʹT0ж
	T0IF = 0;					//T0жϱ־ 
//--------------------------------------------------------------------------------	
//PWM
//TMR2HĴ(λΪܽӳλ)
//ںռձȶ10λ,2λ TMR2H Ĵ,ʱ
// TMR2H Ĵ)
//PA7(PWM1)10KHZ@20%
//	TMR2H = 0x84;
//	T2 = 0;
////[4M/10K = 400](T2LOAD = 399 = 0x18F,2λ(0x01)TMR2Hλ[3:2])
//	T2LOAD = 0x8F;
////ռձ[ռձֵ=ֵ*ռձ](400*20% = 80)
//	PWM1P = 0x50;
////T2ʹ,ֹPWM1,T2ʱԴƵ16M,Ƶ4	
//	T2CON = 0x8A;
////PWM1
//	PWM1E = 1;	

/*
//	PB0(PWM0)20KHZ@50%
	TMR2H = 0x00;
	T1 = 0x34;
	T1LOAD = 0x63;
	PWM0P = 0x32;
	T1CON = 0x80;
	PWM0E = 1;
*/
}
//================================================================================

//********************************************************************************
//	BORѹ			:	2.0V
//	WDTʹ			:	ʹ
//	ܹ		:	
//	ƵڲRCƵ	:	Fsys = 4M, Fcpu = 2M
//	ܽʩ	:	ֹʩ
//	WDTʱ		:	57.6MS
//	ϵͳʱ	:	Ƶ
//	ڲƵRCƵ	:	16MHZ,иƵڲRC
//	ʱԴOSCHM		:	ڲƵRC
//	ʱԴOSCLM		:	ڲƵRC
//********************************************************************************
//================================================================================
void main()
{
	hardware_init();
	ram_clear();
//------------------------------------------------------------
//RF ϵҪ 10ms ʱϵ縴λ,֮ͨ SPI  RF в
	delay_ms(20);
	rf.chn = D_RF_CHANNEL_L;
	rf_init();
//ж,ʹWDT
	enable_wdt();
	GIE = 1;
//------------------------------------------------------------
#if D_RF_TX
	rf_mode_switch(RF_PTX_MODE);
	while(1)
	{
		clear_wdt();

		if(b_base_ms)
		{
			b_base_ms = 0;
			key_scan();
		}
		key_process();
		if(u8_wake_time || !p_key_1 || !p_key_2 || !p_key_3)
		{
			continue;
		}
		
		rf_ce_low();
		rf_power_down();
		system_stop();
		rf_power_on(); 
		rf_mode_switch(RF_PTX_MODE);
	}
#endif
//------------------------------------------------------------	
#if D_RF_RX
	rf.id[0] = 0;
	rf.id[1] = 0;
	rf.id[2] = 0;
	rf_mode_switch(RF_PRX_MODE);
	rf_ce_high();
	while(1)
	{
		clear_wdt();

		if(b_base_ms)
		{
			b_base_ms = 0;

			rf.len = rf_rx_receive(rf.buf);
			rx_data_process();
		}
	}
#endif
}
//================================================================================

//================================================================================
void interrupt isr_vector(void)
{
	if(T0IF)
	{
		T0IF = 0;				//Clear T0IF
		T0 = D_T0_BASE_CNT;		//
	
#if D_RF_RX
		//RX 1MSʱ
		b_base_ms = 1;
#endif
		u8_base_cnt++;
		if(u8_base_cnt >= D_BASECNT)
		{
			u8_base_cnt = 0;
			
#if D_RF_TX
			//TX 10MSʱ
			b_base_ms = 1;
			if(u8_wake_time)
			{
				u8_wake_time--;
			}
#endif

#if D_RF_RX		
			rf.rst_int++;
			rf.slp_int++;
#endif
		}
	}
	
	if(PAIF)
	{	//˿Aƽ仯ж
		PAIF = 0;
		
	}
}
//********************************************************************************